#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "AHA.h"

agrath : Person 'tall lithe green
    agrath/redhead/demoness/princess/queen/(hell)' 'Agrath'
    "She's a chillingly beautiful demoness, tall, slender and angular, with
    bright green skin and a mass of orange hair. You find her simultaneously
    devastatingly attractive and terrifyingly repellant. "
    isHer = true
    isProperName = true
    appear()
    {
        moveIntoForTravel(lair);
        "You are nearly startled out of your wits when there's a sudden clap of
        thunder and a blinding flash of light. Even as you recover your sight
        you find the chamber filled with a choking cloud of purple smoke. It
        quickly starts to disperse, but at that point you receive an even
        greater shock.<.p>";
        inputManager.pauseForMore(nil);
        "Out of the remaining tendrils of fading purple smoke steps a tall,
        lithe creature you instinctively know to be a demoness; the first sight
        of her sends shivers down your spine and makes the hairs rise on the
        nape of your neck. Meanwhile the demoness flashes an evil grin at you
        -- an evil grin that almost freezes your heart.\b     
        <q>I am Agrath, Princess of Demons, Queen of Hell, Temptress and
        Tormenter in Chief,</q> she announces, <q>Welcome to my lair!</q>";
        gSetSeen(self);
    }
    dobjFor(Kiss)
    {
        verify() {}
        action() { curState.kissResponse; }
    }
    dobjFor(Screw)
    { 
        preCond = [touchObj]
        verify() { nonObvious; }
        check() {
            if(curState != agrathLust)
            {
                reportFailure('That may be what your hormones are urging, but
                    right now you\'re too frightened of her to attempt it. ');
                exit;
            }
        }
        action()
        {
            "That's just what she has in mind too, but she wants you to kiss
            her first. ";
        }
    }
    uselessToAttackMsg = 'She\'s a demoness -- a princess of demons -- for
        goodness\'s sake; she could make mincemeat of you with a twitch of her
        little finger! '
    afterAction()
    {
        if(gActionIs(Yell))
            "<.p>Agrath throws you a look of amused contempt.<.p>";
        inherited;
    }
    throwTargetHitWith(projectile, path)
    {
        gMessageParams(projectile);
        "Agrath barely glances at {the projectile/him} as {it projectile/he}
        fl{ies} towards her. She gives a casual wave of her hand and
        {the projectile/he} shatter{s} into fine dust, and then vanishes
        altogether. "; 
        projectile.moveInto(nil);
    }
    cannotPrayToThatMsg = 'You {haven\'t} sunk so low that you feel any need to
        pray to her! '
    cannotEatMsg = 'She\'s more likely to eat you! '
;

+ Unthing 'woman' 'woman'
    'Agrath may be female, but she\'s not a woman. Despite outward appearances,
    she\'s obviously not remotely human. '
;

+ Component 'bright orange copious long mass/hair/tresses/locks' 'Agrath\'s hair'
    "Agrath's hair is orange and extraordinarily copious; not only is it very
    thick, it is exceedingly long, falling well below her waist. It also seems
    to have a life of its own, since it sways and ripples even when she stands
    still -- and there is no hint of a breeze here. "
    isQualifiedName = true
    isMassName = true
    feelDesc()
    {
        if(agrath.curState == agrathLust)
            "You run your hands through her long, thick orange hair, finding
            that it yields and undulates to welcome your caress.\b
            <q>Yes! Yes!</q> she breathes, <q>Now kiss me!</q>";
        else
            "You could almost lose yourself in that mass of hair, but you dare
            not touch it uninvited. ";
    }
    cannotMoveMsg = 'You suspect that might annoy her rather more than
        you\'re willing to risk. '
    
;

+ agrathSpouting : HermitActorState
    
    isInitState = true
    noResponse = "She's too intent on her own agenda to take any
        notice of yours. "
    helloResponse = "<q><i>Hello</i>!</q> she repeats. "
    specialDesc = "The demoness is walking to and fro, gesticulating as
        she addresses you. "
    kissResponse = "You daren't get that close to her. "  
    hugResponse = ( kissResponse )
    handleConversation(otherActor, topic, convType)
    {
        if(convType == helloConvType)
        { 
            if(agrathHelloAgenda.curScriptState > 1)
                helloResponse;
            else
                "<q>Hello,</q> you say.<.p>";          
        }
        else    
            inherited(otherActor, topic, convType);
    }
    
;

+ agrathHelloAgenda: AgendaItem, StopEventList
    [
        
        '<q>Well, <i>hello</i>, what have we here?</q> she asks, cocking her
        head to one side,  <q>A human male! <i>Such</i> a long time since one
        came this way!</q>',
        
        '<q>All this demythologization crap cut off my supply -- I haven\'t had
        any amusement in <i>ages</i>,</q> she continues, <q>so I\'m really
        <i>so</i> glad you dropped by!</q>',
        
        new function {               
        agrath.initiateConversation(agrathTalking, 'torment-temptation');
        isDone = true; }
    ]
    initiallyActive = true
    isReady = agrath.canSee(gPlayerChar) && agrath.isIn(lair)
    invokeItem { doScript; }
;

+ agrathTalking : InConversationState
    specialDesc = "Agrath is staring at you intently, as if eyeing up a tasty
        meal. "
    stateDesc = "She's staring at you intently. "
    kissResponse = "You daren't. "
    attentionSpan = nil
    activateState(actor, oldState)
    {
        inherited(actor, oldState);
        if(lairDoor.isOpen)
            lairDoor.makeOpen(nil);
    }
;


+ ConvNode 'torment-temptation'
    npcGreetingMsg = "She starts to swagger round you, hands on hips,
        inspecting you carefully as if you were some purchase she was
        considering making. <q>Now,</q> she declares, <q>you look like you\'ve
        got plenty of amusement value in you.</q> She stands directly in front
        of you, a cold smile playing on her lips. <q>The question is,</q> she
        says, very deliberately, <q>what form that amusement should take:
        torment or temptation? Tell me, what would your choice be?</q>"
    limitSuggestions = true 
    canEndConversation (actor, reason) 
    {
        "<q>You're not going anywhere -- just answer the question!</q> she
        insists. ";
        return nil; 
        
    }
;

++ SpecialTopic 'choose temptation' 
    ['choose', 'pick', 'select', 'ask', 'for', 'temptation']
    "<q>Of the two, I think I'd prefer temptation,</q> you suggest, a bit
    hesitantly.\b
    <q>Wise choice,</q> the demoness approves, <q>now, what would tempt you --
    I mean <i>really</i> tempt you? Ask me for whatever it is that you
    <i>really really</i> want.</q><.reveal temptation><.convnode temptation>"
;

++ SpecialTopic 'choose torment' 
    ['choose', 'pick', 'select', 'ask', 'for', 'torment']
    "<q>I think I'll go for torment,</q> you declare boldly.\b
    <q>Are you sure about that?</q> she asks sharply, <q>We're talking eternal
    torment here, you know -- no messing. <i>Eternal</i> torment -- I'd gouge
    your eyes out, eat your fingers, flay you alive, stuff your innards down
    your throat, saw your legs off, and then put you back together and start
    all over again -- maybe with thumbscrews and red-hot pokers and boiling oil
    for a bit of variety. Is that what you <i>really</i> want for all
    eternity?</q><.convnode torment>"
;


++ DefaultAnyTopic
    "<q>Torment or temptation -- that's the only issue that interests me right
    now!</q> she insists.<.convstay> "
;


+ ConvNode 'torment'
    limitSuggestions = true
    npcContinueMsg = "<q>You're meant to be telling me whether you really
        wanted to be tormented for all eternity,</q> she reminds you."
    canEndConversation (actor, reason) 
    {
        "<q>You're not going anywhere -- just answer the question!</q> she
        insists. ";
        return nil;      
    }  
;

++ YesTopic, SuggestedYesTopic
    "<q>Yes,</q> you reply, foolishly but bravely, <q>I'd choose torment before
    temptation any day!</q>\b
    <q>You really want eternal agony, unremitting pain, everlasting
    degradation? You really want me to chop you into little pieces again and
    again? You really want me to stick red-hot knives into your genitals until
    you scream for mercy (not that I'll give you any), and to stand in a bath
    of boiling iron while I pull your fingernails out one by one? You really
    want all that?</q> <.convnode torment-2>"
;

++ NoTopic, SuggestedNoTopic
    "<q>No, perhaps on second thoughts, temptation might be better than
    torment,</q> you say.\b
    <q>Wise decision,</q> she nods, <q>now, what would tempt you -- I mean
    <i>really</i> tempt you? Ask me for whatever it is that you <i>really
    really</i> want.</q><.reveal temptation><.convnode temptation>"
;

++ DefaultAnyTopic
    "<q>Do you really want eternal torment, yes or no?</q> she insists.
    <.convstay>"
;

+ ConvNode 'torment-2'
    limitSuggestions = true
    npcContinueMsg = "<q>You're meant to be telling me whether you really
        wanted to be tormented for all eternity,</q> she reminds you."
    canEndConversation (actor, reason) 
    {
        "<q>You're not going anywhere -- just answer the question!</q> she
        insists. ";
        return nil;      
    }  
;

++ YesTopic, SuggestedYesTopic
    "<q>Yes!</q> you cry stoutly, <q>I defy your temptations: do your worse --
    torment me!</q>\b
    Agrath shakes her head disapprovingly, sending ripples cascading down her
    hair, <q>You must <i>really</i> be a masochist!</q> she decides, <q>Well,
    you know the old joke about the masochist saying <q>Hit me!</q> and the
    sadist replying <q>No!</q>. Well, that's just the kind of sadist I am: you
    want torment, you get temptation. So, the next question, what would tempt
    you. You must tell me: what you want; I mean, what do you really
    <i>really</i> want?</q><.reveal temptation><.convnode temptation>"
;

++ NoTopic, SuggestedNoTopic
    "<q>No,</q> you admit, <q>since you put it like that -- maybe on second
    thoughts I'd prefer temptation.</q>\b
    <q>Good boy!</q> she grins, <q>Temptation is <i>so</i> much more fun -- for
    both of us! Now, what shall I tempt you with? I need you you tell me what
    you want -- I mean what you <i>really really truly</i> want.</q><.reveal
    temptation><.convnode temptation>"
;

++ DefaultAnyTopic
    "<q>Don't try to change the subject!</q> she snaps, <q>I'm in charge here,
    and I'm asking you, do you really want eternal torment: yes or
    no?</q><.convstay>"
;

+ ConvNode 'temptation'
    limitSuggestions = true
    isSticky = true
    npcContinueList: ShuffledEventList {
    [
        '<q>You\'re meant to be telling me what you really want,</q> she
        reminds you, <q>Ask me for anything you like -- anything at all --
        provided it\'s something you really want.</q>'
    ]
    [  
        '<q>There must be something I can tempt you with,</q> Agrath pleads,
        <q> you don\'t have to be original about it -- any of the old
        favourites will do!</q>',
        
        '<q>Be bold -- I\'m not judgemental!</q> Agrath assures you, <q>and I
        can provide you with anything you ask for: wealth, fame, sex -- you
        name it, you get it!</q>',
        
        '<q>I\'m a very patient demoness, and I appreciate the importance of
        your decision, but don\'t feel shy about asking,</q> Agrath exhorts
        you, <q>just ask me for what you want!</q>',
        
        '<q>Remember, what I can offer you outweighs anything you may have
        experienced in your earthly life,</q> Agrath tells you, <q>so go for
        it, ask me for whatever really takes your fancy!</q>',
        
        'Agrath runs a hand through her hair and wiggles her hips, <q>Look, you
        can even ask for <i>me</i> if you like,</q> she tells you, <q>I\'m a
        great lover, and I\'m certainly game if you are. So go ahead and ask if
        it\'s me you really want.</q>',
        
        '<q>Maybe it\'s the intellectual pleasures that tempt you more,</q>
        Agrath muses, <q>You can ask me for knowledge if you like -- that\'s
        quite a popular temptation among some people.</q>',
        
        '<q>Now come on,</q> Agrath presses you, <q>Ask me for something you
        really, really want.</q>',
        
        '<q>Come on, play the game!</q> Agrath insists, <q>I am, so it\'s only
        fair you should play your part. Ask me for whatever it is you want
        most.</q>',
        
        '<q>Don\'t worry about not being able to resist my temptation,</q>
        Agrath assures you, <q>resistance isn\'t the point of the game. Just
        ask me for whatever you want, and I\'ll see to the rest!</q>' 
        
    ]                 
        
    }
    canEndConversation (actor, reason) 
    {
        "<q>You're not going anywhere -- just tell me what you want!</q> she
        insists. ";
        return nil;      
    }
;

++ NoTopic, ShuffledEventList, SuggestedNoTopic
    [ '<q>No, I\'m not playing your game. I refuse to give you something to
    tempt me with.</q> you declare.\b
    <q>The only alternative is torment,</q> she reminds you, <q>and we\'ve
    already rejected that. So come on, tell me what you really really want. Ask
    for anything you like -- you\'ll find me amazingly generous in my
    temptations. Why, you can even have <i>me</i> if you want!</q>' ]
    
    [
        '<q>No, I refuse to give you something to tempt me with!</q> you
        declare.\b
        <q>You will sooner or later,</q> she shrugs, <q>we\'ve got all eternity
        to play this game, and I\'m inhumanly patient.</q> ',
        
        '<q>Why on earth do you think I\'m going to tell you what you can tempt
        me with?</q> you ask.\b
        <q>Because your only alternative is for you to stand here staring at me
        through all eternity,</q> she replies, <q>and since you\'re only human
        sooner or later you\'ll get bored with that and ask me for something
        you want. So you might as well make it sooner.</q>',
        
        '<q>No, there\'s nothing I want from you,</q> you say.\b
        <q>Oh yes there is,</q> she smiles alluringly, <q>you\'re human. You
        have desires. I can satisfy them: ask and you shall receive!</q>',
        
        '<q>No, I\'m not going to play your game!</q> you tell her.\b
        <q>But you\'re already playing it!</q> she grins, <q>a refusal to
        choose is still a choice -- so long as you\'re choosing nothing else
        you\'re choosing to stay here with me. If my company is really the
        thing you desire above all, that\'s absolutely fine by me. But if it
        isn\'t, then you may as well ask me for whatever it is that you do
        really really want.</q>'      
        
    ]
    
    timesToSuggest = nil
;

++ AskAboutForTopic, SuggestedAskForTopic @tSomething
    "Try asking for something specific, e.g. ASK FOR WEALTH
    or ASK FOR FAME. "
    name = 'something'
    timesToSuggest = nil
;

++ AskAboutForTopic @tNothing
    "<q>Nothing!</q> you cry stoutly, <q>I want nothing from you!</q>\b
    <q>Oh yes you do!</q> she smiles, touching you lightly on the arm, <q>There
    are all sorts of things you want from me; I see it in your eyes!</q>"
;

++ AskAboutForTopic @tHome
    "<q>I just want to go home!</q> you reply.\b
    <q>From now on, this <i>is</i> your home!</q> she smirks, <q>So now you\'re
    home, what do you want to do here? What can I tempt you with?</q>"
;

++ AskAboutForTopic @tTorment
    "<q>I want torment!</q> you declare, <q>Why don't you stop this temptation
    crap and get on with some good old fashioned torture!</q>\b
    <q>Are you sure that's what you want?</q> she asks. <.convnode torment>"
;

++ AskAboutForTopic @tDamnation
    "<q>I demand damnation!</q> you cry.\b
    <q>As is your right -- you\'ve richly earned it!</q> Agrath assures you,
    <q>But you\'re already damned for all eternity, or you wouldn\'t be here,
    and I can\'t tempt you with something you\'ve already got. So come on, try
    again, ask me for something you really crave. </q>"
;

++ TemptationTopic @agrath   
    "<q>What I really want is you!</q> you find yourself saying, <q>you're so
    incredibly beautiful!</q>\b
    <q>I know!</q> she smiles, <q>I'm utterly irresistible! Of course my body
    tempts you -- so it should! Here, I offer it to you, you can have me -- but
    first prove you really want me -- prove you're succumbing to my temptation
    by giving me a kiss!</q>"
    temptationState = agrathLust     
;

++ TemptationTopic [tSex, tAphrodite]
    "Agrath suddenly looks utterly alluring, so you find yourself saying,
    <q>Sex, I want sex!</q>\b
    <q>Attaboy!</q> the demoness grins approvingly, <q>I <i>like</i> sex -- and
    I <i>really</i> appreciate a man who's tempted by it. So, let\'s go for it,
    just you and me, for all eternity. And believe me, I can <i>really</i>
    deliver -- I'm a demoness, no human limitations, just boundless passion.
    So, here I am, take me! And to prove you really mean it, you can start by
    giving me a kiss!</q>"
    temptationState = agrathLust  
;

++ TemptationTopic @tKiss  
    "<q>I'd like a kiss!</q> you declare, cheekily.\b
    <q>A kiss! What a modest request!</q> she laughs, <q>You can kiss me any
    time! But it won't stop there, I promise you, I can give you <i>much</i>
    more than that, believe me. So come on then, kiss me, kiss me all you
    want!</q>"
    temptationState = agrathLust  
;


++ AskAboutForTopic @felicity  
    "<q>There's this woman I met -- Felicity Hope -- she's what I really
    want!</q> you say, <q>I want to see her again!</q>\b
    <q>To see her again? That's easy!</q> Agrath declares, <q>Look!</q>\b
    The demoness waves her arms in a strange fluid motion, and some sort of
    bubble-shaped viewing screen appears in the wall. On the screen you see a
    moderately clear view of Felicity Hope apparently in imminent danger of
    drowning in a particularly messy-looking marsh. You watch her struggles for
    a moment or two, then Agrath waves her arms again and the viewing screen
    disappears.\b
    <q>Do you really want this woman enough to rescue her? Are you brave enough
    to overcome all the perils in your path? Will you go in quest of her?</q>
    she asks.<.convnode felicity-quest><.reveal felicity-picture>"  
;

++ TemptationTopic @tMoney  
    "<q>I want to be rich -- give me money!</q> you demand.\b
    <q>Money! Yes! Riches beyond measure!</q> she declares eagerly, <q>I can
    certainly tempt you with that! Wealth beyond your wildest dreams!</q> She
    points to the north, <q>There!</q> she declares, <q>All the wealth and
    riches you could possibly want, yours for the taking! Just go and get
    it!</q>"
    temptationRoom = wealthRoom
    temptationState = agrathWealth
;

++ AskAboutForTopic @tJoy
    "<q>I want joy!</q> you declare, <q>I want happiness!</q>\b
    <q>Of course you do,</q> she replies, <q>everyone does; but the question
    is, what do you believe will bring you happiness and joy? That's what you
    have to ask me for!</q><.convstay>";
;

++ AskAboutForTopic @tLove
    "<q>The noblest thing is the universe is love!</q> you declare, <q>I want
    love!</q>\b
    <q>No, no, no!</q> Agrath shakes her head, <q>You're not making sense! You
    can't want love in the abstract, you can only love something in particular
    and want that! So you have to decide who or what it is you think you love
    or think you want to love or think you want to be loved by, and ask for
    that -- then I might consider whether it would be a worthy
    temptation!</q><.convstay>"
;

++ AskAboutForTopic @tHeaven
    "<q>I want to go to heaven!</q> you tell her.\b
    She shakes her head, <q>I can't tempt you with <i>that</i>!</q> she
    complains, <q>Heaven isn't a temptation, it's a reward for those who resist
    temptation -- and since you're here you can hardly one of those, can you?
    So, try again, tell me, what can I tempt you with? What do you really
    want?</q><.convstay>";
;

++ AskAboutForTopic @tLuck
    "<q>I could really use some good luck right now,</q> you tell her.\b
    <q>Yeah, yeah, yeah,</q> she replies dismissively, <q>but luck is never an
    end in itself, is it? People who want good luck want it as a help towards
    getting something else, like fame, wealth or power. So, you've just got
    lucky -- you've got me to supply your deepest desire -- so tell me what you
    really, really want.</q> "
;

++ AskAboutForTopic @tReality
    "<q>I just want to get out of here and back into the real world!</q> you
    tell her.\b
    <q>Real world?</q> she queries slyly, <q>Now there's a question-begging
    term! What do you mean by <q>real</q>? In any case, <i>I'm</i> the reality
    you have to deal with now, and there's nothing illusory about the
    temptations I have to offer -- so, make your choice, what shall I tempt you
    with?</q>"
;


++ TemptationTopic @distantGlow  
    "<q>Before I found my way into hell I saw a golden glow across a deep
    chasm,</q> you tell her, <q>it looked like some bright celestial city, a
    place of ultimate felicity and bliss. What I really want is to find a way
    to get there; can you give me that?</q>\b
    <q>Ah, the golden glow!</q> she smiles, <q>Many there are that have desired
    that! Well, I shan\'t hand it to you on a plate, a special prize like that
    is something you have to prove yourself worthy of. But I can help you on
    your way!</q>"
    temptationRoom = fireLedge
    secondResponse = "<q>There,</q> she says, <q>Go and seek your golden glare 
        -- if you can!</q>"
    temptationState = agrathExit  
;

++ TemptationTopic [tSleep, tDeath, tAnnihilation]
    "<q>I just want a good long rest -- that's the only thing that could tempt
    me now!</q> you declare.\b
    <q>I can go one better than that,</q> she replies, <q>I can offer you
    <i>eternal</i> rest. All you need to do...</q>"
    temptationRoom = oblivion
    secondResponse = "<q>... is walk right through there,</q> she points 
        towards the opening."
    temptationState = agrathRest 
;


++ TemptationTopic @tFame      
    "<q>Fame -- I want to be famous!</q> you say.\b
    <q>Fame, eh? Well I can manage that, easy peasy!</q> she tells you."
    temptationRoom = fameRoom
    temptationState = agrathFame   
;

++ TemptationTopic [tEscape, tFreedom]   
    "<q>All I want is to escape from you;</q> you reply, <q>the only thing you
    can tempt me with is a way out of here!</q>\b
    Agrath looks very thoughtful for a moment, then nods, <q>Yes, you speak
    true, that <i>is</i> what you really want. Very well, I shall oblige!</q>"
    temptationRoom = fireLedge
    temptationState = agrathExit   
;

++ AskAboutForTopic @tLife
    "<q>I want life!</q> you declare.\b
    <q>Well, of course you do, my little stray;</q> she coos, <q>that's just
    basic survival instinct. But now you're here, life has become a rather
    questionable concept. Anyway, bare <i>life</i> isn't all that exciting is
    it? A cabbage has life, and I assume you don't want to be a cabbage! So
    let's take life -- or at least your continued existence -- as a given and
    ask the more interesting question, what do you want to live <i>for</i>?
    What would make your existence more exciting? What can I tempt you
    with?</q>"
;

++ TemptationTopic @tGod   
    "<q>What do I want most of all?</q> you muse, <q>I want God!</q>\b      
    <q>God!</q> she storms, sounding extremely angry and highly scornful,
    <q>You ask me to tempt you with God? Pious twit! I could have given you all
    the things that real red-blooded men desire and you ask for God! Very well,
    you\'re clearly no use to me you pious milksop -- you\'d better get out of
    here!</q>"
    temptationRoom = fireLedge
    secondResponse = "<q>Now, go! Go and find your God -- if you can!</q>"      
    temptationState = agrathExit   
;

++ TemptationTopic @tKnowledge    
    "<q>Well, I\'m a scholar by trade, so I suppose that what I really want is
    knowledge,</q> you reply smugly.\b
    <q>Then knowledge you shall have, my good man!</q> Agrath declares, <q>All
    the knowledge you can imagine and more besides!</q>"
    secondResponse = "<q>Through there!</q> she declares, <q>Go and feast yourself on 
        knowledge!</q>"
    temptationRoom = library    
    temptationState = agrathKnowledge  
;

++ TemptationTopic @tFood  
    "<q>Right now, I could really do with a good meal!</q> you declare, <q>I'm
    famished!</q>\b
    <q>Then I shall serve you a feast -- a veritable banquet!</q> Agrath
    promises, <q>I shall cook and serve it myself -- and I'm really a
    <i>very</i> good cook, though I say so myself.</q> "
    secondResponse = "Indicating that you are to follow her, 
        she adds,  <q>Dinner is served -- after you, monsieur.</q>"     
    temptationRoom = feastRoom
    temptationState = agrathGluttony  
;

++ TemptationTopic @tBooze  
    "<q>I need a drink -- so how about some booze?</q> you suggest.\b
    <q>Is that <i>really</i> the best you can come up with?</q> Agrath
    disapproves, <q>Such low ambition for a scholar! But very well, if you
    must...</q>"    
    secondResponse = "<q>Through there!</q> she points, <q>all the drink
        you'll ever want!</q>"
    temptationRoom = boozeRoom
    temptationState = agrathBooze
;

++ TemptationTopic @tPower
    "<q>I want power!</q> you proclaim.\b
    <q>An honest assessment,</q> Agrath nods approvingly, <q>for that is what
    we all most desire at root.</q>"
    temptationRoom = powerRoom
    temptationState = agrathPower    
;

++ TemptationTopic @tOmnipotence
    "<q>Omnipotence might tempt me,</q> you suggest, <q>make me
    all-powerful!</q>\b
    Agrath shakes her head, <q>Omnipotence is too much,</q> she replies, <q>and
    I'm not even sure it's conceptually coherent. Besides, if I made you
    omnipotent you'd be more powerful than ME, and <i>that</i> I could never
    allow. But I will make you more powerful than any human being has ever been
    -- you'll have to settle for that.</q><.convnode nil> "
    temptationRoom = powerRoom
    temptationState = agrathPower   
; 

++ AskAboutForTopic @tGlory 
    "<q>What I really want is glory!</q> you declare.\b
    <q>When people ask for glory, what they really mean is they want power or
    fame,</q> Agrath observes, <q>Which of those are you after? Ask me for what
    you <i>really</i> want.</q>";
;

++ AskAboutForTopic @tSuccess
    "<q>I want success!</q> you tell her.\b
    <q>Sure, but what kind of success?</q> Agrath wonders, <q><q>Success</q> is
    usually a code word for something more specific, like sex, power, fame or
    wealth. So be more specific and ask me for what you really want!</q>"
;

++ DefaultAskForTopic, ShuffledEventList
    [
        '<q>No,</q> she shakes her head, <q>you may think you want that, but
        you don\'t want it <i>that</i> much -- I can tell. Try
        again.</q><.convstay>',
        
        '<q>No, you can\'t fool me, you don\'t <i>really</i> want that,</q> she
        replies, <q>Now tell me something you do really want.</q><.convstay>',
        
        '<q>That\'s not something you <i>really</i> want,</q> she pouts, <q>Now
        give me a sensible answer!</q><.convstay>',     
        
        '<q>I don\'t mean <i>that</i> sort of thing!</q> she complains, <q>I
        mean something I can seriously tempt you with! Now, pay attention and
        ask me for something you really really really want!</q><.convstay>',
        
        '<q>I don\'t believe you!</q> she declares, <q>You\'re just not the
        type to really want that. Now look, I\'m meant to be tempting you; we
        agreed, remember? So ask me for something you\'d <i>really</i> find
        tempting!</q><.convstay>'     
    ]
;

++ DefaultAnyTopic, StopEventList
    [
        '<q>No, we\'re not here for general chit-chat, I want to know what
        would really tempt you.</q> Agrath declares. <.convstay>',
        
        '<q>Ask me for something,</q> the demoness insists, <q>Ask me for
        whatever it is you really want.</q><.convstay>',  
        
        'Agrath is expecting you to ask her for something.<.convstay>',
        
        'Agrath is expecting you to ask her for something.\n
        [e.g. ASK AGRATH FOR MONEY or just ASK FOR MONEY] <.convstay>'
    ]
;

+ ConvNode 'felicity-quest'
    npcContinueMsg = "<q>Are you brave enough to go in quest of this Hope woman
        -- yes or no?</q> the demoness demands. "
    limitSuggestions = true
;

++ YesTopic, SuggestedYesTopic
    topicResponse()
    {
        "<q>Yes, I want to go and find her,</q> you declare.\b
        <q>Then find her you shall -- if you can!</q> Agrath replies, <q>But
        first, you need to leave this place -- see, I make a way out for
        you!</q> Agrath waves her arms again, this time towards the north. ";
        lairDoor.openTo(fireLedge);
        getActor.setCurState(agrathExit);
    }
;

++ NoTopic, SuggestedNoTopic
    "<q>No, actually I don't think I'm really not all that bothered.</q> you
    tell her.\b
    <q>I don't blame you,</q> Agrath sympathizes, <q>after all why should you
    want that human female when you could have <i>me</i>! So (hint, hint) tell
    me what you would really like. What should I really tempt you with?</q> She
    smiles alluringly, tosses her hair, and makes highly convincing come-on
    eyes at you. <.convnode temptation>"
;



class AgrathConversationState : InConversationState, ShuffledEventList
    [nil]  [nil]
    specialDesc = "Agrath is <<desc>>"
    stateDesc = "She's <<desc>>"
    desc = "standing in the middle of the chamber, pointing towards the
        north. " 
    attentionSpan = nil
    doScript
    {
        if(!getActor.conversedThisTurn())
            inherited;
    }
    nextState = agrathSpouting
    eventReduceAfter = nil
    eventReduceTo = 50
    kissResponse = "Agrath raises her hand to stop you; <q>Oh no,</q> she says,
        <q>it isn't me you want -- what you want lies through there!</q> she
        indicates the opening with a nod of her head. "
    hugResponse = (kissResponse)
    initializeActorState()
    {
        inherited;
        eventReduceAfter = eventList.length;
    }
;

+ agrathLust : AgrathConversationState
    [ nil ]
    [
        
        '<q>Well, what are you waiting for?</q> Agrath asks. ',
        
        'Agrath beckons you closer. ',
        
        'The demoness purses her lips at you. ',
        
        '<q>I\'m still waiting for my kiss,</q> Agrath remarks,    <q>A
        princess doesn\'t like to be kept waiting for such things, you know,
        <i>especially</i> if she\'s a demon princess!</q>',
        
        '<q>You want me to beg?</q> she asks, <q>A Queen of Hell has her pride,
        you know, so come on, kiss me!</q>',
        
        '<q>Look at this way, I\'m the most desirable female you\'re going to
        meet in a <i>very</i> long time, so we might as well start getting
        intimate right away. Come on, you asked for it, so take it! Give me a
        kiss!</q> Agrath tells you. ',
        
        '<q>One itsy bitsy little kiss isn\'t going to do any harm now, is
        it?</q> Agrath pouts, <q>So come on, show me what you can do!</q>'      
        
    ]
    
    desc = "standing just in front of you, her arms outstretched towards you, a
        welcoming smile playing on her lips. "
    kissResponse()
    {
        "You take a faltering step towards her, and hesitantly plant a kiss on
        her lips. At once, she wraps her arms around you, and presses her lips
        to yours, giving you the most passionate kiss you have ever
        experienced, causing you almost to explode with desire. But it doesn't
        end there...<.p>";
        inputManager.pauseForMore(nil);
        "Agrath gives no less than she promised. In fact, she gives a good deal
        more. She works you up into a frenzy of passion, and then invites you
        in, again and again and again. It is the most amazing experience of
        your life (or should that be death?), so that the more she gives you,
        the more you want, and the more desperately and passionately you want
        it. And still she goes on, feeding your desire until desire becomes
        obsession, obsession turns to addiction, and addiction becomes total
        enslavement.<.p>";
        inputManager.pauseForMore(nil);
        "Within a few hours ever growing desire for Agrath has banished every
        other thought and feeling from your mind, and still you carry on
        rutting with her, your need for her ever growing, your thought and will
        and humanity ever diminishing, until you become no more than an
        Agrath-bonking automaton.\b";
        
        inputManager.pauseForMore(nil);
        finishGameMsg('YOU ARE AGRATH\'S SEX-TOY FOR ALL ETERNITY', 
                      [finishOptionUndo, finishOptionFullScore]);      
    }  
    hugResponse = "You make to hug her, but she interrupts you, saying, <q>No,
        no, it's a <i>kiss</i> I want!</q>"
;

++ NoTopic, SuggestedNoTopic
    "<q>No, I've changed my mind,</q> you say, <q>I don't want to kiss
    you!</q>\b
    <q>Change your mind all you like!</q> she grins, <q>We've got all eternity
    to play this game, and you'll succumb to one of my temptations sooner or
    later! So, tell me, what else can I tempt you with?</q>
    <<getActor.setCurState(agrathTalking)>><.convnode temptation>"
;

++ AskTopic, SuggestedAskTopic [agrath, tKiss]
    "<q>Can I really kiss you?</q> you ask, <q>is it safe for a mere mortal to
    kiss a demon queen?</q>\b
    <q>Who said anything about safe?</q> she retorts, <q>This is about
    <i>temptation</i>, about <i>desire</i>, of course it's not safe! But I
    promise you it'll be exciting! So come on, what are you waiting for? Kiss
    me!</q>"
    name = 'the kiss'
;

++ DefaultAnyTopic
    "<q>Don't talk -- kiss me!</q> she urges you. "
;

+ agrathWealth : AgrathConversationState
    [ nil ]
    [
        '<q>Go on,</q> the demoness urges you, <q>there\'s a fortune waiting
        for you through there!</q>',
        
        'Agrath points to the opening, <q>You asked for riches -- go get \'em
        boy!</q>',
        
        '<q>I thought you said money would tempt you!</q> the demoness
        declares, <q>Through that opening is more money than you\'ve dreamt of.
        Go and take a look!</q>'  
        
    ]
    specialDesc  = "Agrath is pointing towards the opening. "
    stateDesc = "She's pointing towards the opening, waiting for you to move. "
;

++ NoTopic, SuggestedNoTopic
    "<q>No, I've changed my mind,</q> you say, <q>I don't want money all that
    much after all; what use is it to me down here?</q>\b
    <q>That's for you to decide,</q> she grins, <q>But we've got all eternity
    to play this game, and you'll succumb to one of my temptations sooner or
    later! So, tell me, what else can I tempt you with?</q>
    <<getActor.setCurState(agrathTalking)>><.convnode temptation>"
;

++ DefaultAnyTopic
    "<q>How can you stand here nattering when your heart's desire is just
    through that opening?</q> she demands, <q>Go on -- go and claim your
    riches!</q>"
;


+ agrathFame :  AgrathConversationState
    [ 
        '<q>Just go through there -- you\'ll find all the fame you want!</q>
        she promises you. ' 
    ]
    [
        '<q>You want to be famous, you go through there,</q> Agrath tells you,
        pointing to the opening. ',
        
        '<q>Look, as wonderful as I know I am, there\'s only one of me, and
        staring at one of me isn\'t going to make you famous. Fame lies through
        there.</q> she nods towards the north. ',
        
        '<q>What do I have to do to make this temptation more tempting?</q>
        Agrath asks, sounding mildly aggrieved, <q>Through that exit lies fame
        beyond your wildest dreams. Believe me, I <i>never</i> give short
        measure. So get going, you famous fellow!</q>'
        
    ]
    
;

++ NoTopic, SuggestedNoTopic
    "<q>Actually, I'm not so sure fame's all it's cracked up to be,</q> you
    confess, <q>maybe I don't want it all that much after all.</q>\b
    <q>Changed our mind, have we?</q> Agrath shrugs, <q>see if I care! We've
    got all eternity to play this game, after all. So tell me, if it isn't fame
    you want, what can I tempt you with? Ask me for anything you like!</q>
    <<getActor.setCurState(agrathTalking)>><.convnode temptation>"
;

++ DefaultAnyTopic
    "<q>You won't get famous chatting to me!</q> she points out, <q>Your fame
    lies through there!</q> she nods towards the opening, <q>Go get it!</q>"
;

+ agrathKnowledge: AgrathConversationState
    [ nil ]
    [
        '<q>Off you go now like a good little scholar!</q> Agrath urges you,
        pointing to the opening. ',
        
        '<q>You won\'t gain any knowledge just by standing there gawping, so
        why don\'t you just hurry along through there?</q> Agrath suggests,
        pointing northwards. ',
        
        '<q>Come on, now, you told me you wanted knowledge,</q> Agrath reminds
        you, <q>Now that I\'m offering it to you, why don\'t you go and get
        it? Hurry along now!</q>',
        
        'Agrath puts her hands on her hips and glowers at you, <q>I hope you
        weren\'t this reluctant to acquire knowledge as a student!</q> she
        remarks, <q>I offer you all the knowledge you can ever wish, and you
        just stand there. Get along with you!</q> she nods towards the exit. '      
    ]  
;

++ NoTopic, SuggestedNoTopic
    "<q>No,</q> you say, <q>I don\'t think I will go through there. Maybe
    knowledge isn't what I want after all.</q>\b
    Agrath shakes her head in mock despair, sending her orange tresses flying
    in all directions, <q>It sounds like knowledge is what you <i>need</i>
    right now -- some knowledge of what you actually <i>do</i> want! A bit of
    self-knowledge wouldn\'t go amiss, I\'m thinking! Very well, if it isn't
    knowledge you want, what it is it?</q>
    <<getActor.setCurState(agrathTalking)>><.convnode temptation>"
;

++ DefaultAnyTopic
    "<q>If you want to know about that, just go through there,</q> the demon
    queen nods towards the north, <q>you\'ll find all the knowledge you want
    about it there!</q>"
;

+ agrathGluttony: AgrathConversationState
    [nil]
    [
        '<q>Hurry along now, dinner is served and we wouldn\'t want it getting
        cold now, would we?</q> Agrath urges you, indicating that you are to
        precede her northwards. ',
        
        '<q>Typical man!</q> Agrath complains, <q>I go to all the trouble to
        cook and serve, and when I say the meal\'s ready you just stand around!
        Come on, get along with you!</q>',
        
        '<q>It\'ll be the best meal you\'ve ever had -- so what are you waiting
        for?</q> Agrath demands, <q>Go on, it\'s all good wholesome food,
        waiting for you, just through there!</q> she points to the north. '  
    ]
;

++ NoTopic, SuggestedNoTopic
    "Suspecting what the catch may be, you quickly retract, <q>On second
    thoughts, I may not be all <i>that</i> hungry!</q> you say.\b
    <q>Really?</q> Agrath enquires, <q>and it was <i>such</i> a good meal I had
    planned for you. Well, if it isn't food you want, what is it? For
    goodness's sake make up your mind!</q>
    <<getActor.setCurState(agrathTalking)>><.convnode temptation>"
;

++ DefaultAnyTopic
    "<q>Don't talk -- eat!</q> she tells you, <q>It's feeding time -- through
    there!</q> she indicates the northern opening with a nod of the head. "
;

+ agrathRest : AgrathConversationState
    [ '<q>Go on then, sleepy head, through there!</q> Agrath urges you,
    pointing to the exit.'  ]
    [
        '<q>Go on,</q> the demoness urges you, <q>there\'s lots of lovely
        sleep waiting for you through there!</q>',
        
        'Agrath points to the opening, <q>You asked for a rest -- go and take
        a rest!</q>',
        
        '<q>I thought you said sleep would tempt you!</q> the demoness declares,
        <q>Through that opening is the longest sleep you\'ve ever known. Go and
        rest!</q>'  
        
    ]
    specialDesc  = "Agrath is pointing towards the opening. "
    stateDesc = "She's pointing towards the opening, waiting for you to move. "
;

++ NoTopic, SuggestedNoTopic
    "<q>No, <i>eternal</i> rest sounds a bit too final,</q> you say, <q>I'm not
    <i>that</i> tired!</q>\b
    <q>You're not?</q> she asks, <q>Very well, we'll have to come up a livelier
    temptation then! So, tell me, what else can I tempt you with?</q>
    <<getActor.setCurState(agrathTalking)>><.convnode temptation>"
;

++ DefaultAnyTopic
    "<q>You are feeling very sleepy!</q> she croons, <q>Too tired to talk! Now,
    go off to sleep with you like a good little boy!</q>"
;


+ agrathExit : AgrathConversationState
    [ nil ]
    [
        'Agrath points to the north, <q>Go on, there\'s your way out, what are
        you waiting for, go!</q>',
        
        '<q>Don\'t just stand there, move!</q> she urges you, <q>that\'s the
        only way out of here you\'re going to get!</q>',
        
        'The demoness points firmly towards the exit. '  
    ]
    desc = "standing in the middle of the chamber, pointing towards the north. "   
;

++ DefaultAnyTopic
    "<q>I thought you couldn't wait to get away from me!</q> she replies
    coldly, <q>So why don't you just go!</q>"
;

+ agrathPower: AgrathConversationState
    [ 
        'Agrath stands by the newly opened doorway and beckons you to step
        through, <q>Go, take your power and reign,</q> she invites you. '
    ]
    [
        '<q>Your majesty, step this way and receive your kingdom!</q> Agrath
        urges you.' ,
        
        '<q>You want power, go and seize it -- through there!</q> Agrath
        command you, pointing through the exit. ',
        
        '<q>There\'s not much point asking for power if you can\'t even make
        your mind up to use it!</q> Agrath complains, <q>Go, seize it!</q>'  
        
    ]
    desc = "standing by the door to the north, gesturing for you to go
        through. "
;

++ NoTopic, SuggestedNoTopic
    "<q>They do say power corrupts,</q> you remark dubiously, <q>perhaps it's
    not such a good idea after all.</q>\b
    <q>Decisive, aren't we?</q> Agrath remarks, <q>well if you really can't
    make up your mind to wield power, you're probably not ready for it. So
    let's try again, shall we? What is it that you really want? What am I to
    tempt you with?</q> <<getActor.setCurState(agrathTalking)>><.convnode
    temptation>"
;

++ DefaultAnyTopic
    "<q>Don't talk -- rule!</q> she tells you, <q>Your empire awaits -- through
    there!</q> she indicates the northern opening with a nod of the head. "
;

+ agrathBooze : AgrathConversationState
    [
        '<q>Your drink is that way,</q> she insists, pointing north. '
    ]
    [
        '<q>Don\'t just stand there, go get your drink!</q> she tells you,
        pointing through the doorway. ',
        
        '<q>What are you waiting for?</q> she demands, <q>You asked for a drink
        -- so go and get it!</q>',
        
        '<q>I conjur up the best collection of booze ever for you and you just
        stand there!</q> she complains, <q>Go on! Drink! Enjoy!</q> she points
        to the north. '  
    ]
    desc = "staring at you fiercely and gesturing towards the door. "
;

++ NoTopic, SuggestedNoTopic
    "<q>Maybe I'm not <i>that</i> thirsty,</q> you remark dubiously.\b
    Agrath rolls her eyes in mock desperation, <q>Frankly, it was rather a
    pathetic choice,</q> she agrees, <q>so have another go and come up with
    something better. Now, what is that you really want?</q>
    <<getActor.setCurState(agrathTalking)>><.convnode temptation>"
;

++ DefaultAnyTopic
    "<q>Don't talk -- drink!</q> she tells you, <q>Your bar awaits -- through
    there!</q> she indicates the northern opening with a nod of the head. "
;



+ agrathInTomb : ActorState
    
    kissResponse = "She intercepts your kiss by putting her hand to your lips
        and gently pushing you away, <q>Not now, not yet -- later, maybe</q>
        she says. "
    
    hugResponse = "You decide that she really doesn't look that cuddly right
        now. "
    
    afterAction()
    {
        /* 
         *   The following test could probably have been written with the 
         *   gActionIn(macro): if(gActionIn(Push, Move, Pull, Take, Break, 
         *   Attack)...
         */
        
        if(gAction.baseActionClass is in (PushAction, MoveAction, PullAction, 
                                          TakeAction, BreakAction, AttackAction) 
           && gDobj == agrathCaveStone)
            pushStone.doScript;
    }
    pushStone : ShuffledEventList {
    [
        '<.p><q>Somehow, I don\'t think you\'re going to manage this by brute
        force,</q> Agrath remarks. <.reveal force-stone>'
    ]
    [
        '<.p><q>It\'s too heavy for you, you\'ll never move it like that.</q>
        Agrath remarks. ',
        
        '<.p><q>I should try a different approach if I were you,</q> Agrath
        suggests. ',
        
        '<.p><q>Not that I mind seeing you struggle,</q> says the demoness,
        <q>it\'s all part of the fun; but sooner or later you really are going
        to have to try a different approach.</q>',
        
        '<.p><q>Of course, if you don\'t manage to find a way to move that
        stone you and I will be shut up together in this cave for all
        eternity,</q> Agrath observes, <q>What fun!</q>',
        
        '<.p>Agrath claps her hands and laughs out loud at your futile
        efforts. ',
        
        '<.p><q>Well, that\'s hardly how I handled my little trick with
        bones,</q> Agrath observes, <q>and I doubt if it\'s how Mark envisaged
        Jesus doing it either!</q>',
        
        '<.p><q>Perhaps you should try being more masterful with it!</q> Agrath
        suggests. '    
    ]
    }
;

++ AskTopic, StopEventList, SuggestedAskTopic @agrath
    [
        '<q>Just who are you, Agrath?</q> you ask.\b
        <q>I told you, I\'m the princess of demons, Queen of Hell, and
        tempter-and-tormenter-in-chief,</q> she replies, <q>right now I\'m
        happily tormenting you with this little puzzle I\'ve devised for
        you!</q>',
        
        '<q>How did you get to be Queen of Hell and all the rest?</q> you
        wonder.\b
        <q>Charm, talent and determination,</q> she shrugs. ',
        
        '<q>Do you <i>like</i> tempting and tormenting people?</q> you ask.\b
        <q>Of course,</q> she replies, <q>it\'s what I do best!</q> ',
        
        '<q>Why are you so...</q> you begin.\b
        <q>So evil?</q> she suggests, <q>Because I\'m a demoness, and that\'s
        what demonesses are by nature. Or were you going to say something
        flattering, like <q>nice</q> or <q>friendly</q> or <q>attractive</q>?
        Well, you\'re the scholar, you should know the answer to that one -- if
        evil didn\'t make itself attractive, no one would fall for it, would
        they? Not that knowing that will stop you for falling for me, of
        course, they all do in the end.</q>',
        
        '<q>What do you want from me?</q> you ask.\b
        <q>I don\'t want anything <i>from</i> you,</q> she replies simply, <q>I
        just want <i>you</i>. And one way or another I\'ll have you.</q>\b
        This answer sends shivers down your spine. ',
        
        '<q>What would change your mind?</q> you want to know.\b
        <q>Nothing,</q> she smiles quietly, <q>absolutely nothing. I\'m not
        changeable, like a human. In fact I\'m nothing like a human at all,
        except in outward form. In a sense you could say I don\'t have a mind
        to change -- not a mind as you humans understand the term, at any rate.
        And I certainly don\'t have a heart, so don\'t make the mistake of
        thinking you can touch it in any way. Not that anything I say will do
        you the remotest good, of course!</q>',  
        
        '<q>So what do I have to do to appease you?</q> you ask bluntly.\b
        Agrath stares down at her fingernails for a few moments, before looking
        up and replying, <q>Oh, you\'ll find out, believe me!</q>'
        
    ]
    name = 'herself'
;

++ AskTopic, ShuffledEventList, SuggestedAskTopic @agrathCaveStone
    [
        '<q>So, how am I meant to budge this stone?</q> you ask.\b
        <q>That\'s your problem,</q> she shrugs. '
    ]
    [
        '<q>Are you sure there really is a way I can budge that stone?</q> you
        ask.\b
        <q>Oh yes, I always play fair,</q> she replies, <q>there is a way you
        can get that stone to move. Whether you\'ll manage to find it is quite
        another matter of course.</q> ',
        
        '<q>What happens if I do manage to get this stone to open?</q> you want to
        know.\b
        <q>Then we can both leave,</q> she answers. ',
        
        '<q>What happens if I can\'t find out how to move the stone?</q> you
        ask.\b
        <q>You can only give up by giving yourself up, by which I mean giving
        yourself to me, whole-heartedly and without reservation to do with just
        as I will.</q> she replies, <q>Personally I doubt you\'re ready for
        that just yet, but any time you are, just let me know.</q><.reveal
        give-yourself>',
        
        '<q>I don\'t suppose there\'s any chance you might give me a hint how I
        can get this blasted stone to move?</q> you ask her.\b
        <q>I suppose I might, if the mood takes me, or again, I might not,</q>
        she replies unhelpfully, <q>Of course you could always try to do
        something to persuade me, but there\'s no use trying to appeal to my
        better nature -- I haven\'t got one.</q>',
        
        '<q>What can I do to persuade you to give me a hint about how to shift
        this stone?</q> you ask.\b
        <q>Perhaps you should try being a bit more like me,</q> she replies
        enigmatically. '   
        
    ]
    shuffleFirst = nil
    name = 'the stone'
    timesToSuggest = nil
    isActive = gRevealed('force-stone')
;

++ AskAboutForTopic @tKiss
    "<q>May I kiss you now?</q> you ask, wondering perhaps if that's what she
    wants.\b
    She appears to consider the idea for a moment, then replies, <q>You can
    kiss me once you've moved that stone!</q>"
;

++ AskAboutForTopic, StopEventList, SuggestedAskForTopic @tAngel
    [
        '<q>What I need here is an angel or two to roll away the stone,</q> you
        suggest.\b
        <q>Shame on you!</q> Agrath retorts, <q>And you call yourself a New
        Testament Scholar! It\'s <i>Matthew\'s</i> Gospel that has an angel
        roll away the stone, but it\'s <i>Mark\'s</i> empty tomb story we\'re
        trying to recreate here.</q>',
        
        '<q>I still think an angel would be a good solution,</q> you insist.\b
        <q>Well, I\'m very sorry, but you can\'t have one,</q> Agrath replies. '   
    ]
    name = 'an angel'
;

++ AskTopic, SuggestedAskTopic @tSatan
    "<q>Are you <i>the</i> devil -- Satan, I mean?</q> you ask.\b
    <q>I am who I am,</q> she replies engimatically. "
    name = 'Satan'
;

++ AskTopic, SuggestedAskTopic @tHell
    "<q>Have you been in Hell long?</q> you ask.\b
    <q>Obviously, I'm Agrath, Queen of Hell and Princess of Demons,</q> she
    shrugs, <q>Hell and I go together like death and destruction.</q>"
    name = 'hell'
;

++ AskTopic @tSex
    "<q>How about sex?</q> you ask\b
    <q>You had your chance to choose your temptation before,</q> she reminds
    you, <q>now I call the tune!</q>"
;

++ AskTellTopic, SuggestedAskTopic @tHeaven
    "<q>Have you never thought of going to heaven?</q> you ask.\b
    <q>Of course not!</q> she replies, <q>What in hell's name for? Neither of
    us is fitted for heaven -- I because of what I am, and you because of what
    you have become!</q>"  
    name = 'heaven'
;

++ GiveTopic, SuggestedGiveTopic @gPlayerChar
    "<q>Okay, I give up, I'm never going to find a way to shift that stone,</q>
    you admit, <q>You win, you can have me!</q>\b
    <q>Are you quite sure?</q> she asks quietly.<.convnode sure-give>"
    name = 'yourself'
    isActive = gRevealed('give-yourself')
;

++ DefaultAnyTopic
    "In reply, Agrath merely cocks her eyebrow at you. "
;

+ ConvNode 'sure-give'
    isSticky = true
    limitSuggestions = true
    canEndConversation(reason)
    {
        return nil;
    }
    npcContinueMsg = "<q>It's a simple enough question,</q> she prompts you,
        <q>are you truly prepared to give yourself to me, yes or no?</q>"
;

++ YesTopic, SuggestedYesTopic
    "<q>Yes -- well, there seems nothing else for it, I'm stumped, I give
    up.</q> you affirm.\b
    <q>Are you really, really sure about that?</q> Agrath asks, <q>Are you sure
    you know what you are doing? If you give yourself to me, it will be without
    reservation, without reprieve. I will take you and do <i>precisely</i> what
    I want with you for all eternity, and you will have absolutely <i>no</i>
    say in what that is. You will become my plaything and my slave -- and there
    will be no going back for you from that -- ever. Are you really sure that's
    what you want?</q><.convnode sure-give2>"
;

++ NoTopic, SuggestedNoTopic
    "<q>No, maybe not,</q> you decide, <q>perhaps I should keep on trying with
    that stone.</q>\b
    <q>Maybe you should,</q> she agrees, <q>keep trying, then -- I'm not in any
    hurry!</q> <.convnode nil>"  
;


++ DefaultAnyTopic
    "<q>Don't try to change the subject: do you really want to give up and give
    yourself to me -- your whole self, without reservation -- yes or no?</q>
    she asks. "
;

+ ConvNode 'sure-give2'
    isSticky = true
    limitSuggestions = true
    canEndConversation(reason)
    {
        return nil;
    }
    npcContinueMsg = "<q>It's a simple enough question,</q> she prompts you,
        <q>are you truly prepared to give yourself to me, yes or no?</q>"
;

++ YesTopic, SuggestedYesTopic
    topicResponse()
    {
        "<q>It seems I have no choice,</q> you reply bleakly.\b
        <q>This could be the last choice you ever have,</q> Agrath replies,
        <q>But I see your mind is made up.</q> So saying, she <<agrath.posture
          == sitting ? 'stands up and' : ''>> walks slowly towards you. Gently,
        ever so gently, she takes your hands in hers, and then leans forward to
        give you a long, lingering kiss. Every second of that kiss sucks away
        your will and all your capacity for independent thought and action,
        until you are not only unable to disobey her, but unable even to frame
        the thought that you might want to disobey her.\b";
        finishGameMsg('YOU HAVE BECOME AGRATH\'S SLAVE',
                      [finishOptionUndo, finishOptionFullScore] );
    }
;

++ NoTopic, SuggestedNoTopic
    "<q>No, maybe not,</q> you decide, <q>perhaps I should keep on trying with
    that stone.</q>\b
    <q>Maybe you should,</q> she agrees, <q>keep trying, then -- I'm not in any
    hurry!</q> <.convnode nil>"  
;


++ DefaultAnyTopic
    "<q>Don't try to change the subject: do you really want to give up and give
    yourself to me -- your whole self, without reservation, for ever and ever
    -- yes or no?</q> she asks. "
;


+ agrathAbsent: ActorState
    /* Dummy state to change Agrath to when she's out of sight and inactive */
;


+ agrathSitAgenda : DelayedAgendaItem
    isReady = inherited && getActor.canSee(agrathCaveSlab) 
    && !gPlayerChar.isIn(agrathCaveSlab)
    invokeItem()
    {
        "<q>I think I'll sit here while I wait for you to move the stone,</q>
        Agrath decides, moving over to the stone slab, <q>I have a feeling this
        could be a very long wait!</q>";
        nestedActorAction(getActor, SitOn, agrathCaveSlab);
        isDone = true;
    }
;

/* 
 *   The topic responses for temptations that Agrath allows all follow a 
 *   similar coding pattern, so it's convenient to encapsulate that in a 
 *   custom class.
 */

class TemptationTopic : AskAboutForTopic
    handleTopic(fromActor, topic)
    {
        inherited(fromActor, topic);
        "<.convnode nil> ";
        if(temptationRoom != nil)
        {      
            openCommand.doScript;   
            lairDoor.openTo(temptationRoom);
        }
        if(secondResponse != nil)
            secondResponse;
        if(temptationState != nil);
        getActor.setCurState(temptationState);   
    }
    temptationRoom = nil
    temptationState = nil
    secondResponse = nil
    openCommand : ShuffledEventList {
    [
        '<.p>She turns to the north and commands, <q>Open!</q> ',
        
        '<.p>Jabbing a finger to the north, she cries, <q>Open!</q> ',
        
        '<.p>Turning to face the northern wall of the chamber, she
        commands, <q>Be open!</q> ',
        
        '<.p>She turns to face north, places one hand on her hips and points to
        the wall with the other, <q>I command you, open!</q> she cries. '  
        
    ]
    }
    
;
