#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "AHA.h"

/* 
 *   thoughts.t - part of All Hope Abandon 
 *
 *   Implements a THINK ABOUT command
 *
 *   This is principally to bridhe the gap between Player and Player 
 *   Character knowlege; the Player can access the PC's specialist knowledge 
 *   by thinking about things.
 *
 *
 */

DefineTopicAction(ThinkAbout)
    execAction()
    {
        if(gActor.isIn(deconstruction))
            deconstructionThoughts.handleTopic(gActor, gTopic, consultConvType, nil);        
        else
            thoughts.handleTopic(gActor, gTopic, consultConvType, nil);            
    }
;

VerbRule(ThinkAbout)
    ((('think' | 'th' )'about')  | 'th') singleTopic
    : ThinkAboutAction
    verbPhrase = 'think/thinking (about what)'
;  

class VConsultTopic: ConsultTopic
    isActive = gPlayerChar.hasSeen(matchObj)
;

 /* 
  *   We leverage the libraries Consultable class to provide responsed to 
  *   THINK ABOUT
  */


thoughts : Consultable
    
;

+ ConsultTopic @worts
    "You think he's a boring, pretentious pseudo-scholar. "
;

+ ConsultTopic @tActsOfJesus
    "The <i>Acts of Jesus</i> is one of the books produced by the group of
    scholars known as the Jesus Seminar. The books prints the text of the four
    canonical gospels, together with <q>The Sayings Gospel Q</q> (which in your
    opinion never existed) and the (fragmentary) Gospel of Peter, showing
    Jesus' deeds in one of four colours: red, pink, grey or black. The colour
    is intended as a judgement of authenticity, anything shown in red being
    judged an authentic deed of the historical Jesus, pink a possibly authentic
    deed, grey something that is doubtful, and black something that almost
    certainly doesn't (in the opinion of the Jesus Seminar) go back to the
    historical Jesus. An earlier publication called <i>The Five Gospels</i> did
    much the same thing for Jesus' reported words. "
;

+ ConsultTopic @tPericope
    "A pericope (pronounced <q>pe<i>rik</i>opee</q>) is a short self-contained
    unit of text, the kind of biblical passage that might be chosen for reading
    as a lesson in church. Mark 18.1-6 (the story of the Empty Tomb) is a
    typical example of such a unit. One wry reflection you have about this word
    is that it so often helps you tell when your students have let their
    spell-checkers loose on their essays, for this invariably turns the
    Evangelists into submariners. "
    
;

+ ConsultTopic @tMidrash
    "In your opinion <q>midrash</q> is becoming a vastly overworked term in the
    discipline. Strictly speaking it refers to a genre of rabbinic literature
    that <i>interprets</i> a biblical text by expanding on the details,
    referring to other texts, and so forth. But the term is all too readily
    used to mean any imaginative weaving of a new story based on themes and
    motifs taken from the Old Testament. A rabbinic midrash on Exodus, say, is
    quite clearly and explicitly an interpretation of some part of the book of
    Exodus, but Wortschlachter seems to be using the term in some quite
    different sense if he's talking about what Mark did in his account of the
    Empty Tomb, since whatever else it is, that story is not an explicit
    interpretation of Old Testament scripture. "
;

+ ConsultTopic @tReligionsGeschichte
    "<i>Religionsgeschichte</i> is a technical term of New Testament
    scholarship which, if rendered into English, is normally translated as
    <q>history-of-religions</q> (even though the German means <q>history of
    religion</q>, singular). In general it denotes a strictly historical (or
    historical-sociological-anthropological) attempt to understand Christian
    origins in relation to its religious context (i.e.\ Second Temple Judaism
    and contemporary Hellenistic religions), and, in particular to trace the
    influence of these other religions on the nascent Christian religion.\b
    So far as you can tell, however, Wortschlachter's use of the term means
    virtually nothing, or at least nothing more than <q>the context of the
    religious ideas of the time</q>. "
;

+ ConsultTopic @tSitzImLeben
    "<q>Sitz im Leben</q> is another of those technical terms deriving from
    German New Testament scholarship (and imported untranslated into English)
    that is in some danger of getting badly overworked. A literal translation
    would be <q>seat in life</q> but the intended meaning is something more
    like <q>life-setting</q>. Originally it was used to refer to the supposed
    settings in the life of the primitive church in which certain forms of oral
    tradition (e.g.\ parables or miracle stories) might typically have been
    employed (and hence had some reasonably definite meaning within a
    particular kind of theory about the transmission of this oral tradition).
    So far as you can tell, however, Wortschlachter is using it to mean little
    more than <q>setting</q> or <q>place</q>. "
;

+ ConsultTopic @tTargum
    "<i>Targum</i> (plural <i>targumim</i>) was the name given to an Aramaic
    translation of the Hebrew scriptures (i.e.\ Old Testament) for the benefit
    of ordinary folk whose first language was Aramaic rather than Hebrew. The
    targumim were often not straightforward translations but paraphrases, often
    expanding the original Hebrew with imaginative and explanatory additions
    (for example to fill in perceived gaps in the story). All the surviving
    targumim are from later than the time of Jesus (or Mark), so by referring
    to <q>proto-rabbinic</q> targumim (i.e.\ targumim from before the rise of
    rabbinic Judaism post 70 CE) you suspect that Wortschlachter is trying to
    suggest an earlier dating, or at least a dating contemporary with the
    composition of Mark (probably circa 70 CE, the date of the destruction of
    the temple by the Romans at the end of the Jewish revolt). If so, he's
    simply talking twaddle in your opinion, since no such <q>proto-rabbinic
    targumim</q> actually survive to be consulted. "
;

+ ConsultTopic @tPhilo
    "Philo of Alexandria, a contemporary of Jesus, was one of the most learned
    men of his age. A wealthy Jew living in the Egyptian city of Alexandria, he
    created a synthesis of Jewish Scripture and Greek philosophy (of a
    predominantly but not exclusively Platonic variety), which, according to at
    least one scholar (H.A. Wolfson) made all the basic moves followed by all
    Jewish, Christian and Islamic philosopher-theologians until the synthesis
    was broken down by Spinoza. Philo achieved this synthesis mainly through
    the allegorical interpretation of scripture (i.e.\ finding a deeper meaning
    beyond the surface, literal meaning of the text).\b
    In your opinion, Wortschlachter is simply being pretentious in referring to
    <q>Philonic exegesis</q> in relation to Mark. Mark is a brilliant
    story-teller, but he's not in the same intellectual league as Philo.
    Wortschlachter is simply trying to bullshit his audience into accepting his
    thesis that Mark did not intend the story of the Empty Tomb to be taken
    literally. Even if that is so, the case needs to be made by other means. "   
;

+ ConsultTopic @tPilate
    "Pontius Pilate was the Roman governor of Judaea at the time of Jesus, and
    was apparently responsible for ordering Jesus' execution. That Jesus was
    crucified strongly indicates Pilate's involvement, since crucifixion was a
    Roman punishment reserved for political rebels and runaway slaves. The
    gospels try to whitewash Pilate (perhaps in the interests of downplaying
    the political implications of Jesus' crucifixion), but contemporary Jewish
    writers such as Philo and Josephus refer to him in very unflattering
    terms. "
;

+ ConsultTopic @tCaiaphas
    "Caiaphas was the Jewish High Priest at the time of Jesus' execution. He
    was not simply a religious official (like a modern pope or archbishop), but
    the leading Jewish political figure, the man the Romans would have held
    responsible for keeping order. His term of office was roughly coterminous
    with Pilate's governorship, which suggests that the two men probably had a
    pretty good working relationship. The gospels give Caiaphas a leading role
    in securing Jesus' execution, though what actually happened is far less
    clear (since the evangelists seem to have had a vested interest in blaming
    the Jews for Jesus' death and exculpating the Romans). "
;

+ ConsultTopic @tJosephus
    "Flavius Josephus (aka Joseph ben Matthias) was a Jewish aristocrat born
    into a priestly family, who lived from roughly 40 to 100 CE. During the
    Jewish War of 66-70 CE he was appointed by the Jewish rebels to take charge
    of operations in Galilee, but after his capture by the Roman general
    Vespasian he effectively changed sides, ingratiating himself with Vespasian
    by prophesying (correctly, as it turned out) that Vespasian would become
    emperor. For the rest of the war Josephus served as a kind of Jewish
    advisor to the Roman forces. Afterwards he wrote a highly tendentious
    account (ostensibly to <q>set the record straight</q>) called <i>The Jewish
    War</i>, designed to demonstrate that the disastrous Jewish revolt was the
    the fault of a lunatic fringe, and not of the great majority of decent Jews
    and Romans (and also to justify his own role in events). Josephus much
    later penned an autobiography also designed to justify his role in the war,
    but telling a story not easy to square with that in the <i>Jewish War</i>;
    the modern reader gets the impression that he is seeking as much to
    obfuscate as to explain at this point.\b
    Josephus also wrote a defense of Judaism called <i>Against Apion</i> and a
    massive twenty-volume work called <i>The Antiquities of the Jews</i>,
    giving an account of the Jewish people from the creation of the world to
    the outbreak of the Jewish Revolt, and clearly designed to promote a
    positive view of the Jewish people and their religion. The first half of
    the <i>Antiquities</i> basically retells the story of the Old Testament in
    the style of a Hellenistic historian, while the second half covers much the
    same ground as the early part of the <i>Jewish War</i>. Book 18 of the
    <i>Antiquities</i> contains a well-known and much debated paragraph about
    Jesus Christ, which you're almost certain is a later interpolation by a
    Christian hand.\b But despite the fact that Josephus is five parts
    propagandist and five parts spin-doctor, he remains the single most
    valuable source for our knowledge of first-century Judaism. "
;

+ ConsultTopic @tBreakfast
    "That was some time ago, and lunch has since intervened, but you still
    remember your brief encounter with the blonde woman you can see sitting
    three rows ahead. "
;

++ AltTopic
    "You were quite looking forward to something to eat, and even more to your
    first cup of tea of the day, but it was the blonde that most interested
    you. "
    isActive = (gPlayerChar.isIn(breakfastQueue))
;

++ AltTopic
    "Breakfast seems a long time ago now. "
    isActive = limbo.seen
;

++ AltTopic
    "Maybe the hospital staff will bring you something to eat soon. "
    isActive = hospital.seen
;

+ ConsultTopic [tPain, tChest, tTwinge]
    "You're not sure what the pain is, but you sure wish it would go away. "
    isActive = gRevealed('pain')
;

++ AltTopic
    "The pain you suffered in Wortschlachter\'s lecture seems to have gone, and
    for now you\'re content to leave it at that; except that you have a pretty
    shrewd idea that you know what caused it. "
    isActive = limbo.seen
;


+ ConsultTopic [blondeWoman1, felicity, blondeWoman]
    "Although you hardly know <<limbo.seen ? 'Felicity Hope' : 'the blonde
        woman'>>, and you've only spoken to her once, you find yourself
    strangely attracted to her, and feel that you'd really like to get to know
    her better. The trouble is that in your experience women tend to be divided
    into two categories: the undesirable and the unavailable, and since she's
    clearly not in the former category she must be in the latter -- or maybe
    that's just a lame excuse for your shyness. <<limbo.seen ? 'But in any
        case, all that would appear to be purely academic now. ' : ''>> "
;

++ AltTopic
    "The picture of Felicity drowning in a swamp leaves you feeling strangely
    disturbed. Rationally, you can't tell what its significance might be, but
    instinctively you feel that it's an indication that she's in deep trouble
    and it's up to you to save her. "
    isActive = gRevealed('felicity-picture')
;

++ AltTopic
    "You wonder what on earth she's doing in that swamp, and you think you'd
    better get out of it as quickly as possible. "
    isActive = (felicity.seen && felicity.isIn(swamp))
;

++ AltTopic
    "You still can't get over your surprise at finding her in this place, but
    you're very glad of her company. "
    isActive = (felicity.curState == felicityFollowing)
;

++ AltTopic
    "You think it's very noble of Felicity to hold the rope to let you cross,
    and you suspect that she knows very well that by doing so she's very
    probably sacrificing her own chance of being able to cross the chasm and
    reach the golden glow. You're also well aware that you've got to make up
    your mind whether to allow her sacrifice or find some way of preventing
    it. "
    isActive = (felicity.curState == felicityHolding)
;

++ AltTopic
    "You can hardly believe what happened to her, even though you saw it with
    her own eyes. You still can't understand what possessed her to try to cross
    that bridge, but you keep wishing that it hadn't. Your sense of loss is
    unbearable. "
    isActive = (felicity.isIn(nil))
;

++ AltTopic
    "You're really surprised to see her here; you had no idea she cared. "
    isActive = (felicity.curState == felicityHospital)
;


+ ConsultTopic @tWirrstadt
    "The University of Wirrstadt sounds like a good place for someone of
    Professor Wortschlachter's calibre to be working. For unless you're much
    mistaken, <q>Wirrstadt</q> means something like <q>Confusedville</q> or
    <q>Muddleton</q>."
;

+ ConsultTopic @tMark
    "In common with the majority of your fellow New Testament scholars you're
    fairly convinced that Mark was the first of the canonical Gospels to be
    written and one of the main sources of the Gospels of Matthew and Luke.\b
    The ending of Mark\'s Gospel -- his account of the empty tomb -- has always
    seemed a bit of an enigma. It goes without saying that you think the
    original text ended at Mark 16.8, since the so-called <q>longer ending</q>
    (Mark 16.9-20) is clearly a spurious addition by a later hand, and is not
    found in the best manuscripts.\b
    
    Mark 16.1-8 contains Mark's account of the Empty Tomb of Jesus by the women
    who go there with the intention of anointing Jesus' body with spices.
    Instead they find the stone rolled away and a young man dressed in white
    who tells them that Jesus the crucified Nazarene is not there but is risen.
    The young man then instructs the women to go and tell Peter and the
    disciples that Jesus is going before them to Galilee, where they will meet
    him, as he said; at that point the women flee from the tomb in terror,
    saying nothing to anyone.\b And on this note Mark's Gospel ends -- no
    actual appearances of the risen Jesus are ever narrated."
;

+ ConsultTopic @tPants
    "The Pan-Atlantic New Testament Society is so-called in an attempt to
    overcome a bias towards either European or North American scholarship,
    though the acronym that results is absurdly silly, in your view, and the
    make-up of those attending is still largely dictated by the accidents of
    geography. As conferences go, this one seems to have a reasonably
    interesting programme. "
;

+ VConsultTopic @limbo
    "You\'re not sure what to make of this place: it's neither being nor
    non-being, life nor death. It strikes you that all you can do is to try to
    find your way around and see what turns up. "   
;

+ ConsultTopic @orangeGlow
    "You don't know what that orange glow represents, but it does appear to be
    the only hint of light or warmth around. Indeed, it seems to be the only
    distinctive feature of an otherwise featureless environment. That alone
    would seem to make it worth investigating further. "
    isActive = orangeGlow.seen && !hellsGate.seen
;

+ ConsultTopic [wintryTree, knife]
    "You wonder how the knife came to be stuck in the tree. The tree looks very
    wintry, in the deadest state a living tree can be, so it occurs to you that
    sticking the knife into it might be a kind of symbolic killing. It's also
    possible that the knife was used to cut the rope bridge from the missing
    post, thus cutting off what seems to be the only path to the living hope
    represented by the distant golden glow. But that still leaves open the
    question of who performed these acts and why. "
    isActive = knife.seen && 
    !(antiquity.seen || tombGarden.seen || gardenPainting.seen)
;

++ AltTopic
    "The knife being stuck into the tree is certainly odd, but a more immediate
    thought occurs to you in connection with the knife -- you need to take a
    closer look at that rope bridge. "
    isActive = location.isActive && !ropeBridge.described
;

+ ConsultTopic @tDeath
    "To be honest, it's one of those things {you/he} prefer{s/ed} not to think
    about if {you/he} {can} help it. "
;

++ AltTopic
    "It's not something you're all that anxious to become personally acquainted
    with, but you're beginning to feel like you're about to find out more about
    it than you'd really like to. "
    isActive = gRevealed('pain')
;

++ AltTopic
    "You're not at all sure whether death is something you're now experiencing,
    or whether it's rather some intermediate state between life and death. Even
    if you are dead, you still seem to be capable of feeling pain, and you
    suspect that there could be an ultimate spiritual death lying beyond mere
    physical death, so you're not anxious to take any foolish risks on the
    basis that dead people can come to no more harm -- your working assumption
    is that you may well be able to come to more harm. "
    isActive = limbo.seen
;

++ AltTopic
    "Right now, you're just glad to have escaped it. "
    isActive = hospital.seen
;

+ VConsultTopic @demon
    "You\'re not quite sure what to make of him: on the one hand he's drably
    dressed and seemingly engaged on a mundane task, and in another context his
    grotesque appearance would almost be comic; he looks just <i>too</i> much
    like the traditional idea of a demon to be quite real. On the other hand,
    since he's a demon, he might well turn out to be dangerous."   
;

++ AltTopic
    "You\'re still not quite sure what to make of him: although he seems
    harmless enough, and even quite friendly in a funny sort of way, there's
    still something demonic about him. Perhaps he's simply not in a position to
    harm you, and views you as a welcome distraction; he may be safe to talk
    to, but you're not at all sure you'd want to put too much trust in his
    benevolence. "
    isActive = gRevealed('demon-speak')
;

+ VConsultTopic @studdedGate
    "You don't think you're likely to get through that massive gate in a hurry. "  
;

+ ConsultTopic @gateLettering
    "A couple of things strike you about it; firstly, there's that missing E at
    the end and the possible double entendre that results. But then there's the
    oddity of finding such a clich&eacute; over what purports to be the real
    gate of hell. "
    isActive = (gateLettering.described)
;

+ ConsultTopic [tBultmann, tDemythologization]
    "The German theological and New Testament scholar Rudolf Bultmann
    (1884-1976) was arguably the most influential New Testament scholar of the
    twentieth century. His programmatic essay on demythologization (written in
    1940) contains one of the most oft-quoted passages in NT scholarship: <q>It
    is impossible to avail oneself of modern medicine and use electric lights
    and radio and believe in the New Testament world of miracles and
    spirits.</q> Bultmann's point was that modern people no longer share the
    mythological world view of the first century, and cannot be expected to
    give their assent to it. The message of the New Testament therefore needs
    <q>demythologizing</q>, by which Bultmann meant translating into the
    categories supplied by the existentialist philosophy of Martin Heidegger.
    The problem to which Bultmann drew attention strikes you as still very much
    a real one, even if you're not so sure about his solution."
;

+ ConsultTopic @tHeidegger
    "You don't consider yourself much of an expert either on Martin Heidegger
    or existentialism. You have a vague recollection that Heidegger's brand of
    existentialism, as employed by Bultmann (and several other Christian
    theologians) talked about human existence in terms of being thrown into a
    world in which one has to come to terms with death and finitude and choose
    between authentic and inauthentic existence. You also vaguely recall that
    Heidegger was accused of being a Nazi sympathiser. "  
;


+ ConsultTopic @tHell
    "You feel morally certain that if it really exists it's best avoided; but
    it also occurs to you that in Dante's allegory the only way to Paradise was
    through hell. "
;

+ ConsultTopic @tHeaven
    "You reckon it would be good to get there, if possible. But that assumes it
    actually exists, and isn't simply a mythological way of talking about
    something else. In any case, as you're all too aware, in the New Testament
    <q>heaven</q> normally referred to the abode of God, not to some place
    where pious people go for their reward after death. "
;

+ VConsultTopic @pipe
    "You reckon that the pipe looks large enough for you to squeeze into, and
    that it's possible it might go somewhere, but you really don't fancy trying
    it right now. "
;

++ AltTopic
    "As reluctant as you are to venture into that pipe, you are beginning to
    suspect that for now you have exhausted all over possibilities, and that
    since the only alternative is to hang around the foot of these cliffs for
    all eternity, you might as well give it a go. "
    isActive = (ropeBridge.seen)
;

++ AltTopic
    "Whether it was wise to crawl into that pipe remains to be seen, but it
    looks like there's no going back, so you decide you'll just have to make
    the best of it. "
    isActive = (insideBoiler.seen)
;

+ ConsultTopic +110 [pipe, wireGrating]
    "It's clear you\'re not going to be able to crawl into that pipe again. You
    suspect that the grating was put there for the very purpose of stopping
    you, perhaps by the workdemon. "
    isActive = (wireGrating.seen)
;

+ ConsultTopic +110 [distantGlow, faintGlow]
    "Although you can't be quite certain what you<<
      gPlayerChar.getOutermostRoom() is in (chasmEdge, cliffGarden,
                                            skullMountain) ? '\'re looking at'
      : ' saw'>>, you feel that the golden glow must be a place of felicity and
    bliss, a city of the blessed. Since nothing else you've found since
    arriving in this netherworld has offered much sign of hope, you decide that
    trying to get to that golden city is the most useful goal you can set
    yourself, whatever it takes, and however long it takes. "
    isActive = (distantGlow.seen) 
;

+ ConsultTopic @chasm
    "It's obviously uncrossable, and it calls to your mind a verse from the
    Lukan parable of the Rich Man and Lazarus: <q>And beside all this, between
    us and you there is a great gulf fixed: so that they which would pass from
    hence to you cannot; neither can they pass to us, that would come from
    thence.</q>"   
    isActive = (chasm.seen && gTokensInclude('chasm') )
;

+ ConsultTopic @ropeBridge
    "It's very frustrating: it looks as if the rope bridge could have taken you
    across the chasm if only it were in better repair. In its present state
    it's obviously far too dangerous to attempt. "
    isActive = (ropeBridge.described)
;

+ ConsultTopic [newspaper, tPrivyCouncil]
    "It occurs to you that the newspaper is referring to the 1864 judgment by
    the then Lord Chancellor, Lord Westbury, clearing two Anglican clergymen
    (Williams and Westbury) on charges of heresy that had been brought against
    them on account of their contributions to the controversial volume
    <i>Essays and Reviews</i>. The primary purpose of the volume was to
    introduce British readers to the advances in Biblical scholarship (that had
    been taking place mainly in Germany); the volume was felt to be offensive
    in some quarters because it challenged the traditional, pre-critical
    understanding of the Bible. The effect of the judgment was to open the door
    to a more critical approach to the Bible among Anglican clergy (and thus in
    England generally). The headline  <q>Hell Dismissed With Costs etc.</q> was
    how one wag described the judgment at the time.\b
    <i>Essays and Reviews</i> was published in the same year as Darwin's
    <i>Origin of Species</i>. It is arguable which actually represented the
    greater challenge to traditional Christianity; as a biblical scholar you
    suspect that it may have been the former (in the sense that critical
    biblical scholarship has turned out to be a bigger challenge than natural
    science), and the fact that an allusion to <i>Essays and Reviews</i> has
    turned up in the <i>Diabolical Gazette</i> suggests that Hell might agree
    with you. "
    isActive = (newspaper.described)
;

+ VConsultTopic @impressiveMural
    "You think the mural gives a pretty bloody interpretation of the events of
    the nineteenth century, but you note the way it implicitly blames much of
    the bloodshed on the denizens of hell. "
;

+ ConsultTopic @tWar
    "You've never been a pacifist, but you consider war to be a bloody business
    only really justifiable as a last resort, hellish to undergo, and best
    avoided if at all possible. "
;

+ ConsultTopic + 90 @tMovie
    "It seems a bit like a diabolical send-up of old silent films, although
    having the death-dealing train come steaming out of the tomb from which one
    might have expected a resurrection strikes you as a particularly nasty
    touch. "
    isActive = (gRevealed('train-movie'))
;

+ ConsultTopic @tMovie
    "Your first thought is that the movie is about the futility of war, but
    then you think it may be intended as a comment on the futility of humankind
    -- building only in order to destroy. "
    isActive = gRevealed('war-movie')
;

++ AltTopic
    "It occurs to you that the city in the war movie is a lot like the ancient
    city you visited down the Via Antiqua, although when you visited it you
    could see no signs of the destruction depicted in the movie. "
    isActive = ancientCity.seen && !battlefield.seen && gRevealed('war-movie')
;

++ AltTopic
    "The final seen in the movie in which a city is first built and then
    destroyed by war reminds you of the battlefield you visited in which only a
    ruined basilica was left standing. "
    isActive = !ancientCity.seen && battlefield.seen && gRevealed('war-movie')
;

++ AltTopic
    "The beginning and end of the movie involving the city and the war reminds
    you of two places you have visited recently. The city you saw built in the
    movie is surely the ancient city you found down the Via Antiqua. The final
    scene, in which the whole city has been reduced to mud and rubble apart
    from the basilica looks strangely like the battlefield you found at the
    start of the Via Moderna. Evidently, there must be a link between the two.
    Moreover, at the end of the film that pair of demons walked on with a
    placard promising <i>real</i> destruction, which is surely what's happening
    out on that battlefield with all the apparatus of twentieth-century
    warfare. "
    isActive = ancientCity.seen && battlefield.seen && gRevealed('war-movie')
;

++ AltTopic
    "You found the movie depicting the torture of the inmates of hell utterly
    disgusting; it makes you heartily glad that the place has now been 
    closed for demythologization, hopefully with no prospects for reopening. "
    isActive = gRevealed('torture-movie')
; 

+ ConsultTopic @tStrauss
    "You feel that there's been a willful confusion of Strausses on that brass
    cylinder. David Friedrich Strauss published his bombshell of a book in 1835
    under the title <i>Leben Jesu kritisch bearbeitet</i> (<q>The Life of Jesus
    Critically Examined</q>); it caused such a huge stir that it ended
    Strauss's academic career. Strauss pointed out the discrepancies between
    the various gospels, not least in the miracle stories, and argued that this
    showed that the gospels could not possibly be understood as history, but
    must instead be understood largely as <q>myth</q>.  However, this has
    absolutely nothing to do with the Strauss family who composed waltzes, or
    Richard Strauss who composed the tone-poem <i>Also Sprach
    Zarathustra</i>. "
    
    isActive = gRevealed('strauss')
;

+ ConsultTopic [moses, tExodus]
    "According to the Old Testament, Moses was the man chosen to lead Israel
    out of Egypt at the time of the Exodus. For Jews at the time of Jesus he
    was one of the most revered great men of God at the past. "
;

++ AltTopic
    "Exodus chapter 4 describes how God gave Moses three signs that would
    enable him to persuade his audience that God had indeed appeared to him and
    commissioned him to lead Israel out of Egypt. The first of these signs was
    that when Moses dropped his rod, it turned into a serpent, and when he
    picked up his serpent by its tail, it turned back into a rod. "
    isActive = (moses.described)
;

+ ConsultTopic @mosaic
    "<<apse.thinkHere()>>"
    isActive = gRevealed('mosaic-desc')
;

+ ConsultTopic @gardenPainting
    "You think it looks a bit odd. It's conventional enough in its depiction of
    Mary Magdalene (at least, you assume that's who's she's meant to be)
    approaching Jesus' tomb through the garden, as it might appear looking out
    through the mouth of the cave. But it seems somehow out of place here, like
    a piece of obviously painted stage-set scenery used to complete an
    otherwise authentic scene. "
    isActive = (gardenPainting.described && gPlayerChar.canSee(gardenPainting))
;

++ AltTopic
    "Well, who would have thought there'd be a way through that painting! "
    isActive = gardenPainting.isOpen && !(lake.seen || largeLawnNorth.seen
                                          || monitorPicture.seen || tombGarden.seen)
;

+ skullTopic: VConsultTopic @skullStatue
    "You're not entirely sure what it's meant to represent, although you're
    struck by the fact that it occupies roughly the same place in the cave as
    did the red-clad woman in the painting. Perhaps it's making some statement
    about the ravages of time, or perhaps it's simply mocking the empty tomb
    story by signifying the death of the woman who was meant to be the first to
    find evidence that Jesus had risen from the dead. "  
    matchScore = (gPlayerChar.lastStatueLoc == gardenCave ? 110 : 90) 
;

+ streetTopic: ConsultTopic [stoneStatues, womanStatue]
    "You think there's something strange and disturbing about all the statues
    in the street, that of the long-haired woman most of all. "
    isActive = stoneStatues.seen
    matchScore = (gPlayerChar.lastStatueLoc == statueStreet ? 110 : 90)
; 

+ ConsultTopic @tAphrodite
    "In Greek mythology Aphrodite was the goddess of love and beauty -- a powerful
    deity if not infrequently a troublesome one. "
;


+ VConsultTopic @chaosSea
    "The sea beyond the cave at the dawn of time strikes you as being a
    mythological representation of primal chaos, as in Isrealite and many other
    ancient near-eastern myths. Its waves of nothingness are in effect the
    state of chaotic non-being that was all there was before anything else was.
    That you can actually stand on the shore of such a sea suggests that the
    demythologization of Hell still has quite some way to go. "  
;

+ ConsultTopic @tJesusWalking
    "Varying accounts of Jesus walking on the sea (i.e.\ Lake Tiberias aka the
    Sea of Galilee) occur at Mark 6.45-52, Matthew 14.22-33 and John 6.15-21
    (but not in Luke). In your opinion none of these accounts is remotely
    historical (or at least, if there is an occurrence that lies behind them it
    is no longer remotely recoverable). Instead the story functions
    mythologically and metaphorically. In Mark's account it is primarily an
    epiphany (or christophany) story, alluding to the Old Testament mythology
    of Yahweh the God of Israel overcoming the waters of chaos and making a
    path through the sea. An Exodus reference (crossing the Red Sea) may be
    partially intended, but is not the exclusive meaning of Mark's version,
    which also aludes to the occasions when God <q>passed by</q> Moses and
    Elijah (in Mark, the sea-walking Jesus means to <q>pass by</q> the
    disciples). Finally, the Markan version stresses the disciples' failure to
    understand what they're witnessing, which is typical of Mark's consistent
    portrayal of the disciples' failure to understand anything.\b
    As with so much of Mark's Gospel, this story has so many potential layers
    of meaning it's hard to know which Mark intended, and which he intended to
    emphasize. "
    /* 
     *   The purpose of the following calculation is to try to guess what 
     *   the player means if s/he just types THINK ABOUT JESUS. We'll boost 
     *   this topic's score over that of the historical Jesus topic once the 
     *   player has seen either depiction of Jesus walking on the Sea, 
     *   provided the player character isn't in the tomb choosing an 
     *   "authentic bead", in which case the historical Jesus topic is 
     *   probably the better default choice.
     */
    matchScore = ((sgWindows.described || mosaic.described) 
                  && !gPlayerChar.isIn(tomb) ? 110 : 90)
;

+ ConsultTopic +110 [examPaper, tQuestions]
    "You think some questions on the paper look much easier than others. "
    isActive = (examPaper.described)
;

+ ConsultTopic @tSynopticProblem
    "The Synoptic Problem concerns the literary relation of three <q>synoptic
    gospels</q>: Matthew, Mark and Luke. The similarities in wording and order
    of material between these three gospels are such as to cause virtually all
    New Testament Scholars to conclude that there must be some literary
    relation between them, but the problem is to decide what this relationship
    is.\b
    Since the late nineteenth century, the dominant theory of Synoptic
    Relations has been the Two-Source Hypothesis (aka Two-Document Hypothesis),
    which asserts that Mark was the first (extant) Gospel to be written, and
    that Matthew and Luke both independently based their Gospels on Mark
    together with a second (now lost but hypothetically reconstructed source)
    Q. This assumes that neither Matthew nor Luke knew the other (otherwise the
    non-Markan material common to Matthew and Luke could be explained, for
    example, by Luke's use of Matthew rather than their independent use of a
    common source Q. Other solutions to the Synoptic Problem, such as those
    associated with Griesbach (Matthew -> Luke -> Mark) and Farrer (Mark ->
    Matthew -> Luke) assume Luke used Matthew, and hence have no need of the
    hypothetical source Q.\b
    Your own sympathies lie with Austin Farrer, (whose theory of synoptic
    relationships has also been vigorously espoused and developed by scholars
    such as Michael Goulder and Mark Goodacre). "
;

+ ConsultTopic @tQ
    "<i>Pace</i> Dan Brown, Q is not a secret document hidden in the Vatican
    that might have been written by Jesus himself, it's a purely hypothetical
    text reconstructed from other texts. Q (short for German Quelle =
    <q>Source</q>) is the name given to one of the two common sources
    supposedly used independently by Matthew and Luke in the composition of
    their gospels, their other common source being Mark. It is used to explain
    the large amount of material common to Matthew and Luke (but not found in
    Mark) on the assumption that neither Luke nor Matthew knew the other
    gospel-writer's work. As reconstructed along these lines, Q consists mainly
    of sayings of Jesus, and has no Passion Narrative (the account of Jesus'
    arrest, trial and execution).\b
    In your view, Q never existed. You find the arguments that Luke could not
    have known and used Matthew to be largely unconvincing, while the so-called
    <q>minor agreements</q> of Matthew and Luke against Mark (difficult to
    explain on the hypothesis that Matthew and Luke were using Mark
    independently) are too numerous to be dismissed as coincidental or due to
    textual corruption. But if Luke knew Matthew, there's no need for Q, and
    what you think of as <q>the Q industry</q> is founded on a mistake. That
    does not, of course, prevent great swathes of (mainly North American)
    scholars from reconstructing not only the text of Q, but its redactional
    history (various editorial layers in the development of Q) and the social
    history and theology of the Q community, and then going on from this to
    deducing a very different picture of Christian origins from that
    traditionally gleaned from the canonical Gospels and Paul. It thus seems to
    you that if, as you believe, Q is a mistake, it's a pretty major mistake. "
;

+ ConsultTopic @tQParallel
    "It is a common observation that the gospels, particular the <q>Synoptic
    Gospels</q>, Matthew, Mark and Luke, have a good deal of material in
    common. The most common (although in your opinion erroneous) explanation of
    this is that Matthew and Luke independently made use of Mark and a second,
    purely hypothetical source, designated <q>Q</q>. Where similar material
    occurs in two or more sources, one may speak of a <q>parallel</q>. For
    example Matthew, Mark and John all have an account of Jesus walking on the
    sea, so one might speak of the Matthean and Johannine parallels to Mark's
    story of the walking on the water.\b
    Since many who believe in the purely hypothetical document Q have quite
    some confidence in their ability to reconstruct what it contained, it
    becomes possible to speak of a Q parallel to material in the extant
    gospels. For example, those who believe in Q are obliged to postulate Q
    parallels to Mark's accounts of Jesus' temptation and the Beelzebul
    Controversy (the accusation that Jesus was casting out demons by the power
    of the prince of demons). These putative Q parallels are also known as
    <q>Mark-Q overlaps</q>.\b
    Since Luke lacks the account of Jesus walking on the sea (and Q is
    principally reconstructed from what is common to Matthew and Luke but
    absent from Mark), no one has ever supposed that Q contained this story.
    Similarly, the orthodox opinion of the Q industry is that Q did not contain
    a passion narrative or any account of Jesus' resurrection, so there could
    be no Q parallel to the story of the Empty Tomb. This is why you think
    Wortschlachter is talking utter rubbish here -- his blunder in speaking of
    Q parallels to these two stories is such as to put him beyond the pale of
    serious scholarship. "
    isActive = gRevealed('q-parallel')
;

+ ConsultTopic @tTwoSourceHypothesis
    "The two source hypothesis (aka two document hypothesis) is the most
    commonly held solution to the Synoptic Problem among New Testament
    scholars. According to the two source hypothesis Matthew and Luke
    independently used Mark's Gospel plus another sayings source (or <q>Sayings
    Gospel</q>) <q>Q</q> as the principal sources for their own Gospels.\b
    Although this theory has a certain plausibility, and it's easy enough to
    see why it's held, in your view it's mistaken. The arguments that Luke
    could not have used Matthew seem to you to be less that compelling, whereas
    the agreements of Luke and Matthew against Mark (the so-called <q>minor
    agreements</q> and <q>Mark-Q overlaps</q>) seem incompatible with the
    notion that Luke and Matthew used Mark independently, as the two source
    hypothesis supposes. "
;

+ ConsultTopic @tMinorAgreements
    "The minor agreements of Matthew and Luke against Mark are, in your
    opinion, one very good argument against the dominant two source hypothesis.
    There is scope for disagreement over what constitutes a <q>minor
    agreement</q> of Matthew and Luke against Mark, but there are about a
    thousand or so of them.\b
    A minor agreement occurs wherever Matthew and Luke both differ from Mark's
    Gospel in similar ways, for example, by adding or deleting the same words
    or changing the same words in the same ways. One of the most striking
    examples occurs in the hearing before the Sanhedrin. According to Mark
    14.66 some bystanders spit at Jesus, cover his face and strike him, saying
    <q>Prophesy!</q>. Matthew 26.28 and Luke 22.36 both agree in adding the
    same five Greek words at this point: <i>tis estin ho paisas se</i> (<q>who
    is it that struck you?</q>). This is <i>very</i> hard to explain on the
    basis of Luke's and Matthew's independent use of Mark (as the two source
    hypothesis demands), and on this occasion, no appeal can be made to a
    so-called <q>Mark-Q</q> overlap since, by common consent, if Q existed it
    contained no Passion Narrative (the account of Jesus' arrest, trial and
    execution)."  
;

+ ConsultTopic @tMarkQOverlaps
    "There are various passages in the Synoptic Gospels (Matthew, Mark and
    Luke) where, contrary to what might be expected on the two source
    hypothesis, there is fairly substantial agreement between Matthew and Luke
    against the Markan parallel, often taking the form of material present in
    Matthew and Luke but not Mark (examples would be the Temptation story and
    the Beelzebul controversy). On the two source hypothesis this is explained
    by appeal to so-called <q>Mark-Q</q> overlaps, that is the notion that the
    same material appears in both Mark and Q and has been combined in similar
    ways by Matthew and Luke, with Luke tending to prefer the Q version and
    Matthew taking more from Mark. A more natural explanation, in your opinion,
    is that in these passages Luke was following (but adapting) Matthew,
    without much reference to Mark. "
;

+ ConsultTopic @tGospels
    "The four canonical gospels are those of Matthew, Mark, Luke and John. Of
    these, John stands somewhat apart in both style and content. The first
    three gospels, Matthew, Mark, and Luke are known collectively as the
    <q>Synoptic Gospels</q>, since their general similarity in content, order
    and even wording allows them to be readily laid out side by side for
    comparison in a three-column <q>synopsis</q> (from the Greek meaning
    <q>seeing together</q>). That there is some kind of literary relationship
    between the three synoptic gospels is scarcely doubted by any modern New
    Testament scholar, but there is (quite understandably, in your opinion),
    much less agreement of the relationship between John and the other three.\b
    In addition to these four, there are a number of non-canonical gospels,
    such as the Gospel of Thomas and the Gospel of Peter, that have attracted
    considerable scholarly interest, but over which there is a sharp division
    of scholarly opinion. All would agree that the scholarly study of Christian
    origins should not be bound by what the Church regards as canonical, but
    there is no consensus on whether such non-canonical Gospels as those of
    Thomas and Peter are early, independent and hence potentially valuable
    sources, or late, dependent on the canonical gospels, and hence of little
    value as independent sources. "
;

+ ConsultTopic +110 @tNewTestament
    "Several things drew you to New Testament scholarship: the importance of
    the New Testament as foundational in understanding Christian origins, a
    great buzz from working closely with a collection of such rich, challenging
    and often puzzling texts, and a fascination with the very different world
    of antiquity. "
    
;

+ ConsultTopic @tArcosolium
    "An arcosolium is an arch-shaped burial-niche cut into the wall of a burial
    tomb to allow a body to be laid out in the niche parallel to the wall. "
;

class DConsultTopic : ConsultTopic
    isActive = (matchObj.described)
;

+ DConsultTopic @q1
    "It's dead easy: all the scholars listed are German. ";  
;

+ DConsultTopic @q2
    "The translation is easy enough: <q>Which is easier, to be raised from the
    dead or to walk on the sea?</q> It seems to be loosely based on Mark 2.9:
    <q>Which is easier, to say to the paralytic, <q>Your sins are forgiven</q>,
    or to say, <q>Get up and take your stretcher and walk</q>?</q>, with
    allusions to other parts of Mark."   
;

+ DConsultTopic @q3
    "You're not sufficiently familiar with the output of any of the persons
    here to be sure of not missing the point of this question, even though you
    suspect it may very well be pointless. "
;

+ DConsultTopic @q4
    "They can't be serious! "
;

+ DConsultTopic @q5
    "The question is absurd, since even if Q ever existed it would not contain a
    parallel to the Empty Tomb story. "
;

+ DConsultTopic @q6
    "It looks a pretty straightforward question. "
;


+ DConsultTopic @pen
    "You think it would be more useful if it had some ink in it. "  
;

++ AltTopic
    "So far as you can see, the pen is in good working order and ready to write. "
    isActive = pen.full
;

+ VConsultTopic @inkBottle
    "You think it would be more useful to you if you had a pen. "  
;

++ AltTopic 
    "It occurs to you that it might be helpful to get pen and ink together
    in the same place. "
    isActive = inkBottle.seen && pen.seen
;

++ AltTopic
    "You doubt that you'll have much further use for the bottle of ink. "
    isActive = pen.full
;

+ VConsultTopic @naveRubble
    "You think it's sad to see such a fine old church in such a state of
    disrepair, and so much rubble left by war damage. "  
;

+ VConsultTopic @whiteYouth
    "In Mark's account of the Empty Tomb, the women who come to the tomb find
    it empty apart from a young man dressed in white who tells them, <q>Don't
    be afraid; you're looking for Jesus the crucified Nazarene; he has been
    raised, he is not here; see the place where they put him.</q> The young man
    you've just encountered would seem to be a weirdly distorted version of
    this. "  
;

+ ConsultTopic @ossuary
    "An ossuary is a bone-box used for secondary burial, a distinctively Jewish
    custom in the first-century Mediterranean. In a Jewish burial, the corpse
    was put on a shelf and left to rot for about a year. After the flesh had
    rotted away, the bones would be reburied in a new location in the tomb; in
    and around Jerusalem these bones were frequently placed in a stone box
    called an ossuary, which might then be placed in a niche. "
;


+ ConsultTopic [tCriteria, tAuthenticity]
    "You were never convinced that the so-called criteria of authenticity
    (multiple attestation, double dissimilarity and the like) constituted a
    valid methodology for historical Jesus research. "
;

++ AltTopic
    "The three criteria on the leaflet look like a strange adaptation of some
    of the standard criteria of authencity used in historical Jesus
    research.<.p>
    
    As normally used these three criteria are used to determine which bits of
    the canonical Gospels and other early Christian literature might actually
    go back to the Historical Jesus.<.p>
    The criterion of <i>double dissimilarity</i> states that something is more
    likely to be authentic Jesus material if it is unlike both what the early
    Church believed and what was current in the Judaism of Jesus' day.\n  
    The criterion of <i>coherence</i> states that anything that <q>coheres</q>
    with material identified as authentic Jesus material by other means is also
    likely to be authentic.\n
    The criterion of <i>multiple attestation</i> states that something is more
    likely to be attributable to the Historical Jesus if it is independently
    attested in more than one source.\b"   
    
    isActive = gRevealed('criteria')
;

+ ConsultTopic @tDoubleDissimilarity
    "The criterion of <i>double dissimilarity</i> states that something is more
    likely to be authentic Jesus material if it is unlike both what the early
    Church believed and what was current in the Judaism of Jesus' day. "
;

+ ConsultTopic @tCoherence
    "The criterion of <i>coherence</i> states that anything that <q>coheres</q>
    with material identified as authentic Jesus material by other means is also
    likely to be authentic. "
;

+ ConsultTopic @tMultipleAttestation
    "The criterion of <i>multiple attestation</i> states that something is more
    likely to be attributable to the Historical Jesus if it is independently
    attested in more than one source. "
;

+ ConsultTopic [tJesusSeminar, tBeads]
    "In the early days of the Jesus Seminar members supposedly voted with the
    appropriate colour bead to indicate their opinion on the historical
    authenticity of different items of Jesus tradition in the gospels.\b
    The Jesus Seminar is a group of (mainly North American) scholars
    collaborating to build a database of authentic Jesus material. One of their
    aims is to educate the American public in what scholars actually think
    about Jesus. To that end, two of their more popular publications, <i>The
    Five Gospels</i> and <i>The Acts of Jesus</i> present the words and deeds
    (respectively) of Jesus printed in red, pink, grey and black type. The
    exact interpretation of these colours varies, but as a first approximation
    red means <q>certainly authentic</q>, pink means <q>probably authentic</q>,
    grey means <q>probably not authentic</q> and black means <q>certainly not
    authentic</q>. These colours are arrived at by inviting members of the
    Jesus Seminar to vote on the authenticity of each item, and then averaging
    their vote. The four colours of bead corresponded in meaning to the four
    colours of printed text. "
;

+ ConsultTopic +110 [redBead, pinkBead, greyBead, blackBead, tBeads]
    "You realize that your explanation would have worked just as well with
    whichever bead you chose to give the young man in white. But then, you
    reflect, this probably makes the young man's challenge not such a bad model
    of much Historical Jesus research. All too much published scholarship on
    the Historical Jesus seems to juggle the criteria with equal facility to
    demonstrate the authenticity or otherwise of whatever is desired. "
    isActive = (redBead.isIn(nil))
;


+ ConsultTopic +110 @tHistoricalJesus
    "In the jargon of New Testament scholarship the <q>Historical Jesus</q>
    means something roughly like <q>Jesus as he can be reconstructed by the
    means of modern critical historical research</q> although you've also seen
    it used to mean <q>Jesus as he actually was</q>. In either case the
    <q>Historical Jesus</q> is contrasted with the <q>Christ of Faith</q>,
    which means Jesus as he is presented in the Gospels or in the tradition,
    worship and doctrine of the church. The distinction arises from a
    long-standing recognition in New Testament scholarship that the Gospels are
    not straightforward historical reporting. "
;

+ ConsultTopic @tGod
    "You're sure that He exists, but right now you do think it a bit of a
    puzzle that an all-wise, all-loving Supreme Being should have included
    Professor Wortschlachter among his creations. "  
;

++ AltTopic
    "You wonder if God can be reached from this strange non-place. You try a
    prayer, but it seems to fall leaden to the ground. You wonder if you have
    now been cut off from the Almighty as part of some eternal punishment --
    after all, even if your life has been mostly innocuous it's hardly been
    saintly -- although you feel that <i>nothing</i> can exist beyond the love
    and mercy of God. There is existence of a sort here, so surely God must be
    present in some sense too; it's just not that apparent. "
    isActive = (limbo.seen)
;

++ AltTopic
    "You thank God that you're still alive. "
    isActive = (hospital.seen)
;

+ VConsultTopic @lake
    "The lake is so large that you half-wonder how you know that it isn't a
    sea, but somehow you do know. Perhaps it's the lack of any evidence of
    tidal activity or any significant waves, or the fact that you can just
    about see to the other side. "  
;

+ ConsultTopic [forkSlope, forkPath]
    topicResponse() { fork.thinkHere; }
    isActive = forkSlope.seen
;

+ VConsultTopic @narrowGate
    "The narrow gate makes you think of Matthew 7.13-14, <q>Enter by the narrow
    gate; ... For the gate is narrow and the way is hard, that leads to life,
    and those who find it are few.</q>"
    matchScore = (gPlayerChar.canSee(narrowGate) ? 110 : 90)  
;

+ VConsultTopic @greenGate
    "The wide green gate calls to mind Matthew 7.13, <q>Enter by the narrow
    gate; for the gate is wide and the way is easy that leads to destruction,
    and those who enter by it are many.</q>"
    matchScore = (gPlayerChar.canSee(greenGate) ? 110 : 90)  
;

+ ConsultTopic @oblivion
    "No more being: no more cares, but no more joys; no more thoughts, and no
    more you -- a terrifying prospect, but one that can seem tempting at
    moments of great weariness and stress. "
;


+ ConsultTopic +80 @titulus
    "The <i>titulus</i> was a notice or placard fixed to the cross of a
    crucified criminal stating his or her crime. All four (canonical) gospels
    agree that the titulus attached to Jesus' cross read <q>The King of the
    Jews</q> (but since Luke and Matthew almost certainly used Mark as a
    source, and John may have done, this agreement should not be regarded as
    particularly remarkable). Christian art and iconography depicting the
    crucifixion generally represents the titulus on Jesus' cross as a small
    placard fixed over his head, with the placard bearing the inscription INRI
    ( = Iesus Nazarenus Rex Iudaeorum, i.e.\ <q>Jesus of Nazareth, King of the
    Jews</q>). The Synoptic Gospels (Matthew, Mark and Luke) do not state which
    language the titulus was written in (but simply give <q>King of the
    Jews</q> in Greek, the language the gospels were written in). According to
    John 19.20 the inscription was trilingual, being written in Hebrew, Latin
    and Greek. "
;

+ VConsultTopic @centralCross
    "You recall reading somewhere that the Romans in fact crucified people on
    T-shaped crosses, but the three crosses on Skull Mountain are the
    traditional shape of Christian art and iconography, with a short projection
    above the cross-beam. The larger size of the central cross seems designed
    to emphasize its importance, a further indication that you have somehow
    stepped into a symbolic scene. "  
;

+ VConsultTopic @crow
    "Ancient sources suggest that leaving bodies of condemned criminals on the
    cross to be consumed by carrion crows (and hence denying the condemned a
    decent burial) was part of the punishment, so the presence of a crow
    pecking at the remains of the dead is not wholly out of place -- although
    one presumably has to imagine that the corpses on the crosses have rotted
    so far as to fall onto the ground as a pile of bones. One would also expect
    to see more than one crow -- except that the bones left piled
    <<gPlayerChar.isIn(skullMountain) ? 'here' : 'on Skull Mountain'>> hardly
    look like they\'d provide enough nourishment even for a single crow. "  
;

+ VConsultTopic @bonePile
    "If the bones piled <<gPlayerChar.isIn(skullMountain) ? 'here' : 'on Skull
        Mountain'>> belonged to the people executed on the crosses, their
    corpses must have rotted so far that the bones simply fell off -- perhaps
    the attentions of the crow helped speed up this process. The gospel
    accounts state that Jesus' body was taken down and buried in a tomb, but
    says nothing about what happened to the bodies of the two bandits crucified
    with him. It could be that if the Jewish authorities had a part in securing
    Jesus' condemnation that they would also feel some responsible for ensuring
    that he was buried, in line with the Jewish law against leaving corpses
    exposed, but that they would have felt no such responsibility towards
    bandits condemned purely by the Romans. "  
;

+ VConsultTopic @wordPile
    "Finding a pile of words among the bones is something of a surprise. One
    theory you consider is that the bones represent the bones from the two
    outer crosses -- the remains of the two bandits -- and the words are
    somehow related to the central cross. Since this seems to be a place where
    myth, legend and theology take on concrete forms, you even hazard a guess
    that having the remains from the central cross represented by a pile of
    words could be related to the Johannine notion of Jesus as the Word made
    flesh -- but maybe that's pushing things too far. It may be that the words
    in the pile have some other function or significance. "  
;

+ ConsultTopic @tTruth
    "Theoretically, at some level, truth is presumably the goal of all academic
    pursuits, although in practice the truth may be very different. As a moral
    quality truth perhaps has more to do with fearless honesty than with the
    attainment of objective fact (whatever that would mean). Still, you're by
    no means a total relativist: whatever the philosophical knots one can tie
    oneself in over the notion of truth, you're sure there are at least some
    things that are simply true and some things that are simply false. "
;

+ ConsultTopic @tLove
    "Love is a fine-sounding word and no doubt a Good Thing -- provided the
    object of one's love is an appropriate one. But perhaps St Paul said it all
    in 1 Corinthians 13. "
;

+ ConsultTopic @tCourage
    "Courage is a virtue you suspect you're going to need quite a lot of, and
    the one without which the others are probably not a lot of use. "
;

+ ConsultTopic @tFaith
    "Faith is not about believing sixteen impossible things before breakfast,
    it's about trust, and the willingess to put that trust into practice. "
;

+ ConsultTopic +110 @tHope
    "Hope is a great virtue, the refusal to give way to despair. "
;

++ AltTopic
    "<<location.topicResponse>> But thinking of hope inevitably makes you
    think of Felicity. "
    isActive = (gPlayerChar.hasSeen(limbo))
;

+ ConsultTopic @tIntegrity
    "To live with integrity is to be true to oneself. At least, that's the
    sound-bite version, but of course it's more complicated than that: it's
    about honesty and reliability, about genuineness and lack of hypocrisy, and
    about standing for something morally worthwhile. "
;

+ ConsultTopic @tJustice
    "Justice is about fairness, and has been defined as love distributed.
    Beyond that it becomes more complex; no one wants to argue that justice is
    anything other than a good thing, but there seem to be any number of
    different views about what is just in any particular situation. Still,
    there are surely many, many things that most reasonable people would
    condemn as manifestly unjust, so maybe justice is best defined as the
    determination to eliminate injustice. "
;


+ ConsultTopic [chessBoard, tChessGame]
    "Well, you muse, the board looks conventional enough even if some of the
    pieces are rather weird. You hazard a guess that the game is somehow a
    symbolic re-enactment of Roman-Jewish relations in the period 30-70 CE,
    i.e.\ from the death of Jesus to the conclusion of the first Jewish
    Revolt. "
    isActive = chessBoard.seen
;

++ AltTopic
    "You sense that the nature of the game has subtly changed. In one sense
    it's still about the exercise of Roman imperial power, but now it has taken
    on apocalyptic dimensions: Rome is simply the first-century face of a more
    perennial power, and you're playing for the highest stakes of all. "
    isActive = !chessDoor.isOpen
; 

++ AltTopic
    "The way the game ended confirms your apocalyptic interpretation of it. It
    was, of course, not so much your victory as the victory of the Word you
    thought belonged on the titulus of the central cross; yet, in other sense,
    it was your victory. It's not yet entirely clear what exactly you've won,
    though -- perhaps it's no more of a temporary reprieve for your soul, a
    temporary escape from the power of the Beast. "
    isActive = fissureDoor.isOpen
;

+ VConsultTopic @chessPiece
    "So far as you can figure out what is going on, your queen represents the
    same quality that you considered crucified on the central cross on Skull
    Mountain. Since you have passed through an empty tomb to get here, and the
    piece is now in play, you surmise that it may somehow be symbolic or
    representative of the Resurrection in some way. If so then it seems a
    highly suitable piece to play the role of your queen in this most
    apocalyptic of chess games. "   
;

+ VConsultTopic @whore
    "The whore chess piece evidently represents the whore who features as one
    of the enemies of the righteous in the book of Revelation. "   
;


+ VConsultTopic @beast
    "The beast on which the whore is seated seems to be something of a
    composite figure, an amalgam of two beasts of Revelation 13 (and 17.3) and
    the beast from the sea of 4 Ezra (or 2 Esdras) 11, all of which represent
    some aspect of Roman imperial power, the heads, wings and horns
    representing the succession of Roman emperors. The way this beast shifts
    shape when you look at of course indicates that you're in a very strange
    sort of reality, but it also suggests to you that the beast stands for more
    than the first-century Roman empire, but in some way represents the
    diabolical misuse of power in all its forms. "   
;

+ VConsultTopic @emperor
    "The emperor seems to be a composite figure, representing all the rulers of
    the Julio-Claudian and Flavian dynasties rolled into one. He's plainly not
    any historical Roman emperor. He is, perhaps, a personification of Roman
    imperial rule, but you suspect that he's rather more than that. He's rather
    a personification of brutal, autocratic rule in all times and places: he's
    as much Hitler and Stalin and Sadam Hussein as Caligula, Nero and Domitian.
    And, even more chillingly, he may also represent the Power behind all their
    thrones. "  
;

+ VConsultTopic @snake
    "Well, Genesis 3 actually talks about a serpent in the Garden of Eden, not
    a snake, but seeing this snake lying under the central tree in the garden
    certainly seems suggestive. "  
;

++ AltTopic
    "Well, it turns out he's a talking snake; in a way that makes him even more
    like the talking serpent of Genesis, and yet the way he's acting makes him
    less so. In Genesis the serpent persuaded Eve to eat the forbidden fruit,
    whereas this snake persuaded you not to. Perhaps there's an <i>Urzeit</i>
    -- <i>Endzeit</i> thingy going on here. That's to say, you\'ve been through
    Golgotha, the tomb, a kind of resurrection of \^<<chessPiece.pieceName>>,
    and an apocalyptic defeat of the Ruler of This World; a return to
    prim&aelig;val paradisal conditions could well be the next thing on the
    mythological agenda, and it would be entirely appropriate for the end-time
    return to the prim&aelig;val paradise to contain some kind of reversal of
    the events that led to the Fall. "
    isActive = snake.curState != snakeSleeping
;

+ ConsultTopic [apple, appleTree]
    "Genesis 3 refers to the forbidden fruit as <q>the fruit of the tree that
    is in the middle of the garden</q> and (by implication) the fruit of <q>the
    tree of knowledge of good and evil</q>, but never specifies a particular
    known species of fruit. Popular reception of the story has envisaged the
    fruit as an apple, however, so you suspect that this is what this
    particular apple is meant to represent. "
    isActive = apple.seen
;

+ ConsultTopic @tSatan
    "You've always regarded Satan as a myth. This doesn't mean he's simply a
    fairy-tale, of course, since a myth is often a pictorial or non-literal way
    of talking about some kind of reality, and the reality of evil can scarcely
    be doubted. "
;

+ ConsultTopic @tMyth
    "Myth is a complex subject in your view. It's not a word you use to
    describe what's simply false (at least, not unless you're speaking very
    loosely). A myth is certainly something that's not literally or empirically
    true, but it may represent an attempt to describe other kinds of truth in
    pictorial terms. "
    
;

+ ConsultTopic @hinnomValley
    "The Valley of Hinnom (from which the name Gehenna derived) was a valley
    outside Jerusalem regarded as an accursed place due to child sacrifice
    having been practised there in ancient times. By New Testament times it may
    have become a kind of rubbish dump for the city, where refuse was
    continually incinerated. The name 'Gehenna' (usually rendered as 'Hell' in
    English translations of the New Testament) became transferred to the place
    of punishment in the afterlife, retaining the imagery of destruction by
    fire. "  
;

+ ConsultTopic @menorah
    "The seven-branched candlestick, or menorah, is a standard Jewish symbol,
    based on the golden candlestick used in the Temple (and described in Exodus
    25.31-40). "
;

+ ConsultTopic @ggWoman
    "You can't work out who the green woman is meant to be. The figure in the
    window corresponds to no Christian iconography that you know of, but then
    this is hell. You toy with the idea that she's meant to represent Eve as
    temptress in a state of nature, but you're not at all convinced -- for one
    thing she's holding no fruit. "    
    matchScore = (agrath.seen ? 90 : 110)
    isActive = sgWindows.described
;

+ ConsultTopic +110 @greenPatch
    topicResponse { replaceAction(TravelVia, greenPatch); }
    isActive = gActor.canSee(greenPatch)
;

+ ConsultTopic +110 @brownPatch
    topicResponse { replaceAction(TravelVia, brownPatch); }
    isActive = gActor.canSee(brownPatch)
;

+ ConsultTopic +120 @tPatch
    topicResponse { replaceAction(Enter, patchPassage); }
    isActive = gActor.canSee(brownPatch)
;

+ VConsultTopic @emeraldSea
    "You think it looks wet. "    
;

+ VConsultTopic @woodenNotice
    "You think it rather an odd sign to put on the sea-shore; someone's idea of
    a joke maybe? "   
;

+ VConsultTopic @greenGardenShed
    "It strikes you as being a perfectly ordinary garden shed. "  
;

+ VConsultTopic @casket
    "It looks a particularly valuable gold gasket -- not at all the thing you'd
    expect to find in a garden shed. "  
;

+ VConsultTopic @ornateScroll
    "The poem strikes you as third-rate doggerel (and that's being generous),
    but it may be trying to convey something of importance. "
;

+ VConsultTopic @shedKey
    "<<shedKey.desc>>"
;

+ VConsultTopic @strangeMist
    "The strange grey reminds you a little of the grey nothingness you first
    encountered when you entered limbo, except that it seems subtly
    different. "
;

+ VConsultTopic @shrine
    "Frankly, you don't like the look of it. The garish gaudy green paint is
    obviously meant to match that on the statue, and you're not too sure you
    care for that either. More than that, there's something agressively pagan
    about the structure; besides, for all the oddness of your arrival here you
    sense you are still in some part of hell, and any place of worship in hell
    is automatically suspect. "
;

+ VConsultTopic +110 @greenStatue
    "The woman -- or goddess -- depicted in the statue <<sgWindows.described ?
      'reminds you of the green-skinned woman you saw in the cathedral windows.
      She ' : ''>>strikes you as beautiful in a way -- a cold, cruel way. You
    feel that to worship this goddess would be to collude in evil. "   
;

+ ConsultTopic @tHanina
    "According to legend, Hanina ben Dosa was a charismatic holy man, or <q>man
    of deed</q> who lived some time in the first century CE. Most of the
    surviving stories about him come from much later, so in your opinion
    getting at the historical Hanina is about as hopeless as trying to get at
    the historical Merlin of Arthurian legend. The earlier traditions mainly
    represent Hanina as a devout man of prayer; later elaborations turn him
    into something of a miracle-worker. "
    
;

+ ConsultTopic @agrath
    "The demon princess Agrath features in a story narrated in the Babylonian
    Talmud, in which she encounters the famous <q>man of deed</q> Hanina ben
    Dosa while he's out for a solitary walk. Hanina's reputation in heaven is
    such that she's unable to harm him, and he's able to command her not to
    enter inhabited places more than two nights a week. "
    isActive = gRevealed('agrath')
;

+ ConsultTopic [agrath, ggWoman]
    "You're well aware that the idea of Satan or some other demon appearing in
    alluring female guise to tempt the unwary is an ancient one -- it turns up
    in several places in rabbinic literature. In particular the demon princess
    Agrath features in a story narrated in the Bablyonian Talmud, in which she
    encounters the famous <q>man of deed</q> Hanina ben Dosa while he's out for
    a solitary walk. Hanina's reputation in heaven is such that she's unable to
    harm him, and he's able to command her not to enter inhabited places more
    than two nights a week.\b
    Well, the Agrath you've encountered may or may not be the same as Hanina's,
    but she's certainly as dangerous, if not more so, since you don't seem to
    share ben Dosa's standing with heaven.\b
    What's so disturbing is the way she manages to be both repellant and
    attractive at the same time. The fact that you have a pretty good idea why
    only makes it more disturbing. Outwardly, her form is beautiful while her
    colouring is grotesque, creating simultaneous fascination, attraction and
    repulsion. The persona she projects also simultaneously attracts and
    repels, and for a complex of reasons. First, there is the naked sexuality
    which she wields at you like a weapon -- something you find disturbing
    enough in human females who employ it, let alone demonic ones. Then there
    is the fact that she is clearly not human but something alien and exotic,
    which makes her both fascinating and fearful, much as Rudolph Otto
    characterized the numinous. But above all, it's the style of her evil. She
    clearly is evil: she clearly makes no attempt to hide the fact. But it's
    not the kind of thuggish evil expressed in overt malice, so much as a
    subtly seductive evil aimed at drawing you into some demonic mode of being
    which would ultimately destroy you. What is so terrible is that this brand
    of evil <i>does</i> have something weirdly attractive about it. " 
    
    isActive = agrath.seen
    matchScore = (valley.seen ? 95 : 120)
;

+ ConsultTopic @tFirstTemptation
    "The first temptation of Jesus in Matthew's temptation story, at Matthew
    4.3, was when Satan said to the ravenously hungry Jesus in the wilderness,
    <q>Command these stones to become bread.</q> "
    isActive = gPlayerChar.isIn(agrathCave)
;

+ VConsultTopic @windlass
    "You think it might be worth a closer look. "  
;

++ AltTopic 
    "There's not much doubt what it's for; you put the socket end in a hole and
    turn the handle. "
    isActive = windlass.described
;

+ VConsultTopic @ravine
    "You think that you're probably going to have some way to cross it, though
    you don't at all relish the prospect. "  
;

++ AltTopic
    "You think you'd really rather not have to cross it again. "
    isActive = farSideRavine.seen
;


+ ConsultTopic @redHerring
    "You suspect that the scarlet fish is a sample of Agrath's warped sense of
    humour, her way of telling you that you've wasted your time pursuing a red
    herring. "   
    isActive = redHerring.described
    matchScore = (gPlayerChar.canSee(redHerring) ? 150 : 110)
;

++ AltTopic
    "<<location.topicResponse()>>But then you wonder about that cave painting. "
    isActive = cavePainting.seen && location.isActive
;

+ ConsultTopic @cavePainting
    "No angel features in Mark's version of the Empty Tomb story, but in
    Matthew it's an angel who rolls the stone away. You wonder if that's what
    the angel in this painting is meant to be doing. "
    isActive = cavePainting.described
    matchScore = (gPlayerChar.canSee(cavePainting) ? 150 : 110)
;

+ ConsultTopic +110 @agrathCaveStone
    "The stones covering the mouth of Jewish burial caves were more normally
    rectangular than round, but this one seems to have been shaped in
    conformity with the tradition that the stone covering Jesus' tomb was
    <i>rolled</i> away. It nevertheless looks too massive for one man to
    roll. "
    isActive = (gPlayerChar.canSee(agrathCaveStone))
;

+ ConsultTopic @gPlayerChar
    "Although you're a much more interesting topic to yourself than anything
    Professor Wortschlachter might have to say about Mark's account of the
    Empty Tomb, you feel you ought at least to make the attempt to focus on
    Wortschlachter's lecture now you're here. "
;

++ AltTopic
    "You wished you were less shy when it came to talking to women you found
    attractive. "
    isActive = (gPlayerChar.isIn(breakfastQueue))
;

++ AltTopic
    topicResponse
    { 
        replaceAction(ThinkAbout, tPain);
    }
    isActive = gRevealed('pain')
; 


++ AltTopic
    "You're not sure what to make of your current circumstances. You suspect that
    you may be dead. "
    isActive = limbo.seen
;

++ AltTopic
    "You're still not entirely sure if you're dead or dreaming, but this place
    doesn't exactly <i>feel</i> like a dream, for all its strangeness it has
    too much concreteness, too much reality about it. Perhaps what you're
    experiencing is the process of dying, the twilight experience between life
    and death. Although you can't put your finger on why, you suspect that you
    may be undergoing some form of judgment."
    isActive = hellsGate.seen
;

++ AltTopic
    "You're glad and grateful to be alive. "
    isActive = hospital.seen
;


+ DefaultConsultTopic
    "{You/he} {have} no particular thoughts on that subject right {now|then}. "
;

++ AltTopic
    "You had no particular thoughts on that subject just then. "
    isActive = gPlayerChar.isIn(breakfastQueue)
;

//-- Think About works a bit differently in the Deconstruction Chamber -------
//-- We handle this below ----------------------------------------------------


deconstructionThoughts : Consultable
;

+ ConsultTopic @tNothing
    "You try to empty your mind and think about nothing, and the screen goes
    temporarily blank; but you don't have the mental discipline to keep your
    mind blank for long, and within moments you're thinking about thinking
    about nothing, and then thinking about how to stop thinking about a whole
    host of things, and then thinking about a whole host of things, so that the
    screen bursts back into activity. "
;

+ ConsultTopic @tFreedom
    "You think about freedom; the screen flashes up <q>Freedom from what?
    Freedom to do what? Free Dom? Who is this Dom you want to free?</q> and
    then the words dissolve into a pile of letters at the bottom of the screen
    before vanishing altogether. "
;

+ ConsultTopic @distantGlow
    "You think about the distant golden glow you saw on the far side of the
    deep chasm. For a moment, a tantalizingly realistic image of it is
    projected onto the screen, filling you with yearning for that beautiful
    golden city. Then a troop of words marches across the screen spelling out
    <q>All that glisters is not gold</q>, and the distant city dissolves into a
    spray of golden shards that turn the colour of dull lead before finally
    disappearing. "
;

+ ConsultTopic @tExit
    "A way out flashes up on the screen. Seeing your chance, you dive through 
    it and find yourself in a garden.<<deconstruction.escape()>>"
;

+ ConsultTopic @tReality
    "You think about the real world outside the text. An image of a solidly
    real garden appears on the screen, so before it can vanish you dive through
    the screen and land in the garden.<<deconstruction.escape()>> "
;

+ ConsultTopic [felicity, blondeWoman]
    "Felicity Hope appears on the screen. For a tantalizing moment or two she
    looks real enough to talk to or touch, but even as you try to respond to
    her presence she vanishes in a whirl of phrases: <i>Do you think she bring
    you </i>felicity<i>? Is she what really you </i>hope<i> for? Hope springs
    eternal... who hopes for what he sees... abandon hope all ye...</i> "
;

+ ConsultTopic @worts
    "Professor Wortschlachter appears on the screen, standing at his lectern
    and continuing his lecture in full flood. Fortunately, after a few moments
    he disintegrates into a stream of verbiage. "
;

+ ConsultTopic @tLanguage
    "Your thoughts about language flash up on the screen:\n
    <i>Cogito ergo sum</i>\n
    I think therefore I am\n
    I think, therefore I am using language.\n
    Language implies culture.\n
    Culture implies society.\n
    Society implies a real world.\n
    What if I were to think about that real world?"
;

+ ConsultTopic @textFragment
    "Fragments of text are already flashing up on the screen: but what are they
    composed of? "
;

+ ConsultTopic @tMark
    "An image of the Empty Tomb springs up on the screen in front of you. But
    you are in an empty tomb, so you see the room you are in before you: then,
    for a terrifying moment you don't know which side of the screen will be
    deconstructed. It turns out to be the other side that collapses back into
    fragment of text: but how can you tell? Maybe it was your side and your
    reality is now on the other side. What is real here? What is mere text? How
    do text and reality relate?"
;

+ ConsultTopic @gPlayerChar
    "You flash up on the screen and stare at yourself in horror, before one of
    you is dissolved into your constituent linguistic entities while the other
    looks on. Is your consciousness any more than the words it contains? What
    remains of the other you when only the words are left? A wave of
    disorientation and nausea sweeps over you as these questions torment you. "
;

+ ConsultTopic @tGod
    "The screen goes blank. God is beyond your power to reduce either to
    imagery or to words, and He stubbornly resists your feeble attempts
    at deconstruction. "
;

+ ConsultTopic @tSatan
    "A terrifying devil appears on the screen, emanating pure evil and malice
    of an intensity you had never dreamt of. Just as you feel you are about to
    be overwhelmed and your soul sucked under, the Devil dissolves into words:
    devil, evil, vile, veil, spin round on the screen and then slowly
    dissipate, leaving you feeling severely shocked and strangely sickened. "
;

+ ConsultTopic @dScreen
    "An image of the screen appears on the screen, and in that image of a
    screen is an image of a screen in which there is an image of a screen
    bearing the image of a screen showing the image of a screen... But then the
    progression collapses before it can become truly infinite. "
;

+ ConsultTopic @tDoor
    "A <<gTopicText>> flashes up on the screen, but is deconstructed into a
    load of pseudo-intellectual gibberish about annulling the binary opposition
    between inside and outside before you can figure out a way to open it. "  
;

+ ConsultTopic @tHistoricalJesus
    "For a moment nothing happens; then upon the screen in large golden letters
    flash the words <q>He is not here; he has risen!</q>, shortly to be
    replaced with <q>Seek the place where they laid him.</q> Finally this
    dissolves into a flurry of fragmentary quotations from the text of Mark
    16.1-8 (Mark's account of the Empty Tomb). "
;

+ DefaultConsultTopic
    "\^<<gTopic.getTopicText>> flashes up on the screen, and lingers there
    a few moments before being linguistically deconstructed. ";
;

