// D:\sw\game_design\tads3\cromGame3\crom_obj.t

// *******************************************************
// crom_obj.t
// This file contains custom designed objects for use in
// the game. 
// 
// CromexxClothing, ClimbableWall, MagicRope
// *******************************************************

// allow this file to be included only once in any project
#pragma once


//#ifndef CROMFUN7_T
//#include <cromfun7.t> // main
//#endif

#ifndef ADV3_H
#include <adv3.h>
#endif

// checks for if a variable was NOT defined from file en_us.h
// .. and if so then include the file to define that variable, method, etc.
#ifndef singleDir
#include <en_us.h>
// #error "You can put an error here too if the variable <> something. Boooo!!"
#endif


/*
 * --------- B E G I N    O B J S -----------
 *   OOOO   BBB   JJJJJ   SSSS
 *   O  O   B  B    J    S
 *  O    O  BBB     J     SSS
 *   O  O   B  B J  J        S
 *   OOOO   BBB   JJ     SSSS
 *
 * (Game Library Special Object Types)
 */

/* ** TEST OBJECT ***
 * The InitObject class loads at COMPILE TIME only
 * where "_main" calls every game InitObject's "execute()" method.
 * You do NOT see any text or anything in a call to "execute()" at
 * game start up.
 * 
 * In the example below the object will have a "myCounter" value of 1
 * after the program starts. (Go into debug mode to verify). 
 */
myIniter: InitObject {  
  myCounter = 0 // will show a value of 1 after we compile
  execute() { 
              myCounter++; 
              "myIniter object: *** YOU SHOULD NEVER SEE THIS TEXT ON GAME START UP ***\n"; 
  }
}


TCommandTopic : CommandTopic 
  /*  
   * The direct object, or a list of direct objects, that will be matched 
   * by this topic. 
   */ 
  matchDobj = nil 
   
  /*  
   * The first direct object of the command that this CommandTopic matches. 
   * We cache it here so that it can easily be picked up in topicResponse. 
   */ 
  currentDobj = nil 
   
  /* 
   * Cache the action that has been matched so that it is readily accessible 
   * from topicResponse  
   */ 
  currentAction = nil 
   
  matchTopic(fromActor, action) 
  { 
    /* First check whether we match the action of the command */ 
    if(!inherited(fromActor, action)) 
      return nil; 
         
    /* Then cache the first direct object of the command */ 
      
    currentDobj = action.getDobj(); 
         
    /* If matchDobj is a list, check if the current direct object is in the list */ 
    if(matchDobj.ofKind(Collection)) 
    { 
      if(matchDobj.indexWhich({x: currentDobj.ofKind(x)}) != nil) 
          return matchScore; 
    } 
    else     
    { 
      /* See if the direct object matches that specified in matchDobj  
       * if it's a single object. 
       */ 
      if(currentDobj != nil){
        if(currentDobj.ofKind(matchDobj)) 
           return matchScore; 
      }
      return nil;
    }    
     
     /* We can't match the direct object at all, so return nil */ 
   return nil;  
  } 
   
  handleTopic(fromActor, action) 
  { 
    actionPhrase = action.getInfPhrase; 
    currentAction = action; 
     
    /*  
     * if the player types a command like X ME, getInfPhrase will 
     * return 'examine you'. In such a case we want to replace 'you' 
     * with 'me'. 
     */ 
    actionPhrase = actionPhrase.findReplace(' you ', ' me ', ReplaceAll); 
    if(actionPhrase.endsWith(' you')) 
      actionPhrase = actionPhrase.findReplace(' you', ' me', ReplaceOnce, 
        actionPhrase.length-5); 
    inherited(fromActor, action); 
  }   
   
  /* The action phrase of the command currently directed to this actor; 
   * for example, if the player types 'X ME' the actionPhrase will be 
   * 'examine me'. This can be used in topicResponse to construct the 
   * command given by the player character, e.g.  
   * 
   *    "Sarah, please examine me," you ask. 
   */ 
  actionPhrase = nil 
; 


swimming: Posture
    postureDesc = "swimming"
    tryMakingPosture(loc) { return tryImplicitAction(SwimIn, loc); }
    setActorToPosture(actor, loc) { nestedActorAction(actor, SwimIn, loc); }
  // see: en_us.t - example: modify standing
  msgVerbIPresent = 'swim{s} down'
  msgVerbIPast = 'swam up'
  msgVerbTPresent = 'swim{s}'
  msgVerbTPast = 'swam'
  participle = 'swimming'
;

modify Thing
  dobjFor(SwimIn){
      preCond = [touchObj]
      verify(){ illogical('{You/he} can\'t swim in {that dobj/him}. '); }
  }
  canSwimIn = nil
;



// see: actor.t - "sitting" Posture is defined...
//      but modified in en_us.t
/*
 *   Crawling posture. 
 */
crawling: Posture
    postureDesc = "crawling on hands and knees"
    tryMakingPosture(loc) { return tryImplicitAction(CrawlOn, loc); }
    setActorToPosture(actor, loc) { nestedActorAction(actor, CrawlOn, loc); }
  //tryMakingPosture(loc) { return tryImplicitAction(Stand); }
  //setActorToPosture(actor, loc) { nestedActorAction(actor, Stand); }
  // see: en_us.t - example: modify standing
  msgVerbIPresent = 'crawl{s} down'
  msgVerbIPast = 'crawled up'
  msgVerbTPresent = 'crawl{s}'
  msgVerbTPast = 'crawled'
  participle = 'crawling'
;

/*
 * // defined earlier in program !?!? .... remming out
// see startrooms.t ... object "mnsnBantensCarCab01" uses this Posture...but also fakes the posture message
sittingBuckledUp: Posture
  postureDesc = "sitting buckled up"
  tryMakingPosture(loc) { } // see actor.t
  setActorToPosture(actor, loc) { } // see actor.t
  //tryMakingPosture(loc) { return tryImplicitAction(Stand); }
  //setActorToPosture(actor, loc) { nestedActorAction(actor, Stand); }
;
*/

beingCarried: Posture
  postureDesc = "carried" // being carried
  tryMakingPosture(loc) { } // see actor.t
  setActorToPosture(actor, loc) { } // see actor.t
  participal = 'carried'
  //tryMakingPosture(loc) { return tryImplicitAction(Stand); }
  //setActorToPosture(actor, loc) { nestedActorAction(actor, Stand); }
;

flying: Posture
    postureDesc = "flying"
    tryMakingPosture(loc) { 
        // return tryImplicitAction(FlyOn, loc); 
         if(gActor.posture == flying){
            reportFailure(&alreadyFlyingMsg);
            exit;
         }
         if(gActor.location.canFly== nil){
            reportFailure(&cannotFlyMsg); 
            exit;
         }else{
            gActor.makePosture(flying); // setActorToPosture(gActor,crawling);
            local oFloor =  gActor.location.getNominalDropDestination();
            local sRpt = playerActionMessages.roomOkayPostureChangeMsg(flying,oFloor);
            mainReport(sRpt);
         }
    }
    setActorToPosture(actor, loc) { 
      flying.tryMakingPosture(loc); // nestedActorAction(actor, CrawlOn, loc); 
    }
  //tryMakingPosture(loc) { return tryImplicitAction(Stand); }
  //setActorToPosture(actor, loc) { nestedActorAction(actor, Stand); }
  // see: en_us.t - example: modify standing
  msgVerbIPresent = 'fly{s}'
  msgVerbIPast = 'flew'
  msgVerbTPresent = 'fly{s}'
  msgVerbTPast = 'flied'
  participle = 'flying'
;

kneeling: Posture
   postureDesc = "kneeling"
   tryMakingPosture(loc) { return tryImplicitAction(KneelOn, loc); }
   setActorToPosture(actor, loc) { 
          nestedActorAction(actor, KneelOn, loc); 
   }
  //tryMakingPosture(loc) { return tryImplicitAction(Stand); }
  //setActorToPosture(actor, loc) { nestedActorAction(actor, Stand); }
  // see: en_us.t - example: modify standing
  msgVerbIPresent = 'kneel{s} down'
  msgVerbIPast = 'kneeled'
  msgVerbTPresent = 'kneel{s}'
  msgVerbTPast = 'kneeled'
  participle = 'kneeling'
;


   
/*******************************\
 * floor of uncrawlable Room   *
\*******************************/
uncrawlableFloor: Floor
  name = 'floor' 
  vocabWords = '(old) ground/floor'
  desc = "The floor looks ordinary enough. "
  putDestMessage = &putDestFloor
  customCanNotCrawlOnMsg = nil // 'Who ever heard of crawling on the floor here? This is the kitchen. '
  customCanNotKneelOnMsg = nil
  dobjFor(Read){ 
         verify(){ 
             illogical('There is nothing written on the floor. '); 
         }  
  }
  dobjFor(CrawlOn){ 
        verify(){ 
          if(self.customCanNotCrawlOnMsg != nil)
            illogical(self.customCanNotCrawlOnMsg);
          illogical(&cannotCrawlOnMsg);//'You can not do that now. '); // &canNotCrawlOnMsg);
        }
  }  
  dobjFor(KneelOn){
        verify(){
          if(self.customCanNotKneelOnMsg !=nil)
            illogical(self.customCanNotKneelOnMsg);
          illogical(&cannotKneelOnMsg);
        }
  }
;

class UncrawlableRoom: Room
  allowedPostures = [sitting, lying, standing]  
  /*  allow the player to enter crawling
   *  but modify it to standing upon enteringRoom routine.
   */ 
  defaultPosture = (gPlayerChar.posture == crawling) ? crawling : standing
  canCrawlOn = nil
  dobjFor(CrawlOn) maybeRemapTo(roomFloor != nil, CrawlOn, roomFloor)
  dobjFor(KneelOn) maybeRemapTo(roomFloor != nil, KneelOn, roomFloor)
  roomParts = [uncrawlableFloor,defaultNorthWall,defaultSouthWall,defaultEastWall,defaultWestWall,defaultCeiling]   
  enteringRoom(traveler) {
      if(traveler.posture == crawling)
         if(gPlayerChar == gActor)
           "You enter <<traveler.posture.participle>> but you immediately stand up. \n";
      if(traveler.posture != nil){
            if(traveler.posture != standing){
                traveler.makePosture(standing); // tryMakingPosture(standing);
                local oFloor =  gActor.location.getNominalDropDestination();
                if(oFloor == nil) oFloor = gActor.location;
                gMessageParams(oFloor);
                if(gPlayerChar == gActor)
                  "{You\'re} now <<gActor.posture.participle>> {on oFloor}. ";
            }
      }
  }
;



// see startrooms.t ... object "mnsnBantensCarCab01" uses this Posture...but also fakes the posture message
sittingBuckledUp: Posture
  postureDesc = "sitting buckled up"
  tryMakingPosture(loc) { } // see actor.t
  setActorToPosture(actor, loc) { } // see actor.t
  //tryMakingPosture(loc) { return tryImplicitAction(Stand); }
  //setActorToPosture(actor, loc) { nestedActorAction(actor, Stand); }
;

/* *********************
class AbstractObject: Fixture
  isAbstract = true
  no_drop = true // true if no drop item
  no_drop_message = "You can not drop that. "
  is_not_removable = true
  is_not_removable_message = "You can not remove that. "
  dobjFor(Remove){
       action(){ "You can not remove abstract objects or ideas. ";  }
  }
  dobjFor(Doff) asDobjFor(Remove)
  dobjFor(Drop) asDobjFor(Remove)  
;
 ********************  */

/*
 * class Attachable is in file: extras.t
 */ 
class CromexxBulletinBoard: Attachable, Readable, Fixture, RoomPartItem
  name = 'bulletin board'
  vocabWords = '(cork) (announcement) (bulletin) board'
  desc = "The bulletin board has many pieces of paper tacked to it. "
  // this shows up in an "examine w wall" command
  specialDesc = "A cork bulletin board hangs on the wall. "
  // note, each obj. in this list must be of class Attachable
  // and also have this object itself in their own list
  attachedObjects = []   
  /*
   * The read description shown when a little girl tries to read the board.
   */
  LGReadDesc = 'Blah blah blah!'
  dobjFor(Read){
     preCond = [objVisible]
     verify(){ if(gActor.is_A_Little_Girl){ illogical(self.LGReadDesc); }
              inherited;
     }
     check(){ inherited; }
     action(){ inherited; }
  }
  /*
   *  If the player does a "read board" command we'll
   *  just show the readDesc of each of our attached notices (if any),
   *  otherwise show a message that there's nothing interesting to read.
   */
  readDesc {          
          foreach(local cur in self.attachedObjects){                 
                 if(cur.readDesc != nil){           
                       cur.readDesc;                       
                       "<br><.p> ";
                 }
          }
          if(self.attachedObjects.length==0){
                 "There doesn\'t seem to be anything of importance 
                 on the bulletin board to read right now. ";                
          }                  
  }
  /* 
   * "isMajorItemFor(obj)" ... this should always return true for
   * various notes pinned to the bulletin board, and as such it will
   * list the note(s) as being attached to the bulletin board and not
   * ever the other way around. 
   */
  isMajorItemFor(obj) {  
        if(obj.ofKind(CromexxBulletinBoardNote)==true) return true;
        return nil; 
  } 
  canAttachTo(obj){
           // this means the note can only attach to the bulletin board (& vice versa)             
           if(obj.ofKind(CromexxBulletinBoardNote)==true) return true;
           return nil; 
  }  
  iobjFor(PutOn) maybeRemapTo((gDobj !=nil),AttachTo,self,gDobj)
  //  iobjFor(AttachTo) maybeRemapTo((gDobj !=nil),AttachTo,self,gDobj) // WARNING: May result in a stack overflow!
  /*
   * Modified "dobjFor(AttachTo)" to move the note out of the
   * player's inventory when the player tries to attach it to the
   * bulletin board. The reply to the action will be: "Dropped. Done." 
   * Note that the "iobjFor(PutOn) maybeRemapTo..." and the same
   * for "iobjFor(AttachTo) maybeRemapTo..." above are used to 
   * correctly remap the action to the below code and cause the
   * player to drop the note first before attaching it to the board.
   */
  // "put note on board" triggers this via "iobjFor(PutOn) maybeRemapTo..." above
  dobjFor(AttachTo){
       preCond = [touchObj]
       verify(){ inherited; }
       check(){ inherited; }
       action(){ 
                 //"We\'re running our attach to stuff now... \n";
                 if(gIobj.isIn(gActor)){
                   /* send the object to the actor's drop destination */
                   gActor.getDropDestination(gIobj, nil)
                      .receiveDrop(gIobj, dropTypeDrop);
                 }               
                 inherited; 
       }
  }
  // "Attach note to board" triggers this...
  iobjFor(AttachTo){
       preCond = [touchObj]
       verify(){ inherited; }
       check(){ inherited; }
       action(){ 
                 //"We\'re running our attach to stuff now... \n";
                 if(gDobj.isIn(gActor)){
                   /* send the object to the actor's drop destination */
                   gActor.getDropDestination(gDobj, nil)
                      .receiveDrop(gDobj, dropTypeDrop);
                 }               
                 inherited; 
       }
  }
;

class CromexxBulletinBoardNote: Attachable, Readable, Thing
  name = 'bulletin board note'
  vocabWords = '(ordinary) (white) paper note/notice' 
  desc = "The notice is printed on white paper. From the professional look it 
          appears like it was printed at a print shop and may have been 
          distributed widely. "  
  /*
   * The read description shown when a little girl tries to read the board.
   */
  LGReadDesc = 'Blah blah blah!'
  dobjFor(Read){
     preCond = [objVisible]
     verify(){ if(gActor.is_A_Little_Girl){ illogical(LGReadDesc); }
              inherited;
     }
     check(){ inherited; }
     action(){ inherited; }
  }
  readDesc = "This note doesn\'t seem to have anything written on it yet. "
  attachedObject = []
 /* Note: we use the pre condition of objNotAttached so 
  * the player doesn't drag the note from the bulletin board
  * like a giant rubber band. 
  */
  dobjFor(Take){    
    preCond = [objNotAttached, touchObj, objNotWorn, roomToHoldObj]
    verify(){ inherited; }
    check(){ inherited; }
    action(){ inherited; }    
  }  
  canAttachTo(obj){
           /* This means the note can only attach to the bulletin board (& vice versa)             
            * Note that you only really need a "canAttachTo(obj)" routine in the
            * actual bulletin board item but we list it here just for completeness.
            */ 
           if(obj.ofKind(CromexxBulletinBoard)==true) return true;
           return nil; 
 }  
;

/* see msg_neu.t for SimpleAttachmentLister & MajorAttachmentLister
 * see extras.t for AttachmentLister
 */
//CromexxWallHookLister : SimpleAttachmentLister
//    construct(parent) { parent_ = parent; }
//    
//    showListEmpty(pov, parent)
//        { /* say nothing when there are no attachments */ }
//    
//    showListPrefixWide(cnt, pov, parent)
//        { "<.p>\^<<parent.nameIs>> asdfasdfasdfattached bongobongo to "; }
//    showListSuffixWide(cnt, pov, parent)
//        { ". "; }
//
//    /* ask the parent if we should list each item */
//    isListed(obj) { return parent_.isListedAsAttachedTo(obj); }
//
//    /* 
//     *   the parent object - this is the object whose attachments are being
//     *   listed 
//     */
//    parent_ = nil
//;

//CromexxMajorWallHookLister: MajorAttachmentLister
//    showListPrefixWide(cnt, pov, parent) { "<.p>\^"; }
//    showListSuffixWide(cnt, pov, parent)
//    {
//        " <<cnt == 1 ? tSel('is', 'was')
//                     : tSel('are', 'were')>>
//        AKAKAKAdangling from <<parent.theNameObj>>. ";
//    } 
//   // vs "attached to"
//
//    // ask the parent if we should list each item 
//    isListed(obj) { return parent_.isListedAsMajorFor(obj); }
//;

/*
 * class CromexxWindow 
 *  NOTE: you must use CromexxWindowGlass as a multi-loc child object
 *        and define the child's locationList which should be equal to
 *        the rooms on either side of the window. 
 *  To use CromexxWindow class:
 *       Make the myWindowGlassObj variable equal to your CromexxWindowGlass object name.
 *       And setup another window on the other side (in the other room) pointing
 *       back to this window, just like you would a Door object. 
 */
//class CromexxWindow: Door
//   name = 'window'
//   vocabWords = '(dusty) (old) window'
//   myWindowGlassObj = nil // specify a CromexxWindowGlass sense connector
//   dobjFor(LookIn) remapTo(LookThrough,self.myWindowGlassObj)
//   dobjFor(Read){ verify(){ illogical('There is nothing written on the window.'); } }   
//;

// TEMPLATE for CromexxWindow (based on Room template) - see: en_us.h
//CromexxWindow template 'roomName' 'destName'? 'name'? "desc"?;

/* class CromexxWindowGlass is a sense connector
 * that uses CromexxWindow as its parent object.
 * 
 *
 */
// Another way to do a "window" is at: http://users.ox.ac.uk/~manc0049/files/GettingStartedInTADS3.htm
// note: DistanceConnector (in sense.t) is required for use with
//       listRemoteContents (in lookDir.t module for "look north", etc.)
//       DistanceConnector extends MultiLoc (from objects.t) so it does 
//       NOT have a normal "location" property but uses a MultiLoc array.
//       Note: as MultiLoc indicates, you should put that class (i.e. DistanceConnector)
//       BEFORE other object type definitions as it has routines that it over-rides. 
// 
//class CromexxWindowGlass: SenseConnector 
//  name = 'window glass'
//  vocabWords = '(dusty) (old) (window) glass'
//  desc = "The window glass is about a quarter inch thick. " 
//  locationList = [self.sideOneRoom,self.sideTwoRoom]
//  dobjFor(LookIn) remapTo(LookThrough,self)
//  dobjFor(Read){ verify(){ illogical('There is nothing written on that.'); } } 
//  /* 
//   * Function: dobjFor(LookThrough)
//   * 
//   * The following calls the "roomRemoteDesc" routine (defined in thing.t)
//   * in the opposite room from which the player is currently in.
//   *    Example (in the mansionDrivewayRoom): 
//   *     roomRemoteDesc(pov){
//   *          if(pov == startRoom){
//   *            "From the other side of the main gate you see
//   *             the driveway curve around to the west and end
//   *             at a garage door. A footpath beside the driveway
//   *             goes up to the front porch of the mansion. ";
//   *          }else{
//   *             // default is to just show our normal description
//   *             self.desc;
//   *          }       
//   *     }
//   *
//   * See also: lookDir.t (tads module from IF-Archive)
//   *             \__ uses listRemoteContents in a "northLook" room property example (vs. roomRemoteDesc)
//   *               |_ describeRemoteRoom(startRoom)
//   *
//   * TO DO: list the contents of the room you're looking into.
//   *        For now we won't do this as it involves checking for
//   *        obstructions in the way of the viewpoint, plus complex
//   *        special object descriptions. 
//   */
//  dobjFor(LookThrough){
//          action(){ 
//                "You look through the ";
//                self.isOpen ? "open" : "closed";
//                " window...\n";                
//                if(locationList.length == 2){ 
//                    local myOther = gActor.isIn(self.locationList[1]) ?
//                                    self.locationList[1] : self.locationList[2];
//                    myOther.roomRemoteDesc(gActor.location);                
//                }
//          }
//  }
//;



/*  class Door is in travel.t (extends: Openable, Throughpassage)
 *  
 */ 
class CromexxIronGate: Door
  name = 'iron gate'
  vocabWords = '(big) (giant) (heavy) (black) (spiked) (iron) (metal) (front) (mansion) (entry) door/gate'
  desc = "The iron gate is built of heavy iron bars with spikes on top. 
          Thick bands of metal are welded and bolted to the bars and the 
          structure stands easily at fifteen feet tall at the apex. "
  //  keyList = [skeletonKey]
  initiallyOpen = nil // options are: true/nil - optional to include this
  //initiallyLocked = true // options are: true/nil. note this val. only is meaningful IF there is an actual lock to the door) - optional to include this  
  lgOpenTries = 0
  lgCloseTries= 0
  specialCloseFailLGMessage = nil
  specialOpenFailLGMessage = nil
  dobjFor(Close){
       preCond = [actorDirectlyInRoom,touchObj,actorTravelReady]
       verify(){
          logicalRank(85,'the gate seems to be the default openable object here');
          // ** is the player a little girl?
          if(libGlobal.playerChar.is_A_Little_Girl==1){
            if(self.isOpen == true){   
                      self.lgCloseTries++;
                      switch(self.lgCloseTries){
                          case 1: "The big heavy gate is much too heavy to move 
                                   for a little girl like yourself.\n ";
                                   break;
                          case 2: "As a grown man you could have closed the this gate
                                   easily but you\'re just a little girl now. The gate
                                   just won\'t budge shut.\n ";
                                  break;
                          case 3: "Mmmmmmmmmmmmmmmmmmmm.... no. Sorry. The heavy iron gate
                                   still won\'t shut for little old you.\n ";
                                   break;
                          case 4: if(self.specialCloseFailLGMessage != nil){
                                      self.specialCloseFailLGMessage;
                                  }else{
                                     "The gate still won\'t shut. It\'s just way 
                                      too heavy for you now.\n ";
                                  }
                                  break;
                          case 5: "Huff......\n<br>";
                                   timeDelay(1000);
                                   "Puff.............\n<br>";
                                   timeDelay(1000);
                                   inputManager.pauseForMore(true);
                                   "Grrrrrrrrrrrrrrr.....\n<br>";
                                  "Shew! That time was too much for you. You have to sit down a 
                                   second to catch your breath. The gate just doesn\'t look like
                                   it\'s going to shut for a little girl like yourself. Times like
                                   this really make you miss being your normal fully grown
                                   male self. ";
                                   libGlobal.playerChar.makePosture(sitting);
                                   break;
                          case 10: "Persistent aren\'t we? The gate still won\'t shut. ";
                                   break;
                          case 11: if(rand(100)> 50){
                                         "The gate won\'t budge. I suppose you\'re expecting 
                                          a dwarf or someone to come along and help you with 
                                          your task but that doesn\'t seem likely. The Union
                                          of Helpful Dwarves probably doesn\'t allow for this
                                          sort of thing all the time anyway.\n ";
                                     }else{
                                         "The gate won\'t budge.\n ";
                                     }
                                     break;
                          case 20: "Still at it? That gate is just way too big to budge for you
                                    now. Perhaps you shouldn\'t have changed into a little girl
                                    in the first place.\n ";
                                    self.lgCloseTries = 0;
                                    break;                  
                          default: "It\'s no use. The gate just won\'t close for tiny 
                                    little you.\n ";
                                   break;                                 
                      }// end switch
                      // ** now exit (i.e. do NOT let little girls close the gate) **
                      exit;
            }// end self.isOpen == true
          }// end is little girl == true         
          // ** otherwise carry out default CLOSE command verify stuff ** 
          inherited;
       }
       check(){ inherited; }
       action(){ inherited; }  
  } 
  dobjFor(Open){
       // actorTravelReady means you'd have to stand up first to open the gate if sitting down
       // (or more precisely this is controlled by the actor's immediately container)
       // see: precond.t
       preCond = [actorDirectlyInRoom,touchObj,actorTravelReady]
       verify(){
                // below resolves a problem with "x gate" followed by "open it"
                // ...we set logical rank to 85 - otherwise we get the parser
                // saying "'it' does not refer to anything right now. " 
                logicalRank(85,'the gate seems to be the default openable object here');
                // ** is the player a little girl?
                if(libGlobal.playerChar.is_A_Little_Girl==1){
                   if(self.isOpen != true){   
                      self.lgOpenTries++;
                      switch(self.lgOpenTries){
                          case 1: "The big heavy gate is much too much for your little girl arms to budge. ";
                                  break;
                          case 2: "You try again but that silly darn old gate just won\'t budge. "; 
                                  break;
                          case 3: "You really lean into it this time but no matter how hard you
                                   try that gate is just too big and heavy for a little girl like
                                   you to move an inch. ";
                                  break;
                          case 4: "Huff....\n<br>";
                                   timeDelay(1000);
                                  "Puff.......\n<br>";
                                   timeDelay(1000);
                                  "Nnnnnnnnnnnn.....\n<br>";
                                   timeDelay(1000);
                                  "It was worth the try but still the gate won\'t open
                                   for you. You\'re just too weak and little and that gate is just
                                   too big and heavy. ";
                                  break;
                           case 5: "Huff......\n<br>";
                                   timeDelay(1000);
                                   "Puff.............\n<br>";
                                   timeDelay(1000);
                                   "Grrrrrrrrrrrrrrr.....\n<br>";
                                  "Shew! That time was too much for you. You have to sit down a 
                                   second to catch your breath. The gate just doesn\'t look like
                                   it\'s going to open for a little girl like yourself. Times like
                                   this really make you miss being your normal fully grown
                                   male self. ";
                                   //remapTo(SitOn,defaultGround) 
                                   // execute another command but don't count agains player turn counter
                                   //libGlobal.totalTurns--;                  
                                   //local tokList = Tokenizer.tokenize('sit on ground');
                                   //executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)       
                                   libGlobal.playerChar.makePosture(sitting);// standing
                                   break;
                            case 6: if(self.specialOpenFailLGMessage != nil){
                                       self.specialOpenFailLGMessage;
                                    }else{
                                       "The gate still won\'t open.\n ";
                                    }
                                    break;
                            case 10: "Persistent aren\'t we? The gate still won\'t open. ";
                                   break;
                            case 11: if(rand(100)> 50){
                                         "A dwarf walks up to the gate. Even for a dwarf he\'s
                                          still taller than you. He notices you\'re having 
                                          trouble with the gate and helps you open it. Then he
                                          jogs off to the west and vanishes.\n ";
                                          self.makeOpen(true);// self.isOpen=1;                                          
                                          self.lgOpenTries=0;
                                     }else{
                                         "The gate won\'t budge.\n ";
                                     }
                                     break;
                            case 20: "Still at it? That gate is just way too big to budge for you
                                      now. Perhaps you shouldn\'t have changed into a little girl
                                      in the first place.\n ";
                                     self.lgOpenTries = 0;
                                     break;                                   
                            default: "It\'s no use. The gate just won\'t open for tiny little you.\n ";
                                   break;                                 
                      }
                      // ** now exit (i.e. do NOT let little girls open the gate) **
                      exit; 
                   }                   
                }
                // ** otherwise carry out default OPEN command verify stuff ** 
                inherited;
       } 
       check(){ inherited; }
       action(){ inherited; }         
  }
  //dobjFor(Open){
  //   preCond = [actorDirectlyInRoom,touchObj] // in case PC is in bed he has to get out of bed first...
  //   verify(){ inherited; }
  //   check(){ inherited; }
  //   action(){ inherited; }
  // }
  // dobjFor(Close){   
  //   preCond = [actorDirectlyInRoom,touchObj] // in case PC is in bed he has to get out of bed first...
  //   verify(){ inherited; }
  //   check(){ inherited; }
  //   action(){ inherited; }
  //}
;

// TEMPLATE for CromexxIronGate (based on Room template) - see: en_us.h
CromexxIronGate template 'roomName' 'destName'? 'name'? "desc"?;




class CromexxCompass: Thing
  name = 'compass'
  vocabWords = '(small) (brass) compass'
  desc = "It\'s a small brass compass. "
  readDesc = "It\'s pointing north but shouln\'t it do that? After all it\'s a compass. "
  // on obtain me.absDirMode=true (okay to use compass notation)
  // on drop me.absDirMode =nil (can not use compass notation)
  // ** do this via daemon 
;

testCompass: CromexxCompass
 location = pixyland // roadside322
;

myMMMLostRoomFootNote: Footnote "Perhaps if you had a compass
                  you could navigate the forest and not get lost so easily. ";

/*
 *  In case you want the "old" style Room object where
 *  it does not matter if you have a compass or not, then
 *  use this OldRoom class. Otherwise all indoor Rooms by 
 *  default will require a compass. 
 */
class OldRoom: Room
 enteringRoom(traveler) {      
     traveler.absDirMode = true;     
  }
  iAllowDirLookAlways = 1 // a mod for the lookDir.t file. - for rooms where you obviously don't need a compass you can override to always allow the DirLook command
  iRequireCompass = 0 //
;



class LostRoom: OutdoorRoom   
  iTravelerHasCompass = 0  
  iRequireCompass = 1 // an override. OutdoorRoom by default never will require compass, indoor rooms will, and LostRooms will
  myFakeConn : FakeConnector {"You wander through the woods for awhile but seem to be going in circles. "; }
  northwest = noTravel
  northeast = noTravel
  southwest = noTravel
  southeast = noTravel
  /* Example use:
   *    north = (iTravelerHasCompass==1) ? noTravel : myFakeConn
   *    desc { "You are in the forest. ";
   *       if(iTravelerHasCompass==1){
   *          if(gActor.hasSeen(roadside322))
   *             "With your compass you are able to determine the mansion 
   *              wall is just off to the northwest from here. ";
   *          if(gActor.hasSeen(woods29))
   *             "The cottage seems to be a little ways to the southeast. ";
   *    }
   */
  helpLostPlayerScript(oActor) {   
          if(lostAndFoundRoom != nil){
              oActor.moveIntoForTravel(lostAndFoundRoom);                
              // clearScreen();             
              "<font color=green><i>A ranger appears and realizes you\'re probably lost way out here
              in the woods so he leads you away to safety and departs quickly 
              back into the forest</i></font>. <<myMMMLostRoomFootNote.noteRef>> ";                            
              oActor.location.showStatuslineExits(); 
          }           
  }
  lostAndFoundRoom = nil  // the room we'll put the player in   
  enteringRoom(traveler) {      
     if(traveler.ofKind(CromexxHuman)){                    
          iTravelerHasCompass = 0;
          foreach(local obj in traveler.contents){
              if(obj.ofKind(CromexxCompass)) iTravelerHasCompass=1;
          }
          if(iTravelerHasCompass==1){
             traveler.absDirMode = true;// see file: reldir.t - forward,backward,l,r...etc.
          }else{
             traveler.absDirMode = nil;// see file: reldir.t - forward,backward,l,r....ect.             
          }
          if((iTravelerHasCompass!=1) && (traveler == gPlayerChar)){
              traveler.lostTally++;
              if((traveler.lostTally) >= (traveler.lostThresh[traveler.iCurLostThresh])){
                   // traveler is too lost so let's help them
                   traveler.lostTally = 0; // reset lost tally 
                   traveler.iCurLostThresh++;
                   if(traveler.iCurLostThresh > traveler.lostThresh.length) traveler.iCurLostThresh = 1;
                   self.helpLostPlayerScript(traveler);
              }
          }
     }
  }
  roomAfterAction() {  
         
  }  
;

 //   lostTally = 0 // counter. if lostTally > lostThresh[iCurLostThresh] we'll "help" the lost player somehow
 //  isLost = (lostTally > 0) ? 1 : 0
 //  lostThresh = [3,5,7,9]  // array of high end lost threshhold - we rotate this each time we "help" a lost player
 //  iCurLostThresh = 1
  

;

/* 
 * Class: LongRoad
 *
 * What it does: This simulates an "infinite" highway,
 *               just like the original mystery mansion text adventure.   
 *
 * How to use:   This is an extention of the Room object. Simply 
 *               use as shown in the example below. For true infinite rooms
 *               leave the farExitRoom value at nil (or omit as it is nil
 *               by default). Otherwise once you arrive at farExitTallyNumber
 *               you will exit into the farExitRoom. 
 *              
 *               Existing longRoadType values are: 'west', 'east', 'north' and 'south'
 * 
 *               A longRoadType 'west' will go westward towards the farExitRoom destination
 *               (if it exists), and eastward to the nearExitRoom (usually the room that got
 *               you to this long road in the first place). 
 *         
 *               This room simply loops back to itself to simulate going on and on.
 *               A hidden counter (tallyNumber) keeps track of where you are in the room.
 *               A tallyNumber of zero (0) allows you to exit to the nearExitRoom (if exists),
 *               and a tallyNumber matching farExitTallyNumber (500 by default) will allow you
 *               to exit to the farExitRoom (if exists).
 *         
 *               The room simulates a long road or tunnel with only two endpoint exits out of
 *               the loop back to itself. Normally you can not go in other directions than the
 *               path of the longRoom ('west' or 'east' will have only east or west exits, 
 *               'north' or 'south' will have only north or south exits). 
 *   
 *               To allow other branches off this longRoad simply end the longRoad object short
 *               and create a normal room at the farExitRoom to be your off ramp or whatever, 
 *               then simply create another longRoad object from there to continue your highway.
 *       
 *               NOTE: Each longRoom should have a unique "id" value. Otherwise dropped objects
 *               may show up in other longRoom locations (due to the same tally flag). 
 *
 * Example use: 
 *  roadWestRoom: longRoad
 *     id = '1001'
 *     name { "A super duper long road"; }
 *     desc { "A really long east-west highway. "; }  
 *     dest = 'a long road' // optional - shows our room dest name in the room exits routine from other locations
 *     longRoadType = 'west'
 *     destroyDroppedObjects= 0
 *     nearExitRoom = startRoom
 *     farExitRoom = elfForestEntryRoom // or nil
 *     farExitTallyNumber = 500  // how many units away from the nearExitRoom our farExitRoom is
 *  ;
 *
 */
class LongRoad: Room 
  id = '0123456'
  name = 'A long road'
  desc = "A road going on and on and on. <<self.tallyNumber>>"
          // "For debugging... current tallyNumber == <<self.tallyNumber>>\n";
  // destName is optional and shows up
  // in outer room exits pointing to this room.
  destName = 'a long road' 
  longRoadType = 'east' // types include: 'west','north','south','east' 
  // "tallyNumber" is an internal variable used to show exact spot on the highway
  tallyNumber = 0
  // "destroyDroppedObjects" - set to 1 to destroy dropped objects, otherwise 0 to allow them to be dropped
  destroyDroppedObjects = 0
  // Note: when creating a new object with the "new" opeartor, the "construct()" method is automatically called.
  // Note: you can use "construct()" without or with "construct(myval)" arguments. 
  // construct(){ inherited; }
  // construct(myval){ inherited; }
  // Note: use the "finalize()" method to notify you when/if your object is automatically deleted via garbage collection
  // Note: finalize() is only ever called ONE TIME only by the garbage collector in TADS. So if you "save" the object from deletion in finalize() once, you may not be able to save it a 2nd time the object is available for garbage collection.
  // finalize(){ inherited;  
  //        MyGlobals.finalizedList += self;// by adding to an outside object it prevents garbage collection until the outer reference is deleted 
  // }
  // "tallyStoreRoom" is an internal variable used to temporarily hold objects.  
  tallyStoreRoom: Room { name = 'Tally store room';
                         desc = "Tally store room for class longRoad. 
                                 Stores objects here and should never 
                                 be seen by the player. ";
                         east = self.lexicalParent; // make a generic exit out of here just in case
                       }
  // for a western road, "nearExitRoom" will be the eastern-most room adjacent to this longRoad   
  nearExitRoom = nil // startRoom 
  // by default the road will go on forever if nil, otherwise a "farExitRoom" can be defined
  farExitRoom = nil
  // If "farExitRoom" is defined we must define a farExitTallyNumber,
  // which is the tallyNumber where an exit goes to farExitRoom. 
  // For example, a western longRoad will have a farExitRoom exit to the west
  // at room tallyNumber 500 by default. An eastern longRoad will exit to the east
  // also at room tallyNumber 500 by default, and so on.
  farExitTallyNumber = 500 
  receiveDrop(obj, desc){
         // destroy objects dropped in this room? 
         if(self.destroyDroppedObjects==1){
            obj.moveInto(nil);
            "A car drives past and runs over the <<obj.name>>, destroying it. ";
         }else{
            if((obj.ofKind(Actor)) &&
               (obj.isIn(self.roomParts))){
               // do nothing - don't move room parts or actors
            }else{
               obj.tallyNumber = self.tallyNumber;// flag for later temp storage in tallyStoreRoom
               obj.tallyID = self.id;// flag marking the item to this room's id number
            }
            // now actually accept the object into the room
            "Okay \n";// have to put something or else you get "nothing obvious happens" when you drop an obj
            obj.moveInto(self);
         }
  }   
  setRoomExitDefaults(){
        // set room exit defaults        
        removeElement(self.east);// self.east=nil;
        removeElement(self.west);// self.west=nil;
        removeElement(self.north);// self.north=nil;
        removeElement(self.south);// self.south=nil;
        // handle anything in between near and far exit numbers
        if((self.tallyNumber > 0) && (self.tallyNumber < self.farExitTallyNumber)){
            switch(self.longRoadType){
                   case 'west': 
                       self.east=self;
                       self.west=self;                       
                       break;
                   case 'east': 
                        self.east=self;
                        self.west=self;                       
                       break;
                   case 'north':
                       self.north=self;
                       self.south=self;
                       break;
                   case 'south':
                       self.north=self;
                       self.south=self;
                       break;
                   default:
                       break;
            }
        }
        // handle nearExitRoom if tallyNumber == 0
        if((self.nearExitRoom != nil) && (self.tallyNumber==0)){
            switch(self.longRoadType){                   
                   case 'west':
                      self.east=self.nearExitRoom;
                      self.west=self;
                      break;
                   case 'east':
                      self.west=self.nearExitRoom;
                      self.east=self;
                      break;
                   case 'north':
                      self.south=self.nearExitRoom;
                      self.north=self;
                      break;
                   case 'south':
                      self.north=self.nearExitRoom;
                      self.south=self;
                      break; 
                   default:
                      break; 
            }            
        }
        // handle farExitRoom if tallyNumber == farExitTallyNumber
        if((self.farExitRoom != nil) && (self.tallyNumber==self.farExitTallyNumber)){
            switch(self.longRoadType){
                   case 'west':
                      self.west=self.farExitRoom;
                      break;
                   case 'east':
                      self.east=self.farExitRoom;
                      break;
                   case 'north':
                      self.north=self.farExitRoom;
                      break;
                   case 'south':
                      self.south=self.farExitRoom;
                      break;
                   default:
                      break;
            }
        }   
  }    
  // these travel descriptions show when a player (not NPC) moves along the longRoad
  westTravelDesc = "You walk west along the long highway.\n "
  eastTravelDesc = "You walk east along the long highway.\n "
  northTravelDesc = "You walk north along the long highway.\n "
  southTravelDesc = "You walk south along the long highway.\n "
  roomBeforeAction(){ 
        // "** before action - getting dropped and setting exits.... **\n";
        self.doRetrieveDropped(); 
        self.setRoomExitDefaults();
        // *** handle go back action ***
        if(gAction.baseActionClass==GoBackAction){
           // going back is too complex in this room (have to conditionally undo tally, etc.)
           // can put this on a "to-do" list for later...
           "You don't know how to return from here.\n ";
           exit;
        }
        // *** handle travel actions to set tallyNumber ***
        if(gAction.baseActionClass==TravelAction){
           if(gAction.dirMatch != nil){
              if(gAction.dirMatch.dir != nil){
                  // store objects before moving...
                  doStoreDropped(); 
                  // show our travel description (if direction is a valid exit)
                  switch(gAction.dirMatch.dir){
                          case westDirection:
                             if((self.west != nil) && (gActor.isPlayerChar))
                               self.westTravelDesc;
                             break;
                          case eastDirection:
                             if((self.east != nil) && (gActor.isPlayerChar))
                               self.eastTravelDesc;
                             break;
                          case northDirection:
                             if((self.north != nil) && (gActor.isPlayerChar))
                               self.northTravelDesc;
                             break;
                          case southDirection:
                             if((self.south != nil) && (gActor.isPlayerChar))
                               self.southTravelDesc;
                             break;
                          default:
                             break;
                  }
                  // handle tallyNumber counter
                  switch(self.longRoadType){
                          case 'west':
                             //if(gAction==WestAction) self.tallyNumber++;
                             //if(gAction==EastAction) self.tallyNumber--;
                             //if(gAction.originalAction.dirMatch.dir==westDirection) self.tallyNumber++;
                             //if(gAction.originalAction.dirMatch.dir==eastDirection) self.tallyNumber--;
                             if(gAction.dirMatch.dir==westDirection) self.tallyNumber++;
                             //        self.westTravelDesc;// show our west travel description
                             if(gAction.dirMatch.dir==eastDirection) self.tallyNumber--;
                             break;
                          case 'east':
                             if(gAction.dirMatch.dir==eastDirection) self.tallyNumber++;
                             if(gAction.dirMatch.dir==westDirection) self.tallyNumber--;
                             break;
                          case 'north': 
                             if(gAction.dirMatch.dir==northDirection) self.tallyNumber++;
                             if(gAction.dirMatch.dir==southDirection) self.tallyNumber--; 
                             break;
                          case 'south':
                             if(gAction.dirMatch.dir==southDirection) self.tallyNumber++;
                             if(gAction.dirMatch.dir==northDirection) self.tallyNumber--;
                             break;
                          default: 
                             break;                                                
                  }
                  // *** Check FAR EXIT Bounds of tallyNumber
                  // don't exceed far exit tally number (if exits)
                  if(self.tallyNumber > self.farExitTallyNumber) self.tallyNumber = farExitTallyNumber;
                  // *** Check NEAR EXIT Bounds of tallyNumber
                  if(self.tallyNumber < 0) self.tallyNumber = 0;                       
                  //
                  //Note: More directions are:
                  //northDirection,southDirection,eastDirection,westDirection,
                  //northeastDirection,northwestDirection,southeastDirection,southwestDirection,
                  //upDirection,downDirection,inDirection,outDirection
                  //                  
              }
           }
        }
        // "before action... self.id==<<self.id>>\n";// verified - this points to the instance object, not the lexical parent (CLASS object)        
  }    
  roomAfterAction(){ 
          // If we were in this room before
          // and traveled back to self via loop,
          // then call a 'look' action. Otherwise
          // it looks like maybe nothing happened.
          //    NOTE: be careful not to call 'look' 
          //    arbitrarily in "roomBeforeAction()" 
          //    or you could get stuck in a loop. 
          //    But if we make sure the player did
          //    a travel action beforehand then we should
          //    be safe to do a 'look' command.
          if((gActor.locationBefore==self) &&
             (gAction.originalAction != nil)){
             if(gAction.baseActionClass ==TravelViaAction){
               libGlobal.totalTurns--;// don't count this against player turn counter                 
               local tokList = Tokenizer.tokenize('look');
               executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)     
             }
          }
  }
  // note: TravelVia will always fire off before the enteringRoom optional subroutine if you traveled
  dobjFor(TravelVia){
               preCond= inherited;
               verify(){ inherited; }
               action(){ //"travel via...\n"; 
                   // gActor.lastTravelDest <-- should == this room
                   // gActor.locationBefore <-- should be startRoom if you went south from there to here
                   // *** STORE DROPPED ***                
                   inherited; 
               }// end action()               
  }
  // optional convenience method...
  leavingRoom(traveler){ }
  // optional convenience method...  
  enteringRoom(traveler){ }
  doStoreDropped(){
        // hide flagged dropped items not matching current room tally
        foreach(local obj in self.contents){
             if(obj.name != nil){
                if((obj.tallyNumber != nil) && (obj.tallyNumber == self.tallyNumber)
                   && (obj.tallyID == self.id)){
                   obj.moveInto(self.tallyStoreRoom);                   
                }
             }
        }   
  }  
  doRetrieveDropped(){
        if(self.tallyStoreRoom.contents == nil){
           // "...nothing found in this room...\n ";
           return;
        }
        foreach(local obj in self.tallyStoreRoom.contents){             
             if(obj.name != nil){
                if((obj.tallyNumber == self.tallyNumber) && (obj.tallyID == self.id)){
                  obj.moveInto(self);                  
                }                
             }
        }      
  }
;



class basicVrModule : Thing, Readable
  vocabWords = '(standard) (blank) (black) (plastic) (wedge) (shaped) (v.) (r.) (v) (r) (vr) module/cartridge'
  sdesc = "A V.R. module. "
  ldesc = "A V.R. module. It is made of black plastic and is wedge shaped. "
  readDesc = "This V.R. module seems to be blank. "
  vrModName = "standard blank"
  username = "administrator"
  password = "password"   
  // if the vrModule is programmed return 1 (or true) else 0 (or false)
  // isProgrammed = (vrModName=='standard blank') ? 1 : 0     
  defaultActor = nil // set this to the gActor object you wish to become in this VR module
  defaultIntro = "\n<br><br>You slip into the virtual world of <<vrModName>>...\n<br>\n "
  defaultRealWorldActor = nil 
  doSomething {
               // change this to what you want the module to do 
               if(defaultActor != nil){
                     defaultIntro; 
                     defaultRealWorldActor = libGlobal.playerChar; // store for return to normal
                     libGlobal.playerChar = defaultActor; 
                     "\nWelcome <<username>>!\n";//  <<defaultRealWorldActor.name>>!\n";
                     "\nDefault vr role: <<defaultActor.name>>.\n";
                     if(defaultRealWorldActor.is_A_Girl != defaultActor.is_A_Girl){
                      "\no--[Error. Real world gender does not match gender configuration 
                       for this module.]--o\n ";
                     }
                }else{
                     "Error. This module has no default actor. Program aborted.\n ";
                     exit;
               }
  }  
;

class basicVRinterface : Thing, Wearable, RestrictedContainer, BulkLimiter
  bulkCapacity = 1 // allow only one VR module at a time
  //isModuleLoaded = (moduleLoadedName != nil) ? 1 : 0  
  validContents=[]
  doBreakOut(){
       // execute another command but don't count agains player turn counter
       libGlobal.totalTurns--;                  
       local tokList = Tokenizer.tokenize('remove hat');
       executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)
  }
  dobjFor(Wear){
     preCond = [touchObj,objHeld]; 
     verify(){     
        if(self.contents.length < 1){
             "There is no VR module loaded so nothing happens. The hat slips off your head. ";
             // doBreakOut();
             exit;
        }        
        inherited;                    
     }// end verify()
     action() {
        // actually wear the hat
        inherited;        

        // This is ***** KEY ***** to body swap type stuff in TADS!!
        //
        // NOTE: default gameMain.initialPlayerChar = me   
        // but whenever you want to change the POV to another gActor you
        // can do so with: libGlobal.playerChar = <nameOfActorObject>
        // 
        // Other way to do this:
        // "\nEnter password: ";
        // str = inputManager.getInputLine(nil,nil);
        // if(str.toUpper() == contents[1].password.toUpper()){
        //   // "\nCorrect!\n";
        // }else{
        //   "\nIncorrect!\n";
        //   // "Should be <<contents[1].password>>\n";
        //   exit;
        // } 
          
        // ask for username   
        clearScreen();    
        "Enter user name: "; // local str = readMainCommand(0); 1 = for oops command allowed, 0 = normal, 2 & 3 are special case error stuff
        local str = inputManager.getInputLine(nil, nil);  
        if(str.toUpper() == contents[1].username.toUpper()){
           // "\nCorrect...\n";
        }else{
           "\nUser name not recognized! \n";
           "The hat slips off your head. \n";
           // "Should be ***<<contents[1].username>>*** ";
           doBreakOut();
           exit;
        }
        // ask for password. etc....         
        clearScreen();// clears the screen - see tadsio.h
        str = nil;        
        local achr;
        //local tchr;
        local ii = 0;    
        local iCount=0;  
        local sFinal='';        
        do{          
          clearScreen();
          "Password: "; 
          local iy=0;                  
          for(iy=0;iy<iCount;iy++){
            "*";
          }        
          achr =inputManager.getKey(nil,nil);
          iCount++;// Player typed something, so increment key counter           //http://teladesign.com/tads/multimedia//faq/                    
          switch(achr){
              case '\n':
                ii = 1; // done
                // "#";
                break;             
              case '[bksp]':
                // note: "\u08";//"\u0008";\\"<<[bksp]>>";
                iCount=iCount-2;// decrement key counter by this key PLUS one more, so -2 total
                if(iCount <0) iCount = 0;   
                if(sFinal.length>0) sFinal=sFinal.substr(1,sFinal.length-2);                         
                break;
              default:
                  sFinal=sFinal+ achr;
                  break;
          }        
        }while(ii == 0);
        "\n"; 
        if(sFinal.toUpper() == contents[1].password.toUpper()){
            "<<sFinal>> is Correct! \n ";
        }else{
            "<<sFinal>> is the Wrong password! \n ";
            doBreakOut();
            exit;
        }
        // transformation or swap...
        contents[1].doSomething;
        // libGlobal.playerChar = vrMe;  
        //OLD WAY --> switchPlayer(vrMe);// Older TADS command to do this...
        //OLD WAY --> local myP = parserGetMe();// 
     }
  }
;



// snagged from Tads Tour Guide (might not even be used in final game...)
/*
stringLister : object 
  showList(lst) 
  { 
    local lstLen = lst.length; 
    for(local i=1; i<= lstLen; i++) 
    { 
      if(i not in (1, lstLen)) ","; 
      if(i == lstLen && lstLen > 1) " and"; 
      if(i>1) " "; 
      say(lst[i]);       
    } 
  } 
; 
*/

// snagged from Tads Tour Guide (might not even be used in final game...)
class IndexTopic : ConsultTopic 
  suggestionList() 
   { 
     local lst = []; 
     foreach(local cur in location.consultTopics) 
      if(cur.name != nil) 
        lst += cur.name; 
     stringLister.showList(lst); 
   } 
; 



// modified from: http://users.abac.com/MeriBird/TADS/Tutorial/lesson6.html
class StandardFlashlight : LightSource
  isLit = nil   
  isDead = nil
  noun = 'flashlight'
  sdesc = "flashlight"
  ldesc = "The flashlight has a switch; it is currently 
           set to the << self.isLit ? "on" : "off" >> position."
  dobjFor(TurnOn){
     preCond = [touchObj,objHeld]; 
     verify(){     
          if(self.isLit){
             "The flashlight is already on! ";
             exit;
          }  
          if(self.isDead){
             "The flashlight battery is dead. ";
             exit;
          }
     }// end verify()
     action() {
        "You turn on the flashlight, producing a powerful beam of light. ";
        self.isLit = true;
     }
  }// end dobjFor(TurnOn)
  dobjFor(TurnOff){ 
     preCond = [touchObj,objHeld]; 
     verify(){  
          if(!self.isLit){
             "The flashlight is already off! ";
          }
     }// end verify()
     action(){
      "You turn off the flashlight, and it goes dark. ";
       self.isLit = nil;
     }
  }// end dobjFor(TurnOff)
  // call from an agent or something to make the flashlight battery dead
  makeDead(){
      if(self.isIn(gPlayerChar)){ 
         if(isLit){
           "The red plastic flashlight grows dim and flickers off as the battery dies. ";
         }// end if(redPlasticFlashlight.isLit)
      }// end if(redPlasticFlashlight.isIn(gPlayerChar))
      isLit = nil;
      isDead = true;
  }
;



class AbstractObject: Fixture
  isAbstract = true
  no_drop = true // true if no drop item
  no_drop_message = "You can not drop that. "
  is_not_removable = true
  is_not_removable_message = "You can not remove that. "
  dobjFor(Remove){
       action(){ "You can not remove abstract objects or ideas. ";  }
  }
  dobjFor(Doff) asDobjFor(Remove)
  dobjFor(Drop) asDobjFor(Remove)  
;




class NotNudePreCondition : PreCondition
   // returns 0 or 1 always. This is for use in making sure true/nil returns back 0 or 1 always
   tf(iVal){
         if((iVal== nil) || (iVal==0)) return 0;
         if((iVal== 1) || (iVal==true)) return 1;
         return 0;// false or 0 if anything else
   } 
  checkPreCondition(obj, allowImplicit){
        if(tf(gActor.ofKind(CromexxHuman))==1){
             if(tf(gActor.nudeCheck)==0){
                 return nil; // we're done
             }
        }else{
             return nil;// non-cromexx humans can go where they want
        }
        // the actor is nude
        if(tf(gActor == gPlayerChar)==1){ 
            reportFailure('Sorry but if you left here without 
                your clothes on you\'d almost certainly get 
                in trouble by the fashion police. At the very 
                least you should wear a fig leaf, don\'t you think? ');
        }else{
            reportFailure('');
        }
        exit;
  }
;

// ********** bookmark


class BasicallyClothedPreCondition: PreCondition
   // returns 0 or 1 always. This is for use in making sure true/nil returns back 0 or 1 always
   tf(iVal){
         if((iVal== nil) || (iVal==0)) return 0;
         if((iVal== 1) || (iVal==true)) return 1;
         return 0;// false or 0 if anything else
   } 
  checkPreCondition(obj, allowImplicit){        
        if(gActor.ofKind(CromexxHuman)!=true){
           say('asfasfdasdf');
           "not cromexx human...\n";
           return nil;
        }
        local s0 = '';
        local iPanties = gActor.justWearingPantiesCheck;
        local iBottomless = gActor.bottomlessAccessCheck;
        local iTopless = gActor.toplessCheck;
        local iNude = gActor.nudeCheck;
        /* are we a woman? */
        if((tf(gActor.is_A_Girl)==1) && 
           (tf(gActor.is_A_Little_Girl)==0)){            
            if(tf(iPanties)==1) s0 = 'You\'d feel much better if you didn\'t leave
                                  here wearing nothing but your panties. ';
            /* topless & bottomless? */
            if((s0=='') && (tf(iTopless)==1) && (tf(iBottomless)==1)) s0 = 'Beautiful girls
                                  like yourself probably shouldn\'t leave here
                                  without wearing something to cover her breasts
                                  and the space between her legs. ';
            /* just bottomless? */
            if((s0=='') && (tf(iBottomless)==1)) s0 = 'You can\'t go out of here looking
                                  like that. You\'ve got nothing covering you up between
                                  your legs. ';
            /* just topless? */
            if((s0=='') && (tf(iTopless)==1)) s0 = 'You should probably wear something to
                                  cover up your breasts before leaving here. ';
            if(iNude==1) s0 = 'If you leave here like that you\'ll
                                  really be giving the guys a treat. You can\'t go
                                  around all over the place nude. What\'ll the
                                  neighbors think? ';
        }
        /* are we a little girl? */
        if(tf(gActor.is_A_Little_Girl)==1){
           if(tf(iPanties)==1) s0 = 'Come on honey, you ought to know better than
                                 wandering around all over in just your panties. Be a
                                 good little girl and let\'s get dressed better than
                                 that before we leave, okay? ';  
           if(tf(iNude)==1) s0 = 'Naughty, naughty. Best put on some clothes first, okay? ';                  
        }
        /* are we a guy? */
        if((s0=='') && ((tf(gActor.is_A_Girl)==0) || (tf(gActor.is_A_Girl)==0))){
           if(iPanties==1) s0 = 'You don\'t feel like leaving just yet before getting
                                 a bit more dressed. ';
           if(iNude==1) s0 = 'You\'ll have to wear some clothes if you want to leave here. 
                                 I think it\'s pretty obvious how humiliating it would be
                                 if you got caught someplace else without your clothes on. ';
        }
        /* if s0=='' then we passed the check, otherwise report something */
        if(s0 == '') return nil;
        // the actor is nude
        if(gActor == gPlayerChar){ 
            reportFailure(s0);
            exit;
        }else{
            reportFailure('asdfsdfaddddddddd');
            exit;
        }
        
  }
;

/* some custom "preCond" objects
 *
 * put these in the "roomTravelPreCond = []"
 * for a Room type object. 
 * 
 */
isNotNude: NotNudePreCondition;
isBasicallyClothed : BasicallyClothedPreCondition;

// use these room classes for the removal
// of AdvancedCromexxClothing.
class ClothingRemovalRoom: Room;

class OutdoorClothingRemovalRoom: OutdoorRoom;

/*
 * Class AdvancedCromexxClothing
 * Extends: CromexxClothing
 * This class just makes normal CromexxClothing more
 * restrictive in that you can only remove the clothes
 * if you are in a ClothingRemovalRoom or an OutdoorClothingRemovalRoom
 */
class AdvancedCromexxClothing: CromexxClothing
   isRemovalAllowedHere {
            if(self.location == nil) return 0;
            if(self.location.ofKind(CromexxHuman) != true) return 0;
            if(self.location.location == nil) return 0;
            if(self.location.location.ofKind(ClothingRemovalRoom)) return 1;            
            if(self.location.location.ofKind(OutdoorClothingRemovalRoom)) return 1;
            return 0; // default is no clothing removal allowed
   }
   is_not_removable = (self.isRemovalAllowedHere == 1) ? 0 : 1
   // {that/him} should return "those" if plural, or "that" if not plural.	
   // is_not_removable_message = "You should be somewhere more appropriate to remove {that/him}. "   
   is_not_removable_message { 
               local myObj = (self.isPlural) ? 'those' : 'that';
              "You should be somewhere more appropriate to remove <<myObj>>. ";
   }	
;

 

/*  
 * A rewrite of CromexxClothingOld...
 * This changes true/nil checks to 0/1 checks (to avoid potential crash problems on nil queries)
 * the routine "tf(iVal)" is used extensively here to translate old true/nil queries back as 0/1
 * The TADS variables that are supposed to return true or nil we'll leave alone.
 *
 * To Do: We've re-written the "Take" routine completely. 
 *        We need to go back and re-write the "Doff" routine.
 *        Also add in NPC descriptions for the actions vs.
 *        reporting it always as if the player were executing
 *        the command.
 */ 
class CromexxClothing: Thing, Wearable
   name = 'generic clothing item'
   vocabWords = '(generic) (clothing) item'
   ac = 0 // armor class
   bulk = 0
   iWornByPlayerCount = 0      // the worn count - only valid for player
   iRemovedByPlayerCount = 0   // the removed count - only valid if player   
   /* if this has a string value it'll get reported before travel for the player */
   sayBeforeTravel = nil
   sayAfterTravel = nil
   no_drop_after_worn = 0 // if true then this item can not be dropped once worn
   no_drop = 0 // if true then this item is a no drop item (can not DROP, but CAN wear!)
   is_not_removable = 0 // true means you can NOT remove an object that is worn, nil = you can remove it
   is_not_removable_message = "You can not remove that. "
   agent_tick_script = nil // if there is a value a timed agent *may* call this 
   girliness_meter = 0 // value from 0 to 100. Higher number = more effect on player girl happiness meter, etc. Also may affect male NPC's with a higher accumulative number based on sum of all clothing items 
   girliness_meter_regen = 0 // value from 0 to 100. Higher number = the regen per real time Agent tick. Use for special items like lingerie that make a girl happy more just by wearing the one item, etc.
   girl_only = 0 // if true then only girls can wear
   boy_only = 0  // if true then only boys can wear
   infant_only = 0 // if true then only infants can wear
   child_only = 0 // if true then only children can wear
   teen_only = 0 // if true then only teens can wear
   adult_only = 0 // if true then only adults can wear
   clothLevel = 0 // value from 1-23 (or so). the level of the clothing item
   // Optional String value to show when an object is worn (usually 1st person reporting only)
   specialWearDesc = defaultReport(&okayWearMsg)
   // Optional String value to show when an object is worn (third person)
   // this would show only if the NPC was in the same room as the player
   specialWearDescThirdPerson {                   
                   local obj = self.location;
                   local obj2 = self;
                   gMessageParams(obj,obj2);
                   local s0 = '{subj obj}{subj obj}{a/he} wears {subj obj2}{a/he}. ';
                   say(s0);
   } 
   // Optional String value to show when an object is removed (1st person / player use only)
   specialRemoveDesc = defaultReport(&okayDoffMsg)
   // Optional String value to show when an object is removed (3rd person version)
   // this would show only if the NPC was in the same room as the player
   specialRemoveDescThirdPerson {                   
                   local obj = self.location;
                   local obj2 = self;
                   gMessageParams(obj,obj2);
                   local s0 = '{subj obj}{subj obj}{a/he} removes {subj obj2}{a/he}. ';
                   say(s0);
   }  
   // returns 0 or 1 always. This is for use in making sure true/nil returns back 0 or 1 always
   tf(iVal){
         if((iVal== nil) || (iVal==0)) return 0;
         if((iVal== 1) || (iVal==true)) return 1;
         return 0;// false or 0 if anything else
   } 
   beforeTravel(traveler, connector) {      
     if((self.isWornBy(traveler)) &&
          (traveler == gPlayerChar)) self.sayBeforeTravel;     
   }
   afterTravel(traveler, connector) {      
     if((self.isWornBy(traveler)) &&
          (traveler == gPlayerChar)) self.sayAfterTravel;
   }
   // get the clothing list of a gActor...
   getClothingList(oActor){
              if(oActor == nil) return [];
              if(oActor.contents == nil) return [];
              if(oActor.contents.length==0) return [];
              local vList = new List();                            
              foreach(local obj in oActor.contents){
                    if(obj.ofKind(CromexxClothing) && (obj.clothLevel != nil)){
                         if(obj.clothLevel != 0) vList += obj;
                    }
              }
              return vList;
   } 
   /* Is the oActor wearing clothing at this level already?
    * Note: you must past a List object to this routine.
    * commonly you would first build the list 
    * from "getClothingList(oActor)" above.
    * This routine will pass back an object of CromexxClothing
    * if it is already worn at the iLevelToCheck value. 
    */
   getClothingItemWornAtThisLevel(lst,iLevelToCheck,oActor){
           if(lst == nil) return nil;
           if(lst.length == 0) return nil; 
           local oRetObj = nil;          
           foreach(local obj in lst){                 
                if((obj.clothLevel == iLevelToCheck) && 
                   (obj.isWornBy(oActor))) oRetObj = obj;
           }
           return oRetObj;
   }
   /* This returns a new list of objects in clothing slots 1-23.
    * If an item of clothing is not found in a slot you will
    * get a nil value for that slot. We add nils to the List
    * to keep it properly at 1-23 items.
    */
   getClothingWornSlotList(oActor,lst){
        local vList = new List();// objects or junk object
        local oTemp = nil;
        for(local x = 0;x < 24; x++){
               if(x>0){
                  oTemp = getClothingItemWornAtThisLevel(lst,x,oActor);
                  if(oTemp != nil){
                       vList +=oTemp;// junk object to fill array 1-23
                  }else{
                       vList +=nil; // oKay;
                  }
               }
        }
        return vList;
   }
   /* **************
   getClothingWornList(owhat){
              if(owhat == nil) return nil;
              local vList = new List();
              if(owhat.location == nil) return nil;
              if(owhat.location.contents == nil) return nil;
              foreach(local obj in owhat.location.contents){
                    if((obj.ofKind(CromexxClothing)) &&
                       (obj.isWorn == true))
                       vList += obj;
              }
              return vList;
   }
   getClothingHeldList(owhat){
           if(owhat == nil) return nil;
           local vList = new List();
              if(owhat.location == nil) return nil;
              if(owhat.location.contents == nil) return nil;
              foreach(local obj in owhat.location.contents){
                    if((obj.ofKind(CromexxClothing)) &&
                       (obj.isWorn != true))
                       vList += obj;
              }
              return vList;   
  }
  ************** */
   getIsWrongSex(oActor){
                /* nil checks */
                if(oActor == nil) return 0;
                /* check only if variables have been set */
                local notForBoys = ((tf(self.girl_only)==1) && (tf(oActor.is_A_Girl) == 0)) ? 1 : 0;
                local notForGirls = ((tf(self.boy_only)==1) && (tf(oActor.is_A_Girl) == 1)) ? 1 : 0;
                if((notForBoys + notForGirls) > 0) return 1;
                return 0;
   }
   dobjFor(Wear){ 
             preCond = [objHeld]
             verify(){
                /* make sure the actor isn't already wearing the item */
                if(self.isWornBy(gActor)){ 
                      if(gActor == gPlayerChar){
                         illogicalAlready(&alreadyWearingMsg);
                      }else{
                         local o1 = self;
                         local o2 = gActor; 
                         gMessageParams(o1,o2);
                         local s0 = '\^{subj o2}{a/he} tr{ies} to 
                                   wear {subj o1}{a/he} but {subj o2}{it\'s/he\'s} already wearing 
                                   {subj o1}{it/he}. ';
                         illogicalAlready(s0);
                      }
                }
                if(tf(self.getIsWrongSex(gActor))==1) logicalRank(50,'wrong sex');// for wrong sex disambig check                                
             }
             check(){
                /* verify above ranks the action lower than normal
                 * but if this was our only option we need
                 * to now fail the action if we're the wrong sex.
                 */
                if(self.getIsWrongSex(gActor)==1){
                       if(tf(gActor.is_A_Girl)==1){                       
                           "That\'s not for girls. ";               
                       }else{
                           "That\'s not for boys. ";
                       }
                       exit;
                }
                /*
                 * check for all sorts of other stuff 
                 * (wrong age, no drop, weight, etc. here...)    
                 */
                local iAge = 21;
                if(gActor.pcAge!=nil) iAge = gActor.pcAge;
                local pcBaby = (iAge < 3) ? 1 : 0;
                local pcChild = (iAge > 2 && iAge < 13) ? 1 : 0;
                local pcTeen = (iAge > 12 && iAge < 20) ? 1 : 0;
                local pcAdult = (iAge > 19) ? 1 : 0;
                local iChildOnly = tf(self.child_only);
                local iInfantOnly = tf(self.infant_only);
                local iTeenOnly = tf(self.teen_only);
                local iAdultOnly = tf(self.adult_only);
                local s0 = '';
                local oTagg = self;
                gMessageParams(oTagg);// set for use in string tags               
                local s1 = '{subj oTagg}{the/he}';// ex: "the green shirt" ... use \^ before it for capitalizing the first letter
                // local s2 = '{subj oTagg}{a/he}';// ex: "a green shirt"
                local s3 = '{subj oTagg}{that/her}';// returns "that" or "those" (if isPlural==true)
                local s4 = '{subj oTagg}{is}';// returns "is" or "are" (if isPlural==true)
                local s5 = '{subj oTagg}{it\'s/he\'s}';// if not plural returns "it's" (if no he/she set) otherwise if plural returns "they're" i.e. "they're not for wearing now."                
                if(iChildOnly){
                      if(pcBaby==1) s0 = '\^' + s1 + ' is for older kids, not for little babies like you. ';
                      if(pcTeen==1) s0 = 'You can\'t. You\'d look ridiculous wearing ' + s3 + '. ' + 
                                          s1 + ' is for little kids not teenagers like yourself. ';
                      if(pcAdult==1) s0 = 'You can\'t. You\'d look silly wearing ' + s3 + ' because ' + s5 + ' for children. ';
                }
                if(iInfantOnly){
                      if(pcChild==1) s0 = '\^' + s1 + ' ' + s4 + ' for infants not kids like you. ';
                      if(pcTeen==1) s0 = '\^' + s1 + ' ' + s4 + ' for babies not teenagers. ';
                      if(pcAdult==1) s0 = '\^' + s1 + ' ' + s4 + ' for babies, not adults. ';
                }
                if(iTeenOnly){
                      if(pcBaby==1) s0 = 'You\'re just a little baby. How can you wear clothes for teenagers? ';
                      if(pcChild==1) s0 = '\^' + s1 + ' ' + s4 + ' for teenagers and you\'re just a little child. ';
                      if(pcAdult==1) s0 = '\^' + s3 + ' ' + s4 + ' not going to fit you. \^' + s5 + ' for teenagers. ';
                }
                if(iAdultOnly){
                      if(pcBaby==1) s0 = 'Poor little babies like you could never fit into ' + s3 + '. \^' + s5 + ' for grown-ups. ';
                      if(pcChild==1) s0 = 'You can\'t. ' + s3 + ' ' + s4 + ' only going to fit grown-ups. ';
                      if(pcTeen==1) s0 = 'You can\'t. ' + s3 + ' ' + s4 + ' only going to fit an adult. You\'re just a teen. ';
                }
                if(pcBaby==1){
                      s0 = s0 + 'You\'re too little to even dress yourself. You\'ll just have to wait for a grown-up to change you. ';
                }
                if(self.clothLevel == nil) s0 = 'Error - this clothing item has a clothLevel of nil. ';
                if(self.clothLevel == 0) s0 = 'Error - this clothing item has a clothLevel of 0. ';     
                if(s0 != ''){
                    if(gActor == gPlayerChar) say(s0);
                    exit;
                }       
                /* The "objHeld" preCond above should force the Player 
                 * to carry the object first, so we do not need to manually
                 * check if (gActor.contents != nil) or (self.isIn(gActor))
                 * or even (self.isHeldBy(gActor)). The old CromexxClothing
                 * class checked for it anyway but this is redundant so we're
                 * skipping it. 
                 */
                // build a list of worn items on the player...
                local myList = new List();
                myList = getClothingList(gActor);                
                local oTemp = getClothingItemWornAtThisLevel(myList,self.clothLevel,gActor);
                if(oTemp != nil){
                    if(gActor == gPlayerChar){
                         gMessageParams(oTemp);
                         s1 = '{subj oTemp}{the/he}';
                         s0 = 'You have to remove ' + s1 + ' first. ';
                         say(s0);
                    }
                    exit;
                }
                // -- check for blocking item(s)
                // build an object list of clothing items in slots 1-23 in proper slot order
                local mySlotList = getClothingWornSlotList(gActor,myList);
                oTemp = nil;                
                switch(self.clothLevel){
                   case 1: 
                   /* shoes */
                       break;                   
                   case 2: 
                   /* socks */
                       if(mySlotList[23]!=nil) oTemp = mySlotList[23];/* stockings */
                       if(mySlotList[1]!=nil) oTemp = mySlotList[1];/* shoes */   
                       break;                   
                   case 3:
                   /* underpants/panties */                       
                       if(mySlotList[23]!=nil) oTemp = mySlotList[23];/* stockings */
                       if(mySlotList[4]!=nil) oTemp = mySlotList[4];/* swimsuit */                       
                       if(mySlotList[9]!=nil) oTemp = mySlotList[9];/* shorts */    
                       break; 
                   case 4:
                   /* swimsuit (1pc) */
                       if(mySlotList[9]!=nil) oTemp = mySlotList[9];/* pants/shorts */    
                       if(mySlotList[10]!=nil) oTemp = mySlotList[10];/* slip */
                       if(mySlotList[11]!=nil) oTemp = mySlotList[11];/* skirt */
                       if(mySlotList[12]!=nil) oTemp = mySlotList[12];/* dress */
                       if(mySlotList[8]!=nil) oTemp = mySlotList[8];/* coat */                       
                   break;
                   case 5:
                   /* bra/bikinni top */
                       if(mySlotList[4]!=nil) oTemp = mySlotList[4];/* swimsuit */
                       if(mySlotList[6]!=nil) oTemp = mySlotList[6];/* t-shirt */    
                       if(mySlotList[7]!=nil) oTemp = mySlotList[7];/* shirt/blouse */                       
                       if(mySlotList[12]!=nil) oTemp = mySlotList[12];/* dress */
                       if(mySlotList[8]!=nil) oTemp = mySlotList[8];/* coat */
                   break;
                   case 6:
                   /* t-shirt */
                       if(mySlotList[7]!=nil) oTemp = mySlotList[7];/* shirt/blouse */                       
                       if(mySlotList[12]!=nil) oTemp = mySlotList[12];/* dress */
                       if(mySlotList[8]!=nil) oTemp = mySlotList[8];/* coat */    
                       break;
                   case 7:
                   /* shirt/blouse */                       
                       if(mySlotList[12]!=nil) oTemp = mySlotList[12];/* dress */
                       if(mySlotList[8]!=nil) oTemp = mySlotList[8];/* coat */
                       break;
                   case 8: 
                   /* fur coat */ 
                   break;
                   case 9:
                   /* pants/shorts */
                       if(mySlotList[10]!=nil) oTemp = mySlotList[10];/* slip */                       
                       if(mySlotList[11]!=nil) oTemp = mySlotList[11];/* skirt */
                       if(mySlotList[12]!=nil) oTemp = mySlotList[12];/* dress */  
                       break;  
                   case 10:
                   /* slip */
                       if(mySlotList[9]!=nil) oTemp = mySlotList[9];/* pants/shorts */  
                       break;
                   case 11:
                   /* skirt */
                       if(mySlotList[9]!=nil) oTemp = mySlotList[9];/* pants/shorts */
                       if(mySlotList[12]!=nil) oTemp = mySlotList[12];/* slip */                       
                       break;
                   case 12:
                   /* dress */
                       if(mySlotList[9]!=nil) oTemp = mySlotList[9];/* pants/shorts */
                       if(mySlotList[11]!=nil) oTemp = mySlotList[11];/* skirt */                       
                       break;
                   case 13: 
                   /* hairbow/hairpin */
                       if(mySlotList[14]!=nil) oTemp = mySlotList[14];/* hat/bonnett */
                       break;
                   case 22:
                   /* body stocking */
                       if(mySlotList[23]!=nil) oTemp = mySlotList[23];/* stockings */
                       for(local x=0;x<22;x++){
                            if(x != 22)
                               if(mySlotList[x]!=nil) oTemp = mySlotList[x];
                       }                       
                       break;
                   case 23: 
                   /* stockings */
                       if(mySlotList[2]!=nil) oTemp = mySlotList[2];/* socks */   
                       if(mySlotList[1]!=nil) oTemp = mySlotList[1];/* shoes */   
                       if(mySlotList[23]!=nil) oTemp = mySlotList[23];/* stockings */  
                       break; 
                   default:
                   /* default */
                       break;                 
                }
                if(oTemp != nil){                   
                   if(gActor == gPlayerChar){
                         gMessageParams(oTemp);
                         s1 = '{subj oTemp}{the/he}';
                         s0 = 'You have to remove ' + s1 + ' first. ';                         
                         say(s0);
                   }
                   exit;
                }    
             }// end check()...
             // Wear-action...
             action(){
                /* make the item worn and describe what happened */
                makeWornBy(gActor);   
                if(gActor==gPlayerChar){
                   self.iWornByPlayerCount++;// increment the player worn count
                   self.specialWearDesc;                
                }else{
                   if(gActor.location == gPlayerChar.location) self.specialWearDescThirdPerson;
                }                
             }         
   }// end dobjFor(Wear)...
   // **** DOFF (REMOVE) CLOTHING ROUTINE ****
   dobjFor(Doff){ 
        preCond = [roomToHoldObj]
        verify()
        {
            // slightly less likely for no drop items           
            if(tf(self.is_not_removable)==1) logicalRank(40,'less likely to try removing a no drop item');
            if(tf(self.is_not_removable)==0) logicalRank(80,'more likely to try removing a no drop item');
            /* make sure the actor is actually wearing the item */
            if (!isWornBy(gActor)){
                if(gActor == gPlayerChar){
                    illogicalAlready(&notWearingMsg);     
                }else{
                    local o1 = self;
                    local o2 = gActor; 
                    gMessageParams(o1,o2);
                    local s0 = '\^{subj o2}{a/he} tr{ies} to 
                                remove {subj o1}{the/he} but {subj o2}{it\'s/he\'s} already not 
                                wearing {subj o1}{that/her}. ';
                    illogicalAlready(s0);
                }       
            }
        }
        check(){           
            // we put this check down here because
            // it gives the logicalRank stuff above
            // a chance to determine which item is more
            // logical before outright failing
            if((self.is_not_removable == true) || (self.is_not_removable== 1)){             
               self.is_not_removable_message;
               exit;
            }         
            if (gActor.contents.length > 0){
                   local clothingWorn_List = [];
                   local x = 0;
                   do{
                      x++;
                      if(gActor.contents[x].isWornBy(gActor)){ 
                         // ....we are only concerned with tracking "clothLevel" enabled clothing
                         if(gActor.contents[x].clothLevel != nil)
                           clothingWorn_List += gActor.contents[x];
                      }
                   }while(x < gActor.contents.length);  // "clothingWorn_List item 1 = <<clothingWorn_List[1].name>> ";  
                   // Now is the clothingWorn_List valid?...
                   if(clothingWorn_List != nil){
                     if(clothingWorn_List.length > 0){                           
                        x = 0;
                        local y = 0;
                        // ....loop through the list, checking all things
                        // ....and if something would be out of order, break,
                        // ....and mention it. i.e. fuzzy logic, we only
                        // ....care when the first illogical thing comes up
                        // ....and then break out of the routine. We're not
                        // ....going to list all the items that need to be
                        // ....removed first. We'll mention ONE and then 
                        // ....let the player figure it out or try again after
                        // ....removing that item.
                        do{ 
                           x++;
                             // check for want to *remove* SOCKS and...
                             if(clothLevel == 2){
                                 // ...anything == 1 (shoes are on)                           
                                 if(clothingWorn_List[x].clothLevel == 1){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to *remove* UNDERPANTS/PANTIES and...
                             if(clothLevel == 3){
                                 // ...anything == 4 (1 pc. swimsuit is on)                           
                                 if(clothingWorn_List[x].clothLevel == 4){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 9 (pants/shorts are on)
                                 if(clothingWorn_List[x].clothLevel == 9){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 23 (stockings are on)
                                 if(clothingWorn_List[x].clothLevel == 23){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to *remove* 1 PC. SWIMSUIT and...
                             if(clothLevel == 4){
                                 // ...anything == 9 (pants/shorts are on)                           
                                 if(clothingWorn_List[x].clothLevel == 9){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to *remove* BRA/BIKINI TOP and...
                             if(clothLevel == 5){
                                 // ...anything == 4 (1 pc. swimsuit is on)                           
                                 if(clothingWorn_List[x].clothLevel == 4){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 6 (t-shirt is on)                           
                                 if(clothingWorn_List[x].clothLevel == 6){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 7 (shirt/blouse is on)                           
                                 if(clothingWorn_List[x].clothLevel == 7){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 8 (coat is on)                           
                                 if(clothingWorn_List[x].clothLevel == 8){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 12 (dress is on)                           
                                 if(clothingWorn_List[x].clothLevel == 12){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 22 (body stocking is on)                           
                                 //if(clothingWorn_List[x].clothLevel == 22){
                                 //      y = x;
                                 //      break;        
                                 //}
                             }
                             // check for want to *remove* T-SHIRT and...
                             if(clothLevel == 6){
                                 // ...anything == 7 (shirt/blouse is on)                           
                                 if(clothingWorn_List[x].clothLevel == 7){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 8 (coat is on)                           
                                 if(clothingWorn_List[x].clothLevel == 8){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to *remove* SHIRT/BLOUSE and...
                             if(clothLevel == 7){
                                 // ...anything == 8 (coat is on)                           
                                 if(clothingWorn_List[x].clothLevel == 8){
                                       y = x;
                                       break;        
                                 }
                             }   
                             // check for want to *remove* HAIRBOW/HAIRPIN and...
                             if(clothLevel == 13){ 
                                 // ...anything == 14 (hat/bonnett is on)                           
                                 if(clothingWorn_List[x].clothLevel == 14){
                                       y = x;
                                       break;        
                                 }
                             }   
                             // check for want to *remove* BODY STOCKING and...
                             if(clothLevel == 22){ 
                                 // ...anything <> 22 anything else on at all..
                                 if(clothingWorn_List[x].clothLevel != 22){
                                       y = x;
                                       break;        
                                 }
                             } 
                             // check for want to *remove* STOCKINGS and...
                             if(clothLevel == 23){
                                 // ...anything == 1 (shoes are on)
                                 if(clothingWorn_List[x].clothLevel == 1){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 4 (1 pc. swimsuit is on)
                                 if(clothingWorn_List[x].clothLevel == 4){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 9 (shorts/pants are on)
                                 if(clothingWorn_List[x].clothLevel == 9){
                                       y = x;
                                       break;        
                                 }
                             }
                        }while(x < clothingWorn_List.length);
                        // end do-while-loop
                        if(y > 0){
                             if(gActor==gPlayerChar) "You need to remove your <<clothingWorn_List[x].name>> first. ";
                             exit;
                        }
                        // NOTE: if they made it this far it seems okay to remove the item!
                        // ...so when we exit the check() routine all we have to do now
                        // ...is just our action() routine and we're done.
                     }// end if(clothingWorn_List.length > 0)
                   }// end if(clothignWorn_List 1= nil)                   
                }// end if(gActor.contents.length > 0)

              // back in the check() routine area...  

         // *********
        }// end check() routine
        action(){
            /* un-wear the item and describe what happened */
            makeWornBy(nil);
            if(gActor==gPlayerChar){
               self.iRemovedByPlayerCount++;// increment the player removed count
               self.specialRemoveDesc;
            }else{
               if(gActor.location == gPlayerChar.location) self.specialRemoveDescThirdPerson;
            }  
        }        
   } 
   //dobjFor(Remove) asDobjFor(Doff)
   //dobjFor(ShowTo) { inherited; }
;

// see: objects.t class Wearable
class CromexxClothingOld : Thing, Wearable
   // disambigName = isIn(libGlobal.playerChar) ? ('your ' + self.name) : self.name
   bulk = 0
   no_drop_after_worn = nil // if true then this item can not be dropped once worn
   no_drop = nil // if true then this item is a no drop item (can not DROP, but CAN wear!)
   is_not_removable = nil // true means you can NOT remove an object that is worn, nil = you can remove it
   is_not_removable_message = "You can not remove that. "
   agent_tick_script = nil // if there is a value a timed agent *may* call this 
   girliness_meter = nil // value from 0 to 100. Higher number = more effect on player girl happiness meter, etc. Also may affect male NPC's with a higher accumulative number based on sum of all clothing items 
   girliness_meter_regen = nil // value from 0 to 100. Higher number = the regen per real time Agent tick. Use for special items like lingerie that make a girl happy more just by wearing the one item, etc.
   girl_only = nil // if true then only girls can wear
   boy_only = nil  // if true then only boys can wear
   infant_only = nil // if true then only infants can wear
   child_only = nil // if true then only children can wear
   teen_only = nil // if true then only teens can wear
   adult_only = nil // if true then only adults can wear
   clothLevel = nil // value from 1-23 (or so). the level of the clothing item
   specialWearDesc = nil // Optional String value to show when an object is worn   
   specialRemoveDesc = nil // Optional String value to show when an object is removed   
   // DATA BLACK FLATS,1
   // DATA BOOTS,1
   // DATA SOCKS,2
   // DATA STOCKINGS,23
   // DATA KNEE HIGH STOCKINGS,2
   // DATA UNDERPANTS,3
   // DATA PANTIES,3
   // DATA SWIMSUIT,4
   // REM Swimsuit (above) is a 1 pc swimsuit
   // DATA BRA,5
   // DATA BIKINNI TOP,5
   // DATA T-SHIRT,6
   // DATA SILK T-SHIRT,6
   // DATA GREEN SHIRT,7
   // DATA BLOUSE,7
   // DATA COAT,8
   // DATA FUR COAT,8
   // DATA PANTS,9
   // DATA SHORTS,9
   // DATA SLIP,10
   // DATA OTHER SLIP,10
   // DATA BLACK SKIRT,11
   // DATA RED SKIRT,11
   // DATA BLACK DRESS,12
   // DATA RED DRESS,12
   // DATA HAIRBOW,13
   // DATA HAIRPIN,13
   // DATA TOP HAT,14
   // DATA BONNETT,14
   // DATA BLACK GLOVES,15
   // DATA WHITE GLOVES,15
   // DATA GOLD BRACELET,16
   // DATA SILVER BRACELET,16
   // DATA GOLD WATCH,17
   // DATA DIGITAL WATCH,17
   // DATA PEARL NECKLASS,18
   // DATA RECKLESS NECKLASS,18
   // DATA SKARF,19
   // DATA FUR SKARF,19
   // DATA DIAMOND RING,20
   // DATA GOLD RING,20
   // DATA GOLD EARRINGS,21
   // DATA SILVER EARRINGS,21
   // DATA BODY STOCKING,22
   // DATA SILK STOCKINGS,23
   // DATA WHITE STOCKINGS,23
   // DATA BLACK STOCKINGS,23
   //  
   // Inherited & modified junk...
   //isWorn(){ inherited; } // is it being worn?
   //makeWornBy(actor){ inherited; }
   //isHeldBy(actor){ inherited; }
   //whatIfHeldBy(func, newLoc){ inherited; } // ** may want to override
   //tryHolding(){ "You try holding something...\n"; inherited; }
   //wornBy = nil  // the object wearing this object, if any (wearer should always be a container)
   //isWornBy(actor){ inherited; }
   //getEncumberingBulk(actor){ inherited; }
   //getEncumberingWeight(actor){ inherited; }
   //
   // * internal command: getIsWrongSex 
   //     .. Used to verify if gActor is the wrong sex to wear/use this clothing item
   getIsWrongSex{
                // check only if variables have been set
                local notForBoys = ((girl_only == true) && (gActor.is_A_Girl != true)) ? true : nil; // gActor
                local notForGirls = ((boy_only == true) && (gActor.is_A_Girl == true)) ? true : nil; // gActor
                if(notForBoys || notForGirls)
                    return true;
                return nil;
   }
   dobjFor(Wear){ 
             preCond = [objHeld]
             verify(){
                /* make sure the actor isn't already wearing the item */
                if (isWornBy(gActor))
                    illogicalAlready(&alreadyWearingMsg);
                // set logic state lower if wrong sex
                if ((gActor.is_A_Girl != 1) && (self.girl_only))
                    logicalRank(50,'girls only');
                if ((gActor.is_A_Girl == 1) && (self.boy_only))
                    logicalRank(50,'boys only');
             }// end of verify()
             check(){ 
                // Wrong sex?
                if(getIsWrongSex){
                       if(gActor.is_A_Girl){                       
                         "That\'s not for girls. ";               
                       }else{
                         "That\'s not for boys. ";
                       }
                       exit;
                }                
                //
                // check for all sorts of other stuff (wrong age, no drop, weight, etc. here...)    
                //
                // ...... *** PUT MORE STUFF HERE ***
                if ((gActor.pcAge > 12 || gActor.pcAge < 3) && (self.child_only)){
                    "That's for children only. ";
                    exit;
                }
                if ((gActor.pcAge > 3) && (self.infant_only)){
                    "That's for little babies. ";
                    exit;
                } 
                if ((gActor.pcAge <12 || gActor.pcAge > 19) && (self.teen_only)){
                    "That's for teenagers. ";
                    exit;
                }
                if ((gActor.pcAge < 20) && (self.adult_only)){
                    "That's for adults only. ";
                    exit;
                }
                // 
                // check for clothlevel
                if(clothLevel != nil){
                   //"... cloth level not = nil...";
                    // see if you are wearing something like it already
                    if(gActor.contents != nil){                   
                        local x = 0;
                        local y = 0;
                        do{
                          x++;
                          if(gActor.contents[x].isWorn()){                            
                             if(gActor.contents[x].clothLevel != nil){
                               if(gActor.contents[x].clothLevel == clothLevel){
                                 if(gActor.contents[x].isWornBy(gActor)){
                                    y = x;
                                 }
                               }
                             }
                          }
                        }while(x < gActor.contents.length);
                        if(y > 0){
                           "You have to remove the <<gActor.contents[y].name>> first. ";
                           exit;
                        }     
                    }// end if gActor.contents != nil
                }// end if clothLevel != nil
                //
                // Now get really picky and see if 
                // they're trying to wear in the wrong order (i.e. socks over shoes)
                //
                // ..grab worn clothing list
                if(gActor.contents.length > 0){
                   local clothingWorn_List = [];
                   local x = 0;
                   do{
                      x++;
                      if(gActor.contents[x].isWornBy(gActor)){ 
                         // ....we are only concerned with tracking "clothLevel" enabled clothing
                         if(gActor.contents[x].clothLevel != nil)
                           clothingWorn_List += gActor.contents[x];
                      }
                   }while(x < gActor.contents.length);  // "clothingWorn_List item 1 = <<clothingWorn_List[1].name>> ";  
                   // Now is the clothingWorn_List valid?...
                   if(clothingWorn_List != nil){
                     if(clothingWorn_List.length > 0){                           
                        x = 0;
                        local y = 0;
                        // ....loop through the list, checking all things
                        // ....and if something would be out of order, break,
                        // ....and mention it. i.e. fuzzy logic, we only
                        // ....care when the first illogical thing comes up
                        // ....and then break out of the routine. We're not
                        // ....going to list all the items that need to be
                        // ....removed first. We'll mention ONE and then 
                        // ....let the player figure it out or try again after
                        // ....removing that item.
                        do{ 
                           x++;
                             // check for want to wear SOCKS and...
                             if(clothLevel == 2){
                                 // ...anything == 23 (stockings are on)                           
                                 if(clothingWorn_List[x].clothLevel == 23){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 1  (shoes are on)                           
                                 if(clothingWorn_List[x].clothLevel == 1){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to wear UNDERPANTS/PANTIES and...
                             if(clothLevel == 3){
                                 // ...anything == 4 (1 pc. swimsuit is on)                           
                                 if(clothingWorn_List[x].clothLevel == 4){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 9  (shorts are on)                           
                                 if(clothingWorn_List[x].clothLevel == 9){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 23  (stockings are on)                           
                                 if(clothingWorn_List[x].clothLevel == 23){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to wear 1 PC. SWIMSUIT and...
                             if(clothLevel == 4){
                                 // ...anything == 8 (coat is on)                           
                                 if(clothingWorn_List[x].clothLevel == 8){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 9 (pants/shorts is/are on)                           
                                 if(clothingWorn_List[x].clothLevel == 9){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 10  (slip is on)                           
                                 if(clothingWorn_List[x].clothLevel == 10){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 11  (skirt is on)                           
                                 if(clothingWorn_List[x].clothLevel == 11){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 12  (dress is on)                           
                                 if(clothingWorn_List[x].clothLevel == 12){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to wear BRA/BIKINI TOP and...
                             if(clothLevel == 5){
                                 // ...anything == 4 (1 pc. swimsuit is on)                           
                                 if(clothingWorn_List[x].clothLevel == 4){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 6  (t-shirt is on)
                                 if(clothingWorn_List[x].clothLevel == 6){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 7  (shirt/blouse is on)                           
                                 if(clothingWorn_List[x].clothLevel == 7){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 8  (coat is on)                           
                                 if(clothingWorn_List[x].clothLevel == 8){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 12  (dress is on)                           
                                 if(clothingWorn_List[x].clothLevel == 12){
                                       y = x;
                                       break;        
                                 }
                             }   
                             // check for want to wear T-SHIRT and...
                             if(clothLevel == 6){
                                 // ...anything == 7 (shirt/blouse is on)                           
                                 if(clothingWorn_List[x].clothLevel == 7){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 8  (coat is on)
                                 if(clothingWorn_List[x].clothLevel == 8){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 12  (dress is on)                           
                                 if(clothingWorn_List[x].clothLevel == 12){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to wear SHIRT/BLOUSE
                             if(clothLevel == 7){
                                 // ...anything == 8 (coat is on)                           
                                 if(clothingWorn_List[x].clothLevel == 7){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 12  (dress is on)
                                 if(clothingWorn_List[x].clothLevel == 8){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to wear PANTS/SHORTS
                             if(clothLevel == 9){
                                 // ...anything == 10  (slip is on)                           
                                 if(clothingWorn_List[x].clothLevel == 10){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 11  (skirt is on)                           
                                 if(clothingWorn_List[x].clothLevel == 11){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 12  (dress is on)                           
                                 if(clothingWorn_List[x].clothLevel == 12){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to wear SLIP
                             if(clothLevel == 10){
                                 // ...anything == 9  (pants/short is/are on)                           
                                 if(clothingWorn_List[x].clothLevel == 9){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to wear SKIRT
                             if(clothLevel == 11){
                                 // ...anything == 12  (dress is on)                           
                                 if(clothingWorn_List[x].clothLevel == 12){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 9 (pants/shorts is/are on)                           
                                 if(clothingWorn_List[x].clothLevel == 9){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to wear DRESS 
                             if(clothLevel == 12){
                                 // ...anything == 9 (pants/shorts is/are on)                           
                                 if(clothingWorn_List[x].clothLevel == 9){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 11  (skirt is on)                           
                                 if(clothingWorn_List[x].clothLevel == 11){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to wear HAIRBOW/HAIRPIN
                             if(clothLevel == 13){
                                 // ...anything == 14 (hat/bonett is/are on)                           
                                 if(clothingWorn_List[x].clothLevel == 14){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to wear BODYSTOCKING
                             if(clothLevel == 22){
                                 // ...anything > 0 (i.e. you need to be nude first)
                                 if(clothingWorn_List[x].clothLevel > 0){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to wear STOCKINGS
                             if(clothLevel == 23){
                                 // ...anything == 1  (shoes are on)                           
                                 if(clothingWorn_List[x].clothLevel == 1){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 2  (socks are on)                           
                                 if(clothingWorn_List[x].clothLevel == 2){
                                       y = x;
                                       break;        
                                 }
                             }
                        }while(x < clothingWorn_List.length);
                        // end do-while-loop
                        if(y > 0){
                             "You need to remove the <<clothingWorn_List[x].name>> first. ";
                             exit;
                        }
                        // NOTE: if they made it this far it seems okay to wear the item!
                        // ...so when we exit the check() routine all we have to do now
                        // ...is just our action() routine and we're done.
                     }// end if(clothingWorn_List.length > 0)
                   }// end if(clothignWorn_List 1= nil)                   
                }// end if(gActor.contents.length > 0)

              // back in the check() routine area...   

             }// end of check()
             action(){
                /* make the item worn and describe what happened */
                makeWornBy(gActor);
                if(specialWearDesc != nil){
                   self.specialWearDesc;
                }else{
                   defaultReport(&okayWearMsg); 
                } 
                //"You wear the <<self.name>>.";                
             }             
    } // override verify(), action(), etc.   
   // **** DOFF (REMOVE) CLOTHING ROUTINE ****
   dobjFor(Doff){ 
        preCond = [roomToHoldObj]
        verify()
        {
            // slightly less likely for no drop items           
            if(self.is_not_removable) logicalRank(40,'less likely to try removing a no drop item');
            if(self.is_not_removable != true) logicalRank(80,'more likely to try removing a no drop item');
            /* make sure the actor is actually wearing the item */
            if (!isWornBy(gActor))
                illogicalAlready(&notWearingMsg);            
        }
        check(){           
            // we put this check down here because
            // it gives the logicalRank stuff above
            // a chance to determine which item is more
            // logical before outright failing
            if((self.is_not_removable == true) || (self.is_not_removable== 1)){             
               self.is_not_removable_message;
               exit;
            }         
            if (gActor.contents.length > 0){
                   local clothingWorn_List = [];
                   local x = 0;
                   do{
                      x++;
                      if(gActor.contents[x].isWornBy(gActor)){ 
                         // ....we are only concerned with tracking "clothLevel" enabled clothing
                         if(gActor.contents[x].clothLevel != nil)
                           clothingWorn_List += gActor.contents[x];
                      }
                   }while(x < gActor.contents.length);  // "clothingWorn_List item 1 = <<clothingWorn_List[1].name>> ";  
                   // Now is the clothingWorn_List valid?...
                   if(clothingWorn_List != nil){
                     if(clothingWorn_List.length > 0){                           
                        x = 0;
                        local y = 0;
                        // ....loop through the list, checking all things
                        // ....and if something would be out of order, break,
                        // ....and mention it. i.e. fuzzy logic, we only
                        // ....care when the first illogical thing comes up
                        // ....and then break out of the routine. We're not
                        // ....going to list all the items that need to be
                        // ....removed first. We'll mention ONE and then 
                        // ....let the player figure it out or try again after
                        // ....removing that item.
                        do{ 
                           x++;
                             // check for want to *remove* SOCKS and...
                             if(clothLevel == 2){
                                 // ...anything == 1 (shoes are on)                           
                                 if(clothingWorn_List[x].clothLevel == 1){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to *remove* UNDERPANTS/PANTIES and...
                             if(clothLevel == 3){
                                 // ...anything == 4 (1 pc. swimsuit is on)                           
                                 if(clothingWorn_List[x].clothLevel == 4){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 9 (pants/shorts are on)
                                 if(clothingWorn_List[x].clothLevel == 9){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 23 (stockings are on)
                                 if(clothingWorn_List[x].clothLevel == 23){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to *remove* 1 PC. SWIMSUIT and...
                             if(clothLevel == 4){
                                 // ...anything == 9 (pants/shorts are on)                           
                                 if(clothingWorn_List[x].clothLevel == 9){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to *remove* BRA/BIKINI TOP and...
                             if(clothLevel == 5){
                                 // ...anything == 4 (1 pc. swimsuit is on)                           
                                 if(clothingWorn_List[x].clothLevel == 4){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 6 (t-shirt is on)                           
                                 if(clothingWorn_List[x].clothLevel == 6){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 7 (shirt/blouse is on)                           
                                 if(clothingWorn_List[x].clothLevel == 7){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 8 (coat is on)                           
                                 if(clothingWorn_List[x].clothLevel == 8){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 12 (dress is on)                           
                                 if(clothingWorn_List[x].clothLevel == 12){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 22 (body stocking is on)                           
                                 //if(clothingWorn_List[x].clothLevel == 22){
                                 //      y = x;
                                 //      break;        
                                 //}
                             }
                             // check for want to *remove* T-SHIRT and...
                             if(clothLevel == 6){
                                 // ...anything == 7 (shirt/blouse is on)                           
                                 if(clothingWorn_List[x].clothLevel == 7){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 8 (coat is on)                           
                                 if(clothingWorn_List[x].clothLevel == 8){
                                       y = x;
                                       break;        
                                 }
                             }
                             // check for want to *remove* SHIRT/BLOUSE and...
                             if(clothLevel == 7){
                                 // ...anything == 8 (coat is on)                           
                                 if(clothingWorn_List[x].clothLevel == 8){
                                       y = x;
                                       break;        
                                 }
                             }   
                             // check for want to *remove* HAIRBOW/HAIRPIN and...
                             if(clothLevel == 13){ 
                                 // ...anything == 14 (hat/bonnett is on)                           
                                 if(clothingWorn_List[x].clothLevel == 14){
                                       y = x;
                                       break;        
                                 }
                             }   
                             // check for want to *remove* BODY STOCKING and...
                             if(clothLevel == 22){ 
                                 // ...anything <> 22 anything else on at all..
                                 if(clothingWorn_List[x].clothLevel != 22){
                                       y = x;
                                       break;        
                                 }
                             } 
                             // check for want to *remove* STOCKINGS and...
                             if(clothLevel == 23){
                                 // ...anything == 1 (shoes are on)
                                 if(clothingWorn_List[x].clothLevel == 1){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 4 (1 pc. swimsuit is on)
                                 if(clothingWorn_List[x].clothLevel == 4){
                                       y = x;
                                       break;        
                                 }
                                 // ...anything == 9 (shorts/pants are on)
                                 if(clothingWorn_List[x].clothLevel == 9){
                                       y = x;
                                       break;        
                                 }
                             }
                        }while(x < clothingWorn_List.length);
                        // end do-while-loop
                        if(y > 0){
                             "You need to remove your <<clothingWorn_List[x].name>> first. ";
                             exit;
                        }
                        // NOTE: if they made it this far it seems okay to remove the item!
                        // ...so when we exit the check() routine all we have to do now
                        // ...is just our action() routine and we're done.
                     }// end if(clothingWorn_List.length > 0)
                   }// end if(clothignWorn_List 1= nil)                   
                }// end if(gActor.contents.length > 0)

              // back in the check() routine area...  

         // *********
        }// end check() routine
        action()
        {
            /* un-wear the item and describe what happened */
            makeWornBy(nil);
            if(specialRemoveDesc != nil){
                   self.specialRemoveDesc;
                }else{
                   defaultReport(&okayDoffMsg);
            }
        }        
   } 
   //dobjFor(Remove) asDobjFor(Doff)
   //dobjFor(ShowTo) { inherited; }
;
// A generic unclimbable mansion wall
class unclimbableWall : RoomPart
  isClimbableWall = nil // or true
  name = 'wall'
  vocabWords = '(black) (brick) (mansion) wall/fence'   
  desc = "An ordinary enough wall made of bricks stacked fifteen feet high and painted black.  "
;

// plug this into the room's "roomParts" array if needed (but may be initialized as an ordinary object too)
// Note: main tads lib. for Room object has a defaultFloor, defaultCeiling and four defaultWalls 
// NOTE: we put Attachable FIRST, because RoomPart first would override some functionality
// Also note: do not put this wall object in a room that has an ordinary up/down exit as the
// ..rope on the wall creates an up/down exit and may overwrite the room's normal up/down exit. 
class ClimbableWall : Attachable, RoomPart, Thing
   isClimbableWall = true // NOTE: modify Thing object in crom_mod.t so default is false
   name = 'wall'
   vocabWords = '(black) (brick) (mansion) wall/fence' // though 'gate' may introduce bug(s) if a door/gate is in the same room as wall
   desc = "An ordinary enough wall made of bricks stacked fifteen feet high and painted black.  "
   attachedObjects = []  // usually will be attached to a MagicRope object if anything
   location = nil
   OtherWall = nil // default
   OtherRoom = nil // default 
   DestinationDirection = 'UP'  // default = 'UP', Note: rope obj will use toLower() in the check so it doesn't matter if using 'UP' or 'up' or 'Up' and also handles just 'u' or 'U'
   resetUpToAfterRopeGet = nil  // set the room's up direction to this after rope get, otherwise rope will set to nil
   resetDownToAfterRopeGet = nil // set the room's down direction to this after rope get, otherwise rope will set to nil
   // redefining method from Thing.t 
   // ..This handles what happens when something thrown actually hits the wall
   throwTargetHitWith(projectile, path) {
         if(projectile.isMagicRope){
           if((DestinationDirection != nil) &&
              (OtherWall!= nil) &&
              (OtherRoom != nil)){  
                if(attachedObjects.length < 1){    
                 "The rope lands over the <<self.name>> and dangles nearby ready for climbing. ";              
                  // execute another command but don't count agains player turn counter (otherwise the "throw" command plus this next one = +2 turns and we don't want that)
                  libGlobal.totalTurns--;                  
                  local tokList = Tokenizer.tokenize('attach rope to wall');
                  executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)
                  exit;
                  //projectile.attachTo(self); // buggy version. doesn't work right with "again" command after "throw rope"
                  //exit;
                }else{
                  // NOTE: if you switch projectile/self below to self,projectile then 
                  // .. every other throw detaches rope & does default "falls to the ground" 
                  // .. thing after next command line nested action runs. However doing 
                  // .. projectile,self will make the rope always attach to the wall. 
                  // setOriginalAction(attachTo,projectile,self); // 
                  // setOriginalAction(self); 
                  replaceAction(DetachFrom,projectile,self); // (DetachFrom,self,projectile); NOTE: do NOT use "exit;" after or the nested action comes back and exits without executing defalts
                  // nestedAction(DetachFrom,projectile,self); // (DetachFrom,self,projectile); NOTE: do NOT use "exit;" after or the nested action comes back and exits without executing defalts
                  // self.detachFrom(projectile);
                  // exit;
                }               
           }
         }
        /* 
         *   figure out where we fall to when we hit this object, then send
         *   the object being thrown to that location 
         */
        getHitFallDestination(projectile, path)
            .receiveDrop(projectile, new DropTypeThrow(self, path));
   }
   canAttachTo(obj){
           // this means the wall can only attach to the rope (& vice versa)             
           if(obj.isMagicRope) 
              return true;
           return nil; // return yellowRope ? true : nil;
   }
   dobjFor(Examine){
          verify(){ inherited; }
          check(){ 
              inherited; 
              // If the rope is attached to the wall.. 
              // ..we don't want it to display "The wall is attached to the rope."
              // ..which would be the default look or examine behavior
              if(attachedObjects.length() > 0){
                if(attachedObjects[1].isMagicRope){
                   "<<desc>><br><br> A <<attachedObjects[1].name>> dangles from the <<self.name>>. ";
                   exit;
                }                 
              }
          }
          action(){ inherited; }
   }
   // dobjFor(Climb) remapTo(Climb,Up) // buggy... "climb" tends to auto-remap to rope without this line so let's not remap
   dobjFor(ClimbUp){
          verify(){ 
              if(attachedObjects.length() > 0){              
                if(attachedObjects[1].isMagicRope){
                   "(assuming you meant climb up rope...)\n";
                   replaceAction(ClimbUp,attachedObjects[1]); // yellowRope); // replaces action with another
                } 
              }
              if(DestinationDirection == nil){
                  illogical('You can not climb here. '); 
                  exit;
              }
              if((DestinationDirection.toLower() == 'down') ||
                 (DestinationDirection.toLower() == 'd')){
                  illogical('You can not climb in that direction. '); 
              }
              illogicalNow('You might try that later when a rope or something is attached to it. '); // msg, params...)
           // inherited; // NOTE: means by default you can NOT climb wall! (i.e. UNLESS an attached object was there)
          }
          check(){ inherited; }
          action(){ inherited; }
   }
   dobjFor(ClimbDown){
          verify(){ 
              if(attachedObjects.length() > 0){
                if(attachedObjects[1].isMagicRope){
                  "(assuming you meant climb down rope...)\n";
                 replaceAction(ClimbDown,attachedObjects[1]); // yellowRope); // replaces action with another
                }
              }
              if((DestinationDirection.toLower() == 'up') ||
                 (DestinationDirection.toLower() == 'u')){
                  illogical('You can not climb in that direction. '); 
              }
              illogicalNow('You might try that later when a rope or something is attached to it. ');
           // inherited; // NOTE: means by default you can NOT climb wall! (i.e. UNLESS an attached object was there)
          }
          check(){ inherited; }
          action(){ inherited; }
   }  
   dobjFor(Climb) {         
         verify() { 
           if(attachedObjects.length() > 0){
                if(attachedObjects[1].isMagicRope){
                   "(assuming you meant climb up rope...)\n";
                   replaceAction(Climb,attachedObjects[1]); // yellowRope); // replaces action with another
                } 
           }
           if(DestinationDirection == nil){
                  illogical('You can not climb here. ');
           }
           inherited; // NOTE: means by default you can NOT climb wall!
         }       
         check() { inherited(); }
         action() { inherited(); }      
   } 
;

/* 
 *  TO DO: recreate this object as an extention of the MultiFaceted
 *         or MultiLoc class. See info in the rem statement area
 *         above the MultiLoc class in file objects.t for more information
 *         on this idea. The room wall on either side should be MultiLoc
 *         as well, so attaching rope to wall on one side likewise automatically
 *         attaches it to wall on the other (as it is ONE object but in two locations). 
 *
 */
class MagicRope : Thing, Attachable // Attachable, Thing 
   // See also: class Passage in file: travel.t (i.e. could have extended the Passage object)
   // name = !isAttachedTo(defaultMansionWeeel) ? 'rope' : 'dangling rope'
   name = (ropeState == 1) ? 'rope' : 'dangling rope'
   isMagicRope = true // note: modify Thing in crom_mod.t to include isMagicRope = false by default
   vocabWords = '(yellow) (dangling) (coil) rope/roep'
   // sisterRope always in Pixyland if not in use
   ropeStorageRoom = pixyland
   attachedObjects = []  // usually will be attached to a wall if anything
   location = nil
   ropeState = 1 // 1 = coiled, 2 = dangling
   sisterRopeObj = nil // actual object name of sister rope
   getIsCoiled{ return (ropeState == 1); }
   setIsCoiled{ ropeState = 1; }
   getIsDangling{ return (ropeState == 2); }
   setIsDangling{ ropeState = 2; }
   bulk = 3 // note: 10 is usually the limit on bulk for objects that can hold other objects
   dobjFor(Use) remapTo(Climb, self) // using the rope is the same as climbing the rope

   //cannotAttachMsg = 'The rope is... yum?!?!? '
   //cannotAttachToMsg = 'The yum is.... rope!?!!?'

   canAttachTo(obj){
           // this means the wall can only attach to the rope (& vice versa)             
           if(obj.isClimbableWall) 
              return true;
           return nil; 
   }
   // Throw actions: ThrowTo, ThrowAt, Throw ...see actions.t, thing.t
   // ..Below works smartly for "Throw Rope" and finds and attaches it to an attachable wall
   // ..otherwise does default throw action. 
   // ..NOTE: The parser has a bug that if you say "Get rope" and then "throw it" the
   // ..default throw behavior seems to happen (i.e. you are asked "throw rope at what?")
   // ..however if players are aware of the "throw rope" command then hopefully they will
   // ..use "throw rope" (triggering below) and not "throw it" (triggering default for "it")
   dobjFor(Throw){
           preCond = [objHeld];
           //isRepeatable = true; // 
           //includeInUndo = true; 

           verify(){ 
                // note: we don't inherit this as it reroutes to ThrowAt and asks for iObj value 
                // .. instead let's loop through all room objects to find if there is a
                // .. object with isClimbableWall == true and then use that as iObj,
                // .. else we will then inherit default thing.t behavior and ask for iObj value.                
                if(self.location.roomParts != nil){
                   if(self.location.roomParts.length() > 0){
                      local x = 0;               
                      local tempObj = nil;
                      do{
                        x++;
                        if(self.location.roomParts[x].isClimbableWall){
                           tempObj = self.location.roomParts[x];
                        }
                      }while(x < self.location.roomParts.length());
                      if(tempObj != nil){
                        // we found one! what a smart rope! now let's throw rope at the wall
                        // replaceAction(ThrowAt,self,tempObj); 
                        //nestedAction(ThrowAt,self,tempObj);
                        local tokList = Tokenizer.tokenize('throw rope at wall');
                        executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)
                        exit;
                      }
                   }
                }
                // okay... now handle if the wall object is NOT a room part
                // but setup and placed in the room as a direct object...  (code variant: gActor... vs. me...)
                if(gActor.location.contents != nil){
                  if(gActor.location.contents.length() > 0){
                      local x = 0;               
                      local tempObj = nil;
                      do{
                        x++;
                        if(gActor.location.contents[x].isClimbableWall){
                           tempObj = gActor.location.contents[x];
                        }
                      }while(x < gActor.location.contents.length());
                      if(tempObj != nil){
                        // we found one! what a smart rope! now let's throw rope at the wall
                        // replaceAction(ThrowAt,self,tempObj); 
                        //nestedAction(ThrowAt,self,tempObj);
                        local tokList = Tokenizer.tokenize('throw rope at ' + tempObj.name); // wall
                        executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)
                        exit;
                      }
                   }
                }
                inherited; // at this point if we did not find a wall the default will ask for the iObj value of what we want to throw the rope at
           }
           check(){ inherited; }
           action(){ inherited; }
   }
   dobjFor(AttachTo){
         preCond = [touchObj,objHeld]; 
         verify(){
              if(gIobj != nil){
                 // bad bad bad... hard coding here
           //      if(gIobj == roadside21RavineRocks){
           //         "You try to attach the rope to the rocks but as soon as the magic rope brushes against
           //         their sharpness it retracts again. ";
           //         exit;
           //      }
                 if(!gIobj.isClimbableWall){  // gDobj = direct object, gIobj = indirrect
                   "You can not attach the rope to that. "; 
                   exit;
                 }
              }
              if(sisterRopeObj == nil){
                 // no sister rope found! this is an error in setting up the object(s)
                 "You can not attach the rope to that. ";
               #ifdef __DEBUG
               "... Error: No sister rope object found. The objects need to be setup 
               with a valid sister rope object to allow for the attach routine to work. ";
               #endif
               exit;
              }
              if(gIobj != nil){
                 if(!gIobj.OtherWall){
                    "You can not attach the rope to that. ";
                    #ifdef __DEBUG
                    "Error: Wall object does not have property OtherWall in setup. ";
                    #endif
                    exit;
                 }
              }
              if(gIobj != nil){ 
                 if(!gIobj.OtherRoom){ 
                    "You can not attach the rope to that. ";
                    #ifdef __DEBUG
                    "Error: Wall object does not have property OtherRoom in setup. ";
                    #endif
                    exit;
                 }
              }
              if(gIobj != nil){
                 if(!gIobj.DestinationDirection){
                    "You can not attach the rope to that. ";
                    #ifdef __DEBUG
                    "Error: Wall object does not have property DestinationDirection in setup. ";
                    #endif
                    exit;
                 }  
              }
         }
         check(){ inherited; 
                }
         action(){               
              // ...move sister rope to opposite room
              sisterRopeObj.moveInto(gIobj.OtherRoom); // (me.location); //sisterRopeObj.ActionMoveTo(me.location);
              sisterRopeObj.attachTo(gIobj.OtherWall); // (bogjuice); 
              // ...now do the inherited attach stuff to attach rope to this room's wall
              if(isHeldBy(gActor)){
                   setOriginalAction(self); 
                   moveInto(gActor.location); // ActionDrop; // nestedAction(Drop,self);
              }
              ropeState = 2; // 1 = coiled, 2 = dangling
              sisterRopeObj.ropeState = 2;
              // now create up locations (default) 
              //me.location.up = gIobj.OtherRoom; // use this and next line..
              //gIobj.OtherRoom.up = me.location; // ..instead of all the rest IF default direction = up on all walls
              local s1 = gIobj.DestinationDirection.toLower();
              // NOTE: using a converter switch because using OR || is buggy 
              // ......in the switch statements. So you need to convert first, then switch check.
              switch(s1){
                case 'u' : s1 = 'up'; break; 
                case 'd' : s1 = 'down'; break;
                default  : s1 = s1;
              }
              switch(s1.toLower()){              
               case 'up'  : me.location.up = gIobj.OtherRoom; break;
               case 'down': me.location.down = gIobj.OtherRoom; break;
               default : gActor.location.up = gIobj.OtherRoom;
              }
              local s2 = gIobj.OtherWall.DestinationDirection.toLower();
              // NOTE: using a converter switch because using OR || is buggy 
              // ......in the switch statements. So you need to convert first, then switch check.
              switch(s2){
                case 'u' : s2 = 'up'; break;
                case 'd' : s2 = 'down'; break;
                default  : s2 = s2; 
              } 
              switch(s2){
               case 'up' : gIobj.OtherRoom.up = me.location; break; // gIobj.OtherWall.OtherRoom; // break;
               case 'down': gIobj.OtherRoom.down = me.location; break;// gIobj.OtherWall.OtherRoom; // break;
               default : gActor.location.up = gIobj.OtherRoom; 
              }              
              inherited;              
         }
   }
   //dobjFor(Detach){
   //      preCond = [touchObj,objHeld]; 
   //      verify(){ inherited; }
   //      check(){ inherited; }
   //      action(){ inherited; }   
   //}
   dobjFor(Take) { 
         verify(){ 
            // inherited();
            if(attachedObjects.length > 0){
               // now remove up locations (default) but later modify to point to wall tag(s)
               gActor.location.up = nil; 
               gActor.location.down = nil;               
               // Detach this rope object from any wall
               foreach(local obj in attachedObjects){
                    detachFrom(obj);
                    if(obj.resetUpToAfterRopeGet != nil) obj.location.up = obj.resetUpToAfterRopeGet;
                    if(obj.resetDownToAfterRopeGet != nil) obj.location.down = obj.resetDownToAfterRopeGet;
               }
            }
            // Detach sister rope object from any wall
            if(sisterRopeObj.attachedObjects.length > 0){
                // now remove up locations (default) but later modify to point to wall tag(s)
                sisterRopeObj.location.up = nil;
                sisterRopeObj.location.down = nil;
                foreach(local obj in sisterRopeObj.attachedObjects){
                    sisterRopeObj.detachFrom(obj);
                    if(obj.resetUpToAfterRopeGet != nil) obj.location.up = obj.resetUpToAfterRopeGet;
                    if(obj.resetDownToAfterRopeGet != nil) obj.location.down = obj.resetDownToAfterRopeGet;
                }
            }
            if(ropeStorageRoom == nil){
               "Error: ropeStorageRoom is nil in rope object Take method. "; 
               exit;
            }
           // if(isAttachedTo(defaultMansionWeeel)){              
           //    nestedAction(Detach,defaultMansionWeeel); // "nestedAction" runs Detach, then follows through with our orig. command here             
               // "Okay. ";                                 // replaceAction(Detach,defaultMansionWheel); // replaces action with another
           // }           
         }
         check(){ inherited;
         }
         action(){              
              sisterRopeObj.moveInto(ropeStorageRoom); // (me.location);
              //   sisterRopeObj.detachFrom(gIobj.OtherWall); // (bogjuice); 
              ropeState = 1; // 1 = coiled, 2 = dangling
              sisterRopeObj.ropeState = 1;
              inherited;
         }
  }
  dobjFor(Climb){  
          verify(){
             // NOTE: you would have to trap the room exit(s) to check for "UP" also for this...
             //if(bogjuice.isHeldBy(gActor)){
             //   "You can't climb anything while holding that bog juice. (It might spill). ";
             //   exit;
             //} 
          }
          check(){
             if(attachedObjects.length() < 1){       // if(!isAttachedTo(defaultMansionWeeel)){
                  "Try attaching the rope to something first, like a wall. ";
                  exit;
             }
             inherited();
          }
          action(){ 
             inherited(); 
             "You climb the rope..."; 
             // NOTE: change below to wall object checks but using default up/down for now
             if(gActor.location.up != nil){
               gActor.travelTo(me.location.up,self,nil);
               exit;
             }  // (treeHouse,self,nil); 
             if(gActor.location.down != nil){
               gActor.travelTo(me.location.down,self,nil);
               exit;
             }
          } // <<self>>. "; }
  } 
  dobjFor(ClimbUp){
          verify(){ }
          check(){ 
             if(attachedObjects.length() < 1){ 
                  "Try attaching the rope to something first, like a wall. ";
                  exit; 
             }
             if(gActor.location.up == nil){
                  "There is no way to climb in that direction. ";
                  exit; 
             }             
             if(attachedObjects[1].isClimbableWall){  
                  if(attachedObjects[1].DestinationDirection != nil){
                     local s1 = attachedObjects[1].DestinationDirection.toLower();
                     switch(s1){
                         case 'u' : s1 = 'up'; break;
                         case 'd' : s1 = 'down'; break;
                         default  : s1 = s1; 
                     } 
                     switch(s1){
                         case 'up' : break; // okay 
                         case 'down' : "You can only climb down from here. "; exit; 
                     }
                  }else{
                     "There is no way to climb down from here. ";
                     exit;
                  }
             }             
             inherited;
          }
          action(){ 
             inherited(); 
             "You climb up the rope..."; 
             // NOTE: change below to wall object checks but using default up/down for now
             if(gActor.location.up != nil){
               gActor.travelTo(me.location.up,self,nil);
               exit;
             }  // (treeHouse,self,nil); 
             inherited;
          }
  }
  dobjFor(ClimbDown){
          verify(){ }
          check(){ 
             if(attachedObjects.length() < 1){ 
                  "Try attaching the rope to something first, like a wall. ";
                  exit; 
             }
             if(me.location.down == nil){
                  "There is no way to climb in that direction. ";
                  exit; 
             }             
             if(attachedObjects[1].isClimbableWall){  
                  if(attachedObjects[1].DestinationDirection != nil){
                     local s1 = attachedObjects[1].DestinationDirection.toLower();
                     switch(s1){
                         case 'u' : s1 = 'up'; break;
                         case 'd' : s1 = 'down'; break;
                         default  : s1 = s1; 
                     } 
                     switch(s1){
                         case 'up' : "You can only climb up from here. "; exit;
                         case 'down' : break; // okay 
                     }
                  }else{
                     "There is no way to climb down from here. ";
                     exit;
                  }
             }             
             inherited;
          }
          action(){ 
             "You climb down the rope..."; 
             // NOTE: change below to wall object checks but using default up/down for now
             if(me.location.down != nil){
               gActor.travelTo(me.location.down,self,nil);
               exit;
             }  // (treeHouse,self,nil); 
             inherited;
          }
  }
;

/* ------------------------------------------------------------------------ */
/*
 *   Pre-condition: object must be held.  This condition requires that an
 *   object of a command must be held by the actor.  If it is not, we will
 *   attempt a recursive "take" command on the object.
 *   
 *   This condition is useful for commands where the object is to be
 *   manipulated in some way, or used to manipulate some other object.
 *   For example, the key in "unlock door with key" would normally have to
 *   be held.  
 */
objNotHeld: PreCondition
    checkPreCondition(obj, allowImplicit)
    {
        /* if the object is not held then return true */
        if (obj == nil || !obj.meetsObjHeld(gActor))
            return true;

        /* it's not held and we can't take it - fail */
        reportFailure('{You/he} {must} try that someplace else. ', obj);

        /* make it the pronoun */
        gActor.setPronounObj(obj);

        /* abort the command */
        exit;
    }

    /* lower the likelihood rating for anything not being held */
    verifyPreCondition(obj)
    {
        /* if the object isn't being held, reduce its likelihood rating */
        if (obj != nil && !obj.meetsObjHeld(gActor))
            logicalRankOrd(80, 'implied take', 150);
    }
;

// use this if you don't want the player as a little girl trying various things
isNotALittleGirl: PreCondition
    checkPreCondition(obj, allowImplicit){
        if(obj == nil || obj != gPlayerChar)
            return true;
        
        if(obj != nil && obj == gPlayerChar && !gameMain.is_a_little_girl){
            reportFailure('That\'s only for big people. ', obj);
            gActor.setPronoounObj(obj);
            exit;
        }
        // player must not be a little girl then
        return true;
    }
    
    verifyPreCondition(obj){
        // if the obj isn't the player then lower the liklihood
        if(obj != nil && obj != gPlayerChar)
            logicalRankOrd(50, 'not likely', 150);
    }
;


// Attachable to ClothesHangar class objects
class HangableCromexxClothing: AdvancedCromexxClothing, Attachable
    //specialDesc {
  //        if(self.isAttachedTo(yourLGhangar)){
  //             local myobj = self;
  //             gMessageParams(myobj);
  //             // The "A" will change to "some" if the self object is plural (isPlural == true). The "is" will change to "are" if self isPlural is true. 
  //             "{subj myobj}{A myobj/him} {is} hanging from a hangar in the closet. ";
  //        }
  //        inherited;// ususally nothing
  //}
  dobjFor(HangOn) maybeRemapTo((gIobj != nil),AttachTo,self,gIobj)
    // isListedInContents = nil
   
  handleAttach(other){
          moveInto(other); // yourLGhangar);
  }   
  canAttachTo(obj) { 
        //if(obj == kellyshangar){
        //    return true; // obj == kellyshangar;
        //}
        //if(obj == yourLGhangar){
        //    return true;
        //}
        //if(obj == nickyshangar){
        //    return true;
        //}
        return obj.ofKind(ClothesHangar);
  }
    canDetachFrom(obj) { 
        //if(obj == kellyshangar){
        //    return true; // obj == kellyshangar;
        //}
        //if(obj == yourLGhangar){
        //    return true;
        //}
        //if(obj == nickyshangar){
        //    return true;
        //}
        return obj.ofKind(ClothesHangar);
    }
    
  //canAttachTo(obj) { 
  //      return obj.ofKind(ClothesHangar);
 // }
 // canDetachFrom(obj) { return obj.ofKind(ClothesHangar); }
  dobjFor(Take){
      preCond = [touchObj, objNotWorn, roomToHoldObj]
      verify(){ 
          inherited; 
          if(self.attachedObjects.length() > 0){
               // Detach this object from any other
               local x = 0;
               do{
                 x++;
                 if(x <= self.attachedObjects.length()){
                   detachFrom(self.attachedObjects[x]); // attachedObjects[x].detachFrom(self);                 
                 }
               }while(self.attachedObjects.length() > 0 || x < 20);     
          }
      }
      check(){ inherited; }
      action(){ inherited; }
  } 
  dobjFor(PutOn) remapTo(AttachTo,gDobj,gIobj) // maybeRemapTo((gIobj != nil) && (gIobj == yourLGhangar)),AttachTo,gDobj,yourLGhangar) 
 
  myIobj = nil
  
  // for some reason part of the natural Tads3 code fails because it is checking for gIobj which doesn't exist even though it should. This should "fix" it.    
  checkIobj(zimmer){
             // verify that gIobj is not nil
             local iFound = nil;
               if(gAction.tokenList != nil){
                    if((gAction.tokenList.length >= 1)){
                         local iLength = gAction.tokenList.length;
                         for(local i = 1;i <= iLength;i++){
                              foreach(local obj in gAction.tokenList[i]){
                                   if(obj == 'hangar') iFound = true;
                              }
                         }
                    }
               }
               if(iFound){
                    audreysDress.myIobj = yourLGhangar;
                    gAction.setResolvedObjects(self,yourLGhangar);// dobj, iobj
                    if(gIobj == nil){
                         return nil;// exit;
                    }
               }
               return true;
  }
    
  dobjFor(Examine) {
          preCond = [objVisible]
          verify(){ inherited; }   
          check(){ inherited; }
          action(){ 
                 if(self.isAttachedTo(yourLGhangar)){                  
                "{The dobj/him} {is} hanging from a hangar in the closet. ";
                 }
            self.desc; // inherited;
                 exit;
          }
  }
   dobjFor(AttachTo)
    {
        /* require that the actor can touch the direct object */
        preCond = [touchObj]
        
        verify(){
        }
          
        check()
        {
               if(self.isWornBy(gPlayerChar)){
                    tryImplicitAction(Remove,self);
               }
               if(self.isWornBy(gPlayerChar)){
                    failCheck('You need to remove it from yourself first. ');
               }
            if(gIobj == nil){
                // find it again
                local oHangar = nil;
                foreach(local objy in gActor.location){
                    if(objy.ofKind(ClothesHangar)){
                        oHangar = objy;
                    }
                }
                self.myIobj = oHangar;   
            }else if(!canAttachTo(gIobj)){
                self.myIobj = nil;    
                explainCannotAttachTo(gIobj);
                exit;
            }
        }
        
        action()
        {
            self.myIobj = nil;
             
            /* add the other object to our list of attached objects */
           attachedObjects += gIobj;

            /* add our default acknowledgment */
            defaultReport(self.myHangingReport);// &okayAttachToMsg);

            /* fire the handleAttach event if we're ready */
            maybeHandleAttach(gIobj);
        }
    }  
;

// ClothesHangar class
class ClothesHangar: RoomPartItem, Attachable, Decoration
    vocabWords = '(your) (my) (little) (girl) (girls) (girl\'s) (clothes) (clothing) (closet) (hanging) hangar hanger dowel/rod/rack' 
    name = 'clothes rack'
   // specialDesc = "A little wooden clothes hangar is in the closet. "
   isListed = nil // ((contents.length > 0) ? true : nil)
   isListedIncontents = nil
   useSpecialDescInRoom(room) { return true; }
   //specialDesc = ""
   examineStatus(){ } // wipe it out so it does not list contents
   contentsListed = nil // overrode to stop listing by default
   contentsListedinExamine = nil // overrode
   lookInLister = nil // thingLookInLister
   isListedInInventory = nil    
   specialDesc = ""
   attachedObjects = []// DO put dresses or whatever here if they START the game ON the hangar!  
   cromexxAllowedAttachables = []// NOTE: You MUST put this in the object you create for the canAttachTo(obj) method to work properly!     
   desc {
          local something = 'it\'s about as tall as you. ';
          if(gPlayerChar.posture == sitting) 
               something = 'it\'s above you a ways while you\'re sitting. ';
          if(gPlayerChar.posture == lying) 
               something = 'it\'s above you quite a bit while you\'re lying down. ';
          if(gPlayerChar.posture == kneeling) 
               something = 'it\'s above you a ways while you\'re kneeling. ';
          if(gPlayerChar.posture == crawling){ 
               something = 'it\'s above you quite a bit while you\'re crawling. ';
          }
          "A wooden clothes rack specially designed to be at little kid level so <<something>> ";
          if((attachedObjects != nil) && (attachedObjects.length > 0)){
               examineListContents();// listContents();  
          }         
   }
     aboutDesc = "TIP: To use the clothes rack simply <b>\"hang\" (whatever) \"on rack\"</b> or <b>\"take\" (whatever) \"from\" rack</b>.
                Or if you\'re in a hurry and want to skip a step by wearing something on the rack you can simply try 
                to <b>\"wear\" whatever</b> and if it\'s on the rack (and you\'re ready to wear it without it getting in the 
                way of what you might be wearing) you\'ll automatically take it off and wear it. "  
     // we tell the parser that this is okay but remap it from the clothing item's dobjFor(HangOn) to AttachTo instead.  
     iobjFor(HangOn){
          verify(){ 
            if(gActor.canSee(self)){
                logicalRank(110,'likely'); 
              }
          }
          check(){}
          action(){}
     }
     iobjFor(PutIn){
          verify(){
            if(gActor.canSee(self)){
                logicalRank(110,'likely'); 
              }
          }
          check(){}
          action(){}
     }
     
   handleDetach(other){
          // moveInto(gActor);    
          attachedObjects -= other;
   }
  
   canAttachTo(obj) { 
          // if(obj == audreysDress) return true;
          local clothingArray = self.cromexxAllowedAttachables;
          local i;
          local oReturner = nil;
          for(i=1;i < clothingArray.length;i++){
            if(obj == clothingArray[i]){
                oReturner = true;
            }
          } 
          if(!oReturner){
                return obj.ofKind(HangableCromexxClothing);// failsafe - always allow this type of object
          }
          return oReturner;     
   } 
   handleAttach(other){ 
          // other.name
          "{You/he} hang{s}  {the dobj/him} on the little hangar. "; 
          // self.attachTo(other);// programmatic attach (handles variables from self and other.
   } 
    /* handle attachment on the indirect object side */
    iobjFor(AttachTo)
    {
        /*
         *   Require that the direct object can touch the indirect object.
         *   This ensures that the two objects to be attached can touch
         *   one another.  Note that we don't also require that the actor
         *   be able to touch the indirect object directly, since it's
         *   good enough that (1) the actor can touch the direct object
         *   (which we enforce with the dobj precondition), and (2) the
         *   direct object can touch the indirect object.  This allows for
         *   odd things like plugging something into a recessed outlet,
         *   where the recessed bit can't be reached directly but can be
         *   reached using the plug.  
         */
        preCond = [dobjTouchObj]
        
        verify()
        {
            /* 
             *   it makes sense to attach to anything but myself, or things
             *   we're already attached to 
             */
            if (gDobj != nil)
            {
                if (isAttachedTo(gDobj))
                    illogicalAlready(&alreadyAttachedMsg);
                else if (gDobj == self)
                    illogicalSelf(&cannotAttachToSelfMsg);
            }
        }
        
        check()
        {
            /* only allow it if we can attach to the other object */
            if (!canAttachTo(gDobj))
            {
                explainCannotAttachTo(gDobj);
                exit;
            }
        }
        
        action()
        {
            /* add the other object to our list of attached objects */
            attachedObjects += gDobj;

            /* fire the handleAttach event if we're ready */
            maybeHandleAttach(gIobj);
        }
    }
; 




/*************
 * END OBJS  *
 *************/ 



