// START


forestdesc: decoration
	sdesc = "forest"
	ldesc = "The forest is large, dark, foreboding and you are lost in it."
	location = startroom
	noun = 'forest'
	adjective = 'large' 'dark'
;

startroom: room
	sdesc = "Forest"
	ldesc = "You are lost in a dark forest.  Every path looks the same.
		Luckily the full moon above is providing some light."
	north = {forestdesc.moveInto(f1); return(f1);}
	ne = {forestdesc.moveInto(f2); return(f2);}
	east = { forestdesc.moveInto(f3); return(f3);}
	south = {forestdesc.moveInto(f3); return(f3);}
	sw = { forestdesc.moveInto(startroom); return(startroom);}
	nw = { forestdesc.moveInto(startroom); return(startroom);}
;

f1: room
	sdesc = "Forest"
	ldesc = "You are lost in a forest.  Every path looks the same.  Luckily the full moon above is providing some light."
	north = {forestdesc.moveInto(f2); return(f2);}
	ne = {forestdesc.moveInto(f2); return(f2);}
	south = {forestdesc.moveInto(startroom); return(startroom);}
	west = {forestdesc.moveInto(f1); return(f1);}
;

f2: room
	sdesc = "Forest"
	ldesc = "You are lost in a forest. Luckily the full moon above 
			is providing some light.  The forest looks darker to the 
			east."
	north = {forestdesc.moveInto(f1); return(f1);}
	ne = {forestdesc.moveInto(f5); return(f5);}
	east = {forestdesc.moveInto(f4); return(f4);}
	se = {forestdesc.moveInto(startroom); return(startroom);}
	south = {forestdesc.moveInto(f3); return(f3);}
	sw = {forestdesc.moveInto(f1); return(f1);}
	west = {forestdesc.moveInto(f1); return(f1);}
;

f3: room
	sdesc = "Forest"
	ldesc = "You are lost in a forest. Luckily the full moon above
			is providing some light. The forest looks darker to the northeast."
	north = { forestdesc.moveInto(startroom); return(startroom);}
	ne = {forestdesc.moveInto(f4); return(f4);}
	west = {forestdesc.moveInto(f2); return(f2);}
	nw = {forestdesc.moveInto(f3); return(f3);}
;

f4: darkroom
	sdesc = "Forest"
	ldesc = "You are lost in a very dark forest. Every path looks the same."
	north = {forestdesc.moveInto(f2); return(f2);}
	east = {forestdesc.moveInto(f5); return(f5);}
	se = {forestdesc.moveInto(f5); return(f5);}
 	south = {forestdesc.moveInto(f3); return(f3);}
	west ={forestdesc.moveInto(f4); return(f4);}
;

f5: darkroom
	sdesc = "Forest"
	ldesc = "You are lost in a dense dark forest. 
			Every path does not look the same.
			The dense shrubbery to the east has been recently 
			burned away. There is a strange soft glow emanating from the
			 east as well."
	north = {forestdesc.moveInto(f5); return(f5);}
	sw = {forestdesc.moveInto(f4); return(f4);}
	west = {forestdesc.moveInto(f4); return(f4);}
	east = crash
;

shrub: decoration
	sdesc = "shrubbery"
	ldesc = "The shrubbery looks like it has been burned away recently."
	noun = 'shrubbery' 'bushes'
	location = f5
;

glow: decoration
	sdesc = "strange glow"
	ldesc = "The glow seems to flow like molasses from the burned region to the
			east.  Looking at it gives you an eerie feeling."
	noun = 'glow'
	adjective = 'strange' 'soft'
	location = f5
;

crash: room
	sdesc = "Burned Forest"
	ldesc = "This area has been recently charred away by, what you assumed to
			be, the recent meteor strike.  As you look closer at the impact
			crater you realize the meteor at the center 
			is not the usual sort of meteor (that is unless you consider a 
			large, glowing metal cylinder usual). 
			\n\tLying next to an opening in the cylinder is some sort
			of humanoid creature.  It appears to be very badly wounded."
	west = {forestdesc.moveInto(f5); return(f5);}
	in = shipin
;

bfor: decoration
	sdesc = "burned forest"
	ldesc = "Most of the trees have been blackened by the impact. There
			are some embers still glowing in the burnt trees."
	noun = 'trees' 'forest'
	adjective = 'burned'
	location = crash
;

embers: vowelItem, decoration
	sdesc = "embers"
	ldesc = "There is nothing special about the embers."
	noun = 'embers'
	location = crash
;

dalien: qcontainer, fixeditem 
	sdesc = "dead creature"
	noun = 'creature' 'alien'
	adjective = 'dead'
	location = crash
	ldesc = 
	{
		"The creature is roughly humanoid, about 7 feet tall, covered in light orange skin and
 		is quite dead.  A thin red fluid flows from the many wounds that cover its body. ";

	if (translator.location = dalien)
		"The creature is holding a thin metal box in its left hand.";
	}
;
