#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"
#include "qtalk.h"
//Quip template "desc"? "reply"?;

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// SCOPE OF FILE
// CONFERENCE ROOM
// HACKS IN TOUCHOBJ, etc.
// NETON/OVAN CONVERSATION: Preliminary handling.
// NETON/OVAN CONVERSATION: The initial two questions.
// NETON/OVAN CONVERSATION: After they tell you it's the year 2189.
// NETON/OVAN CONVERSATION: After they tell you about the nuclear war.
// NETON/OVAN CONVERSATION: After they tell you about the Oo arrival on Earth.
// NETON/OVAN CONVERSATION: After they tell you they like IF.
// NETON/OVAN CONVERSATION: If/when they ask you whether you've played IF.
// NETON/OVAN CONVERSATION: After they tell you how they revived you.
// NETON/OVAN CONVERSATION: After they say they want you to play their game.
// NETON/OVAN CONVERSATION: After they tell you they like mazes.
// NETON/OVAN CONVERSATION: After they tell you their game is Nothing But Mazes.
// NETON/OVAN CONVERSATION: After they ask you for any final questions.
// CUT SCENE #2
// CONFERENCE ROOM DAEMON
// CONFERENCE ROOM BANNER PICTURES
// DEBUG STUFF

// -------------------------------------------------------------------
// SCOPE OF FILE
// -------------------------------------------------------------------

// This file is meant to include pretty much everything that happens
// in the scene in the conference room -- *except it does not define
// NPCs or things directly related to NPCs, such as NPC collective
// groups, objects owned by NPCs, etc.*
// 
// As such, this file basically includes two things:
// 
// (1) the conference room and its component objects, and
// (2) the conversation you have with Neton and Ovan in the conference
// room.

// -------------------------------------------------------------------
// CONFERENCE ROOM
// -------------------------------------------------------------------

confRoom: FormerRoomShadowCaster, AlienRoom 'Conference Room'
  "This room is dominated by a long, wide table made of black stone.
    Around it are three chairs. To the north, a green door
    <<confDoor.isOpen
      ? 'is open, leading into the hallway.'
      : 'stands closed.'>> "
  // for vocabWords, see modifications in 3endgame.t.
  bannerValue() {
    if (killBanner)
      return nil;
    if (glob.isInEndgame)
      return endgame;
    if (!neton.isIn(confRoom))
      return confRmPic;
    else
      return confPfPic;
  }
  killBanner = nil
  getDoorForLeavingRoom = confDoor
  isInColumn = 4
  isInRow = 6
  north =   confDoor
  out asExit(north)
  roomBeforeAction() {
    if (!glob.isInEndgame 
        && confDaemon.daemonID == nil 
        && daemonStartStatus < 5) {
      if (me.hasSeen(coffin))
        daemonStartStatus++;
      else
        daemonStartStatus = daemonStartStatus + 2;
      if (daemonStartStatus >= 2) {
        confDaemon.startDaemon();
        confDaemon.isActive = true;
        daemonStartStatus = 10;
      }
    }
  }
  roomAfterAction() {
    if (gActionIs(Yell)) {
      if (!glob.isInEndgame) {
        if (!ovan.isIn(confRoom)) {
          "<p>The guards squint at you 
            and raise their guns. Then 
            they shrug, deciding to ignore you. ";
        }
        // The following "else" covers all cases where you're in the 
        // confRoom, it's the intro as opposed to the endgame,
        // and Neton and Ovan are there with you as well.
        else {
          "<p>The aliens regard you quizzically for a moment. ";
          if (confDaemon.nextSpeaker == neton) {
            "<p>Then <<neton.theName>> shrugs and says, <.q>The human does evidently
                possess a healthy set of vocal cords.<./q> 
              <p><.q>That<./s>s for sure,<./q> 
                <<ovan.hasBeenIdentified ? 'says Ovan' : 'his companion says'>>. ";
            //"<p>Then <<ovan.theName>> furrows his brow and says, 
            //    <.q>I wonder if the
            //    <i>Journal of Twenty-First Century Earth Etiquette</i> 
            //    explains the meaning of this kind of screaming.<./q>
            //    He fiddles with his tablet device for a few seconds, then
            //    shrugs and says, <.q>I guess not.<./q> ";
            
            //"<p>\^<<neton.theName>> replies, <.q>At any rate, 
            //    the human does evidently
            //    possess a healthy set of vocal cords.<./q> ";
          }
          else {
            "<p>Then <<neton.theName>> shrugs and says, <.q>The human does evidently
                possess a healthy set of vocal cords.<./q> ";
            //"<p>\^<<ovan.theName>> furrows his brow and says, 
            //    <.q>I wonder if the
            //    <i>Journal of Twenty-First Century Earth Etiquette</i> 
            //    explains the meaning of this kind of screaming.<./q>
            //    He fiddles with his tablet device for a few seconds, then
            //    shrugs and says, <.q>I guess not.<./q> ";
          }
          //local speaker1;
          //local speaker2;
          //switch (confDaemon.nextSpeaker) {
          //  case neton:
          //    "Neton regards you quizzically, ";
          //  default:
          //}
        }
        //"<p>Next speaker: ";
        //if (!confDaemon.nextSpeaker)
        //  "None! ";
        //else
        //  say(confDaemon.nextSpeaker.theName + '. ');
      }
    } // YellAction
  }
  daemonStartStatus = 0
;

// Note to self: I don't know why I put this here.
modify playerMessages
    uniqueObjectRequired(actor, txt, matchList) {
        "<.parser>You can<./s>t use multiple objects there.<./parser> ";
    }
;

// Note that the AlienChair class is defined in 3endgame.t
// (in the breakRoom section).

class ConfChair: ConfFurniture, AlienChair
  desc = "It<./s>s a black chair, fastened to the ground <<locDesc>>. "
  location = confRoom
  actorInPrep = 'in'
  collectiveGroup = confChairGroup
  dobjFor(Use) asDobjFor(SitOn)
  // When wordName = 'chair', if you fire the T-removing gun 
  // at the first chair, it won't try to do the transformation
  // "first chair" -> "firs chair"; it'll just do an ordinary 
  // "chair" -> "chair"; hence, nothing happens.
  wordName = 'chair'
;

confChairGroup: CollectiveGroup, Fixture
  '(black) (conference) chair*chairs'
  'chairs'
  "The chairs are black, and are fastened to the ground 
    around the conference table. The first chair is on the
    south side of the table, while the second and third 
    chairs are northwest and northeast of the table, 
    respectively. "
  isPlural = true
  location = confRoom
  isCollectiveAction(action, whichObj) {
    if (action.ofKind(TakeAction) ||
        action.ofKind(EnterAction) ||
        action.ofKind(GetOffOfAction) ||
        action.ofKind(GetOutOfAction) ||
        action.ofKind(LieOnAction) ||
        action.ofKind(PutInAction) ||
        action.ofKind(PutOnAction) ||
        action.ofKind(PutUnderAction) ||
        action.ofKind(PutBehindAction) ||
        action.ofKind(StandOnAction) ||
        action.ofKind(TakeFromAction) ||
        action.ofKind(SitOnAction))
      return nil;
    else
      return true;
  }
;

firstConfChair: ConfChair
  'first (south) (southern) (nw) (black) (conference) chair*chairs'
  'first chair'
  locDesc = 'on the south side of the conference table'
  pluralOrder = 1
;
secondConfChair: ConfChair
  'second (west) (western) (northwest) (northwestern) (nw) (black) (conference) chair*chairs'
  'second chair'
  locDesc = 'on the north side of the conference table, towards the west'
  pluralOrder = 2
;
thirdConfChair: ConfChair
  'third (east) (eastern) (northeast) (northeastern) (ne) (black) (conference) chair*chairs'
  'third chair'
  locDesc = 'on the north side of the conference table, towards the east'
  pluralOrder = 3
;

class ConfFurniture: object
  actorTravelingWithin(origin, dest) {
    //local k; k = 9 / k;
    if (gActor == gPlayerChar && !glob.isInEndgame) {
      reportFailure('The younger of the two guards emits a low growl and points 
        his hand cannon directly at you. You decide to stay where 
        you are. ');
      exit;
    }
  }
  dobjFor(SitOn) {
    check() {
      if (gActor == gPlayerChar && !glob.isInEndgame) {
        reportFailure('The younger of the two guards emits a low growl and points 
          his hand cannon directly at you. You decide to stay where 
          you are. ');
        exit;
      }
    }
  }
  dobjFor(StandOn) {
    check() { checkDobjSitOn(); }
  }
  dobjFor(LieOn) {
    check() { checkDobjSitOn(); }
  }
  makeStandingUp() {
    // Do travelWithin before makePosture; otherwise, when travelWithin
    // fails, makePosture will sometimes work anyway, which makes no sense.
    gActor.travelWithin(location);
    gActor.makePosture(location.defaultPosture);
    gActor.okayPostureChange();
  }
;

confTable: FormerShadowCaster, ConfFurniture, AlienTable
  '(shiny) (black) (stone) (conference) table'
  'table'
  "The table is made of shiny black stone.
    It<./s>s about eight feet long, and about 
    five feet wide. "
  location = confRoom
  shadowVocabWords = '(shiny) (black) (stone) (conference) table'
  shadowList = [hallway6]
  allowedPostures = [sitting, standing, lying]
  obviousPostures = [sitting, standing, lying]
;

confDoor: AlienDoor
  location = confRoom
  beforeAction() {
    if (gActionIs(ListenImplicit) && confDaemon.daemonState == 2) {
      "You hear some shuffling from outside the door. ";
      exit;
    }
    inherited();
  }
  dobjFor(ListenTo) {
    action {
      if (confDaemon.daemonState == 2) {
        "You hear some shuffling from outside the door. ";
      }
      else {
        inherited();
      }
    }
  }
;

// -------------------------------------------------------------------
// HACKS IN TOUCHOBJ, etc.
// -------------------------------------------------------------------

// Note (written 2016-11-09): TouchObjCondition.checkPreCondition 
// is hacked both here and in 3endgame.t. This works because of the use of 
// inherited() in the latter hack in 3endgame.t.

// This hack
// (1) prevents the player from being able to touch
// anything he's not supposed to be able to touch while in the
// conference room under supervision of the guards, and 
// (2) prevents the player from being able to touch an alien 
// possession while the guards are around.
modify TouchObjCondition //: PreCondition
    // construct with a given source object
    construct(src) { sourceObj = src; }
    // the source object - this is the object that is attempting to
    // touch the target object 
    sourceObj = nil
    // check the condition
    checkPreCondition(obj, allowImplicit) {
        local pastObs;
        
        
        // START HACK #1
        //local k = 0; k = 9 / k;
        local objLoc, sourceObjLoc, a;
        if (sourceObj == gPlayerChar
            && sourceObj.isIn(confRoom) 
            && sourceObj.location != confRoom
            && obj.isIn(confRoom)) {
          
          a = obj;
          for (;;) {
            if (a == firstConfChair) {
              objLoc = 6;
              break;
            }
            if (a == confTable) {
              objLoc = 7;
              break;
            }
            if (a == secondConfChair || a == thirdConfChair) {
              objLoc = 8;
            }
            if (a == confRoom) {
              objLoc = 10;
              break;
            }
            if (a == nil) {
              objLoc = 0;
              break;
            }
            a = a.location;
          }
          
          a = sourceObj;
          for (;;) {
            if (a == firstConfChair) {
              sourceObjLoc = 6;
              break;
            }
            if (a == confTable) {
              sourceObjLoc = 7;
              break;
            }
            if (a == secondConfChair || a == thirdConfChair) {
              sourceObjLoc = 8;
            }
            if (a == confRoom) {
              sourceObjLoc = 10;
              break;
            }
            if (a == nil) {
              sourceObjLoc = 0;
              break;
            }
            a = a.location;
          }
          
          // If "sourceObj" is on one of the chairs or on the table,
          // and if "obj" is anywhere in the conference room...
          if (objLoc && sourceObjLoc && sourceObjLoc != 10) {
            // ... and if "obj" is not within reach of "sourceObj",
            // then tell "sourceObj" to try to stand up.
            if (objLoc - sourceObjLoc < -1 ||
                objLoc - sourceObjLoc > 1) {
              if (allowImplicit && tryImplicitAction(Stand)) {
                if (sourceObj.location != confRoom)
                  exit;
                else
                  return true;
              }
              else {
                //k = 0; k = 9 / k;
                reportFailure('You can<./s>t quite reach ' + obj.theName 
                  + ' while you<./s>re ' + sourceObj.posture.participle
                  + ' ' + sourceObj.location.actorInName + '. ');
                exit;
              }
              //if (tryImplicitAction(GetOffOf, sourceObj.location)) {
              //  return true;
              //}
              //else {
              //  exit;
              //}
              //  if () 
              //    return true;
              //  else
              //    return nil;
              //}
            }
          }
          
        }
        // END HACK #1
        // START HACK #2
        if (obj && sourceObj 
            && sourceObj == gPlayerChar 
            && obj.ofKind(AlienPossession)
            && gPlayerChar.getOutermostRoom == confRoom 
            && gPlayerChar.canSee(youngGuard) 
            && !glob.isInEndgame) {
          reportFailure('As you move toward ' + obj.theName + ',
            the younger of the two guards emits a low growl 
            and points his hand cannon directly at you. 
            On second thought, you decide 
            to stay away from ' + obj.theName + '. ');
          exit;
        }
        // END HACK #2
        
        
        // If we can touch the object, we can proceed with no implicit
        // actions.
        if (sourceObj.canTouch(obj))
            return nil;
        // we haven't tried removing any obstructors yet
        pastObs = new Vector(8);
        // Repeatedly look for and attempt to remove obstructions.
        // There could be multiple things in the way, so try to remove
        // each one we find until either we fail to remove an
        // obstruction or we run out of obstructions.  
        for (;;) {
            local stat;
            local path;
            local result;
            local obs;
            // get the path for reaching out and touching the object
            path = sourceObj.getTouchPathTo(obj);
            // if we have a path, look for an obstructor
            if (path != nil) {
                // traverse the path to find what blocks our touch
                stat = sourceObj.traversePath(path, function(ele, op) {
                    // If we can continue the reach via this path element,
                    // simply keep going.  Otherwise, stop the reach here. 
                    result = ele.checkTouchViaPath(sourceObj, obj, op);
                    if (result.isSuccess) {
                        // no objection here - keep going
                        return true;
                    }
                    else {
                        // stop here, noting the obstruction
                        obs = ele;
                        return nil;
                    }
                });
                // if we now have a clear path, we're done - simply return
                // true to indicate that we ran one or more implicit
                // commands 
                if (stat)
                    return true;
            }
            else {
                // we have no path, so the object must be in an
                // unconnected location; we don't know the obstructor in
                // this case 
                obs = nil;
            }
            // 'result' is a CheckStatus object explaining why we can't
            // reach past 'obs', which is the first object that
            // obstructs our reach.
            // 
            // If the obstructor is not visible or we couldn't find one,
            // we can't do anything to try to remove it; simply report
            // that we can't reach the target object and give up.  
            if (obs == nil || !gActor.canSee(obs)) {
                reportFailure(&cannotReachObjectMsg, obj);
                exit;
            }
            // Ask the obstructor to get out of the way if possible.
            // 
            // If we've already tried to remove this same obstructor on
            // a past iteration, don't try again, as there's no reason
            // to think an implicit command will work any better this
            // time.
            if (pastObs.indexOf(obs) != nil
                || !allowImplicit
                || !obs.tryImplicitRemoveObstructor(touch, obj)) {
                // We can't remove the obstruction - either we've tried
                // an implicit command on this same obstructor and
                // failed, or we can't try an implicit command at all.
                // In any case, use the explanation of the problem from
                // the CheckStatus result object.  
                reportFailure(result.msgProp, result.msgParams...);
                exit;
            }
            // if the implied command failed, simply give up now -
            // there's no need to go on, since the implied command will
            // have already explained why it failed 
            if (gTranscript.isFailure)
                exit;
            // We've tried an implied command to remove this obstructor,
            // but that isn't guaranteed to make the target touchable,
            // as there could be further obstrutions, or the implied
            // command could have failed to actually remove the
            // obstruction.  Keep iterating.  To avoid looping forever
            // in the event the implicit command we just tried isn't
            // good enough to remove this obstruction, make a note of
            // the obstruction we just tried to remove; if we find it
            // again on a subsequent iteration, we'll know that we've
            // tried before to remove it and failed, and thus we'll know
            // to give up without making the same doomed attempt again. 
            pastObs.append(obs);
        }
    }
    verifyPreCondition(obj)
    {
        // If there's no source object, do nothing at this point.  We can
        // have a nil source object when we're resolving nouns for a
        // two-object action, and we have a cross-object condition (for
        // example, we require that the indirect object can touch the
        // direct object).  In these cases, when we're resolving the
        // first-resolved noun phrase, the second-resolved noun phrase
        // won't be known yet.  The only purpose of verification at times
        // like these is to improve our guess about an ambiguous match,
        // but we have nothing to add at such times, so we can simply
        // return without doing anything.  
        if (sourceObj == nil)
            return;
        // if we can't touch the object, make it less likely
        if (!sourceObj.canTouch(obj)) {
            // If we can't see the object, we must be able to sense it
            // by some means other than sight, so it must have a
            // sufficiently distinctive sound or odor to put it in
            // scope.  Explain this: "you can hear it but you can't see
            // it", or the like.  
            if (gActor.canSee(obj)) {
                local info;
                // It's visible but cannot be reached from here, so it
                // must be too far away, inside a closed but transparent
                // container, or something like that.
                // 
                // If it's at a distance, rule it illogical, since
                // there's not usually anything automatic we can do to
                // remove the distance obstruction.
                // 
                // If it's not distant, don't rule it illogical, but do
                // reduce the likelihood ranking, so that we'll prefer a
                // different object that can readily be touched.  Since
                // we can see where the object is, we might know how to
                // remove the obstruction to reachability.  
                info = gActor.bestVisualInfo(obj);
                if (info != nil && info.trans == distant) {
                    // it's distant - assume we can't fix this
                    inaccessible(&tooDistantMsg, obj);
                }
                else {
                    // it's not distant; rank it logical (since we might
                    // be able to clear the obstruction with an implied
                    // action), but at reduced likelihood (in case
                    // there's something that doesn't need any prior
                    // implied action to reach) 
                    logicalRankOrd(80, 'unreachable but visible', 150);
                }
            }
            else {
                // if it has a sound presence, then "you can hear it but
                // you can't see it"; if it has a smell presence, then
                // "you can smell it but you can't see it"; otherwise,
                // you simply can't see it 
                if (obj.soundPresence && gActor.canHear(obj))
                {
                    // it can be heard but not seen
                    inaccessible(&heardButNotSeenMsg, obj);
                }
                else if (obj.smellPresence && gActor.canSmell(obj))
                {
                    // it can be smelled but not seen
                    inaccessible(&smelledButNotSeenMsg, obj);
                }
                else if (!gActor.isLocationLit())
                {
                    // it's too dark to see the object
                    inaccessible(&tooDarkMsg);
                }
                else
                {
                    // it simply cannot be seen
                    inaccessible(&mustBeVisibleMsg, obj);
                }
            }
        }
    }
    // This condition tends to be fragile, in the sense that other
    // preconditions for the same action have the potential to undo any
    // implicit action that we perform to make an object touchable.  This
    // is most likely to happen when we implicitly move the actor (moving
    // in or out of a nested room, for example) to put the actor within
    // reach of the target object.  To reduce the likelihood that this
    // fragility will be visible to a player, try to execute this
    // condition after other conditions.  Most other preconditions tend
    // to be "stickier" - less likely to be undone by subsequent
    // preconditions.  
    preCondOrder = 200
;

// -------------------------------------------------------------------
// NETON/OVAN CONVERSATION: Preliminary handling.
// -------------------------------------------------------------------

modify Professional
  dobjFor(TalkTo) {
    verify { }
    check { }
    action {
      //"<font color=blue>confDaemon.daemonState == <<confDaemon.daemonState>></font>\b";
      if (!glob.isInEndgame) {
        switch (confDaemon.daemonState) {
          case 3:
            "You start to speak, but the alien in the green 
                jacket raises his hand. 
              <p><.q>Just a moment,<./q> he says. <.q>We will 
                answer all your questions shortly.<./q> ";
            break;
          case 4:
            nocMainFuture.select;
            break;
          case 5:
            nocMainWar.select;
            break;
          case 6:
            nocMainOo.select;
            break;
          case 7:
            nocMainIf.select;
            break;
          case 8:
            nocMainCryo.select;
            break;
          case 9:
            nocMainGame.select;
            break;
          case 10:
            nocMainMazes.select;
            break;
          case 11:
            nocMainNbm.select;
            break;
          //case 12:
          //  
          //  break;
          //case 13:
          //  
          //  break;
          //case 14:
          //  
          //  break;
          //case 15:
          //  
          //  break;
          //case 16:
          //  
          //  break;
          //case 17:
          //  
          //  break;
          //case 18:
          //  
          //  break;
          //case 19:
          //  
          //  break;
          //case 20:
          //  
          //  break;
          default:
            "You can<./s>t think of anything to say. ";
        }
      }
      else {
        "<<endgameTalkMsg(glob.pluralTalkers)>>";
      }
    }
  }
;

// -------------------------------------------------------------------
// NETON/OVAN CONVERSATION: The initial two questions.
// -------------------------------------------------------------------

modify glob
  guardGunName = 'hand cannon'
  saltMinesFlag = nil
  pcKnowsAboutRule = nil
  aliensKnowPcLikesIf = nil
  pcChoseHypertext = nil
  mentionedBetaTesting = nil
  mentionedWindCryo = nil
;

modify Quip
  saltMines(arg1, arg2) {
    if (!glob.saltMinesFlag) {
      say(arg1);
      "what are things like in the salt mines? 
          Do we need any more laborers there?<./q> 
        <p><.q>No, I think the mines are as full 
          as they can get at this point,<./q> says <<ovan.autoName>>.
        <p><.q>Very well,<./q> says <<neton.autoName>>. With that, he turns
          to the younger of the two guards.
        <p><.q>Please dispose of the prisoner,<./q> he says. <p>";
      glob.saltMinesFlag = true;
    }
    else {
      say(arg2);
      "since the salt mines are full, please dispose 
        of the prisoner immediately.<./q> <p>";
    }
    "The guard<./s>s face lights up. He raises his
      <<glob.guardGunName>> and carefully aims it
      straight at you. ";
  }
  guardConfKill() {
    "The guard fires his <<glob.guardGunName>> at you. 
        For a moment you are engulfed in blinding light and 
        agonizing pain. Then you collapse to the floor. 
      <p>In case it is any consolation, you should know that 
        the guard tremendously enjoyed killing you. 
        In times like this, it may be a comfort to know 
        that you have not died in vain. ";
    endGame(ftDeath);
  }
  introduceNetonOvan() {
    "Then the alien in the green jacket turns to you 
        and says, <.q>Let me introduce myself. My name 
        is Neton. I am the director of the Institute of 
        Humanities at the Center for Earthological Studies, 
        Australian Campus.<./q> 
      <p><.q>And my name is Ovan,<./q> says the alien in the 
        yellow jacket. <.q>I<./s>m an assistant professor of 
        interactive fiction, also at CESAC Humanities.<./q> 
      <p><.q>Now, Mr. <<me.lastName>>, as you know,<./q> says Neton, 
        <.q>you elected to be cryogenically frozen upon your death. 
        And when you had a heart attack in 2026, you were 
        indeed cryogenically frozen.<./q> 
      <p><.q>And it<./s>s a good thing, too,<./q> says Ovan. 
        <.q>Otherwise you wouldn<./s>t be here right now!<./q> 
      <p>Neton casts Ovan an irritable glance. Then, 
        turning back to you, he says, 
        <.q>It is now, by your calendar, the year 2189.<./q> ";
    neton.hasBeenIdentified = true;
    ovan.hasBeenIdentified = true;
  }
  ovanSarcastic =
    "\^<<ovan.autoName>> rolls his eyes, 
      then says, <.q>Okay, thanks for confirming that.<./q> "
;

nocMainUnderstand: QMain
  options = [
     nocUndYes
    ,nocUndNo
    ,nocUndSilence
  ]
  zeroOption = nocUndSilence
;

nocUndYes: Quip
  "<.q>Yes.<./q> "
  "<.q>Yes,<./q> you say. 
    <p><.q>Ah, good,<./q> says the alien in the green jacket. 
    <p><<nocSubName.reply>>"
  transfer = nocSubName
;

nocUndNo: Quip
  "<.q>No.<./q> "
  "<.q>No,<./q> you say. 
    <p>The two aliens stare at you for a long moment. 
    <p>Then the one in the green jacket turns to his companion 
      and says, <.q>Evidently the human is making some sort 
      of joke. He says that he cannot understand us, yet his 
      answer indicates that he can.<./q> 
    <p><.q>Well, if he can understand us, then I guess we
      can continue,<./q> says his companion. 
    <p><.q>Yes, I agree.<./q> 
    <p><<nocSubName.reply>>"
  transfer = nocSubName
;

nocUndSilence: Quip
  "Stare at them silently. "
  reply() {
    "You stare at them silently. 
      <p>The two aliens wait for several seconds. Finally they 
        glance at each other nervously. 
      <p><.q>Is it possible the knowledge infusion process 
        was unsuccessful?<./q> asks the one in the green jacket. 
      <p><.q>We<./s>ve had great success rates,<./q> 
        his companion replies, <.q>but we can<./s>t rule out
        that some humans might just be too stupid to learn 
        our language.<./q> 
      <p>The one in the green jacket sighs. <.q>This is disappointing.
        I had such high hopes for this human. But of course
        if he can<./s>t understand us, then he<./s>s of no
        use to us."; // sic; no closing quote
    saltMines(
      ' Okay, in that case, ',
      '<./q> Then, turning to the guard, he says, <.q>In that case, '
    );
  }
  options = [
     nocUnd2Yes
    ,nocUnd2Silence
  ]
  zeroOption = nocUnd2Silence
;

nocUnd2Yes: Quip
  "<.q>No, wait! I was just kidding. Actually, I do understand you.<./q> "
  "<.q>No, wait!<./q> you shout. <.q>I was just kidding. Actually, 
      I do understand you.<./q> 
    <p><.q>What<./s>s this?<./q> says the alien in the green jacket. Then he 
      shrugs and says, <.q>So he understands us after all. Very well, 
      in that case we can continue.<./q> 
    <p><<nocSubName.reply>>"
  transfer = nocSubName
;

nocUnd2Silence: Quip
  "Stare at them silently. "
  "You stare at them silently. 
    <p><<guardConfKill>>" // You die!
;

nocSubName: QSub
  reply() {
    "With that, the alien in the yellow jacket turns to you and says, 
        <.q>And another question.<./q> He shuffles some 
        papers around in front of him, then asks, 
        <.q>Are you <<me.fullName>>, born July 23, 1966, 
        in St. Cloud, Minnesota, USA, 
        with social security number 078-05-1120?<./q> 
      <p>Your eyes widen. You don<./s>t know where he got this from, 
        but it<./s>s exactly right. ";
    me.hasExplainedOrigin = true;
  }
  options = [
     nocNameYes
    ,nocNameNo
    ,nocNameSilence
  ]
  zeroOption = nocNameSilence
;

nocNameYes: Quip
  "<.q>Yes, that<./s>s me.<./q> "
  "<.q>Yes, that<./s>s me,<./q> you say. 
    <p>The alien in the yellow jacket replies, 
      <.q>Great! Thanks for confirming that.<./q>
    <p><<introduceNetonOvan>>" // successful conclusion
;

nocNameNo: Quip
  "<.q>No, that<./s>s not me.<./q> "
  "<.q>No, that<./s>s not me,<./q> you say. 
    <p><.q>What?<./q> cries the alien in the yellow jacket. 
      <.q>But our records say you<./s>re 
      <<me.fullName>>! Are you sure that<./s>s wrong?<./q> "
  options = [
     nocNameNoConfirm
    ,nocNameNoDisconfirm
  ]
  zeroOption = nocNameNoSilence
;

nocNameNoDisconfirm: Quip
  "<.q>No, I was just kidding. Actually, I am <<me.fullName>>.<./q> "
  "<.q>No, I was just kidding,<./q> you say. <.q>Actually, I am 
      <<me.fullName>>.<./q> 
    <p><<ovanSarcastic>>
    <p><<introduceNetonOvan>>" // successful conclusion
;

nocNameNoConfirm: Quip
  "<.q>Yes, your records are wrong. That<./s>s not me.<./q> "
  reply() {
    "<.q>Yes, your records are wrong,<./q> you say. 
        <.q>That<./s>s not me.<./q>
      <p><.q>I don<./s>t believe this!<./q> cries the alien 
        in the yellow jacket. 
      <p>His companions sighs and says, <.q>After all the effort 
        we went through to 
        revive him, it turns out he<./s>s not <<me.fullName>>.
        Of course, in that case, he<./s>s of no use to us.";
    saltMines(
      ' Well, all right. In that case, ',
      ' Well, so be it.<./q> Then, turning to the younger 
        of the two guards, he says, <.q>In that case, '
    );
  }
  options = [
     nocNameNoConfirmWait
    ,nocNameNoConfirmSilence
  ]
  zeroOption = nocNameNoConfirmSilence
;

nocNameNoConfirmWait: Quip
  "<.q>No, wait! I was just kidding. Actually, I am 
    <<me.fullName>>.<./q> "
  "<.q>No, wait!<./q> you say. <.q>I was just kidding. Actually, 
      I am <<me.fullName>>.<./q> 
    <p><<ovanSarcastic>> 
    <p><<introduceNetonOvan>>" // successful conclusion
;

nocNameNoConfirmSilence: Quip
  "Stare at them silently. "
  "You stare at them silently. 
    <p><<guardConfKill>>" // You die!
;

nocNameNoSilence: Quip
  "Stare at them silently. " // probably will never be seen
  reply() {
    "You stare at them silently. 
      <p>Nobody says a word for several long seconds. 
      <p>Finally the one in the yellow jacket turns 
        to his companion and says, <.q>Well, I guess 
        we have to believe him. If he says he<./s>s not 
        <<me.fullName>>, he must not be <<me.fullName>>.<./q> 
      <p><.q>Of course, in that case he<./s>s useless to us,<./q>
        says his companion, shaking his head. ";
    saltMines(
      '<.q>How disappointing. But all right. In that case, ',
      'Then, turning to the younger of the two guards, he says, <.q>\^'
    );
  }
  options = [
     nocNameNoSilenceWait
    ,nocNameNoSilenceSilence
  ]
  zeroOption = nocNameNoSilenceSilence
;

nocNameNoSilenceWait: Quip
  "<.q>No, wait! I was just kidding. Actually, I am <<me.fullName>>.<./q> "
  "<.q>No, wait!<./q> you shout. <.q>I was just kidding. 
      Actually, I am <<me.fullName>>.<./q> 
    <p><<ovanSarcastic>> 
    <p><<introduceNetonOvan>>" // successful conclusion
;

nocNameNoSilenceSilence: Quip
  "Stare at them silently. "
  "You stare at them silently. 
    <p><<guardConfKill>>" // You die!
;

nocNameSilence: Quip
  "Stare at them silently. " // probably will never be outputted.
  reply() {
    "You stare at them silently. 
      <p>Nobody says a word for several long seconds. 
      <p><.q>It seems the human is being uncooperative,<./q> 
        says the one in the green jacket. 
      <p>His companion lets out a long sigh. <.q>That<./s>s true,<./q> 
        he says. <.q>And if he won<./s>t cooperate, he<./s>s of no
        use to us. Even if he <i>is</i> <<me.fullName>>.<./q> 
      <p><.q>All right,<./q> says the one in the green 
        jacket. ";
    saltMines(
      '<.q>In that case, ',
      'Then, turning to the guard, he says, <.q>\^'
    );
  }
  options = [
     nocNameSilenceYes
    ,nocNameSilenceNo
    ,nocNameSilenceSilence
  ]
  zeroOption = nocNameSilenceSilence
;

nocNameSilenceYes: Quip
  "<.q>No, wait! Sorry, I didn<./s>t hear you at first. 
      Actually, I am <<me.fullName>>.<./q> "
  "<.q>No, wait!<./q> you shout. <.q>Sorry, I didn<./s>t hear you 
      at first. Actually, I am <<me.fullName>>.<./q> 
    <p><<ovanSarcastic>> 
    <p><<introduceNetonOvan>>" // successful conclusion
;

nocNameSilenceNo: Quip
  "<.q>No, wait! Sorry, I didn<./s>t hear you at first. 
      The fact is, you<./s>re wrong. I am not <<me.fullName>>.<./q> "
  "<.q>No, wait!<./q> you shout. <.q>Sorry, I didn<./s>t hear you at first. 
      The fact is, you<./s>re wrong. I am not <<me.fullName>>.<./q> 
    <p>The alien in the yellow jacket sighs, then 
      calls to the guard, <.q>Hit him with all you got!<./q> 
    <p><<guardConfKill>>" // You die!
;

nocNameSilenceSilence: Quip
  "Stare at them silently. "
  "You stare at them silently. 
    <p><<guardConfKill>>" // You die!
;

// -------------------------------------------------------------------
// NETON/OVAN CONVERSATION: After they tell you it's the year 2189.
// -------------------------------------------------------------------

nocMainFuture: QMain
  options = [
     nocFutureRuins
    ,nocFutureAliens
    ,nocFutureWhere
    ,nocFutureIf
    ,nocFutureKnow
    ,nocFutureFind
  ]
;

modify Quip
  justBePatient(arg) {
    "<.q><<arg>>I<./s>ll be getting to that,<./q> says Neton.
      <p><.q>Just be patient,<./q> adds Ovan. ";
  }
;

nocFutureRuins: Quip
  "<.q>What on earth happened while I was asleep? I saw 
      human habitation in ruins.<./q> "
  //"<.q>What on earth happened while I was asleep?<./q> 
  //    you ask. <.q>I saw human habitation in ruins.<./q> 
  //  <p><<justBePatient('')>>"
  "<.q>What on earth happened while I was asleep?<./q> 
      you ask. <.q>I saw human habitation in ruins.<./q> 
    <p><.q>I think Neton was just about to explain that,<./q>
      says Ovan. "
;
nocFutureAliens: Quip
  "<.q>What kind of creatures are you? Aliens?<./q> "
  reply() {
    "<.q>What kind of creatures are you?<./q> you ask. 
        <.q>Aliens?<./q> 
      <p><.q>Yes, we are from outside your
        solar system,<./q> says Neton. <.q>But 
        I<./s>ll be getting to that.<./q>
      <p><.q>Just be patient,<./q> adds Ovan. ";
    glob.pcKnowsTheyreAliens = true;
  }
;
nocFutureWhere: Quip
  "<.q>Where am I?<./q> "
  "<.q>Where am I?<./q> you ask. 
    <p><.q>You are at the Center for Earthological Studies,
      Australian Campus,<./q> says Ovan. "
;
nocFutureIf: Quip
  "<.q>Wait a minute. Did you say <.s>professor
      of interactive fiction<./s>?<./q> "
  "<.q>Wait a minute,<./q> you say. <.q>Did you say 
      <.s>professor of interactive fiction<./s>?<./q> 
    <p><.q>Yes,<./q> says Ovan. <.q>But we<./s>ll get to
      that. For now, there is much more to explain.<./q> "
;
nocFutureKnow: Quip
  "<.q>How do you know all this stuff about me?<./q> "
  "<.q>How do you know all this stuff about me?<./q> 
      you ask. 
    <p><<justBePatient('')>>"
;
nocFutureFind: Quip
  "<.q>How did you find me, in order to wake me up?<./q> "
  "<.q>How did you find me, in order to wake me up?<./q> 
      you ask. 
    <p><<justBePatient('')>>"
;

// -------------------------------------------------------------------
// NETON/OVAN CONVERSATION: After they tell you about the nuclear war.
// -------------------------------------------------------------------

modify glob
  pcKnowsTheyreAliens = nil
;

modify Quip
  veryInquisitive =
    "<.q>Our guest is very inquisitive!<./q> Ovan says 
        to Neton, and chuckles. 
      <p>Neton says to you, <.q>It<./s>s commendable of you 
        to take an interest in ancient Earth history, 
        but we will have to save that for another time. 
        Right now we have other things to discuss.<./q> "
;

nocMainWar: QMain
  options = [
     nocWarTerrorists
    ,nocWarElection
    ,nocWarPopulations
    ,nocWarTechnology
    ,nocWarExplain
    ,nocWarCondolences
  ]
;

nocWarTerrorists: Quip
  "<.q>Terrorists? What terrorists?<./q> "
  "<.q>Terrorists?<./q> you ask. <.q>What terrorists?<./q> 
    <p><<veryInquisitive>>"
;

nocWarElection: Quip
  "<.q>The presidential election? What was that all 
      about?<./q> "
  "<.q>The presidential election?<./q> you ask. 
      <.q>What was that all about?<./q> 
    <p><<veryInquisitive>>"
;

nocWarPopulations: Quip
  "<.q>What do you mean, <.s>few populations<./s>? 
      Who survived?<./q> "
  "<.q>What do you mean, <.s>few populations<./s>?<./q> 
      you ask. <.q>Who survived?<./q> 
    <p>Ovan turns to Neton and asks, <.q>I think 
      there are still a few thousand humans left, 
      aren<./s>t there?<./q> 
    <p><.q>Yes, about ten or twenty thousand people, 
      all of them 
      with stone-age technology,<./q> Neton replies. 
      <.q>That is, except for one or two cryogenically 
      unfrozen ones, like you, but we<./s>ll be 
      getting to that momentarily.<./q> "
;

nocWarTechnology: Quip
  "<.q>What do you mean, <.s>few exceptions<./s>? 
      What technology survived?<./q> "
  "<.q>What do you mean, <.s>few exceptions<./s>?<./q> 
      you ask. <.q>What technology survived?<./q> 
    <p>Ovan looks at Neton and says, <.q>Here in 
      Australia, one tribe scavenged some lawnmower 
      blades and started using them as weapons. 
      Does that count?<./q>
    <p>Neton replies, <.q>Well, the humans 
      only scavenged them; they didn<./s>t make the
      blades themselves. So I don<./s>t know if that
      counts. And if it doesn<./s>t count, then I guess
      there is no better-than-stone-age human
      technology right now. Forgive me if I misspoke.<./q> "
;

nocWarExplain: Quip
  "<.q>That doesn<./s>t exactly explain why you<./s>re 
      here.<<areYouAliens>><./q> "
  reply() {
    "<.q>That doesn<./s>t exactly explain why you<./s>re 
        here,<./q> you say. ";
    if (!glob.pcKnowsTheyreAliens)
      "<.q>Are you aliens or what?<./q> ";
    "<p><.q>Well, perhaps we should discuss that,<./q> 
      Neton says. ";
  }
  areYouAliens() {
    if (!glob.pcKnowsTheyreAliens)
      " Are you aliens or what?";
  }
;

nocWarCondolences: Quip
  "<.q>Condolences! That<./s>s supposed to make me feel 
      better?<./q> "
  "<.q>Condolences!<./q> you cry. <.q>That<./s>s supposed 
      to make me feel better?<./q> 
    <p><.q>Yes,<./q> says Ovan, <.q>it says so 
      in the <i>Journal of Twenty-First Century 
      Earth Etiquette.<./q></i> He fiddles with his tablet device 
      for a few seconds, then points at the screen. 
      <.q>Yes, right here.<./q>
    <p>Neton nods in agreement. "
;

// -------------------------------------------------------------------
// NETON/OVAN CONVERSATION: After they tell you about the Oo arrival on Earth.
// -------------------------------------------------------------------

nocMainOo: QMain
  options = [
     nocOoNotMuch
    ,nocOoInterstellar
    ,nocOoName
    ,nocOoStar
    ,nocOoMission
    ,nocOoHelp
    ,nocOoSpaceship
  ]
;

nocOoNotMuch: Quip
  "<.q>What do you mean, not much to study here?<./q> "
  "<.q>What do you mean, not much to study here?<./q>
      you ask. 
    <p>Ovan chuckles and says, without a hint of irony, 
      <.q>Well, that<./s>s easy! <.s>Not much to 
      study<./s> simply means that there isn<./s>t much 
      to find out more about!<./q> 
    <p><.q>Well stated,<./q> says Neton.
    <p><.q>Thanks,<./q> says Ovan. 
      <.q>I like to help people when I can.<./q> "
;

//o,a,e,oo,ee,i,
//ntvrlskfmz
//zoozavonitoofoofomavalekeesokanos
//sarevoovekoonataleevasokanos
nocOoInterstellar: Quip
  "<.q>What kind of technology allowed you to achieve 
      interstellar travel?<./q> "
  reply {
    "<.q>What kind of technology allowed you to achieve 
        interstellar travel?<./q> you ask. 
      <p><.q>That<./s>s a very good question, and it has to 
        do with a pivotal moment in 
        Oo science,<./q> says Neton, starting to get 
        excited for the first time. 
        <.q>You see, for decades our scientists 
        were working as hard as they could 
        to <i>oolesona</i> <i>avenatos,</i> or at least 
        <i>bavoona</i> <i>teek</i> <i>eefoms,</i>
        in an effort to achieve <i>tooloval,</i>
        without much success. Then, finally, a scientist 
        named Tero came along said, <.s>Hey, wait a 
        minute. What if, instead of busting our tails to
        <i>oolesona</i> these <i>avenatos,</i> 
        we just <i>koroomaed</i> a bunch of 
        <i>toofomavalekeesokanos?</i>
        Then, if we were careful to align the
        <i>sarekoonatasokanos</i> with perfect precision, 
        we might well achieve <i>tooloval</i> 
        as a natural consequence.<./s> That was the crucial 
        insight. After that&mdash;<./q>
      <p>At this point Ovan raises his hand and interrupts.
        <.q>Pardon me, Neton, but I don<./s>t think
        our language infusion process uses the 
        vocabulary for understanding modern physics.
        Most likely, this human doesn<./s>t understand a word
        you<./s>re saying.<./q>
      <p><.q>Oh,<./q> says Neton. <.q>Well, in that case,
        nevermind. Shall we move on?<./q>
      <p><.q>Yes, let<./s>s,<./q> says Ovan. ";
    hasBeenUttered = true;
  }
  hasBeenUttered = nil
;
nocOoName: Quip
  "<.q><.s>Oo<./s>? What kind of name is that?<./q> "
  "<.q><.s>Oo<./s>?<./q> you say. <.q>What kind of 
      name is that?<./q> 
    <p>Ovan chuckles and says, without a hint of irony, 
      <.q>Well, that<./s>s easy! <.s>Oo<./s> is 
      the kind of name you can use to refer to the Oo!<./q> 
    <p><.q>Well stated,<./q> says Neton.
    <p><.q>Thanks,<./q> says Ovan. 
      <.q>I like to help people when I can.<./q> "
;
nocOoStar: Quip
  "<.q>What star system are you from, anyway?<./q> "
  "<.q>What star system are you from, anyway?<./q> 
      you ask. 
    <p><.q>We just call it the Oo system,<./q> says Ovan.
      Then, turning to Neton, he asks,
      <.q>What do Earthlings call it again?<./q>
    <p><.q>The Earthling name for our home star is 
      <<ooStar.starName>>,<./q> says Neton.
    <p><.q>How catchy,<./q> says Ovan, rolling his eyes. 
      <.q>No wonder I can never remember it.<./q> "
;

/*
Star possibilities:
Name            Dist.  Age
HD 98618       126 LY  4,300,000,000 years
18 Scorpii      46 LY  ?
37 Geminorum    56 LY  5,500,000,000 years
51 Pegasi       42 LY  ?
Beta Canum      27 LY  4,000,000,000 years
  Venaticorum
HD 172051:      42 LY  ?
*/

ooStar: object
  starName = 'HD 98618'
  starDist = '126' // light years
;

nocOoMission: Quip
  "<.q>Your ship<./s>s <.s>primary mission<./s>&mdash;what 
      was that?<./q> "
  reply {
    "<.q>Your ship<./s>s <.s>primary mission<./s>&mdash;what 
        was that?<./q> you ask. 
      <p>Ovan furrows his brow. <.q>Hey, that<./s>s a good 
        question, actually. What was their mission?<./q>
      <p>Neton leans closer to Ovan and lowers his voice.
        <.q>Ask me that sometime when the human is not around.
        Obviously, he doesn<./s>t have that kind of 
        security clearance.<./q> 
      <p><.q>Ah yes, good point,<./q> says Ovan. ";
    hasBeenUttered = true;
  }
  hasBeenUttered = nil
;
nocOoHelp: Quip
  "<.q>No doubt you stayed because you wanted to help 
      the survivors of the nuclear holocaust. 
      How has that gone?<./q> "
  reply() {
    "<.q>No doubt you stayed because you wanted to help 
        the survivors of the nuclear holocaust,<./q>
        you say. <.q>How has that gone?<./q> 
      <p>The aliens give you a long, blank stare. 
      <p>Then Neton replies, <.q>Uh, yes. 
        In a sense, perhaps it might be desirable 
        to help the surviving 
        humans a bit. The problem is, though, we are
        bound by a directive that we call Rule Number One.
        According to this rule, we are not allowed to interfere
        with the natural development of other alien 
        cultures&mdash;unless we really feel like it.<./q> 
      <p><.q>And, you see, this is a case where we don<./s>t 
        really feel like it,<./q> says Ovan, smiling cheerfully. ";
    glob.pcKnowsAboutRule = true;
  }
;
nocOoSpaceship: Quip
  "<.q>What makes you think they<./s>ll send another 
      spaceship back?<./q> "
  "<.q>What makes you think they<./s>ll send another 
      spaceship back?<./q> you ask. 
    <p><.q>Well, they told us they would,<./q> says Ovan.
      <.q>Or, rather, they told our grandparents.<./q> ";
  //"<p><.q>Well stated,<./q> says Neton.
  //  <p><.q>Thanks,<./q> says Ovan. 
  //    <.q>I like to help people when I can.<./q> "
;

// -------------------------------------------------------------------
// NETON/OVAN CONVERSATION: After they tell you they like IF.
// -------------------------------------------------------------------

nocMainIf: QMain
  options = [
     nocIfKnow
    ,nocIfDunno
    ,nocIfArt
    ,nocIfPainting
    ,nocIfHelp
  ]
;

nocIfKnow: Quip
  "<.q>Who, me? Yeah, I like interactive fiction 
      well enough.<./q> "
  reply() {
    "<.q>Who, me?<./q> you say. <.q>Yeah, I like 
        interactive fiction well enough.<./q> 
      <p><.q>Good,<./q> says Ovan. <.q>That<./s>s 
        what our records say. Thanks 
        for confirming that.<./q> ";
    glob.aliensKnowPcLikesIf = true;
  }
;
nocIfDunno: Quip
  "<.q>Who, me? But I<./s>ve never heard of\ .\ .\ . 
      Uh, what<./s>s interactive fiction?<./q> "
  reply() {
    "<.q>Who, me?<./q> you say. <.q>But I<./s>ve never heard 
        of\ .\ .\ . Uh, what<./s>s interactive 
        fiction?<./q> 
      <p>Neton and Ovan glance at each other 
        uncertainly.
      <p><.q>But&mdash;but&mdash;this can<./s>t be!<./q> 
        cries Ovan.
      <p><.q>Indeed, it cannot be,<./q> says Neton. Grabbing
        a stack of papers from the table, he says to you, <.q>You see,
        as we were just about to explain, we possess 
        your cryogenic records. And right here,<./q> 
        he says, pointing to a 
        particular spot, <.q>in this blank, marked 
        <.s>interests,<./s> you wrote <.s>interactive fiction.<./s> 
        Or, anyway, that<./s>s what <i>somebody</i> wrote, 
        and they wrote it in the exact same handwriting
        that they used to sign the name <.s><<me.fullName>><./s> 
        at the bottom. ";
    //"Now, you confirmed that your name is <<me.fullName>>. ";
    "So, Mr. <<me.lastName>>,
        are you still going to maintain that you have never
        played interactive fiction?<./q> ";
    cryoPapers.moveInto(neton);
  }
  transfer = nocPlayedNo
;
nocIfArt: Quip
  "<.q>But how can you turn up your noses to art, 
      literature, and music?<./q> "
  "<.q>But how can you turn up your noses to art, 
      literature, and music?<./q> you ask. 
    <p>For a long moment, Neton and Ovan look at 
      each other. Then, abruptly, they both burst out 
      laughing. 
    <p><.q>Humans say the funniest things!<./q> 
      says Ovan.
    <p><.q>To be fair,<./q> says Neton, 
      <.q>ancient non-interactive media 
      do have a certain historical interest. 
      But, non-interactive as they are, they are 
      now seen as dull, quaint, and virtually 
      obsolete.<./q>
    <p>Ovan stops laughing and takes on an 
      earnest expression. 
      <.q>I mean, think of a writer&mdash;say, 
      William Shakespeare. In years gone by, people 
      obviously thought he was pretty good. 
      But honestly, 
      who would bother to read Shakespeare<./s>s novels now, 
      after the towering achievements 
      of William Crowther, Don Woods, and Scott Adams?<./q>
    <p>You are stunned to silence. "
;
nocIfPainting: Quip
  "<.q>Name one <i>painting</i> about interactive 
      fiction.<./q> "
  "<.q>Name one <i>painting</i> about interactive 
      fiction,<./q> you say. 
    <p>Neton looks at you uncomprehendingly, then says, 
      <.q>I suppose if I had to name one, it might be 
      <i>The Nameless Adventurer of the Never-Ending Cave.<./q></i> 
      He pauses. <.q>Or no, wait, I think it might be 
      <i>The Not-Very-Well-Described Beast of the 
      Generic Dungeon.<./q></i>
    <p><.q>I think I prefer more modern works,<./q> 
      says Ovan. <.q>Who could forget the majesty 
      of <i>Infinite Maze,</i> or the awful pathos 
      of <i>Death by Hunger?<./q></i>
    <p><.q>Now that I think about it, that was 
      a good question,<./q> says Neton. <.q>If one were 
      forced to name only one painting about 
      IF, it would be difficult to choose.<./q>
    <p>You are stunned to silence. "
;
nocIfHelp: Quip
  "<.q>How can you sit there and talk about 
      interactive fiction when there are people 
      out there who need help?<./q> "
  reply() {
    "<.q>How can you sit there and talk about 
        interactive fiction when there are people 
        out there who need help?<./q> you ask. ";
    if (glob.pcKnowsAboutRule) {
      //"<p><.q>What?<./q> cries Ovan. <.q>But we
      //    already told you about Rule Number One.<./q> ";
      "<p><.q>Well, we already told you about Rule
          Number One,<./q> says Neton. <.q>Nevertheless,
          I think I understand your question. 
          As you know, Rule Number One says that
          we can<./s>t interfere with alien cultures 
          unless we feel like it. Perhaps this sounds like
          an open-ended rule that permits just anything,
          but that is not the case. The rule is extremely strict.
          If Ovan or I didn<./s>t feel like interfering
          with an alien culture, but did so anyway,
          the dean of CESAC would find out,
          and he would almost certainly give us a severe 
          reprimand.<./q> 
        <p>Ovan adds, <.q>And it<./s>s not as simple 
          as lying to the dean, either. He has access
          to the campus<./s>s brain-wave pattern scanner,
          so he can find out what we genuinely want to do.
          So, as it turns out, until we truly develop
          a genuine desire to help out Earthlings, 
          our hands are tied.<./q> ";
      glob.pcKnowsMoreAboutRule = true;
    }
    else {
      "<p>The aliens give you a long, blank stare.
        <p>Then Neton replies, <.q>Uh, yes. 
          In a sense, it might be desirable 
          to help the surviving 
          humans a bit. The problem is, though, we are
          bound by a directive that we call Rule Number One.
          According to this rule, we are not allowed to interfere
          with the natural development of other alien 
          cultures&mdash;unless we really feel like it.<./q> 
        <p><.q>And, you see, this is a case where we don<./s>t 
          really feel like it,<./q> says Ovan, smiling cheerfully. ";
      glob.pcKnowsAboutRule = true;
    }
  }
;

modify glob
  pcKnowsMoreAboutRule = nil
;

// -------------------------------------------------------------------
// NETON/OVAN CONVERSATION: If/when they ask you whether you've played IF.
// -------------------------------------------------------------------

// Note: this set of quips won't be called if you have previously
// volunteered the information that you've played IF.

modify Quip
  explainBetaTesting() {
    //"<font color=blue>Quip.explainBetaTesting has called the following stuff: \b</font>";
    confDaemon.daemonState = 8;
    confDaemon.daemon();
    //confDaemon.daemonState = 8;
  }
;

nocMainPlayed: QMain
  options = [
     nocPlayedYes
    ,nocPlayedNo
  ]
  zeroOption = nocPlayedSilence
;

nocPlayedYes: Quip
  "<.q>Yes, I<./s>ve played interactive fiction.<./q> "
  reply() {
    "<.q>Yes, I<./s>ve played interactive fiction,<./q> you say. 
      <p><.q>Okay, great!<./q> Ovan replies. 
        <.q>Thanks for confirming that.<./q> ";
    if (glob.mentionedWindCryo)
      "<p><<explainBetaTesting>>";
    glob.aliensKnowPcLikesIf = true; // successful conclusion
  }
;
nocPlayedNo: Quip
  "<.q>Who, me? I<./s>ve never played interactive fiction.<./q> "
  reply() {
    "<.q>Who, me? I<./s>ve never played interactive fiction,<./q> 
        you say. You don<./s>t sound very convincing.
      <p><.q>I can<./s>t believe what I<./s>m hearing!<./q>
        screams Ovan.
      <p><.q>Neither can I,<./q> says Neton, who suddenly grabs
        a stack of papers from the table.
        <.q>You see, we have your cryogenics file 
        right here. And right here,<./q> he says, 
        pointing to a particular spot, 
        <.q>in the blank marked <.s>interests,<./s> 
        you wrote <.s>interactive fiction.<./s> 
        Or, anyway, that<./s>s what <i>somebody</i> wrote, 
        and they wrote it in the exact same handwriting
        that they used to sign the name <.s><<me.fullName>><./s> 
        at the bottom. ";
    //"Now, you confirmed that your name is <<me.fullName>>. ";
    "So, Mr. <<me.lastName>>,
        are you still going to maintain that you have never
        played interactive fiction?<./q> ";
    cryoPapers.moveInto(neton);
  }
  options = [
     nocPlayedNoKidding
    ,nocPlayedNoAnother
    ,nocPlayedNoLied
    ,nocPlayedNoHypertext
  ]
  zeroOption = nocPlayedNoSilence
;

nocPlayedNoKidding: Quip
  //, I<./s>m not going to say that
  "<.q>Uh, no. 
      Sorry, I was just kidding you.
      Actually, I have played 
      interactive fiction.<./q> "
  reply() {
    "<.q>Uh, no,<./q> you say.
        <.q>Sorry, I was just kidding you.
        Actually, I have played 
        interactive fiction.<./q> 
      <p><<ovanSarcastic>>";
    if (glob.mentionedWindCryo)
      "<p><<explainBetaTesting>>";
    glob.aliensKnowPcLikesIf = true; // successful conclusion
  }
;

class NocPlayedNoQuip: Quip
  reply() {
    doConsequences;
    "<<restatedName>>
      <p><<ovanOutburst>>
      <p><<netonReply1>>"; // sic; no final space or quotation mark
    saltMines(
      ' Fine, then. In that case, ',
      '<./q> Then, turning to the guard, he says, 
        <.q>Well, fine. In that case, '
    );
  }
  ovanOutburst =
    "<.q>This is outrageous!<./q> shouts Ovan. "
  netonReply1 =
    "<.q>All right,<./q> Neton says, and breathes a heavy
        sigh. <.q><<unconvincingStr>> really 
        doesn<./s>t know 
        <<claimsToKnowNothing ? 'anything' : 'much'>> about 
        <<glob.pcChoseHypertext 
          ? 'the type of IF we<./s>re talking about'
          : 'IF'>>, 
        or else he<./s>s just 
        being uncooperative. Either way, 
        he<./s>s of no use to us." // sic; no final space or quotation mark
  unconvincingStr = "The human<./s>s story is unlikely, 
    but it doesn<./s>t matter. Either he"
  claimsToKnowNothing = true
  options = [
     nocPlayedNoNoWait
    ,nocPlayedNoNoSilence
  ]
  zeroOption = nocPlayedNoNoSilence
;

nocPlayedNoAnother: NocPlayedNoQuip
  "<.q>Well, apparently those records refer to some other 
      <<me.fullName>> who was also cryogenically frozen.<./q> "
  restatedName = 
    "<.q>Well, apparently those records refer to 
        some other <<me.fullName>> who was also cryogenically 
        frozen,<./q> you say. "
  unconvincingStr = "The human<./s>s story is exceedingly 
    unlikely, but it doesn<./s>t matter. Either he"
;
nocPlayedNoLied: NocPlayedNoQuip
  "<.q>Well, I had to write something in that blank,
      so I made it up. I<./s>ve never actually played
      interactive fiction.<./q> "
  restatedName = 
    "<.q>Well, I had to write 
        something in that blank, so I made it up,<./q> you say. 
        <.q>I<./s>ve 
        never actually played interactive fiction.<./q> "
  claimsToKnowNothing = nil
;
nocPlayedNoHypertext: NocPlayedNoQuip
  "<.q>Well, it<./s>s true that I<./s>m interested 
      in <.s>interactive fiction,<./s> but only in the sense of 
      hypertext fiction. I<./s>ve never <.s>played<./s> 
      the type of <.s>IF<./s> you apparently have in mind.<./q> "
  restatedName = 
    "<.q>Well, it<./s>s true that 
        I<./s>m interested in <.s>interactive fiction,<./s> but only 
        in the sense of hypertext fiction,<./q> you say. 
        <.q>I<./s>ve never 
        <.s>played<./s> the type of <.s>IF<./s> you apparently 
        have in mind.<./q> "
  unconvincingStr = "I<./s>m not exactly convinced, but it 
    doesn<./s>t matter. Either the human"
  doConsequences() {
    glob.pcChoseHypertext = true;
  }
;

nocPlayedNoSilence: NocPlayedNoQuip
  "Stare at them silently. " // will apparently never be displayed
  reply() {
    "You stare at them silently. 
      <p>After several seconds of silence, Ovan shouts, 
        <.q>This is outrageous!<./q> 
      <p><.q>When faced with the evidence, the human
        declines to respond. Well, if he won<./s>t cooperate,
        then he<./s>s of no use to us,<./q> says Neton. ";
    saltMines(
      'Then, turning to Ovan, he asks, <.q>In that case, ',
      'Then, turning to the younger of the two guards, he says,
        <.q>Fine, then. \^'
    );
  }
;

nocPlayedNoNoWait: Quip
  "<.q>No, wait! I was just kidding.
      Actually, <<ifStrForThisQuip>>.<./q> "
  reply() {
    "<.q>No, wait!<./q> you cry. <.q>I was just kidding.
        Actually, <<ifStrForThisQuip>>.<./q> 
      <p><.q>It<./s>s amazing what a gun barrel will do for
        one<./s>s memory,<./q> says Neton.
      <p>Ovan scoffs, then says to you, 
        <.q>Okay, thanks for confirming that.<./q> ";
    if (glob.mentionedWindCryo)
      "<p><<explainBetaTesting>>"; // successful conclusion
    glob.aliensKnowPcLikesIf = true;
  }
  ifStrForThisQuip() {
    if (glob.pcChoseHypertext)
      "I have played the kind of interactive fiction 
        you<./s>re talking about";
    else
      "I<./s>ve played quite a lot of interactive fiction";
  }
;


nocPlayedNoNoSilence: Quip
  "Stare at them silently. "
  "You stare at them silently. 
    <p><<guardConfKill>>" // You die!
;

nocPlayedSilence: Quip
  "Stare at them silently. " // presumably will never be seen.
  reply() {
    "You stare at them silently. 
      <p>Neton and Ovan wait patiently for a few seconds.
        Then their faces turn angry. ";
    //"<p><.q>I don<./s>t believe this!<./q> shouts Ovan. ";
    "<p>Neton says, <.q>I had been led to believe 
        that the human was going
        to cooperate with us. But perhaps 
        I was wrong. Of course, in that case, he<./s>s of no
        use to us. Very well, then.";
    saltMines(
      ' In that case, ',
      '<./q> Turning to the younger of the two guards, he 
        says, <.q>\^'
    );
  }
  options = [
     nocPlayedSilenceYes
    ,nocPlayedSilenceNo
    ,nocPlayedSilenceSilence
  ]
  zeroOption = nocPlayedSilenceSilence
;

nocPlayedSilenceYes: Quip
  "<.q>No, wait! Sorry, I didn<./s>t hear you at first. 
      Actually, I have played interactive fiction.<./q> "
  reply() {
    "<.q>No, wait!<./q> you cry. <.q>Sorry, I didn<./s>t 
        hear you at first. Actually, I have played 
        interactive fiction.<./q> 
      <p><<ovanSarcastic>>";
    if (glob.mentionedWindCryo)
      "<p><<explainBetaTesting>>"; // successful conclusion
    glob.aliensKnowPcLikesIf = true;
  }
;
nocPlayedSilenceNo: Quip
  "<.q>No, wait! Sorry, I didn<./s>t hear you at first.
      The fact is, you<./s>re wrong. I<./s>ve never played
      interactive fiction.<./q> "
  "<.q>No, wait!<./q> you cry. <.q>Sorry, I didn<./s>t 
      hear you at first. The fact is, you<./s>re wrong. 
      I<./s>ve never played interactive fiction.<./q> 
    <p>Ovan sighs, then calls to the guard, 
      <.q>Hit him with all you got!<./q> 
    <p><<guardConfKill>>" // You die!
;
nocPlayedSilenceSilence: Quip
  "Stare at them silently. "
  "You stare at them silently. 
    <p><<guardConfKill>>" // You die!
;

// -------------------------------------------------------------------
// NETON/OVAN CONVERSATION: After they tell you how they revived you.
// -------------------------------------------------------------------

// Note: this set of quips will *only* be called if you 
// already volunteered that you've played IF.

nocMainCryo: QMain
  options = [
     nocCryoLiked
    ,nocCryoDisliked
    ,nocCryoAwake
    ,nocCryoAsleep
    ,nocCryoThanks
  ]
;

nocCryoLiked: Quip
  "<.q>Yeah, actually, I did enjoy the flight.<./q> "
  "<.q>Yeah, actually, I did enjoy the flight,<./q> 
      you reply. 
    <p><.q>Great!<./q> says Ovan, giving you an
      enormous grin. <.q>I<./s>m glad to hear it!<./q> "
;
nocCryoDisliked: Quip
  "<.q>Enjoyed the flight? I think not. My stomach is 
      still churning.<./q> "
  "<.q>Enjoyed the flight?<./q> you reply. <.q>I think not. 
      My stomach is still churning.<./q> 
    <p>Neton replies, <.q>Perhaps this is another occasion 
      where we might offer condolences.<./q> 
    <p><.q>But we already gave him condolences,<./q> 
      says Ovan. <.q>How many condolences does he really 
      need?<./q> 
    <p><.q>I<./s>m not sure,<./q> replies Neton,
      <.q>but it doesn<./s>t deplete our resources 
      to give them out, so we might as well be generous.<./q>
    <p>Ovan shrugs. "
;
nocCryoAwake: Quip
  "<.q>How many other humans have been revived?<./q> "
  "<.q>How many other humans have been revived?<./q>
      you ask. 
    <p><.q>Four,<./q> replies Ovan. "
;
nocCryoAsleep: Quip
  "<.q>How many humans remain in cryogenic stasis?<./q> "
  "<.q>How many humans remain in cryogenic stasis?<./q> 
      you ask.
    <p>Ovan shuffles through some papers, then says, 
      <.q>I guess about ninety or so.<./q> "
;
nocCryoThanks: Quip
  "<.q>I see. Well, uh, thanks for waking me up and all.<./q> "
  "<.q>I see,<./q> you say. <.q>Well, uh, thanks for 
      waking me up and all.<./q> 
    <p><.q>No problem!<./q> says Ovan, and gives you an
      enormous grin. <.q>It was our pleasure!<./q> "
;

// -------------------------------------------------------------------
// NETON/OVAN CONVERSATION: After they say they want you to play their game.
// -------------------------------------------------------------------

nocMainGame: QMain
  options = [
     nocGameWilling
    ,nocGameUnwilling
    ,nocGameDescribe
  ]
;

nocGameWilling: Quip
  "<.q>Sounds good. I<./s>d be happy to play your game.<./q> "
  "<.q>Sounds good,<./q> you say. <.q>I<./s>d be happy 
      to play your game.<./q> 
    <p><.q>Wonderful!<./q> Ovan says, smiling broadly. 
      <.q>I know you won<./s>t be disappointed!<./q> "
;
nocGameUnwilling: Quip
  "<.q>Uh, wait. I<./s>m not so sure I want to play your 
      game.<./q> "
  "<.q>Uh, wait,<./q> you say. <.q>I<./s>m not so sure 
      I want to play your game.<./q> 
    <p><.q>Desire is irrelevant,<./q> says Neton. 
    <p>The muscles in your neck tighten a bit. 
    <p><.q>We have ways of helping people overcome their
      reluctance,<./q> says Ovan cheerfully. <.q>We<./s>d be
      glad to help you overcome yours, don<./s>t worry!<./q> "
;
nocGameDescribe: Quip
  "<.q>What<./s>s your game about?<./q> "
  "<.q>What<./s>s your game about?<./q> you ask.
    <p><.q>We<./s>ll be explaining that in a bit,<./q> 
      says Ovan. <.q>Just be patient.<./q> "
;

// -------------------------------------------------------------------
// NETON/OVAN CONVERSATION: After they tell you they like mazes.
// -------------------------------------------------------------------

nocMainMazes: QMain
  options = [
     nocMazesPlot
    ,nocMazesPuzzles
    ,nocMazesMazes
    ,nocMazesAntimaze
    ,nocMazesUnskilled
  ]
;

nocMazesPlot: Quip
  "<.q>What<./s>s wrong with plot and characterization?<./q> "
  "<.q>What<./s>s wrong with plot and characterization?<./q> 
      you ask.
    <p>Ovan sighs, then says in a loud voice, 
      <.q>As I said, all they do is detract from 
      the one thing that<./s>s truly great about IF: 
      puzzles.<./q>
    <p><.q>That<./s>s good, I<./s>m sure he heard you that 
      time,<./q> says Neton.
    <p><.q>Thanks,<./q> says Ovan. <.q>I like to help
      people when I can, but it gets to be aggravating
      when I have to repeat myself.<./q> "
;
nocMazesPuzzles: Quip
  "<.q>Why are puzzles <.s>the one thing that<./s>s truly 
      great about IF<./s>?<./q> "
  "<.q>Why are puzzles <.s>the one thing that<./s>s truly 
      great about IF<./s>?<./q> you ask.
    <p><.q>That<./s>s a good question, and a lot of 
      scholarly research has gone into it,<./q>
      says Neton. <.q>I think, for one thing, puzzles 
      help to prevent the player from getting distracted 
      with thoughts about the game<./s>s story
      or its characters, causing the player instead to 
      think about it in a purer way, as he might think of 
      a jigsaw puzzle or a Rubik<./s>s cube.<./q>
    <p><.q>I just think puzzles are fun!<./q> says Ovan. "
;
modify glob
  philistinismEnunciated = nil
;
nocMazesMazes: Quip
  "<.q>What<./s>s so great about mazes?<./q> "
  reply {
    "<.q>What<./s>s so great about mazes?<./q> you ask. 
      <p>Ovan sighs. 
      <p><.q>Indeed, one does not <i>have</i> 
        to like mazes,<./q> Neton says. 
        <.q>One does not <i>have</i> to like art, literature, 
        or even interactive fiction, for that matter. 
        There is nothing stopping you from being 
        a philistine and a nihilist, if that is what suits you. 
        Yes, by all means, feel free to dislike mazes.<./q> 
      <p><.q>You don<./s>t look like a nihilist to me,<./q>
        says Ovan. <.q>I<./s>m sure after you have
        a chance to think about it, you<./s>ll see the 
        appeal of mazes.<./q> ";
    glob.philistinismEnunciated = true;
  }
;
nocMazesAntimaze: Quip
  "<.q>Well, I can unravel that mystery. You see, 
      mazes suck.<./q> "
  reply {
    "<.q>Well, I can unravel that mystery,<./q> you say. 
        <.q>You see, mazes suck.<./q> 
      <p>Ovan gapes at you uncomprehendingly. 
      <p><.q>Indeed, one does not <i>have</i> 
        to like mazes,<./q> Neton says. 
        <.q>One does not <i>have</i> to like art, literature, 
        or even interactive fiction, for that matter. 
        There is nothing stopping you from being 
        a philistine and a nihilist, if that is what suits you. 
        Yes, by all means, feel free to dislike mazes.<./q> 
      <p>Ovan says, <.q>In the old days, they used to say, 
        <.s>Critics of mazes perish in blazes.<./s>
        It<./s>s a good thing for you we live
        in more tolerant times.<./q> ";
    glob.philistinismEnunciated = true;
  }
;
nocMazesUnskilled: Quip
  "<.q>Unfortunately, I<./s>m not too good at mazes. Maybe 
      you should get somebody else to test your game.<./q> "
  "<.q>Unfortunately, I<./s>m not too good at mazes,<./q> 
      you say. <.q>Maybe you should get somebody else 
      to test your game.<./q> 
    <p><.q>We<./s>ve found that professed skill is less 
      important than motivation,<./q> says Neton.
    <p><.q>We have ways of motivating people,<./q> 
      says Ovan cheerfully. <.q>Don<./s>t worry!<./q> "
;

// -------------------------------------------------------------------
// NETON/OVAN CONVERSATION: After they tell you their game is Nothing But Mazes.
// -------------------------------------------------------------------

nocMainNbm: QMain
  options = [
    nocNbmNo
  ]
;

nocNbmNo: Quip
  "<.q>No&ndash;o&ndash;o!<./q> "
  "<.q>No&ndash;o&ndash;o!<./q> you cry.
    <p>For a long time the aliens stare at you blankly.
      Your shout echoes around the room.
    <p>Finally Ovan says, <.q>I don<./s>t get it. 
      It<./s>s a simple fact that
      <i>eeret</i> means <.s>Earth,<./s> 
      but it also means <.s>only.<./s> What<./s>s
      there to object to?<./q>
    <p><.q>Perhaps the human is unable to grasp the idea
      that words have multiple meanings,<./q> says Neton.
      <.q>This is peculiar, but it makes no difference
      to us. He will still be able to help us, 
      regardless of his linguistic ineptitude.<./q> "
;

// -------------------------------------------------------------------
// NETON/OVAN CONVERSATION: After they ask you for any final questions.
// -------------------------------------------------------------------

nocMainQuest: QMain
  options = [
     nocQuestDisability
    ,nocQuestRefuse
    ,nocQuestMice
    ,nocQuestDying
    ,nocQuestFinished
  ]
  zeroOption = nocQuestSilence
;

/*
modify glob
  askedNocQuestion = nil
;

class NocQuestContent: Quip
  reply {
    glob.askedNocQuestion = true;
    nocQuestReply;
  }
;
*/

class QuipBeforeCS2: Quip
  reply {
    replyText;
    "<p>With that, he and Ovan gather up their things
        from the table, then open the door and head
        out into the hallway. The guards wave their guns, 
        motioning for you to follow, and so you follow
        the professors. The guards step out behind you. ";
    cutScene2.execute;
  }
;

nocQuestDisability: QuipBeforeCS2
  "<.q>I used to play IF when I was younger, 
      but now my eyesight is very bad. I think 
      it might be too much of a strain for me 
      to play your game.<./q> "
  replyText = 
    "<.q>I used to play IF when I was younger, 
        but now my eyesight is very bad,<./q> you say. 
        <.q>I think it might be too much of a strain for me 
        to play your game.<./q> 
      <p><.q>Don<./s>t worry about that,<./q>
        says Ovan with a grin. <.q>No matter how lengthy
        our mazes are, we make sure everyone can enjoy them.
        No one is kept out on account of disability!<./q> 
      <p><.q>No one is kept out for <i>any</i> reason,
        unless we wish it,<./q>
        says Neton. Then, adjusting his jacket, he says,
        <.q>Well, I guess that<./s>s enough questions.
        We<./s>ll escort you to your room now.<./q> "
;

nocQuestRefuse: QuipBeforeCS2
  "<.q>What if I refuse to play your game?<./q> "
  replyText =
    "<.q>What if I refuse to play your game?<./q> 
        you ask.
      <p>The aliens stare blankly at you for a few
        moments. Then they both burst out laughing.
      <p><.q>That<./s>s a good one!<./q>
        cries Neton.
      <p>Ovan, still chuckling, says, <.q>No, no,
        you don<./s>t get the chance to refuse.
        It<./s>s not like we need your cooperation
        or anything. Nice try, though.<./q>
      <p>Then Neton becomes more sober and says, 
        <.q>Well, I guess that<./s>s enough questions.
        We<./s>ll escort you to your room now.<./q> "
;

nocQuestMice: QuipBeforeCS2
  "<.q>Is this what human beings are to you?
      Are we just mice to run in your mazes?<./q> "
  replyText =
    "<.q>Is this what human beings are to you?<./q> you ask.
        <.q>Are we just mice to run in your mazes?<./q> 
      <p><.q>Yep, pretty much,<./q> says Neton.
      <p><.q>That<./s>s about the size of it,<./q> says Ovan. 
      <p>Then Neton says, 
        <.q>Well, I guess that<./s>s enough questions.
        We<./s>ll escort you to your room now.<./q> "
;

nocQuestDying: QuipBeforeCS2
  "<.q>People are out there dying, and you<./s>d 
      rather talk about <i>mazes?</i>
      What is wrong with you?<./q> "
  replyText {
    "<.q>People are out there dying, and you<./s>d 
        rather talk about <i>mazes?<./q></i> you shout.
        <.q>What is wrong with you?<./q> ";
    if (glob.pcKnowsMoreAboutRule) {
      "<p>Neton shakes his head and sighs. 
          <.q>We already told you about Rule Number One.
          We can<./s>t interfere with alien cultures
          unless we feel like it,<./q> he says. 
        <p><.q>Why is he asking this?<./q> says Ovan.
          <.q>We already told him we don<./s>t feel like
          helping the native humans.<./q>
        <p><.q>Now, now, Ovan, don<./s>t be so impatient.
          Some species learn more slowly than us. No
          doubt the human will catch on eventually,<./q>
          says Neton. Then, turning to you, he adds,
          <.q>Well, I guess that<./s>s enough questions.
          We<./s>ll escort you to your room now.<./q> ";
    }
    else if (glob.pcKnowsAboutRule) {
      "<p>Neton shakes his head and sighs. 
          <.q>We already told you about Rule Number 
          One,<./q> he says. <.q>But perhaps you didn<./s>t
          fully understand. As you know, Rule Number One 
          says that we can<./s>t interfere with 
          alien cultures unless we really feel like it. 
          Perhaps this sounds like an open-ended rule 
          that permits just anything. Nothing could
          be further from the truth. The rule is 
          extremely strict. If Ovan or I didn<./s>t feel 
          like interfering with an alien culture, 
          but did so anyway, the dean of CESAC would 
          find out, and he would almost certainly give us 
          a severe reprimand.<./q>
        <p>Ovan adds, <.q>And it<./s>s not as simple as 
          lying to the dean, either. He has access to the 
          campus<./s>s brain-wave pattern scanner, 
          so he can find out what we genuinely want to do. 
          So, as it turns out, until we truly develop 
          a genuine desire to help out Earthlings, 
          our hands are tied.<./q>
        <p>Then Neton says, 
          <.q>Well, I guess that<./s>s enough questions.
          We<./s>ll escort you to your room now.<./q> ";
      glob.pcKnowsMoreAboutRule = true;
    }
    else {
      "<p>Neton shakes his head and sighs. Then he says, 
          <.q>Maybe in a sense it might be desirable 
          to help the surviving humans a bit. 
          The problem is, though, we are bound 
          by a directive that we call Rule Number One. 
          According to this rule, we are not allowed 
          to interfere with the natural development 
          of other alien cultures&mdash;unless we 
          really feel like it.<./q> 
        <p><.q>And, you see, this is a case where we 
          don<./s>t really feel like it,<./q> says Ovan, 
          smiling cheerfully.
        <p>Then Neton says, 
          <.q>Well, I guess that<./s>s enough questions.
          We<./s>ll escort you to your room now.<./q> ";
      glob.pcKnowsAboutRule = true;
    }
  }
;

nocQuestFinished: QuipBeforeCS2
  "<.q>Thanks, but I don<./s>t have any questions.<./q> "
  replyText =
    "<.q>Thanks, but I don<./s>t have any questions,<./q> 
        you say.
      <p><.q>Very well,<./q> says Neton. 
        <.q>Since you have no questions, please allow us
        to escort you to your room.<./q> "
;

nocQuestSilence: QuipBeforeCS2
  "Stare at them silently. " // Will never be displayed
  replyText =
    "You stare at them silently. 
      <p><.q>Very well,<./q> says Neton. 
        <.q>Since you have no questions, please allow us
        to escort you to your room.<./q> "
;

/*
nocQuest: NocQuestContent
  "<.q>option 2<./q> "
  nocQuestReply = 
    "<.q>option 2<./q> 
      <p>reply "
;
nocQuest: NocQuestContent
  "<.q>option 2<./q> "
  nocQuestReply = 
    "<.q>option 2<./q> 
      <p>reply "
;
nocQuestFinished: Quip
  // "Thanks, but I don't have any questions." -OR-
  // "I guess that's all for now." 
  "<.q><<quipText>>.<./q> "
  reply {
    "<.q><<quipText>>,<./q> you say. ";
    nocQuestNothingFurther;
    cutSceneTwo();
  }
  quipText() {
    if (glob.askedNocQuestion)
      return 'I guess that<./s>s all for now';
    else
      return 'Thanks, but I don<./s>t have any questions';
  }
;
nocQuestSilence: Quip
  "Stare at them silently. " // Will never be displayed
  reply {
    "You stare at them silently. ";
    nocQuestNothingFurther;
    cutSceneTwo();
  }
;
*/

// -------------------------------------------------------------------
// CUT SCENE #2
// -------------------------------------------------------------------

// Here is the new way of doing it, as of August 2006.

cutScene2: CutScene
  beginScene { }
  endScene {
    foreach (local cur in confTable.contents) {
      cur.moveInto(nil);
    }
    goToCell.execute;
    me.makePosture(standing);
    nestedAction(Look);
    confRoom.killBanner = nil; // should be reduntant, but just in case
    enterCell();
    cancelPendingCommands();
  }
  sceneList = [
    [ 'You walk down the hallway behind Neton and Ovan,
        forced at gunpoint by the guards behind you. 
        Finally the professors reach a closed door,
        and everyone comes to a stop. ',
      nil,
      'illustrations/hallway2_0300.jpg',
      'illustrations/hallway2_0469.jpg' ],
    [ 'Turning around, Neton says to you, <.q>Here is your
        guest room. As I said before, remember to get plenty
        of sleep tonight. We all have a long day ahead of
        us tomorrow.<./q> Ovan cheerfully adds, 
        <.q>Good night!<./q> With that, 
        the two professors walk off. ',
      nil,
      'illustrations/hallway2_0300.jpg',
      'illustrations/hallway2_0469.jpg' ],
    [ 'The older of the two guards pushes a button,
        then opens the door. With that, he waves his gun, 
        and you enter the room.
        He closes and locks the door behind you. ',
      nil,
      'illustrations/hallway2_0300.jpg',
      'illustrations/hallway2_0469.jpg' ]
  ]
;

/*
modify Quip
  nocQuestNothingFurther {
    "<p><.q>Very well,<./q> says Neton. 
        <.q>Since you have no 
        <<glob.askedNocQuestion ? 'further' : ''>>
        questions, please allow us to escort you to
        your room.<./q> ";
    "<p>With that, he and Ovan gather up their things
        from the table, then open the door and head
        out into the hallway. The guards wave their guns, 
        motioning for you to follow, and so you do. 
        The guards step out into the hallway, and so you step out into
        the hallway. The guards follow close behind you. ";
    //"<p><.q>Have a good evening!<./q> says Ovan.
    //  <p><.q>Yes,<./q> Neton says, <.q>and once again, 
    //    remember to get a good
    //    night<./s>s sleep. We have a long day ahead of us 
    //    tomorrow.<./q> 
    //    With that, the two professors collect the last of 
    //    their things and head for the door. The guards
    //    point with their guns for you to follow them. ";
  }
;
*/

// This is the old way of doing Cut Scene Two, superceded by the 
// above method. I could probably comment this out, but I don't 
// feel like monkeying around with it right now.

cutSceneTwo() {
  //"And then the top of the container opens up. Light floods in.
  //  You are nearly blinded. ";
  nbmPause();
  "<.p>";
  glob.status = blank;
  statusLine.showStatusLineDaemon();
  confRoom.killBanner = true;
  nbmBanner.updateMe;
  nbmCls();
  // Put up the cutSceneBanner, to clear the screen with nothing
  // but a big banner.
  csShout('');
  // Make sure the text actually goes to the main window. People won't
  // see this on the screen right now, because of the 100%-size banner
  // window. But we have to do this, or else it won't go to the 
  // transcript when we put the text to the banner later.
  for (local a=1; a<=glob.cs2List.length(); ++a) {
    "<<glob.cs2List[a][2]>><.p>";
  }
  nbmCls();
  // Go through the slide show.
  for (local a=1; a<=glob.cs2List.length(); ++a) {
    // Clear the 100%-size banner window.
    cutSceneBanner.clearWindow();
    // Unless the first element in this part of the list is nil,
    // display it as an image in the banner window.
    if (glob.cs2List[a][1]) {
      csDispImg(glob.cs2List[a][1]);
    }
    // If there is text to output to the window, output it.
    if (glob.cs2List[a][2]) {
      csShout(glob.cs2List[a][2]);
    }
    // If there is anything to output to the main window (i.e. sound)
    // output it.
    if (glob.cs2List[a][3]) {
      "<<glob.cs2List[a][3]>>";
    }
    nbmPause();
  }
  
  cutSceneBanner.removeBanner();
  
  // The old way of doing it:
  //me.moveInto(confChair);
  //me.makePosture(sitting);
  
  // The new way of doing it:
  goToCell.execute;
  //me.moveIntoForTravel(cell);
  me.makePosture(standing);
  nestedAction(Look);
  confRoom.killBanner = nil;
  nbmBanner.updateMe;
  glob.status = trinity;
  statusLine.showStatusLineDaemon();
  // Now execute the stuff in 1.prisoners.t:
  enterCell();
  cancelPendingCommands();
}

modify glob
  cs2List = [
    [ 'hallway2.jpg',
      'You walk down the hallway behind Neton and Ovan,
        feeling a bit uncomfortable with the guards<./s> 
        guns pointed at your back. 
        Finally the professors reach a closed door,
        and everyone comes to a stop. ',
      nil ],
    //[ 'hallway2.jpg',
    //  'Turning around, Neton says to you, <.q>Here is your
    //    guest room. As I said before, remember to get plenty
    //    of sleep tonight. We have a long day ahead of
    //    us tomorrow.<./q> ',
    //  nil ],
    //[ 'hallway2.jpg',
    //  '<.q>Have a good night!<./q> says Ovan cheerfully.
    //    With that, the two professors walk off. ',
    //  nil ],
    [ 'hallway2.jpg',
      'Turning around, Neton says to you, <.q>Here is your
        guest room. As I said before, remember to get plenty
        of sleep tonight. We have a long day ahead of
        us tomorrow.<./q> Ovan cheerfully says, 
        <.q>Have a good night!<./q> With that, 
        the two professors walk off. ',
      nil ],
    [ 'hallway2.jpg',
      'The older of the two guards pushes a button,
        then opens the door. With that, he waves his gun, 
        motioning for you to enter, and so you enter.
        He closes and locks the door behind you. ',
      nil ]
  ]
;

// -------------------------------------------------------------------
// CONFERENCE ROOM DAEMON
// -------------------------------------------------------------------

// This is how the aliens speak to you. It also contains a 
// nextSpeaker() method to determine who spoke last and therefore
// who should speak next (to prevent the same person from speaking
// twice in a row).

// This is now a "faux" daemon. Its daemonID is always equal to nil.
// Its daemon property is now called by endgameDaemon.daemon.

confDaemon: DaemonComponent
  //location = me
  isActive = nil
  daemonID = nil
  startDaemon {
    if (daemonID == nil) {
      moveInto(gPlayerChar);
      daemonID = new Daemon(self, &daemon, 1);
    }
    // Otherwise, if the daemon is already running, let it continue.
  }
  daemon {
    //"<font color=blue>confDaemon.daemonState was <<daemonState>>; ";
    daemonState++;
    //"it's now <<daemonState>>. \b</font>";
    
    //if (daemonState == 9 && glob.mentionedBetaTesting)
    //  daemonState++;
    switch (daemonState) {
      //case 1:
        //"<p><.q>Oddly enough, the same was not true on
        //    Earth,<./q> says Ovan, furrowing his brow.
        //    <.q>For whatever reason, Earth<./s>s early IF
        //    was puzzle-based, yet became more story-based 
        //    as time went on. I never understood that at all.<./q>
        //  <p><.q>Then again, you<./s>re talking about a culture
        //    that didn<./s>t even have the good sense to 
        //    appreciate IF very much anyway,<./q> says Neton.
        //    <.q>What do you expect?<./q>
        //  <p>Ovan nods, acknowledging the point.<p>\b\b\b\b\b\b ";
            
          //  "This was the main insight that gave rise to
          //  modern IF. If you add plot or characterization
          //  to your game, it just distracts people from the one 
          //  
          //  
          //  Today, all IF is puzzle-based,<./q> Ovan says.
          //  <.q>No modern IF author would be caught 
          //  dead writing story-based stuff.<./q>
          //<p><.q>Modern writers have experimented with many 
          //  different types of puzzles,<./q> says Neton.
          //  <.q>Hunger puzzles, inventory management puzzles,
          //  light source puzzles, and the like. But by far 
          //  the most popular type of puzzle has been the
          //  maze.<./q>
          //<p>With that, a look of beatific joy crosses 
          //  Ovan<./s>s face. <.q>I just love mazes!<./q> he says.
          //<p>Yes,<./q> if there were one thing to symbolize the 
          //  state of affairs in Oo interactive fiction, the best 
          //  symbol would be one big maze, stretching on to 
          //  infinity.<./q>
          //<p>You are aghast. ";
          
        //"<p>Neton nudges one of his books to bring it into
        //    more perfect alignment with the others in his stack,
        //    then says to you, <.q>To explain 
        //    why Ovan is so excited about our game, 
        //    I<./s>ll have to tell you 
        //    about the artistic traditions of our homeworld. 
        //    You see, many centuries ago, IF games on planet Oo 
        //    were very different than they are today.<./q> 
        //  <p><.q>Most of them really sucked!<./q> 
        //    says Ovan.
        //  <p><.q>Now, Ovan, they didn<./s>t 
        //    <.s>suck.<./s> They were simply based on a different
        //    artistic tradition.<./q> Then Neton says to you, 
        //    <.q>People in those days wanted IF to tell
        //    a <.s>story.<./s>
        //    They wanted 
        //    <.s>character development,<./s>
        //    a <.s>strong plot,<./s> and other features
        //    which today seem completely 
        //    superfluous.<./q>
        //  <p>Ovan says, <.q>They used to futz around with 
        //    <.s>conversation 
        //    systems,<./s> <.s>multiple endings,<./s> and 
        //    compliance with <.s>mimesis,<./s> whatever
        //    that is. It was nuts!<./q>
        //  <p><.q>Some of these things sound good in theory,<./q>
        //    says Neton, <.q>but in practice they were just 
        //    distracting. Maybe it sounds good to add a strong
        //    plot to a game, but in practice, it just interferes
        //    with one's appreciation of the
        //    main thing that makes IF great: 
        //    puzzles.<./q>
        //  <p><.q>Today, all IF is puzzle-based,<./q> Ovan says.
        //    <.q>No modern IF author would be caught 
        //    dead writing story-based stuff.<./q>
        //  <p><.q>Modern writers have experimented with many 
        //    different types of puzzles,<./q> says Neton.
        //    <.q>Hunger puzzles, inventory management puzzles,
        //    light source puzzles, and the like. But by far 
        //    the most popular type of puzzle has been the
        //    maze.<./q>
        //  <p>With that, a look of beatific joy crosses 
        //    Ovan<./s>s face. <.q>I just love mazes!<./q> he says.
        //  <p>Yes,<./q> if there were one thing to symbolize the 
        //    state of affairs in Oo interactive fiction, the best 
        //    symbol would be one big maze, stretching on to 
        //    infinity.<./q>
        //  <p>You are aghast. ";
      case 2:
        "For a brief moment, you hear some shuffling from 
            outside the door. ";
        break;
      case 3:
        "The door opens, and two aliens walk in, dressed in 
            odd-looking jackets of green and yellow. As they step in, 
            one is saying to the other, <.q>&mdash;but I had to save 
            my game 256 times!<./q> And they both erupt into snorts 
            of laughter. 
          <p>The aliens are carrying a number of books, papers, 
            and electronic devices. They proceed to stack these on 
            the table. Then they sit down behind their items, 
            across the table from you. 
          <p><.q>Hello,<./q> says the alien in the green jacket. 
          <p><.q>Just a sec,<./q> says the one in the yellow jacket. 
            <.q>I want to set up my tablet device so I can look at the 
            newsgroups.<./q> 
          <p>The one in the green jacket says, <.q>You need to check 
            them now? Even with a <<ooStar.starDist>>-year delay?<./q> 
          <p><.q>You never know when someone might post some new
            insight into <.game>Cave Maze VII.<./q><./game> 
          <p>The other alien grumbles a bit, but waits without 
            further objection. ";
        //neton.moveInto(secondConfChair);
        //ovan.moveInto(thirdConfChair);
        neton.scMoveInto(secondConfChair);
        ovan.scMoveInto(thirdConfChair);
        neton.makePosture(sitting);
        ovan.makePosture(sitting);
        
        neton.hasEnteredConfRoom = true;
        ovan.hasEnteredConfRoom = true;
        
        ovanPda.moveInto(ovan);
        cryoPapers.moveInto(confTable);
        netonBooks.moveInto(confTable);
        
        nbmBanner.updateMe;
        break;
      case 4:
        "With a final push of a button, the alien in the 
            yellow jacket sets his tablet device down on the table,
            then says to his companion,
            <.q>Should we begin?<./q> 
          <p><.q>Yes, let<./s>s begin,<./q> says the one in the 
            green jacket. He is speaking in his native alien 
            language, as he and his colleague have been since they 
            arrived. Turning to you, he says, <.q>Well, first 
            things first. Just to be sure, can you understand 
            us?<./q> ";
        ovanPda.moveInto(confTable);
        nocMainUnderstand.select;
        break;
      case 5:
        "Then Neton takes on a serious expression as he says, 
            <.q>In the 160 years while you were in 
            cryogenic stasis, much has changed on 
            planet Earth.<./q> Turning to his colleague, he asks, 
            <.q>Where should we begin?<./q> 
          <p><.q>Well, in the 2060s, I suppose,<./q> says Ovan. 
            <.q>During that period, 
            some members of your species got&mdash;well, a 
            little too rambunctious for their own good. 
            It all started with this one group of 
            terrorists&mdash;<./q> 
          <p><.q>What!<./q> Neton interrupts. <.q>That<./s>s not 
            what the new studies indicate. In fact, it began in 
            the U.S. presidential election of 2060&mdash;<./q> 
            But then, perhaps sensing that this debate 
            could become unproductive, he cuts himself off and returns 
            his gaze to you, saying, <.q>Well, basically, to make 
            a long story short, in 2068 there was a full-blown 
            nuclear war.<./q> 
          <p><.q>It wiped out 98% of the human species 
            and effectively destroyed human civilization,<./q> 
            Ovan says. 
          <p><.q>Few populations survived the war,<./q> says Neton. 
            <.q>The remaining humans had time for little else 
            but survival, so learning and culture dwindled. 
            With few exceptions, technology reverted 
            back to the Iron Age.<./q> 
          <p><.q>And so it has remained until the present day,<./q> 
            adds Ovan. <.q>Human civilization 
            as you know it no longer exists.<./q> 
          <p>Neton says, <.q>We understand that, in human cultures, 
            it is customary to offer condolences when giving 
            bad news,<./q> says Neton. <.q>Rest assured, you have 
            our condolences.<./q> ";
        break;
      case 6:
        "Then Ovan looks you in the eye and says, 
            <.q>Neton and I belong 
            to an alien race known as the Oo. We are from far 
            outside your solar system.<./q>
          <p>Neton says, <.q>During the early twenty-second century,
            a few decades after the nuclear war, one of our 
            Oo spaceships just happened to be passing by 
            your planet, when they noticed signs of life on
            the Earth<./s>s surface.<./q>
          <p><.q>The crew decided to zoom down to your planet 
            to investigate,<./q> says Ovan. <.q>They explored 
            briefly, then returned to the ship with their 
            findings. Most of the Oo did not wish to be diverted 
            any further, so they blasted off and proceeded with 
            their primary mission.<./q>
          <p><.q>A few, however, decided to stay behind and 
            investigate at much greater length,<./q> says Neton, 
            <.q>even though they knew they would have no spaceship 
            with which to get back home. Ovan and I are 
            descended from this group of Oo investigators. 
            Our race has been investigating Earth for 
            almost a hundred years now.<./q> 
          <p><.q>Since then it<./s>s become painfully obvious that 
            there is not a hundred years<./s> worth of stuff to study 
            here,<./q> says Ovan with a sigh. <.q>But we make the 
            most of it.<./q>
          <p><.q>And we wait for the day when another spaceship 
            will come to bring us back home,<./q> says Neton. ";
        break;
      case 7:
        "Then Neton looks at you and says, 
            <.q>Now, as I said earlier, Ovan and I are scholars 
            of the humanities.<./q> (The noun might literally be 
            translated as <.q>Oo-ities,<./q> but it<./s>s easier 
            to think in terms of words you know.) 
            <.q>That means we study, 
            among other things, interactive fiction.<./q> 
          <p><.q>What do you mean, other things? I study 
            nothing else!<./q> Ovan says with a grin.
          <p>Neton shakes his head, then continues. 
            <.q>In Oo culture, interactive fiction is regarded 
            as the highest form of art. All other 
            media&mdash;painting, architecture, literature, 
            film&mdash;are of only secondary significance 
            compared with interactive fiction, or IF.<./q>
          <p><.q>Personally, I don<./s>t like paintings or books 
            very much,<./q> says Ovan, <.q>unless they<./s>re 
            paintings or books about IF.<./q>
          <p>You frown. Are they talking about what you think 
            they<./s>re talking about? Interactive fiction, as in 
            text adventure games like <.game>Zork?<./game>
          <p><.q>Apparently, the same was not true in your 
            culture,<./q> says Neton. <.q>Even though your 
            planet independently invented IF, 
            you did not grasp it for the revolutionary 
            breakthrough that it was. After a brief flare of 
            popularity in the 1980s, the whole medium seems 
            to have gone into a decline.<./q>
          <p>You shake your head in astonishment. Sure enough, 
            they<./s>re talking about text adventure games. 
            You were always a big fan of such games, 
            but you never thought of them as the 
            highest form of art.
          <p><.q>Some of us have speculated that this was, 
            in fact, the reason for Earth<./s>s fate,<./q> says Ovan. 
            <.q>Without a healthy respect for IF,  
            where was the good judgment that might have 
            averted a nuclear catastrophe?<./q>
          <p>Neton says, <.q>We Oo have been studying 
            Earth for nearly a century, 
            but in all that time we never found a single 
            human being who knew anything about 
            interactive fiction.<./q>
          <p><.q>Until now,<./q> says Ovan. ";
        break;
      case 8:
        glob.mentionedWindCryo = true;
        if (cryoPapers.isIn(neton)) {
          cryoPapers.moveInto(confTable);
          "Then Neton sets the papers back down on the table, ";
        }
        else {
          "Then Neton adjusts his green jacket, ";
        }
        "and he says
            to you, <.q>You see, what brings you here
            is an astonishing discovery. Only two months ago, 
            one of our Oo scientists found a twenty-first-century 
            human cryogenic facility that had auxiliary wind power, 
            with the result that in over 150 years, 
            the electricity had never gone out, 
            and, amazingly, most of the frozen 
            bodies were still intact.<./q>
          <p><.q>He did an exhaustive search,<./q> Ovan says, 
            <.q>and eventually found five such facilities 
            with viable frozen humans.<./q>
          <p>Neton says, <.q>When Ovan and I searched through
            the records of these facilities, we made a discovery 
            of our own. One of the humans on the 
            list had said that he was interested
            in interactive fiction. And that human was you.<./q>
          <p><.q>Imagine,<./q> says Ovan, his voice rising 
            to a squeal, <.q>a human with first-hand knowledge 
            of Earth<./s>s golden age of IF! 
            Naturally, we pushed for you to be revived 
            as soon as possible.<./q> 
          <p><.q>They accomplished this just a few days ago,<./q> 
            Neton says, <.q>and now they tell us that you have 
            been physically rehabilitated. 
            They sent you here in the next aircar.<./q>
          <p><.q>We hope you enjoyed the flight,<./q> 
            says Ovan. ";
        //"\bSTOP!\nSTOP!\nSTOP!\nSTOP!\nSTOP!\n
        //  There is no interactive conversation after this point.
        //  You may type UNDO or RESTART now. ";
        if (!glob.aliensKnowPcLikesIf) {
          "<p><.q>Now, perhaps we should confirm that our records 
              are correct,<./q> says Neton.
            <p><.q>Ah, yes, good point,<./q> says Ovan. Turning 
              to you, he asks, <.q>Well, how about it? 
              You have played interactive fiction,
              haven<./s>t you?<./q> ";
          //"<p>The answer, of course, is yes. You<./s>ve played 
          //    text adventure games for years, starting with 
          //    <.game>Zork<./game> back in the early 1980s, and 
          //    continuing well into the 2020s, by which time 
          //    amateur IF had become very sophisticated. ";
          nocMainPlayed.select;
        }
        break;
      case 9:
        //Quip.explainBetaTesting;
        //break;
        if (!glob.mentionedBetaTesting) {
          if (cryoPapers.isIn(neton)) {
            cryoPapers.moveInto(confTable);
            "Then Neton sets the papers back down on the table, ";
          }
          else {
            "Then Neton nudges one of his books to bring it into more 
              perfect alignment with the others in his stack, ";
          }
          "and he says,
              <.q>Fortunately, your timing is very good. As it 
              happens, you arrived at our institute just as
              we were entering into the final stage of an
              exciting project.<./q>
            <p><.q>We wrote a game!<./q> says Ovan, beaming with 
              pride.
            <p>Neton says, <.q>As Ovan has 
              indicated, he and I have just spent the last year
              writing an IF game, which is now nearly complete.
              All that remains is to test it and iron out
              the bugs. 
            <p><.q>And we want you to help!<./q> Ovan says.
            <p><.q>Since our game is set on Earth,<./q> Neton says,
              <.q>it<./s>ll be great to get it tested by a human
              with real knowledge of interactive fiction&mdash;not
              to mention real knowledge of Earth as it once
              was.<./q>
            <p><.q>I<./s>m so excited!<./q> Ovan squeals. 
              <.q>He<./s>s really gonna play it!<./q> 
            <p>Neton looks at Ovan and shakes his head. ";
        }
        glob.aliensKnowPcLikesIf = true;
        glob.mentionedBetaTesting = true;
        break;
      case 10:
        "Then Neton turns to you and says, <.q>To explain why 
            Ovan is so excited, I<./s>ll have 
            to go back and tell you about the artistic traditions 
            of our homeworld. You see, many centuries ago, 
            interactive fiction on planet Oo 
            was very primitive by today<./s>s standards. 
            Most early IF games were story-based, 
            with <.s>plot,<./s> 
            <.s>character development,<./s> and other such 
            niceties.<./q> 
          <p><.q>Some of these things might sound okay 
            in principle,<./q> says Ovan, <.q>but in practice, 
            all they do is detract from the one thing 
            that<./s>s truly great about IF: puzzles.<./q>
          <p><.q>Puzzles have become all-important
            in contemporary Oo interactive fiction,<./q> 
            says Neton. <.q>Oo IF authors have 
            experimented with hunger puzzles, inventory 
            management puzzles, and so on. But of all the kinds
            of puzzles, none are more dearly loved than mazes.<./q>
          <p><.q>I just love mazes!<./q> Ovan cries, 
            and gives a blissful smile. 
          <p><.q>Mazes are the main driving force
            in all modern Oo IF, and they keep getting
            more and more complex,<./q> says Neton.
          <p>You can<./s>t believe this! In most IF games,
            there<./s>s nothing worse than a maze. Walking from one 
            identical room to the next while you scribble 
            at a map is not your idea of a good time. 
            What is wrong with these aliens? 
          <p>Then Ovan looks perplexed as he says, 
            <.q>Oddly enough, the exact opposite 
            was true on Earth. Your IF games were 
            perfect right from the start! Lots of mazes, 
            plenty of puzzles, and no irrelevant story or plot. 
            What more could anybody ask for?<./q>
          <p><.q>But then,<./q> says Neton, 
            <.q>having achieved such an excellent ideal, 
            the game authors of Earth conspired to 
            subvert it. As time went on, Earth<./s>s IF games 
            grew more and more story-based, with fewer and fewer 
            puzzles. In the end, they contained hardly any 
            mazes.<./q>
          <p><.q>I don<./s>t get it!<./q> says Ovan. <.q>Without
            mazes, why write games at all?<./q>
          <p><.q>Some mysteries were not meant to be 
            unraveled,<./q> says Neton. <.q>Surely, this is 
            a riddle to confound scholars for all time.<./q> ";
        break;
      case 11:
        "Then Neton says to you, 
            <.q>Now, this brings us to the game that Ovan
            and I have written. 
            You see, for years, the interactive fiction of Oo
            has been filled with mazes, but it struck me as odd
            that no one had ever thought to take this trend
            to its ultimate conclusion.<./q>
          <p><.q>That was such a great idea, too!<./q> says
            Ovan. 
          <p><.q>Thanks,<./q> says Neton, <.q>but don<./s>t be
            so modest. I think your <.s>insta-death<./s> rooms
            added a lot to the game.<./q>
          <p><.q>Oh, it was nothing,<./q> says Ovan. <.q>Now
            come on, let<./s>s tell him about the title.<./q>
          <p><.q>Ah, yes,<./q> says Neton. 
            <.q>You see, our game is set on Earth.
            So we entitled the game\ .\ .\ . <.game>Totoona 
            Eeret.<./q><./game> With that, he leans back and
            looks at you significantly.
          <p>You frown. The title means <i>The Mazes of Earth.</i> 
            But you don<./s>t understand the proud gleam in his eye.
          <p>Ovan sighs and says, <.q>I guess we<./s>ll have to 
            explain.<./q>
          <p><.q>Yes, excuse me,<./q> says Neton. <.q>I thought
            this was clear. But anyway&mdash;the word <i>eeret</i>
            means <.s>Earth,<./s> but it is also an ancient Oo word
            meaning <.s>only.<./s><./q>
          <p><.q>And so,<./q> says Ovan, <.q><i>Totoona Eeret</i> 
            means <i>The Mazes of Earth,</i> 
            but it also means <i>Only Mazes.</i><./q>
          <p><.q>Or, to translate it more idiomatically,
            you might call it\ .\ .\ .<./q> ";
        nbmPause();
        confRoom.killBanner = true;
        nbmBanner.updateMe;
        glob.status = blank;
        statusLine.showStatusLineDaemon();
        //nbmCls();
        //csShout('');
        //cutSceneBanner.clearWindow();
        if (glob.imageSize == 1) {
          csDispImg('illustrations/mazestitle0420.jpg');
        }
        else {
          csDispImg('illustrations/mazestitle0605.jpg');
        }
        playSound('<sound src=\"sound/prelude.mp3\" layer=foreground>');
        nbmPause();
        cutSceneBanner.removeBanner();
        confRoom.killBanner = nil;
        nbmBanner.updateMe;
        glob.status = trinity;
        statusLine.showStatusLineDaemon();
        "<p>
            <b>NOTHING BUT MAZES</b>
            \nA Game
            \nby Greg Boettcher
            \nVersion <<versionInfo.version>>
            \nCopyright 2006&ndash;2019 Greg Boettcher";
        "\n<a href=\"<<versionInfo.gameUrl>>\">Game<./s>s web site</a>";
        "\n(Whatever you do, don<./s>t type <a href=\"about\">ABOUT</a>.)";
        "<p><.q>.\ .\ .\ <i>Nothing but Mazes,<./q></i> 
            says Neton.
          <p>You are aghast. A game called <i>Nothing but Mazes?</i>
            And they want you to play it? This is just too
            much! ";
        me.knowsMazeGameTitle = true;
        break;
      case 12:
        "Then Ovan turns to Neton and says, 
            <.q>Well, I guess we<./s>ve explained everything!
            Should we let him play the game right now, then?<./q>
          <p>Neton replies, <.q>No, it is
            far too late in the day. Besides, the human
            is probably tired from his long flight. We should let 
            him rest.<./q> 
          <p><.q>Ah, yes, good point,<./q> says Ovan.
          <p>Turning to you, Neton says, 
            <.q>In a moment, the guards will take you to your 
            guest room. Help yourself to as much food substance 
            as you<./s>d like, and feel free to socialize with
            the other guests. Above all, be sure to get a 
            good night<./s>s sleep. But before we let you go, 
            do you have any questions for us?<./q> ";
        nocMainQuest.select;
        break;
      case 13:
        
        break;
      case 14:
        
        break;
      case 15:
        
        break;
      case 16:
        
        break;
      case 17:
        
        break;
      case 18:
        
        break;
      case 19:
        
        break;
      case 20:
        
        break;
      case 21:
        
        break;
      case 22:
        
        break;
      case 23:
        
        break;
      case 24:
        
        break;
      case 25:
        
        break;
      case 26:
        
        break;
      case 27:
        
        break;
      case 28:
        
        break;
      case 29:
        
        break;
      case 30:
        
        break;
      default:
        
        break;
    }
  }
  // To begin the conference room sequence promptly, set 
  // confDaemon.daemonState to 0. To create a delay before the sequence, 
  // set it to some negative number.
  daemonState = 0
  endDaemon {
    if (daemonID != nil) daemonID.removeEvent;
    daemonID = nil;
    moveInto(nil);
  }
  nextSpeaker {
    switch (daemonState + 1) {
      case 2:
        return nil;
//        "For a brief moment, you hear some shuffling from 
//            outside the door. ";
//        break;
      case 3:
        return nil;
//        "The door opens, and two aliens walk in, dressed in 
//            odd-looking jackets of green and yellow. As they step in, 
//            one is saying to the other, <.q>&mdash;but I had to save 
//            my game 533 times!<./q> And they both erupt into snorts 
//            of laughter. 
//          <p>The aliens are carrying a number of books, papers, 
//            and electronic devices. They proceed to stack these on 
//            the table. Then they sit down behind their items, 
//            across the table from you. 
//          <p><.q>Hello,<./q> says the alien in the green jacket. 
//          <p><.q>Just a moment,<./q> says the one in the yellow jacket. 
//            <.q>I want to set up my tablet device so I can look at the 
//            newsgroups.<./q> 
//          <p>The one in the green jacket says, <.q>You need to check 
//            them now? Even with a <<ooStar.starDist>>-year delay?<./q> 
//          <p><.q>You never know when someone might post some new
//            insight into <.game>Cave Maze VII.<./q><./game> 
//          <p>The other alien grumbles a bit, but waits without 
//            further objection. ";
//        neton.moveInto(secondConfChair);
//        ovan.moveInto(thirdConfChair);
//        neton.makePosture(sitting);
//        ovan.makePosture(sitting);
//        
//        neton.hasEnteredConfRoom = true;
//        ovan.hasEnteredConfRoom = true;
//        
//        ovanPda.moveInto(ovan);
//        cryoPapers.moveInto(confTable);
//        netonBooks.moveInto(confTable);
//        
//        nbmBanner.updateMe;
//        break;
      case 4:
        return ovan;
//        "With a final push of a button, the alien in the 
//            yellow jacket sets his tablet device down on the table,
//            then says to his companion,
//            <.q>Should we begin?<./q> 
//          <p><.q>Yes, let<./s>s begin,<./q> says the one in the 
//            green jacket. He is speaking in his native alien 
//            language, as he and his colleague have been since they 
//            arrived. Turning to you, he says, <.q>Well, first 
//            things first. Just to be sure, can you understand 
//            us?<./q> ";
//        ovanPda.moveInto(confTable);
//        nocMainUnderstand.select;
//        break;
      case 5:
        return neton;
//        "Then Neton takes on a serious expression as he says, 
//            <.q>In the 160 years while you were in 
//            cryogenic stasis, much has changed on 
//            planet Earth.<./q> Turning to his colleague, he asks, 
//            <.q>Where should we begin?<./q> 
//          <p><.q>Well, in the 2060s, I suppose,<./q> says Ovan. 
//            <.q>During that period, 
//            some members of your species got&mdash;well, a 
//            little too rambunctious for their own good. 
//            It all started with this one group of 
//            terrorists&mdash<./q> 
//          <p><.q>What!<./q> Neton interrupts. <.q>That<./s>s not 
//            what the new studies indicate. In fact, it began in 
//            the U.S. presidential election of 2060&mdash;<./q> 
//            But then, perhaps sensing that this debate 
//            could become unproductive, he cuts himself off and returns 
//            his gaze to you, saying, <.q>Well, basically, to make 
//            a long story short, in 2068 there was a full-blown 
//            nuclear war.<./q> 
//          <p><.q>It wiped out at least 95% of the human species 
//            and effectively destroyed your civilization,<./q> 
//            Ovan says with a decisive nod. 
//          <p><.q>Few populations survived the war,<./q> says Neton. 
//            <.q>The remaining humans had time for little else 
//            but survival, so learning and culture dwindled. 
//            With very few exceptions, technology reverted 
//            almost back to the stone age.<./q> 
//          <p><.q>And so it has remained until the present day,<./q> 
//            adds Ovan, nodding. <.q>Human civilization 
//            as you know it no longer exists.<./q> 
//          <p>Neton says, <.q>We understand that, in human cultures, 
//            it is customary to offer condolences when telling 
//            such news,<./q> says Neton. <.q>Rest assured, you have 
//            our condolences.<./q> ";
//        break;
      case 6:
        return ovan;
//        "Then Ovan looks you in the eye and says, 
//            <.q>Neton and I belong 
//            to an alien race known as the Oo. We are from far 
//            outside your solar system.<./q>
//          <p>Neton says, <.q>During the early twenty-second century,
//            a few decades after the nuclear war, one of our 
//            Oo spaceships just happened to be passing by 
//            your planet, when they noticed signs of life on
//            the Earth<./s>s surface.<./q>
//          <p><.q>The crew decided to zoom down to your planet 
//            to investigate,<./q> says Ovan. <.q>They explored 
//            briefly, then returned to the ship with their 
//            findings. Most of the Oo did not wish to be diverted 
//            any further, so they blasted off and proceeded with 
//            their primary mission.<./q>
//          <p><.q>A few, however, decided to stay behind and 
//            investigate at much greater length,<./q> says Neton, 
//            <.q>even though they knew they would have no spaceship 
//            with which to get back home. Ovan and I are 
//            descended from this group of Oo investigators. 
//            Our race has been investigating Earth for 
//            almost a hundred years now.<./q> 
//          <p><.q>Since then it<./s>s become painfully obvious that 
//            there is not a hundred years<./s> worth of stuff to study 
//            here,<./q> says Ovan with a sigh. <.q>But we make the 
//            most of it.<./q>
//          <p><.q>And we wait for the day when another spaceship 
//            will come to bring us back home,<./q> says Neton. ";
//        break;
      case 7:
        return neton;
//        "Then Neton looks at you and says, 
//            <.q>Now, as I said earlier, Ovan and I are scholars 
//            of the humanities.<./q> (The noun might literally be 
//            translated as <.q>Oo-ities,<./q> but it<./s>s easier 
//            to think in terms of words you know.) 
//            <.q>That means we study, 
//            among other things, interactive fiction.<./q> 
//          <p><.q>What do you mean, other things? I study 
//            nothing else!<./q> Ovan says with a grin.
//          <p>Neton shakes his head, then continues. 
//            <.q>In Oo culture, interactive fiction is regarded 
//            as the highest form of art. All other 
//            media&mdash;painting, architecture, literature, 
//            film&mdash;are of only secondary significance 
//            compared with interactive fiction, or IF.<./q>
//          <p><.q>Personally, I don<./s>t like paintings or books 
//            very much,<./q> says Ovan, <.q>unless they are 
//            paintings or books about IF.<./q>
//          <p>You frown. Are they talking about what you think 
//            they<./s>re talking about? Interactive fiction, as in 
//            text adventure games like <.game>Zork?<./game>
//          <p><.q>Apparently, the same was not true in your 
//            culture,<./q> says Neton. <.q>Even though your 
//            planet independently invented IF, 
//            you did not grasp it for the revolutionary 
//            breakthrough that it was. After a brief flare of 
//            popularity in the 1980s, the whole medium seems 
//            to have gone into a decline.<./q>
//          <p>You shake your head in astonishment. Sure enough, 
//            they<./s>re talking about text adventure games. 
//            You were always a big fan of such games, 
//            but you never thought anybody would regard them as the 
//            highest form of art.
//          <p><.q>Some of us have speculated that this was, 
//            in fact, the reason for Earth<./s>s fate,<./q> says Ovan. 
//            <.q>Without a healthy respect for IF,  
//            where was the good judgment that might have 
//            averted a nuclear catastrophe?<./q>
//          <p>Neton says, <.q>We Oo have been studying 
//            Earth for nearly a century, 
//            but in all that time we never found a single 
//            human being who knew anything about 
//            interactive fiction.<./q>
//          <p><.q>Until now,<./q> says Ovan. ";
//        break;
      case 8:
        return neton;
//        glob.mentionedWindCryo = true;
//        if (cryoPapers.isIn(neton)) {
//          cryoPapers.moveInto(confTable);
//          "Then Neton sets the papers back down on the table, ";
//        }
//        else {
//          "Then Neton adjusts his green jacket, ";
//        }
//        "and he says
//            to you, <.q>You see, what brings you here
//            is an astonishing discovery. Only two months ago, 
//            one of our Oo scientists found a twenty-first-century 
//            human cryogenic facility that had auxiliary wind power, 
//            with the result that in over 150 years, 
//            the electricity had never gone out, 
//            and, amazingly, most of the frozen 
//            bodies were still intact.<./q>
//          <p><.q>He did an exhaustive search,<./q> Ovan says, 
//            <.q>and eventually found five such facilities 
//            with viable frozen humans.<./q>
//          <p>Neton says, <.q>Then he searched 
//            through the records
//            of these facilities and forwarded his findings to CESAC. 
//            There, Ovan and I made a remarkable discovery 
//            of our own. One of the humans on the 
//            list had said that he was interested
//            in interactive fiction. And that human was you.<./q>
//          <p><.q>Imagine,<./q> says Ovan, his voice rising 
//            to a squeal, <.q>a human with first-hand knowledge 
//            of Earth<./s>s golden age of IF! 
//            Naturally, we pushed for you to be revived 
//            as soon as possible.<./q> 
//          <p><.q>They accomplished this just a few days ago,<./q> 
//            Neton says, <.q>and now they tell us that you have 
//            been more or less physically rehabilitated. 
//            They sent you here in the next aircar.<./q>
//          <p><.q>We hope you enjoyed the flight,<./q> 
//            says Ovan. ";
//        if (!glob.aliensKnowPcLikesIf) {
//          "<p><.q>Now, perhaps we should confirm that our records 
//              are correct,<./q> says Neton.
//            <p><.q>Ah, yes, good point,<./q> says Ovan. Turning 
//              to you, he asks, <.q>Well, how about it? Is it 
//              true that you<./s>ve played interactive fiction?<./q> ";
//          nocMainPlayed.select;
//        }
//        break;
      case 9:
        return neton;
//        //Quip.explainBetaTesting;
//        //break;
//        if (!glob.mentionedBetaTesting) {
//          if (cryoPapers.isIn(neton)) {
//            cryoPapers.moveInto(confTable);
//            "Then Neton sets the papers back down on the table, ";
//          }
//          else {
//            "Then Neton nudges one of his books to bring it into more 
//              perfect alignment with the others in his stack, ";
//          }
//          "and he says,
//              <.q>Fortunately, your timing is very good. As it 
//              happens, you arrived at our institute just as
//              we were entering into the final stage of an
//              exciting project.<./q>
//            <p><.q>We wrote a game!<./q> says Ovan, beaming with 
//              pride.
//            <p>Neton says, <.q>As Ovan has 
//              indicated, he and I have just spent the last year
//              writing an IF game, which is now nearly complete.
//              All that remains is to test it and iron out
//              any remaining bugs. 
//            <p><.q>And we want you to help!<./q> Ovan says.
//            <p><.q>Since our game is set on Earth,<./q> Neton says,
//              <.q>it<./s>ll be great to get it tested by a human
//              with real knowledge of interactive fiction&mdash;not
//              to mention real knowledge of Earth as it once
//              was.<./q>
//            <p><.q>I<./s>m so excited!<./q> Ovan squeals";
//              //", nearly bouncing in his chair";
//              ". <.q>He<./s>s really gonna
//              play it!<./q> 
//            <p>Neton looks at Ovan and shakes his head. ";
//        }
//        glob.aliensKnowPcLikesIf = true;
//        glob.mentionedBetaTesting = true;
//        break;
      case 10:
        return neton;
//        "Then Neton turns to you and says, <.q>To explain why 
//            Ovan is so excited about our game, I<./s>ll have 
//            to go back and tell you about the artistic traditions 
//            of our homeworld. You see, many centuries ago, 
//            interactive fiction on planet Oo 
//            was very primitive by today<./s>s standards. 
//            Most early IF games were story-based, 
//            with <.s>plot,<./s> 
//            <.s>character development,<./s> and other such 
//            niceties.<./q> 
//          <p><.q>Some of these things might sound okay 
//            in principle,<./q> says Ovan, <.q>but in practice, 
//            all they do is detract from the one thing 
//            that<./s>s truly great about IF: puzzles.<./q>
//          <p><.q>Puzzles, indeed, have become all-important
//            in contemporary Oo interactive fiction,<./q> 
//            says Neton. <.q>Oo IF authors have 
//            experimented with hunger puzzles, inventory 
//            management puzzles, and so on. But of all the kinds
//            of puzzles, none are more dearly loved than mazes.<./q>
//          <p><.q>I just love mazes!<./q> Ovan cries, 
//            and gives a blissful smile. 
//          <p><.q>Mazes have become the main driving force
//            in contemporary Oo IF, with game authors continually
//            adding more and more mazes of greater and greater
//            complexity,<./q> says Neton.
//          <p>You can<./s>t believe this! In most IF games,
//            there<./s>s nothing worse than a maze. Walking from one 
//            identical room to the next while you scribble 
//            at a map is not your idea of a good time. 
//            What is wrong with these aliens? 
//          <p>Then Ovan takes on a look of perplexity as he says, 
//            <.q>Oddly enough, the exact opposite 
//            was true on Earth. Your IF games were 
//            perfect right from the start! Lots of mazes, 
//            plenty of puzzles, and no irrelevant story or plot. 
//            What more could anybody ask for?<./q>
//          <p><.q>But then,<./q> says Neton, 
//            <.q>having achieved such an excellent ideal, 
//            the game authors of Earth conspired to 
//            subvert it. As time went on, Earth<./s>s IF games 
//            grew more and more story-based, with fewer and fewer 
//            puzzles. In the end, they contained hardly any 
//            mazes.<./q>
//          <p><.q>I don<./s>t get it!<./q> says Ovan. <.q>Without
//            mazes, why write games at all?<./q>
//          <p><.q>Some mysteries were not meant to be 
//            unraveled,<./q> says Neton. <.q>Surely, this is 
//            a riddle to confound the sages.<./q> ";
//        break;
      case 11:
        return neton;
//        "Then Neton says to you, 
//            <.q>Now, this brings us to the game that Ovan
//            and I have written. 
//            You see, for years, the interactive fiction of Oo
//            has been filled with mazes, but it struck me as odd
//            that no one had ever thought to take this trend
//            to its ultimate conclusion.<./q>
//          <p><.q>That was a great idea 
//            you came up with, too!<./q> says
//            Ovan. <.q>I wish I<./s>d thought of it.<./q>
//          <p><.q>Thanks,<./q> says Neton, <.q>but don<./s>t be
//            so modest. I think your <.s>insta-death<./s> rooms
//            added a lot to the game.<./q>
//          <p><.q>Oh, it was nothing,<./q> says Ovan. <.q>Now
//            come on, let<./s>s tell him about the title.<./q>
//          <p><.q>Ah, yes,<./q> says Neton. 
//            <.q>You see, our game is set on Earth.
//            So we entitled the game\ .\ .\ . <.game>Totoona 
//            Eeret.<./q><./game> With that, Neton leans back and
//            looks at you significantly.
//          <p>You frown. Certainly, you understand that the
//            title means <i>The Mazes of Earth.</i> 
//            But you don<./s>t understand why
//            he<./s>s looking at you this way.
//          <p>Ovan sighs and says, <.q>I guess we<./s>ll have to 
//            explain it.<./q>
//          <p><.q>Yes, excuse me,<./q> says Neton. <.q>I thought
//            this was clear. But anyway&mdash;well, as you know, 
//            the word <i>eeret</i>
//            means <.s>Earth.<./s> However, as it happens, 
//            <i>eeret</i> is also an old Oo word
//            that means <.s>only.<./s><./q>
//          <p><.q>And so,<./q> says Ovan, <.q><i>Totoona Eeret</i> 
//            not only means <i>The Mazes of Earth,</i> 
//            but it also means <i>Only Mazes.</i><./q>
//          <p><.q>Or, to translate it more idiomatically,
//            you might call it\ .\ .\ .<./q> ";
//        nbmPause();
//        confRoom.killBanner = true;
//        nbmBanner.updateMe;
//        glob.status = blank;
//        statusLine.showStatusLineDaemon();
//        //nbmCls();
//        //csShout('');
//        //cutSceneBanner.clearWindow();
//        csDispImg('mazestitle.png');
//        playSound('<sound src=\"sound/prelude.mp3\" layer=foreground>');
//        nbmPause();
//        cutSceneBanner.removeBanner();
//        confRoom.killBanner = nil;
//        nbmBanner.updateMe;
//        glob.status = trinity;
//        statusLine.showStatusLineDaemon();
//        "<p>
//            <b>NOTHING BUT MAZES</b>
//            \nA Game
//            \nby Greg Boettcher
//            \nRelease <<versionInfo.version>>
//            \nCopyright 2006 Greg Boettcher";
//        if (!glob.isForIntroComp) {
//          "\n<a href=\"<<versionInfo.gameUrl>>\">Game<./s>s web site</a>";
//          "\n(Whatever you do, don<./s>t type ABOUT.)";
//        }
//        "<p><.q>.\ .\ .\ <i>Nothing but Mazes,<./q></i> 
//            says Neton.
//          <p>You are aghast. A game called <i>Nothing but Mazes?</i>
//            And they want you to play it? This is just too
//            much! ";
//        me.knowsMazeGameTitle = true;
//        break;
      case 12:
        return ovan;
//        "Then Ovan turns to Neton and says, 
//            <.q>Well, then I guess we<./s>ve explained everything!
//            Should we let him play the game right now, then?<./q>
//          <p>Neton replies, <.q>No, it is
//            far too late in the day. Besides, the human
//            is probably tired from his long flight. We should let 
//            him rest.<./q> 
//          <p><.q>Ah, yes, good point,<./q> says Ovan.
//          <p>Turning to you, Neton says, 
//            <.q>In a moment, the guards will take you to your 
//            guest room. Help yourself to as much food substance 
//            as you<./s>d like, and feel free to socialize with
//            the other guests. Above all, be sure to get a 
//            good night<./s>s sleep. But before we let you go, 
//            do you have any questions for us?<./q> ";
//        nocMainQuest.select;
//        break;
      default:
        return nil;
        //break;
    }
  }
;

// -------------------------------------------------------------------
// CONFERENCE ROOM BANNER PICTURES
// -------------------------------------------------------------------

//confPicPrint() {
//  if (!neton.isIn(confRoom))
//    return '<img src="misc/confroom2.jpg">';
//  else
//    return '<img src="misc/confprofs2.jpg">';
//}


// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

foolishToken: Fixture
  'foolishtoken' 'foolishtoken'
  @hallway9
  "This is a foolish token. "
;

//myConfFixture: Fixture
//  location = confRoom
//  afterAction {
//    local k = 0;
//    if (gAction.ofKind(TalkToAction))
//      k = k / k;
//  }
//;

//modify playerActionMessages
//    thingDescMsg(obj)
//    {
//        gMessageParams(obj);
//        return '{You/he} {sees} nothing unusual about '
//               + '{the obj/him}. ';
//    }
//;


//DefineIAction(Qq)
//  execAction() {
//    //argMain.execute;
//    cutSceneTwo();
//  }
//;
//
//VerbRule(Qq)
//  'qq'
//  : QqAction
//  verbPhrase = 'qq/qqing'
//;

/*
DefineIAction(Conf)
  execAction() {
    mainReport('{You\'re} not sleepy right now. ');
  }
;

VerbRule(Conf)
  'conf' | 'confroom'
  : ConfAction
  verbPhrase = 'go/going to the conference room'
;
*/

#endif // __DEBUG
