#include "madv.t"
#include "mystery.t"

init: function;

init: function
{
    version.sdesc;
    setdaemon( turncount, nil );               // start the turn counter daemon
    Me.location := startroom;                // move player to initial location
    startroom.lookAround( true );                    // show player where he is
    startroom.isseen := true;                  // note that we've seen the room
    scoreStatus(0);
    "\b[Try pushing the bust.] ";
}

version: object
        sdesc = "\b\(Example Mystery\)\n
                by David M.\ Tuller\b"
;

startroom: passageRoom
        sdesc = "Den"
        roomdesc = "This is an ordinary room with a bust. "
        secretdoor = passageDoor1
        east = 
        {
                if (secretdoor.isopen) return passageDoor1;
                else 
                {
                        "%You% can't go that way. ";
                        return nil;
                }
        } 
;

bust: triggerItem, fixeditem
        sdesc = "bust"
        ldesc = "It's Baaaach. "
        noun = 'bust'
        adjective = 'bach\'s' 'bach'
        location = startroom
        triggerobj = passageDoor1
        verDoPush( actor ) = {}
        doPush( actor ) = 
        {
                self.trigger; 
        } 
;

passageDoor1: secretDoor
        location = 
        {
                if (self.isopen) return startroom;
                else return nil;
        }
        noun = 'passage'
        adjective = 'secret'
        opendesc = "There is a secret passage to the east. "
        openmsg = "Suddenly, the walls slide back to reveal a secret
                passage! "
        closemsg = "The secret door shuts quietly. "
        otherside = passageDoor2
        doordest = passage
;

passageDoor2: secretDoor
        location = 
        {
                if (self.isopen) return passage;
                else return nil;
        }
        noun = 'passage'
        adjective = 'secret'
        opendesc = "There is a secret passage to the west. "
        openmsg = "The walls slide back and you can see the 
                den to the west. "
        closemsg = "The secret passage closes in on %you%. "
        otherside = passageDoor1
        doordest = startroom
;

passage: passageRoom 
        sdesc = "Secret Passage"
        roomdesc = "This is an ordinary secret passage. "
        secretdoor = passageDoor2
        west = 
        {
                if (secretdoor.isopen) return passageDoor2;
                else 
                {
                        "%You% can't go that way. ";
                        return nil;
                }
        } 
;

remote: triggerItem
        sdesc = "remote control"
        ldesc = "It has a single green button. "
        noun = 'remote' 'control'
        adjective = 'remote'
        location = passage
        triggerobj = passageDoor2
;

remotebutton: buttonitem
        sdesc = "green button"
        ldesc = "It's a green button. "
        noun = 'button'
        adjective = 'green'
        location = remote
        doPush( actor ) =
        {
                remote.trigger; 
        }
;

xavier: mdeadActor
        name = "Xavier"
        ldesc = "It looks like somebody stabbed ol' Xavier in the back. "
        location = startroom
        noun = 'xavier' 'body'
        adjective = 'xavier\'s'
;

mike: mActor
        name = "Mike"
        ldesc = "Mike looks like your usual computer hacker. "
        location = startroom
        noun = 'mike'
        murderlist = [knife disk]
        murderConf =
        {
                "Mike looks at you and says \"Yes. I killed him. 
                I KILLED him.\" ";
                incscore(50);
        }
        doPrint( actor ) =
        {
                caps(); self.name; " lets you fingerprint him. ";
                global.printlist += self;
        }
;

knife: item
        sdesc = "knife"
        ldesc = "It's an ordinary kitchen knife that was used to kill
                someone. "
        noun = 'knife'
        location = startroom
        prints = [mike xavier]
        printscore = 5
;

disk: hiddenClue
        hasbeenseen = nil
        sdesc = "diskette"
        ldesc = 
        {
                "The disk appears to be a game. The label says it was
                developed by Xavier, but you can just barely make out
                the word 'Mike'. ";
                useasclue := true;
                if (not hasbeenseen)
                {
                        hasbeenseen := true;
                        incscore(10);
                }
        }
        noun = 'disk' 'diskette' 'floppy'
        adjective = 'floppy'
        searchLoc = xavier
        useasclue = nil
        findpts = 5
;

replace timeevents: function
{
        if ((global.day = 'Monday') and 
            (global.minute = 45) and
            (global.hour = 11) and
            (global.isAM = true))
        {
                intsay('Suddenly, a loud voice booms \"This is a test. This
                is only a test.\"');
        }
        if ((global.day = 'Monday') and 
            (global.minute = 50) and
            (global.hour = 11) and
            (global.isAM = true))
        {
                intsay('Time is running out. ');
        }
}

replace runEnding: function( actor, canArrest )
{
        if (canArrest)
        {
                "\bThe following week, your superiors award you a promotion for
                your outstanding work on Xavier's murder. Good work! ";
                incscore(25);
                "\b";
                scoreRank();
                options();
        }
        else if (actor = nil)
        {
                "\bYou run out of time trying to solve the case. As you
                leave, Mike hits you over the head with a giant leg of
                lamb. ";
                die();
        }
        else
        {
                "\bMike gets out of jail immediately because there wasn't 
                enough evidence to convict. Soon afterwards, you are killed
                by a hit and run driver. ";
                die();
        }
}
