////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: BehindHider 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _BEHIND_HIDER_H_
#define _BEHIND_HIDER_H_

#include <hider.h>

#pragma C+

/*
 *  BehindHider: Hider
 *
 *  This is just like an underHider, except that objects are hidden
 *  behind this object.  Objects to be behind this object should have their
 *  behindLoc property set to point to this object.
 *  
 *  The objects hidden with behindHider must be of class Hidden.
 */
class BehindHider: Hider
    behindCont = []
    verDoLookbehind(actor) = {}
    doLookbehind(actor) = {
        if (self.behindCont == nil)
            "There's nothing else behind <<self.theDesc>>. ";
        else
            self.behindCont = self.searchObj(actor, self.behindCont);
    }
;

#pragma C-

#endif /* _BEHIND_HIDER_H_ */
