////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: DarkRoomDisplayable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _DARK_ROOM_DISPLAYABLE_H_
#define _DARK_ROOM_DISPLAYABLE_H_

#include <roomdisplayable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  DarkRoomDisplayable: RoomDisplayable
 *
 *  Rules for room display in a DarkRoom.
 */
class DarkRoomDisplayable: RoomDisplayable
    lookAround(verbosity) = {
        if (self.isLit(gActor()))
            pass lookAround;
        else
            "It's pitch black. ";
    }
    statusRoot = {
        if (self.isLit(gActor()))
            pass statusRoot;
        else
            "In the dark.";
    }
;

#pragma C-

#endif /* _DARK_ROOM_DISPLAYABLE_H_ */
