////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Door 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _DOOR_H_
#define _DOOR_H_

#include <floatingdestination.h>
#include <doorway.h>

#pragma C+

/*
 *  Door: FloatingDestination, Doorway
 *
 *  A Door is a Destination class that impedes progress when it is closed.
 *  Unlike the Doorway, a Door is Floating and should not have its
 *  location attribute coded. Instead, use the foundIn list to indicate
 *  the rooms in which the Door is to be found. 
 *
 *  To make a simple two-sided Door you need only code both room
 *  objects in the foundIn list of the Door: 
 *
 *      foundIn = [ hallway, kitchen ]
 *  
 *  To make a one-sided Door, code the foundIn list with the room
 *  object in which the Door is to be found, and the foundIn list
 *  with the room object to which the Door leads:
 *
 *      foundIn = hallway 
 *      leadsTo  = kitchen 
 *
 *  If you want a Door that returns rooms different from those it is
 *  found in, simply code both the foundIn list and foundIn list 
 *  accordingly, each element of the foundIn list must have a 
 *  corresponding foundIn element:
 *
 *      foundIn = [ hallway, kitchen ]
 *      leadsTo  = [ foyer, hallway ]
 *
 *  From the hallway the Door leads to the foyer, but from the kitchen
 *  it leads to the hallway.
 */
class Door: FloatingDestination, Doorway
; 

#pragma C-

#endif  /* _DOOR_H_ */
