////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Follower 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _FOLLOWER_H_
#define _FOLLOWER_H_

#include <actor.h>

#pragma C+

/*
 *  Follower: Actor
 *
 *  This is a special object that can "shadow" the movements of a
 *  character as it moves from room to room.  The purpose of a Follower
 *  is to allow the player to follow an actor as it leaves a room by
 *  typing a "follow" command.  Each actor that is to be followed must
 *  have its own follower object.  The Follower object should
 *  define all of the same vocabulary words (nouns and adjectives) as the
 *  actual actor to which it refers.  The Follower must also
 *  define the myActor property to be the Actor object that
 *  the Follower follows.  The Follower will always stay
 *  one room behind the character it follows; no commands are effective
 *  with a Follower except for "follow."
 */
class Follower: Actor
    isFollower = true
    myActor = nil   // set to the Actor to be followed
    sDesc = { self.myActor.sDesc; }
    lDesc = { caps(); self.myActor.theDesc; " <<self.myActor.isDesc>> no
             longer here. "; }
    actorDesc = {}
    actorAction(v, d, p, i) = { self.lDesc; exit; }
    verDoFollow(actor) = {}
    doFollow(actor) = {
        actor.travelTo(self.myActor.location);
    }
    dobjGen(a, v, i, p) = {
        if (v != followVerb) {
            "\^<< self.myActor.theDesc >> <<self.myActor.isDesc>> no
            longer here.";
            exit;
        }
    }
    iobjGen(a, v, d, p) = {
        "\^<< self.myActor.theDesc >> <<self.myActor.isDesc>> no
        longer here.";
        exit;
    }
;

#pragma C-

#endif /* _FOLLOWER_H_ */
