////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: ListGroupMessage 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _LIST_GROUP_MESSAGE_H_
#define _LIST_GROUP_MESSAGE_H_

#include <listgroup.h>
#include <listcontgen.t>

#pragma C+

/*
 *  ListGroupMessage: ListGroup
 *
 */
class ListGroupMessage: ListGroup
    groupPrefix = nil
    groupSuffix = nil
    showList(desc, flags, indent) = {
        local t = self.getSizeOfGroup;
        local desc = &aDesc;
        
        if (t > 1) {
            if (proptype(self, &groupPrefix) != DTY_NIL)
                "<<self.groupPrefix>> ";
            desc = &groupDesc;
        }
        listContGen(self.groupList_, desc, flags|LCG_NOLISTGROUP, indent);
        if (t > 1) {
            if (proptype(self, &groupSuffix) != DTY_NIL)
                " <<self.groupSuffix>>";
        }
    }
;

#pragma C-

#endif /* _LIST_GROUP_MESSAGE_H_ */
