////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Openable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _OPENABLE_H_
#define _OPENABLE_H_

#include <itemcount.t>
#include <listcont.t>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  Openable: object
 *
 *  A class that can be opened and closed.  The isOpenable
 *  property is set to true.  
 */
class Openable: object
    isOpenable = true
    isOpen = true
    canSenseLocations(sense, isVantage) = {
        return self.canSenseContents(sense, isVantage);
    }
    canSenseContents(sense, isVantage) = { 
        if (self.isOpen || isVantage)
            return true;
        else return material.senseThru(sense);
    }
    verDoClose(actor) = {
        if (!self.isOpen) {
            caps(); self.theDesc; " <<self.isDesc>> already closed! ";
        }
    }
    doClose(actor) = {
        "Closed. ";
        self.setIsOpen(nil);
    }
    verDoOpen(actor) = {
        if (self.isOpen) {
            caps(); self.theDesc; " <<self.isDesc>> already open! ";
        } else if (self.isLockable && self.isLocked) {
            "\^<<self.itIsDesc>> locked. ";
        }
    }
    doOpen(actor) = {
        if (!actor.isIn(self) && itemCount(self.contents)) {
            "Opening "; self.theDesc; " reveals "; listCont(self); ". ";
        }
        else
            "Opened. ";
        self.setIsOpen(true);
    }
    setIsOpen(setting) = {
        /* update my status */
        self.isOpen = setting;

        /* 
         *   if there's another side to this door, and its status is not
         *   already set to the new setting, update it as well (we don't
         *   update it if it's already been updated, since otherwise we'd
         *   recurse forever calling back and forth between the two sides) 
         */
        if (self.otherSide != nil && self.otherSide.isOpen != setting)
            self.otherSide.setIsOpen(setting);
    }
    verDoLookin(actor) = {
        /* we can look in it if either it's open or it's transparent */
        if (!self.isOpen && !self.isTransparent)
           "\^<<self.itIsDesc>> closed. ";
    }
    verDoSearch(actor) = { self.verDoLookin(actor); }
    verIoPutIn(actor) = {
        if (!self.isOpen) {
            caps(); self.theDesc; " <<self.isDesc>> closed. ";
        }
    }
;

#pragma C-

#endif /* _OPENABLE_H_ */
