////////////////////////////////////////////////////////////////////////
//  
//  Venture
//  Release:    1.0
//
//  Copyright (c) 2000 Kevin Forchione. All rights reserved.
//
//  This file is one of the Alt Library demonstration games
//  and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#include <stdif.h>

#pragma C+

modify story
    startingLocation = forestClearing
    title = "VENTURE"
    headline = "An Interactive Worked Example\n
        Copyright (c) 2000 by Kevin Forchione\n"
    introduction = "\b\b\b\bDays of cutting through impenetrable 
        underbrush have brought you to the brink of exhaustion. At last
        your efforts bear fruit as you stumble upon the remnants of a
        lost civilisation."
    initDaemon = {
        randomize;
        notify(queue, &processQueue, 0);    
        setdaemon(turnCount, nil);                 // start the turn counter daemon
        setdaemon(sleepDaemon, nil);                      // start the sleep daemon
        setdaemon(eatDaemon, nil);                       // start the hunger daemon
        gameClock.setClock('5:00 am', 5, 1887, 6, 17);        
    }
;

forestClearing: Room
    sDesc = "Forest Clearing"
    lDesc = "This small clearing is covered in a thick bed of grasses
        and heavy frond leaves of the trees that form a near-
        impenetrable barrier encircling it. The air is heavy and
        sweltering, seemingly drawing out swarms of tiny blue-bottle
        flies that dart about drawn to the rotting vegetation."
    down = stoneSteps
;

redBerry: FoodItem
    location = forestClearing
    noun = 'berry'
    adjective = 'red'
    sDesc = "red berry"
    initial = "A red berry hangs suspended from a vine 
        like a single drop of blood."
    lDesc = "The berry gleams darkly ruby-red, leaving you
        to wonder what it is you seem to have forgotten about
        this particular fruit. "
    dobjPreAction = {
        local r;
        switch(gVerb()) {
            case tasteVerb:
                "You extend your tongue tentatively\n";
                return nil;
            case eatVerb:
                r = _rand(100);
                if (r <= 30) {
                    "The tinniest nibble is enough. It was a poisonous
                    berry after all. ";
                    story.deathMessage(nil);
                } else
                    "You nibble at the berry, but the curious taste 
                    repels you. ";
                return true;
        }
    }
    dobjPostAction = {
        switch(gVerb()) {
            case takeVerb: 
                if (self.hasMovedCount == 1) 
                    "You pick the berry, neatly cleaving it from the vine. ";
                else
                    "You pick up the slowly-decaying berry.";
                return true;
            case dropVerb:
                "The berry drops to the ground, battered slightly. ";
                raven.squawk('Nevermore!');
                return true;
        }
    }
;

gnarledTree: FixedItem
    location = forestClearing
    noun = 'tree'
    adjective = 'gnarled' 'old' 'very'
    sDesc = "gnarled old tree"
    lDesc = {
        "It looks as though it's been there for hundreds of years. ";
        if (raven.isIn(self))
            "\^<<raven.aDesc>> <<raven.isDesc>> <<raven.posture.desc>> 
            high up in one of its branches.";
    }
    initial = "At the edge of the clearing stands a very old gnarled
        tree. "
;

raven: Animate
    location = gnarledTree
    noun = 'raven'
    adjective = 'ominous' 'ominous-looking'
    sDesc = "raven"
    lDesc = "It's an ominous-looking raven! It seems to be watching
        you!"
    actorDesc = "An ominous looking raven is here, watching you
        intently."
    squawk(utterance) = {
        if (self.isIn(gLocation(sound)))
            "\bQuoth <<self.theDesc>>, \"<<utterance>> <<utterance>>\"";

    }
    posture = perching
;

perching: Posture
    desc = "perching"
;

ruckSack: SackItem
    location = forestClearing
    noun = 'sack' 'rucksack' 'bag'
    adjective = 'ruck'
    sDesc = "rucksack"
    aDesc = "your <<self.sDesc>>"
    theDesc = "your <<self.sDesc>>"
    lDesc = {
        "This capacious sack can hold a surprising number of
        objects. ";
        pass lDesc;
    }
    whenOpen = "\^<<self.theDesc>> is here, lying open."
;

stoneSteps: Passageway
    location = forestClearing
    noun = 'steps'
    adjective = 'stone'
    isThem = true
    sDesc = "stone steps"
    lDesc = "Ancient steps extend down into shadows. Perhaps these steps
        have have lain untrodden for a thousand years."
    leadsTo = stoneChamber
;

stoneChamber: Room
    sDesc = "Stone Chamber"
    lDesc = "The sunken chamber appears to be hewn from the living rock
        itself. It forms a perfect square ten yards on each side.
        Sunlight filters down from the steps above, casting the furthest
        corners of the chamber into deepening shadow."
;

mist: Floating, Decoration
    foundIn = [forestClearing, stoneChamber]
    noun = 'mist'
    adjective = 'low-lying'
    sDesc = "low-lying mist"
    initial = "A low-lying mist hugs the ground about your feet."
    smellDesc = "The mist smells of boiled cabbage."
    doSmell(actor) = {self.smellDesc;}
;

#pragma C-
