/*
 * Sample game area to test stuff
 */
#include <world.t>

Me: Player
  location = startroom
;

startroom: Room
  sdesc = "room 1"
  ldesc = "You are in a very boring room."
  noun = 'room 1'
;

/*
 * Cupcake dispenser
 */
dispenser: Fixture
  sdesc = "cupcake dispenser"
  ldesc = "This is a classic cupcake dispenser with a big red button for
    dispensing cupcakes."
  heredesc = { "A rather battered looking cupcake dispenser rests against the
    northern wall."; }
  noun = 'dispenser' 'machine'
  adjective = 'cupcake'
  location = startroom
;

button: Part, Button
  partof = dispenser
  sdesc = "button"
  ldesc = "It's big, it's red, it's round. Yep, it's a button."
  noun = 'button'
  adjective = 'red'
  numcupcakes = 10

  doPush(actor) =
    {
    if (numcupcakes > 0)
      {
      local x = new Cupcake;
      "The dispenser grinds for a second, and then dumps a cupcake onto the
       floor through a small hatch.";
      numcupcakes--;
      }
    else
      "Click! Nothing happens.";
    }
;

class Cupcake: Edible
  isEquivalent = true
  sdesc = "cupcake"
  ldesc = "This is a rather unremarkable, but delicious looking, cupcake."
  noun = 'cupcake' 'cake'
  plural = 'cupcakes'

  doEat(actor) =
    {
    self.eatdesc(actor);
    self.addfoodvalue(actor);
    delete self;
    }
  eatdesc(actor) = { "The cupcake tastes absolutely delicious."; }

  construct =
    {
    self.movein(dispenser.location);
    }

  destruct =
    {
    self.movein(nil);
    }
;