#include <adv.t>
#include "stdlab10.t"

startroom: room
  sdesc = "Lobby"
  ldesc = "You're in a large lobby, with an office to the east.  A large
  receptionist's desk sits next to the office door. "
  east = office
;

office : room
  sdesc = "Office"
  ldesc = "You are in a fairly ordinary office. The exit is to the
  west. There is a small closet to the north. "
  west = startroom
  north = closet
;

closet : room
  sdesc = "Closet"
  ldesc = "You are in a closet at the north end of the office. "
  south = office
;

receptionist: Actor
  noun = 'receptionist'
  sdesc = "receptionist"
  ldesc = "The receptionist reminds you of your third-grade teacher."
  location = startroom
  actorDesc = "A receptionist is sitting at the desk next to the door,
  watching you suspiciously. "
  script =
  {
    // Print a random fidget message when you're in the same room as
    // the receptionist
    if (self.location == Me.location)
    {
      switch(rand(5))
      {
      case 1:
        "\n\tThe receptionist sharpens some pencils. ";
        break;
      case 2:
        "\n\tThe receptionist goes through some personal mail, holding each
        letter up to the light and attempting to read the contents. ";
        break;
      case 3:
        "\n\tThe receptionist looks through the personnel files. ";
        break;
      case 4:
        "\n\tThe receptionist answers the phone and immediately puts the
        caller on hold, cackling to herself fiendishly. ";
        break;
      case 5:
        "\n\tThe receptionist shuffles some papers. ";
        break;
      }
    }
  }
;

lloyd: Actor
  noun = 'lloyd' 'salesman'
  adjective = 'insurance'
  sdesc = "Lloyd"
  adesc = "Lloyd"
  thedesc = "Lloyd"
  ldesc = "Lloyd has jet-black hair and thick glasses. "
  actorDesc = "An insurance salesman, with the name \"Lloyd\" clearly 
  emblazoned on his nametag, is holding a clipboard and eyeing you 
  intently. "
  location = startroom
  script = 
  {
    if (self.location == Me.location)
    {
      switch(rand(3))
      {
      case 1:
        "\n\tLloyd hums one of his favorite insurance songs. ";
        break;
      case 2:
        "\n\tLloyd scribbles something on his clipboard. ";
        break;
      case 3:
        "\n\tLloyd idly fingers his nametag. ";
        break;
      }
    }
    else
    {
      self.travelTo(Me.location);
    }
  }
;

vacRobot: Actor
  sdesc = "cleaning robot"
  noun = 'robot'
  adjective = 'cleaning'
  ldesc = "The robot has a bright metallic sheen and numerous cleaning
  attachments. "
  actorDesc = "A cleaning robot darts from corner to corner in search of
  dust particles. "
  tracklist = [closet office startroom office]
  trackpos = 0
  script = 
  {
    // Move the robot along his path
    self.trackpos = self.trackpos + 1;
    
    // Loop around if we've reached the end of the tracklist
    if (self.trackpos > length(self.tracklist))
    {
      self.trackpos = 1;
    }
    
    self.travelTo(tracklist[self.trackpos]);
  }
  sayLeaving = "\n\tThe cleaning robot rolls out of the room. "
  sayArriving = "\n\tThe cleaning robot rolls into the room and starts
  noisily moving around the room vacuuming and dusting. "
  myfollower = vacRobotFollower
;

vacRobotFollower : follower
  noun = 'robot'
  adjective = 'cleaning'
  myactor = vacRobot
;

fortuneteller : Actor
  sdesc = "fortuneteller"
  noun = 'fortuneteller' 'teller'
  adjective = 'fortune'
  ldesc = "The fortuneteller is an old man with a gray beard.  He
  is sitting cross-legged in the corner. "
  actorDesc = "A fortuneteller is here, waiting to tell you the future
  about anyone you ask about. "
  location = closet
  askWord(word, lst) = 
  { 
    switch (word)
    {
    case 'lloyd':
    case 'salesman':
      "\"Lloyd is a most annoying salesman.  He will be killed by an
      irate customer before the year is out.\" ";
      return true;
    case 'robot':
      "\"The cleaning robot will develop a short circuit tomorrow
      afternoon.\" ";
      return true;
    case 'receptionist':
      "\"The receptionist will have heartburn later tonight.\" ";
      return true;
    case 'teller':
    case 'fortuneteller':
    case 'himself':
      "\"I was trained at an accredited forecasting college.\" ";
      return true;
    case 'elvis':
      "\"Elvis is dead.\" ";
      return true;
    }
    return nil; 
  }
  
  disavow = "\"The future of that is not clear to me.\" "
;

conversationTopics : thing
  noun = 'elvis' 'himself'
;
