#include <adv.t>
#include <std.t>

startroom : room
  sdesc = "Bedroom"
  ldesc = "You are in your bedroom. 
  Out the window, you can see some mountains in the distance.  
  Furnishing the room is a waterbed, and a chair in front of a desk.  
  A closet is to the east."
  east = closet
;

mountains : distantItem
  location = startroom
  noun = 'mountain' 'mountains'
  sdesc = "mountains"
  ldesc = "The mountains are beautiful, but are far, far away."
;

magnifyingGlass : seethruItem
  location = startroom
  noun = 'glass'
  adjective = 'magnifying'
  sdesc = "magnifying glass"
  ldesc = "It looks like a standard, handheld magnifying glass."
  thrudesc = "When you look through the magnifying glass, everything
  looks much bigger."
;

window : seethruItem, fixeditem
  location = startroom
  noun = 'window'
  sdesc = "window"
  ldesc = "A double-paned window provides a pleasant mountain view."
  thrudesc = "As you look through the window, you sigh at the beauty of
  the mountains outside."
;

comfyChair : chairitem
  location = startroom
  noun = 'chair'
  adjective = 'comfy'
  sdesc = "chair"
  ldesc = "The comfy chair has an indentation in the seat from many
  years of supporting your butt."
;

waterbed : beditem
  location = startroom
  noun = 'bed' 'waterbed'
  sdesc = "waterbed"
  ldesc = "The king-size waterbed takes up most of the room."
;

candybar : fooditem
  location = startroom
  noun = 'bar'
  adjective = 'candy' 'chocolate'
  sdesc = "chocolate bar"
  ldesc = "The bar of chocolate is unwrapped.  It's amazing it hasn't
  turned into a sticky, gooey mess."
;

ring : clothingItem
  location = startroom
  noun = 'ring'
  adjective = 'secret' 'decoder' 'plastic'
  sdesc = "ring"
  ldesc = "This is the plastic secret decoder ring that you found in 
  your box of Cheerios yesterday at breakfast."
;

desk : surface, fixeditem
  location = startroom
  noun = 'desk'
  sdesc = "desk"
;

pencilHolder : container
  location = desk
  noun = 'holder'
  adjective = 'pencil'
  sdesc = "pencil holder"
;

box : openable
  location = startroom
  noun = 'box'
  adjective = 'cardboard'
  sdesc = "cardboard box"
  isopen = nil
;

jar : transparentItem, lockable
  location = box
  noun = 'jar' 'latch'
  adjective = 'glass' 'locking'
  sdesc = "glass jar with locking latch"
  isopen = nil
  islocked = true
;

brassKey : keyItem
  location = closet
  noun = 'key'
  adjective = 'brass' 'big' 'shiny'
  sdesc = "brass key"
  ldesc = "It's a big, shiny, brass key."
;

treasureChest : keyedLockable
  location = startroom
  noun = 'chest'
  adjective = 'treasure'
  sdesc = "treasure chest"
  mykey = brassKey
  isopen = nil
  islocked = true
;

closet : darkroom
  sdesc = "Closet"
  ldesc = "You are in a tiny closet containing a dresser and a pile of clothes.
  The exit is to the west."
  west = startroom
;

firefly : lightsource
  location = jar
  noun = 'fly' 'firefly'
  sdesc = "firefly"
  ldesc = "The firefly is buzzing and generating a surprising amount of
  light."
  islit = true
;

dresser : underHider, behindHider, fixeditem
  location = closet
  noun = 'dresser'
  sdesc = "dresser"
  ldesc = "This dresser has no drawers, and is falling apart.  The
  dresser has short stubby legs, which create a bit of a gap between the
  dresser and the floor.  There is also some space behind the dresser."
;

clothes : searchHider, fixeditem
  location = closet
  noun = 'pile'
  adjective = 'clothes'
  sdesc = "pile of clothes"
  ldesc = "A messy pile of clothes covers the floor.  Who could even
  guess what might be buried in the pile?"
;

diamond : hiddenItem, item
  underLoc = dresser
  noun = 'diamond'
  sdesc = "diamond"
  ldesc = "The sparkling diamond is exquisite.  You can't imagine how it
  could have ended up under the dresser."
;

emerald : hiddenItem, item
  behindLoc = dresser
  noun = 'emerald'
  sdesc = "emerald"
  adesc = "an emerald"
  ldesc = "The emerald is an intense shade of green.  You wonder how it
  ended up behind the dresser."
;

ruby : hiddenItem, item
  searchLoc = clothes
  noun = 'ruby'
  sdesc = "ruby"
  ldesc = "The ruby is blood red.  What was it doing in your pile of
  clothes?"
;

pencil : item
  location = pencilHolder
  noun = 'pencil'
  adjective = 'wooden' 'wood'
  sdesc = "wood pencil"
  ldesc = "This pencil is in dire need of sharpening."
;

