//
//  XTLoggingClassesInitializer.m
//  XTads
//
//  Created by Rune Berg on 24/02/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTLoggingClassesInitializer.h"
#import "XTLogConfig.h"
#import "XTBannerTextHandler.h"
#import "XTBannerContainerView.h"
#import "XTBannerTextView.h"
#import "XTBannerBorderView.h"
#import "XTFontManager.h"
#import "XTOutputFormatter.h"
#import "XTPendingWhitespaceQueue.h"
#import "XTTabStopModel.h"
#import "XTHtmlLinebreakHandler2.h"
#import "XTHtmlTag.h"
#import "XTOpenForTestingController.h"
#import "XTTads2AppCtx.h"
#import "XTHtmlCharEntityParser.h"
#import "XTOutputTextParserHtml.h"
#import "XTOutputTextParserPlain.h"
#import "XTPrefs.h"
#import "XTPrefsWindowController.h"
#import "XTResourceFinder.h"
#import "XTMainTextView.h"
#import "XTUIUtils.h"
#import "XTFontUtils.h"
#import "XTTextFieldWithLink.h"
#import "XTTextView.h"
#import "XTViewLayoutUtils.h"
#import "XTAllocDeallocCounter.h"
#import "XTFileNameHelper.h"
#import "XTEventLoopBridge.h"
#import "XTFileUtils.h"
#import "XTStringUtils.h"
#import "XTUserDefaultsUtils.h"
#import "XTAppDelegate.h"
#import "XTBaseTextHandler.h"
#import "XTGameWindowController.h"
#import "XTMainTextHandler.h"
#import "XTVmHostIfcClassName.h"


@implementation XTLoggingClassesInitializer

static BOOL hasBeenInitialized = NO;

+ (void)initialize
{
	if (hasBeenInitialized) {
		return;
	}
	hasBeenInitialized = YES;
	
	NSArray *loggingClasses = @[
		[XTAppDelegate class],
		[XTBannerTextHandler class],
		[XTBannerContainerView class],
		[XTBannerTextView class],
		[XTBannerBorderView class],
		[XTFontManager class],
		[XTOutputFormatter class],
		[XTPendingWhitespaceQueue class],
		[XTTabStopModel class],
		[XTHtmlLinebreakHandler2 class],
		[XTHtmlTag class],
		[XTOpenForTestingController class],
		[XTTads2AppCtx class],
		[XTHtmlCharEntityParser class],
		//[XTLogConfig class],  -- No, this class handles itself
		[XTOutputTextParserHtml class],
		[XTOutputTextParserPlain class],
		[XTPrefs class],
		[XTPrefsWindowController class],
		[XTResourceFinder class],
		[XTMainTextView class],
		[XTUIUtils class],
		[XTFontUtils class],
		[XTTextFieldWithLink class],
		[XTTextView class],
		[XTViewLayoutUtils class],
		[XTAllocDeallocCounter class],
		[XTFileNameHelper class],
		[XTEventLoopBridge class],
		[XTFileUtils class],
		[XTStringUtils class],
		[XTUserDefaultsUtils class],
		[XTBaseTextHandler class],
		[XTGameWindowController class],
		[XTMainTextHandler class]
	];
	
	for (Class aClass in loggingClasses) {
		// Nothing, just trigger each logging class's +initialize
	}
	
	// ...and a couple of special (read: C, C++ class) cases:
	[XTLogConfig registerLoggerForName:@"XTAppResourceLoader"];
	[XTLogConfig registerLoggerForName:@"osxtads"];
	[XTLogConfig registerLoggerForName:XT_VM_HOST_IFC_CLASS_NAME];
	
	[XTAppDelegate class]; // to trigger +initialize
}
	
@end
