//
//  XTViewLayoutUtils.m
//  XTads
//
//  Created by Rune Berg on 27/12/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import "osxtads.h"
#import "osifc.h"
#import "XTViewLayoutUtils.h"
#import "XTLogger.h"


@implementation XTViewLayoutUtils

static XTLogger* logger;

+ (void)initialize
{
	logger = [XTLogger loggerForClass:[XTViewLayoutUtils class]];
}

+ (void)newLayoutInParentView:(NSView *)parentView
				   childView1:(NSView *)childView1
				   childView2:(NSView *)childView2
		  childView2Alignment:(NSUInteger)childView2Alignment
			   childView2Size:(CGFloat)childView2Size
		 childView2IsAbsSized:(BOOL)childView2IsAbsSized
{
	XT_TRACE_ENTRY;
	
	NSLayoutAttribute childView1Edge1;
	NSLayoutAttribute childView1Edge2;
	NSLayoutAttribute childView1Edge3;
	NSLayoutAttribute childView1Edge4; // facing childView2
	NSLayoutAttribute childView2Edge1;
	NSLayoutAttribute childView2Edge2;
	NSLayoutAttribute childView2Edge3;
	NSLayoutAttribute childView2Edge4; // facing childView1
	NSLayoutAttribute childView2SizeOrientation; // is size height or width?
	
	switch (childView2Alignment) {
		case OS_BANNER_ALIGN_TOP:
			childView1Edge1 = NSLayoutAttributeBottom;
			childView1Edge2 = NSLayoutAttributeLeft;
			childView1Edge3 = NSLayoutAttributeRight;
			childView1Edge4 = NSLayoutAttributeTop;
			childView2Edge1 = NSLayoutAttributeTop;
			childView2Edge2 = NSLayoutAttributeLeft;
			childView2Edge3 = NSLayoutAttributeRight;
			childView2Edge4 = NSLayoutAttributeBottom;
			childView2SizeOrientation = NSLayoutAttributeHeight;
			break;
		case OS_BANNER_ALIGN_BOTTOM:
			childView1Edge1 = NSLayoutAttributeTop;
			childView1Edge2 = NSLayoutAttributeLeft;
			childView1Edge3 = NSLayoutAttributeRight;
			childView1Edge4 = NSLayoutAttributeBottom;
			childView2Edge1 = NSLayoutAttributeBottom;
			childView2Edge2 = NSLayoutAttributeLeft;
			childView2Edge3 = NSLayoutAttributeRight;
			childView2Edge4 = NSLayoutAttributeTop;
			childView2SizeOrientation = NSLayoutAttributeHeight;
			break;
		case OS_BANNER_ALIGN_LEFT:
			childView1Edge1 = NSLayoutAttributeTop;
			childView1Edge2 = NSLayoutAttributeBottom;
			childView1Edge3 = NSLayoutAttributeRight;
			childView1Edge4 = NSLayoutAttributeLeft;
			childView2Edge1 = NSLayoutAttributeTop;
			childView2Edge2 = NSLayoutAttributeBottom;
			childView2Edge3 = NSLayoutAttributeLeft;
			childView2Edge4 = NSLayoutAttributeRight;
			childView2SizeOrientation = NSLayoutAttributeWidth;
			break;
		case OS_BANNER_ALIGN_RIGHT:
			childView1Edge1 = NSLayoutAttributeTop;
			childView1Edge2 = NSLayoutAttributeBottom;
			childView1Edge3 = NSLayoutAttributeLeft;
			childView1Edge4 = NSLayoutAttributeRight;
			childView2Edge1 = NSLayoutAttributeTop;
			childView2Edge2 = NSLayoutAttributeBottom;
			childView2Edge3 = NSLayoutAttributeRight;
			childView2Edge4 = NSLayoutAttributeLeft;
			childView2SizeOrientation = NSLayoutAttributeWidth;
			break;
		default:
			XT_ERROR_1(@"unknown alignment %lu", childView2Alignment);
			return;
	}
	
	[self addEdgeConstraint:childView1Edge1 superview:parentView subview:childView1];
	[self addEdgeConstraint:childView1Edge2 superview:parentView subview:childView1];
	[self addEdgeConstraint:childView1Edge3 superview:parentView subview:childView1];
	
	[self addEdgeConstraint:childView2Edge1 superview:parentView subview:childView2];
	[self addEdgeConstraint:childView2Edge2 superview:parentView subview:childView2];
	[self addEdgeConstraint:childView2Edge3 superview:parentView subview:childView2];
	
	[parentView addConstraint:[NSLayoutConstraint constraintWithItem:childView1
														   attribute:childView1Edge4
														   relatedBy:NSLayoutRelationEqual
															  toItem:childView2
														   attribute:childView2Edge4
														  multiplier:1
															constant:0]];
	
	NSView *otherView = nil;
	CGFloat multiplier = 1.0;
	if (! childView2IsAbsSized) {
		otherView = parentView;
		multiplier = childView2Size / 100.0;
		childView2Size = 0.0;
	}
	
	[parentView addConstraint:[NSLayoutConstraint constraintWithItem:childView2
														   attribute:childView2SizeOrientation
														   relatedBy:NSLayoutRelationEqual
															  toItem:otherView
														   attribute:childView2SizeOrientation
														  multiplier:multiplier
															constant:childView2Size]];
}

+ (void)addEdgeConstraint:(NSLayoutAttribute)edge
				superview:(NSView *)superview
				  subview:(NSView *)subview
{
	[superview addConstraint:[NSLayoutConstraint constraintWithItem:subview
														  attribute:edge
														  relatedBy:NSLayoutRelationEqual
															 toItem:superview
														  attribute:edge
														 multiplier:1
														   constant:0]];
}


@end
