//
//  XTTabStopModel.h
//  XTads
//
//  Created by Rune Berg on 06/02/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTTabStopModelEntry.h"

@interface XTTabStopModel : NSObject

@property (readonly) NSUInteger count;

- (XTTabStopModelEntry *)entryAtIndex:(NSUInteger)index;

- (void)reset;

- (void)addTabStopWithId:(NSString *)ident
				position:(CGFloat)position
			   alignment:(NSString *)alignment
			 decimalChar:(NSString *)decimalChar;

- (XTTabStopModelEntry *)findTabWithId:(NSString *)toId;

- (CGFloat)findPositionOfNextTabWithMultiple:(NSNumber *)multipleObj
								fromPosition:(CGFloat)position
								enSpaceWidth:(CGFloat)enSpaceWidth;

- (XTTabStopModelEntry *)createOverridenTabStop:(XTTabStopModelEntry *)tabstop
										  align:(NSString *)alignment
									decimalChar:(NSString *)decimalChar;

- (XTTabStopAlignment)alignmentFromString:(NSString *)alignment;

- (XTTabStopAlignment)alignmentFromStringLeftCenterRightOnly:(NSString *)alignment;

@end
