//
//  XTResourceFinder.h
//  XTads
//
//  Created by Rune Berg on 04/05/15.
//  Copyright (c) 2015 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTResourceEntry.h"
#import "XTResourceFindResult.h"
#import "XTTads2AppCtx.h"


@interface XTResourceFinder : NSObject

@property XTTads2AppCtx *tads2AppCtx;

- (void)setResourceDir:(NSString *)resourceDir;

- (void)setGameFileName:(NSString *)fqGameFileName;

- (NSInteger)addPhysicalResourceFile:(NSString *)fqFileName;

- (void)setSeekBase:(NSUInteger)seekBase forPhysicalFileNo:(NSUInteger)physicalFileNo;

- (void)addResourceEntry:(XTResourceEntry *)entry;

- (XTResourceFindResult *)findResource:(NSString *)resName;

- (BOOL)resourceExists:(NSString *)resName;

- (XTResourceFindResult *)findResourceInTerpExecutable:(NSString *)resPath ofType:(NSString *)resType;

- (XTResourceFindResult *)findResource:(NSString *)resPath inTerpExecutableLibraryFile:(NSString *)libraryFile;

@end
