//
//  XTStringUtilsTests.m
//  TadsTerp
//
//  Created by Rune Berg on 24/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <XCTest/XCTest.h>
#import "XTStringUtils.h"


@interface XTStringUtilsTests : XCTestCase

@end


@implementation XTStringUtilsTests

- (void)setUp
{
    [super setUp];
}

- (void)tearDown
{
    // Put teardown code here. This method is called after the invocation of each test method in the class.
}

- (void)test_stringEndsWith
{
	XCTAssertTrue([XTStringUtils string:@"a" endsWith:@"a"]);
	XCTAssertTrue([XTStringUtils string:@"ab" endsWith:@"b"]);
	XCTAssertTrue([XTStringUtils string:@"abc" endsWith:@"c"]);
	XCTAssertTrue([XTStringUtils string:@"ab" endsWith:@"ab"]);
	XCTAssertTrue([XTStringUtils string:@"abc" endsWith:@"abc"]);
	XCTAssertTrue([XTStringUtils string:@"abcdef" endsWith:@"cdef"]);
	XCTAssertTrue([XTStringUtils string:@"game.gam" endsWith:@".gam"]);
	XCTAssertTrue([XTStringUtils string:@"game.t3" endsWith:@".t3"]);

	XCTAssertFalse([XTStringUtils string:@"a" endsWith:@"A"]);
	XCTAssertFalse([XTStringUtils string:@"A" endsWith:@"a"]);
	XCTAssertFalse([XTStringUtils string:@"ab" endsWith:@"aB"]);
	XCTAssertFalse([XTStringUtils string:@"a" endsWith:@"b"]);
	XCTAssertFalse([XTStringUtils string:@"ab" endsWith:@"a"]);
	XCTAssertFalse([XTStringUtils string:@"abc" endsWith:@"b"]);

	XCTAssertFalse([XTStringUtils string:nil endsWith:nil]);
	XCTAssertFalse([XTStringUtils string:@"" endsWith:nil]);
	XCTAssertFalse([XTStringUtils string:@"a" endsWith:nil]);
	XCTAssertFalse([XTStringUtils string:@"abc" endsWith:nil]);

	XCTAssertFalse([XTStringUtils string:nil endsWith:@""]);
	XCTAssertFalse([XTStringUtils string:@"" endsWith:@""]);
	XCTAssertFalse([XTStringUtils string:@"a" endsWith:@""]);
	XCTAssertFalse([XTStringUtils string:@"abc" endsWith:@""]);
}

- (void)test_stringEndsWithCaseInsensitive
{
	XCTAssertTrue([XTStringUtils string:@"a" endsWithCaseInsensitive:@"a"]);
	XCTAssertTrue([XTStringUtils string:@"a" endsWithCaseInsensitive:@"A"]);
	XCTAssertTrue([XTStringUtils string:@"A" endsWithCaseInsensitive:@"A"]);
	XCTAssertTrue([XTStringUtils string:@"A" endsWithCaseInsensitive:@"a"]);
	XCTAssertTrue([XTStringUtils string:@"ab" endsWithCaseInsensitive:@"b"]);
	XCTAssertTrue([XTStringUtils string:@"abc" endsWithCaseInsensitive:@"c"]);
	XCTAssertTrue([XTStringUtils string:@"ab" endsWithCaseInsensitive:@"ab"]);
	XCTAssertTrue([XTStringUtils string:@"abc" endsWithCaseInsensitive:@"abc"]);
	XCTAssertTrue([XTStringUtils string:@"abc" endsWithCaseInsensitive:@"ABC"]);
	XCTAssertTrue([XTStringUtils string:@"ABC" endsWithCaseInsensitive:@"abc"]);
	XCTAssertTrue([XTStringUtils string:@"ABC" endsWithCaseInsensitive:@"ABC"]);
	XCTAssertTrue([XTStringUtils string:@"abcdef" endsWithCaseInsensitive:@"cdef"]);
	XCTAssertTrue([XTStringUtils string:@"game.gam" endsWithCaseInsensitive:@".gam"]);
	XCTAssertTrue([XTStringUtils string:@"game.gam" endsWithCaseInsensitive:@".GAM"]);
	XCTAssertTrue([XTStringUtils string:@"GAME.GAM" endsWithCaseInsensitive:@".gam"]);
	XCTAssertTrue([XTStringUtils string:@"GAME.T3" endsWithCaseInsensitive:@".t3"]);
	
	XCTAssertFalse([XTStringUtils string:@"a" endsWithCaseInsensitive:@"b"]);
	XCTAssertFalse([XTStringUtils string:@"ab" endsWithCaseInsensitive:@"a"]);
	XCTAssertFalse([XTStringUtils string:@"abc" endsWithCaseInsensitive:@"b"]);
	
	XCTAssertFalse([XTStringUtils string:nil endsWithCaseInsensitive:nil]);
	XCTAssertFalse([XTStringUtils string:@"" endsWithCaseInsensitive:nil]);
	XCTAssertFalse([XTStringUtils string:@"a" endsWithCaseInsensitive:nil]);
	XCTAssertFalse([XTStringUtils string:@"abc" endsWithCaseInsensitive:nil]);
	XCTAssertFalse([XTStringUtils string:nil endsWithCaseInsensitive:@""]);
	
	XCTAssertFalse([XTStringUtils string:@"" endsWithCaseInsensitive:@""]);
	XCTAssertFalse([XTStringUtils string:@"a" endsWithCaseInsensitive:@""]);
	XCTAssertFalse([XTStringUtils string:@"abc" endsWithCaseInsensitive:@""]);
}

- (void)test_filterRepeatedNewlines
{
	XCTAssertEqualObjects(nil, [XTStringUtils filterRepeatedNewlines:nil]);
	XCTAssertEqualObjects(@"", [XTStringUtils filterRepeatedNewlines:@""]);
	XCTAssertEqualObjects(@"a", [XTStringUtils filterRepeatedNewlines:@"a"]);
	XCTAssertEqualObjects(@"abc", [XTStringUtils filterRepeatedNewlines:@"abc"]);
	XCTAssertEqualObjects(@"\n", [XTStringUtils filterRepeatedNewlines:@"\n"]);
	XCTAssertEqualObjects(@"\n", [XTStringUtils filterRepeatedNewlines:@"\n\n"]);
	XCTAssertEqualObjects(@"\n", [XTStringUtils filterRepeatedNewlines:@"\n\n\n"]);
	XCTAssertEqualObjects(@"a\nb", [XTStringUtils filterRepeatedNewlines:@"a\nb"]);
	XCTAssertEqualObjects(@"ab\nbc", [XTStringUtils filterRepeatedNewlines:@"ab\n\nbc"]);
	XCTAssertEqualObjects(@"ab\nb\nc", [XTStringUtils filterRepeatedNewlines:@"ab\n\nb\nc"]);
}

- (void)test_findRangeOfWhitespaceAfterLastNewline
{
	NSRange range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:nil];
	XCTAssertEqual(NSNotFound, range.location);

	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@""];
	XCTAssertEqual(NSNotFound, range.location);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\n"];
	XCTAssertEqual(NSNotFound, range.location);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"a"];
	XCTAssertEqual(NSNotFound, range.location);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"abc"];
	XCTAssertEqual(NSNotFound, range.location);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"a\n"];
	XCTAssertEqual(NSNotFound, range.location);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\na"];
	XCTAssertEqual(NSNotFound, range.location);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\t"];
	XCTAssertEqual(0, range.location);
	XCTAssertEqual(1, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@" "];
	XCTAssertEqual(0, range.location);
	XCTAssertEqual(1, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\t\t"];
	XCTAssertEqual(0, range.location);
	XCTAssertEqual(2, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"  "];
	XCTAssertEqual(0, range.location);
	XCTAssertEqual(2, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\t\t\t\t\t"];
	XCTAssertEqual(0, range.location);
	XCTAssertEqual(5, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"    "];
	XCTAssertEqual(0, range.location);
	XCTAssertEqual(4, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"x\t"];
	XCTAssertEqual(NSNotFound, range.location);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"x "];
	XCTAssertEqual(NSNotFound, range.location);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"x\t\t"];
	XCTAssertEqual(NSNotFound, range.location);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"x\t "];
	XCTAssertEqual(NSNotFound, range.location);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\n\ta"];
	XCTAssertEqual(NSNotFound, range.location);
	XCTAssertEqual(0, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\na\t"];
	XCTAssertEqual(NSNotFound, range.location);
	XCTAssertEqual(0, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\n\t"];
	XCTAssertEqual(1, range.location);
	XCTAssertEqual(1, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\n "];
	XCTAssertEqual(1, range.location);
	XCTAssertEqual(1, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\n\t\t"];
	XCTAssertEqual(1, range.location);
	XCTAssertEqual(2, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\n  "];
	XCTAssertEqual(1, range.location);
	XCTAssertEqual(2, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\n\t\t\t\t"];
	XCTAssertEqual(1, range.location);
	XCTAssertEqual(4, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"\n    "];
	XCTAssertEqual(1, range.location);
	XCTAssertEqual(4, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"abc\n\t"];
	XCTAssertEqual(4, range.location);
	XCTAssertEqual(1, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"abc\n  "];
	XCTAssertEqual(4, range.location);
	XCTAssertEqual(2, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"ab\n\t\t\t"];
	XCTAssertEqual(3, range.location);
	XCTAssertEqual(3, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"ab\n\t  "];
	XCTAssertEqual(3, range.location);
	XCTAssertEqual(3, range.length);
	
	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"abc\n\t\t\t\n\t"];
	XCTAssertEqual(8, range.location);
	XCTAssertEqual(1, range.length);

	range = [XTStringUtils findRangeOfWhitespaceAfterLastNewline:@"abc\n\t \t\n \t"];
	XCTAssertEqual(8, range.location);
	XCTAssertEqual(2, range.length);
}

@end
