//
//  XTAboutWindowController.m
//  XTads
//
//  Created by Rune Berg on 31/10/15.
//  Copyright © 2015 Rune Berg. All rights reserved.
//

#import "XTAboutWindowController.h"
#import "XTAbout.h"
#import "XTNotifications.h"
#import "XTTextFieldWithLink.h"


@interface XTAboutWindowController ()

@property XTAbout *about;
@property (unsafe_unretained) IBOutlet NSTextView *thankYouTextView;
@property (unsafe_unretained) IBOutlet NSTextView *licenseTextView;
@property (weak) IBOutlet XTTextFieldWithLink *terpAuthorEmailTextField;
@property (weak) IBOutlet XTTextFieldWithLink *terpHomepageTextField;
@property (weak) IBOutlet XTTextFieldWithLink *tadsHomepageTextField;

@end


@implementation XTAboutWindowController

+ (XTAboutWindowController *)controllerWithAbout:(XTAbout *)about
{
	XTAboutWindowController *wc = [[XTAboutWindowController alloc] initWithWindowNibName:@"XTAboutWindowController"];
	wc.about = about;
	
	return wc;
}

- (id)initWithWindowNibName:(NSString *)windowNibName
{
	self = [super initWithWindowNibName:windowNibName];
	if (self) {
		[self myCustomInit];
	}
	return self;
}

- (void)myCustomInit
{
}

- (void)windowDidLoad {
	
    [super windowDidLoad];
	
	self.thankYouTextView.editable = NO;
	NSSize insetOutput = NSMakeSize(0.0, 4.0);
	[self.thankYouTextView setTextContainerInset:insetOutput];
	
	self.licenseTextView.editable = NO;
	
	NSString *terpAuthorEmailLinkText = [NSString stringWithFormat:@"%@ <%@>", self.about.terpAuthorName, self.about.terpAuthorEmailAddress];
	NSString *terpAuthorEmailUrlStr = [NSString stringWithFormat:@"mailto:%@", self.about.terpAuthorEmailAddress];
	NSURL *terpAuthorEmailUrl = [NSURL URLWithString:terpAuthorEmailUrlStr];
	[self.terpAuthorEmailTextField setLinkText:terpAuthorEmailLinkText forUrl:terpAuthorEmailUrl];
	
	NSURL *terpHomepageUrl = [NSURL URLWithString:self.about.terpHomepageUrl];
	[self.terpHomepageTextField setLinkText:self.about.terpHomepageLinkText forUrl:terpHomepageUrl];
	
	NSURL *tadsHomepageUrl = [NSURL URLWithString:self.about.tadsHomepageUrl];
	[self.tadsHomepageTextField setLinkText:self.about.tadsHomepageLinkText forUrl:tadsHomepageUrl];
}

- (void)windowWillClose:(NSNotification *)notification
{
	[XTNotifications notifyAboutWindowClosed:self];
}

@end
