//
//  XTHtmlTagTab.m
//  TadsTerp
//
//  Created by Rune Berg on 05/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagTab.h"
#import "XTOutputFormatterProtocol.h"
#import "XTAllocDeallocCounter.h"


@implementation XTHtmlTagTab

OVERRIDE_ALLOC_FOR_COUNTER

OVERRIDE_DEALLOC_FOR_COUNTER

+ (NSString *)name
{
	return @"tab";
}

+ (BOOL)standalone
{
	return YES;
}

- (NSArray *)dispatchToFormatter:(NSObject<XTOutputFormatterProtocol> *)formatter
{
	return [formatter handleHtmlTagTab:self];
}

+ (instancetype)rightAligned
{
	XTHtmlTagTab *tabTag = [XTHtmlTagTab new];
	tabTag.attributes[@"align"] = @"right";
	return tabTag;
}

+ (instancetype)forPlainTextMode
{
	XTHtmlTagTab *tabTag = [XTHtmlTagTab new];
	tabTag.attributes[@"multiple"] = @"4";
	return tabTag;
}

@end
