/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of PROTEUS, the TADS 3 Utility Classes Package
 *
 *  Proteus.h
 *
 *  Provides an abstract datatype class that encapsulates a lookup table
 *  for use by other proteus modules.
 */

#ifndef PROTEUS_H
#define PROTEUS_H
 
/* include the TADS and T3 system headers */
#include <tads.h>
#include <t3.h>
#include <vector.h>

/* the symbol table */
#define gSymbols (proteusGlobal.symbolTableLU)

/* the snapshot lookup table */
#define gSnapshots (proteusGlobal.snapshotLU)

/* the interface lookup table */
#define gInterfaces (proteusGlobal.interfaceLU)

/* the observable lookup table */
#define gObservables (proteusGlobal.observableLU)

/* the observers lookup table */
#define gObservers (proteusGlobal.observerLU)

/* the services lookup table */
#define gServices (proteusGlobal.serviceLU)

#define gProteusLU (proteusGlobal.proteusLU)

#define gAHrefMetaCmd (proteusGlobal.aHrefMetaCmd)

/* ------------------------------------------------------------------------ */
/*
 *   Property set definitions 
 */
#define luCustomProps(node) \
    myValuesProp = &my ## node ## s \
    myAddProp = &add ## node \
    myServiceSuffix = #@node ## 'ProteusService' \
    myServiceProp = &has ## node ## ProteusServiceProp

#define proteusServiceFor(node) \
    has ## node ## ProteusServiceProp = true \
    propertyset '*' ## #@node ## 'ProteusService' 

/*
 *  Macro for implementing interfaces in an object definition
 */
#define implements(interface, arg...) \
    proteusServiceFor(Interface) \
    { \
        proteusInterface ## interface : interface {} \
        arg#foreach$ proteusInterface ## arg : arg {} $$ \
    }

#define DefineSystemRefTagAction(name, mixIn...) \
    class name##Action: mixIn#foreach: mixIn, :: SystemRefTagAction

#define DefineSystemSymbolicAction(name, mixIn...) \
    class name##Action: mixIn#foreach: mixIn, :: SystemSymbolicAction

#define DefineSystemTAction(name, mixIn...) \
    class name##Action: mixIn#foreach: mixIn, :: SystemTAction \
    verDobjProp = &verifyDobj##name \
    remapDobjProp = &remapDobj##name \
    preCondDobjProp = &preCondDobj##name \
    checkDobjProp = &checkDobj##name \
    actionDobjProp  = &actionDobj##name

#define DefineVerbRule(tag, seq...) \
    grammar predicate(tag##seq): \
    tag##seq##AltList \
    : tag##Action

#define delegateObj(delObj, args...) \
    DelegateObj.delegateTo(targetobj, delObj, targetprop, args)

#define delegateObjMeth(delObj, method, args...) \
    DelegateObj.delegateTo(targetobj, delObj, method, args)


/* ------------------------------------------------------------------------ */
/*
 *   Enumerators for structural analysis.
 */

/* the entities are the same entity */
enum tautological;

/* the entities are instances of the same class */
enum equivalent;

/* 
 *  the entities are instances of the same class, but directly define
 *  different properties.
 */
enum contingent;

/* the first entity is a superclass of the second */
enum trait;

/* the first entity extends the second */
enum extension;

/* the entities share superclasses */
enum shared;

/* 
 *  the entities have no superclass in common except TadsObject.
 */
enum disparate;

/* mapXxxxToSString control flags */
enum MapObjReference, MapObjStructure, MapObjValue;

/* mapXxxxToSString header type flags */
enum MapObjRefSym, MapObjRefTag, MapObjRefAHref;

/* delegateObj enums */
enum DelegateRet, DelegateSynch, DelegateNoSynch;

/* templates for Morphic */
Morphic template 'vocabWords_' 'name';
Morphic template 'vocabWords_' 'name' "desc";
Morphic template 'vocabWords_' 'name' @location;
Morphic template 'vocabWords_' 'name' @location "desc";

/* enumerators and macros for propDesc() */
enum PropDescType, PropDescDefined, PropDescGetClass, PropDescInfo;

#define PropDefNotDefined   0
#define PropDefNonStatic    5
#define TypePropNonStatic   16

#endif /* PROTEUS_H */