#charset "us-ascii"

/*
 *   TADS 3 Tips Extension. English-specific definitions.
 */

#include <adv3.h>
#include <en_us.h>
#include "tips.h"

/* ---------------------------------------------------------------------- */
/*
 *   Add grammar to turn tips on and off.
 */
VerbRule(TipsOn)
    ('tips' | 'tip') 'on'
    : TipModeAction

    stat_ = true

    verbPhrase = 'turn/turning tips on'
;

VerbRule(TipsOff)
    ('tips' | 'tip') 'off'
    : TipModeAction

    stat_ = nil

    verbPhrase = 'turn/turning tips off'
;

/* ---------------------------------------------------------------------- */
/*
 *   Add library messages.
 */
modify libMessages
    /* acknowledge turning tips on or off */
    acknowledgeTipStatus(stat)
    {
        "<.parser>Tips are now turned <<stat ? 'on' : 'off'>>.<./parser> ";
    }

    /* describe the tip mode setting */
    tipStatusShort(stat)
    {
        "TIPS <<stat ? 'ON' : 'OFF'>>";
    }

    /*
     *   The following five properties are notifications that are only
     *   displayed once. By redefining these as tips, the player will be
     *   able to turn them off like all other tips, if desired.
     */
    replace firstScoreChange(delta)
    {
        scoreChange(delta);

        scoreChangeTip.showTip();
    }

    replace firstFootnote()
    {
        footnotesTip.showTip();
    }

    replace oopsNote()
    {
        oopsTip.showTip();
    }

    replace mentionFullScore()
    {
        fullScoreTip.showTip();
    }

    replace explainExitsOnOff()
    {
        exitsTip.showTip();
    }
;

/*
 *   Redefine a couple of first-time only notifications as tips.
 */
scoreChangeTip: Tip
    "If you&rsquo;d prefer not to be notified about score changes in the
    future, type <<aHref('notify off', 'NOTIFY OFF', 'Turn off score
    notificatons')>>."
;

footnotesTip: Tip
    "A number in [square brackets] like the one above refers to a footnote,
    which you can read by typing FOOTNOTE followed by the number:
    <<aHref('footnote 1', 'FOOTNOTE 1', 'Show footnote [1]')>>, for example.
    Footnotes usually contain added background information that might be
    interesting but isn&rsquo;t essential to the story. If you&rsquo;d
    prefer not to see footnotes at all, you can control their appearance by
    typing <<aHref('footnotes', 'FOOTNOTES', 'Control footnote
    appearance')>>."
;

oopsTip: Tip
    "If this was an accidental misspelling, you can correct it by typing
    OOPS followed by the correct word now. Any time the story points out an
    unknown word, you can correct a misspelling using OOPS as your next
    command."
;

fullScoreTip: Tip
    "To see a detailed accounting of your score, type
    <<aHref('full score', 'FULL SCORE')>>."
;

exitsTip: Tip
    "You can control the exit listings with the EXITS command.
    <<aHref('exits status', 'EXITS STATUS',
            'Turn on status line exit listings')>>
    shows the exit list in the status line,
    <<aHref('exits look', 'EXITS LOOK', 'List exits in room descriptions')>>
    shows a full exit list in each room description,
    <<aHref('exits on', 'EXITS ON', 'Turn on all exit lists')>>
    shows both, and
    <<aHref('exits off', 'EXITS OFF', 'Turn off all exit lists')>>
    turns off both kinds of exit lists."
;

