#include <tads.h>

/*
 * An XTads test game.
 * Focus is on abs. resizing of vert. text banner.
 */
main(args)
{
	local b0 = nil;

    "A banner test game for XTads.\b\b";

    local b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeText, BannerAlignRight,
                       0, BannerSizeAbsolute,
                       0);
    "b1 (child of b0) is a vertical text banner right of b0. Initial size is abs 0. ";
    "\bPress a key to continue...\n";
    inputKey();
    
    bannerSay(b1, '0');
    "\bNow banner contains '0' but has size 0, so should be invisible. ";
    inputKey();
    
    bannerSetSize(b1, 1, BannerSizeAbsolute, nil);
    "\bNow banner should be resized to show '0'. ";
    inputKey();
    
    //---

    bannerSay(b1, '0');
    "\bNow banner contains '00' but has size 1. ";
    inputKey();

    bannerSetSize(b1, 2, BannerSizeAbsolute, nil);
    "\bNow banner should be resized to show '00'. ";
    inputKey();

    //---

    bannerSay(b1, '000');
    "\bNow banner contains '00000' but has size 2. ";
    inputKey();

    bannerSetSize(b1, 5, BannerSizeAbsolute, nil);
    "\bNow banner should be resized to show '00000'. ";
    inputKey();

    //---

    bannerSay(b1, '00000000');
    "\bNow banner contains '0000000000000' but has size 5. ";
    inputKey();

    bannerSetSize(b1, 13, BannerSizeAbsolute, nil);
    "\bNow banner should be resized to show '0000000000000'. ";
    inputKey();

    "\bPress another key to exit...\n";
    inputKey();
}

showBannerInfo(win)
{
    local info = bannerGetInfo(win);

    "align = <<info[1]>>, style = <<toString(info[2], 16)>>,
    rows = <<info[3]>>, columns = <<info[4]>>, pixel height = <<info[5]>>,
    pixel width = <<info[6]>>";
}
