
title_screen = 
        "* Adams ADVENTURE * Version TI/001.2",
        "  Adventure  Box 3435  Longwood FL 32750",
        "",
        "  This program will allow you to have an",
        "adventure   without  ever  leaving  your",
        "armchair!  You  will find yourself in  a",
        "strange  new world.   You'll  be able to",
        "examine, take,  and otherwise manipulate",
        "the objects  you find  there.  You  will",
        "also be able to travel  from location to",
        "location.",
        "",
        "  I'll be your puppet in this adventure.",
        "You  command  me  with  2  word  English",
        "sentences.  I have a vocabulary of  over",
        "120  words, so if one word doesn't work,",
        "try another!",
        "",
        "  Some commands I know are: HELP, QUIT,",
        "SAVE GAME, SCORE, and TAKE INVENTORY.",
        "",
        "   The author has worked for over a year",
        "on this program, so please don't copy or",
        "accept a pirated copy!  Now press ENTER!"
        ;

word_length = 4;
light_time = 10000;
max_load = 6;

flag flag_00;
flag flag_01;
flag flag_02;
flag flag_03;
flag flag_04;
flag flag_05;
flag flag_06;
flag flag_07;
flag flag_08;
flag flag_09;
flag flag_10;
flag flag_11;
flag flag_12;
flag flag_13;
flag flag_14;
flag (night) flag_15;
flag (runout) flag_16;
flag flag_17;
flag flag_18;
flag flag_19;
flag flag_20;
flag flag_21;
flag flag_22;
flag flag_23;
flag flag_24;
flag flag_25;
flag flag_26;
flag flag_27;
flag flag_28;
flag flag_29;
flag flag_30;
flag flag_31;

timreg tr_00;
timreg tr_01;
timreg tr_02;
timreg tr_03;
timreg tr_04;
timreg tr_05;
timreg tr_06;
timreg tr_07;
timreg tr_08;
timreg tr_09;
timreg tr_10;
timreg tr_11;
timreg tr_12;
timreg tr_13;
timreg tr_14;
timreg tr_15;

roomreg rr_00;
roomreg rr_01;
roomreg rr_02;
roomreg rr_03;
roomreg rr_04;
roomreg rr_05;
roomreg rr_06;
roomreg rr_07;
roomreg rr_08;
roomreg rr_09;
roomreg rr_10;
roomreg rr_11;
roomreg rr_12;
roomreg rr_13;
roomreg rr_14;
roomreg rr_15;

noun(north) nort;
noun(south) sout;
noun(east)  east;
noun(west)  west;
noun(up)    up;
noun(down)  down;
verb(go)    go;
verb(drop)  drop;
verb(get)   get, take;

# 95 messages

alias msg_000 = "";
alias msg_001 = "Welcome to Adventure 6: 'STRANGE ODYSSEY' by Scott Adams. Dedicated to the Novaks.";
alias msg_002 = "Nothing happens.";
alias msg_003 = "OK.";
alias msg_004 = "The pressure gauge says";
alias msg_005 = "moves until the suit air is expended. The air outside the suit is";
alias msg_006 = "The suit has a pressure gauge & a connecter for a hose.";
alias msg_007 = "breatheable.";
alias msg_008 = "not";
alias msg_009 = "The air is";
alias msg_010 = "It is";
alias msg_011 = "My air ran out!";
alias msg_012 = "Some GAS comes out of the hose for awhile and then stops.";
alias msg_013 = "The phaser is set on:";
alias msg_014 = "DESTROY!";
alias msg_015 = "stun.";
alias msg_016 = "'TO STUN' or 'TO DESTROY'?";
alias msg_017 = "(use 2 words)";
alias msg_018 = "My suit popped open!";
alias msg_019 = "A warning light says: 'POWER CRYSTAL DAMAGED'";
alias msg_020 = "There's a blue button marked 'BLAST OFF' & an unmarked red button.";
alias msg_021 = "The console replies: 'INSUFFICIENT POWER'";
alias msg_022 = "Alien script covers it.";
alias msg_023 = "I fire the Phaser,";
alias msg_024 = "I destroyed it!";
alias msg_025 = "My air is getting stale! Read the gauge!";
alias msg_026 = "It won't budge!";
alias msg_027 = "I see nothing special.";
alias msg_028 = "It's some sort of force field.";
alias msg_029 = "I ruined the ship!";
alias msg_030 = "Either I missed, or the beam was absorbed without visible effect!";
alias msg_031 = "It's empty.";
alias msg_032 = "Charge left registers:";
alias msg_033 = "It seems to be as far";
alias msg_034 = "out";
alias msg_035 = "in";
alias msg_036 = "out.";
alias msg_037 = "in.";
alias msg_038 = "as it will go.";
alias msg_039 = "Odd, it only required very little force";
alias msg_040 = "for it to break off in my hand with a CRYSTALLINE snap!";
alias msg_041 = "HOW?";
alias msg_042 = "The plastic GLOWED briefly.";
alias msg_043 = "The plastic GLOWED briefly";
alias msg_044 = "times.";
alias msg_045 = "for it to shatter!";
alias msg_046 = "I feel strangely disoriented for a moment!";
alias msg_047 = "to slide";
alias msg_048 = "The Ice Hound attacks me unexpectedly!";
alias msg_049 = "It woke up!";
alias msg_050 = "I found nothing.";
alias msg_051 = "We're drifting in space!";
alias msg_052 = "I see: a black button, a white button, and a hose.";
alias msg_053 = "The hose rips out!";
alias msg_054 = "It's a tight fit!";
alias msg_055 = "Lift off!! After a brief flight we arrive...";
alias msg_056 = "The Ice Hound burrows off...";
alias msg_057 = "Ice fills back in around me, as I dig my way in. The pick broke, but I made it!";
alias msg_058 = "Ice is very smooth & hard!";
alias msg_059 = "I slid back down.";
alias msg_060 = "I don't know where to look.";
alias msg_061 = "Try: 'SHOOT SOMETHING'";
alias msg_062 = "Say that again, but use a color.";
alias msg_063 = "There's writing there.";
alias msg_064 = "I can't do that.";
alias msg_065 = "Whooosh!";
alias msg_066 = "The gravity here is very";
alias msg_067 = "strong.";
alias msg_068 = "weak.";
alias msg_069 = "It's stuck.";
alias msg_070 = "I'm SQUASHED!";
alias msg_071 = "The power crystal was in the shape of a thin rod.";
alias msg_072 = "I feel LIGHT-HEADED!";
alias msg_073 = "It floats!";
alias msg_074 = "A gentle touch will work wonders!";
alias msg_075 = "It should fit. It has a large buckle.";
alias msg_076 = "The painting is of an Alien, twisting a buckle on a belt.";
alias msg_077 = "The wiring behind the plastic shorts out! I'm electrocuted!";
alias msg_078 = "I see a picture of an ALIEN TENTACLE.";
alias msg_079 = "Wonderful. It ATE me!";
alias msg_080 = "It is of an alien being.";
alias msg_081 = "It's wearing only a strange belt!";
alias msg_082 = "Watch it! It's known to spit molten DIAMONDS!";
alias msg_083 = "There's a box on it, with a yellow button.";
alias msg_084 = "I just see shades of black. It makes my eyes swim!";
alias msg_085 = "I think it's broken!";
alias msg_086 = "I found something.";
alias msg_087 = "Ouch!";
alias msg_088 = "It's stunned!";
alias msg_089 = "The metal helped!";
alias msg_090 = "Get Adventure 7: 'MYSTERY FUN HOUSE' from your favorite Dealer! Have you gotten your Adventure T-SHIRT yet?";
alias msg_091 = "Tidal forces rip me apart!";
alias msg_092 = "I'm not wearing it!";
alias msg_093 = "My hand went THROUGH it!";
alias msg_094 = "I don't have it!";


# 24 rooms

room rm_001 
    "I am in a one man scoutship.",
    d_to rm_007;

room rm_002 
    "I am in a small airlock.";

room rm_003 
    "I am in a large cavern.",
    u_to rm_008;

room rm_004 
    "I'm on a small planetoid.",
    n_to rm_005,
    s_to rm_008,
    e_to rm_005,
    w_to rm_008;

room rm_005 
    "I'm on a small planetoid.",
    n_to rm_008,
    s_to rm_005,
    e_to rm_008,
    w_to rm_004;

room rm_006 
    "I am in a strange hexagonal room.";

room rm_007 
    "I am in a storage hold.",
    u_to rm_001;

room rm_008 
    "I'm on a small planetoid.",
    n_to rm_004,
    s_to rm_005,
    e_to rm_005,
    w_to rm_004;

room rm_009 
    "I am in a large grassy plain, at the edge of a jungle.";

room rm_010 
    "I am in a methane snow storm.",
    n_to rm_019,
    s_to rm_019,
    e_to rm_019,
    w_to rm_020;

room rm_011 
    "I am in a small derelict spacecraft.";

room rm_012 
    "I'm outside the airlock on a ledge. The ground is 90 meters below!";

room rm_013 
    "I am in a Alien Art Museum.";

room rm_014 
    "I am in a deserted Jovian mining colony.";

room rm_015 
    "I am in a strange jungle.",
    n_to rm_015,
    s_to rm_015,
    e_to rm_021,
    w_to rm_009;

room rm_016 
    "I am in a hollow ice mound.";

room rm_017 
    "I am in a BLACK EMPTINESS.";

room rm_018 
    "I am in a methane snow storm.",
    n_to rm_019,
    s_to rm_020,
    e_to rm_010,
    w_to rm_020;

room rm_019 
    "I am in a methane snow storm.",
    n_to rm_010,
    s_to rm_018,
    e_to rm_020,
    w_to rm_018;

room rm_020 
    "I am in a methane snow storm.",
    n_to rm_020,
    s_to rm_020,
    e_to rm_020,
    w_to rm_020;

room rm_021 
    "I'm in the ruins of an intergalatic ZOO.",
    s_to rm_015;

room rm_022 
    "I am in a storage hold of the Mother Ship.";

room rm_023 
    "I am in a maintenance crawlway.",
    u_to rm_007;

room rm_024 
    "I am in a lot of TROUBLE!";

item itm_000 
    "" void;

item itm_001 
    "EVERYTHING HAS A BLUISH TINT" void;

item itm_002 
    "Strangely flickering curtain of light" void;

item itm_003 
    "Scoutship" void;

item itm_004 (hatc) 
    "Maintenance access hatch" rm_007;

item itm_005 (sign) 
    "Alien sign" rm_013;

item itm_006 
    "Control console" rm_001;

item itm_007 (suit) 
    "Space suit" rm_007;

item itm_008 
    "which I'm wearing" void;

item (light) itm_009 
    "Black Hole" rm_017;

item itm_010 (phas) 
    "Phaser" rm_007;

item itm_011 (phas) 
    "Phaser" void;

item itm_012 
    "Closed door" rm_001;

item itm_013 
    "Open door" void;

item itm_014 
    "Strangely flickering curtain of light" rm_006;

item itm_015 
    "Cave" rm_008;

item itm_016 (flas) 
    "Empty flask" void;

item itm_017 
    "Red button by door" rm_002;

item itm_018 
    "Closed outer door" rm_002;

item itm_019 
    "Open outer door" void;

item itm_020 
    "Closed inner door" void;

item itm_021 
    "Open inner door" rm_002;

item itm_022 
    "Alien machine" rm_011;

item itm_023 
    "Large boulder" rm_003;

item itm_024 
    "Small piece of plastic flush in the wall" rm_006;

item itm_025 
    "Rod jutting straight out of the wall" rm_006;

item itm_026 (rod) 
    "Broken piece of rod" void;

item itm_027 
    "Strange light far to the NORTH" rm_018;

item itm_028 (houn) 
    "Rigilian Dia-Ice Hound" rm_021;

item itm_029 (houn) 
    "Stunned Dia-Ice Hound" void;

item itm_030 
    "Viewport" rm_011;

item itm_031 
    "Sign: 'Leave Treasures here say: SCORE'" rm_022;

item itm_032 (flas) 
    "*ANCIENT FLASK SAURIAN BRANDY*" rm_014;

item itm_033 
    "Empty crystal holder" rm_023;

item itm_034 (crys) 
    "Broken pieces of Power Crystal" rm_023;

item itm_035 
    "Broken rod in the crystal holder" void;

item itm_036 
    "Large ice mound" void;

item itm_037 (pick) 
    "Ancient ice pick" void;

item itm_038 (pick) 
    "Broken ice pick" void;

item itm_039 (meta) 
    "Short twisted piece of metal" rm_014;

item itm_040 
    "Entrance to a crawlway" void;

item itm_041 (diam) 
    "*RIGILIAN ICE DIAMOND*" rm_016;

item itm_042 (belt) 
    "*STRANGE ALIEN BELT*" void;

item itm_043 
    "which I'm wearing" void;

item itm_044 
    "& it's activated" void;

item itm_045 (pain) 
    "*RARE ALIEN PAINTING*" rm_013;

item itm_046 (dust) 
    "Rock dust" void;

item itm_047 
    "Centurion Slime Trees" rm_015;

item itm_048 (scul) 
    "*ALIEN SCULPTURE*" rm_013;

item itm_049 (gogg) 
    "Strange looking goggles" rm_006;

item itm_050 
    "which I'm wearing" void;

item itm_051 (shov) 
    "Shovel" rm_007;

item itm_052 (shov) 
    "Broken & splintered shovel" void;

item itm_053 
    "A hose connects my suit to the machine." void;

item itm_054 (help) 
    "" void;

item itm_055 (whit) 
    "" void;

act auto 100
{
    in (rm_014);
    !has (itm_043);        # which I'm wearing
    msg_066;    # "The gravity here is very";
    msg_067;    # "strong.";
    msg_070;    # "I'm SQUASHED!";
    ignore;
    quit;
    
}

act auto 100
{
    here (itm_018);        # Closed outer door
    off flag_02;
    
}

act auto 100
{
    in (rm_014);
    !has (itm_044);        # & it's activated
    msg_066;    # "The gravity here is very";
    msg_067;    # "strong.";
    msg_070;    # "I'm SQUASHED!";
    ignore;
    quit;
    
}

act auto 100
{
    !set (flag_01);
    on flag_01;
    on flag_05;
    on flag_06;
    swap tr_02;
    timer 28;
    swap tr_02;
    msg_001;    # "Welcome to Adventure 6: 'STRANGE ODYSSEY' by Scott Adams. Dedicated to the Novaks.";
    swap tr_01;
    timer 110;
    swap tr_01;
    goto rm_006;
    swap tr_03;
    timer 2;
    swap tr_03;
    select_rv;
    goto rm_001;
    swap tr_05;
    timer 20;
    swap tr_05;
    
}

act auto 100
{
    avail (itm_008);        # which I'm wearing
    swap tr_01;
    sub 1;
    try
    {
        le (27);
        msg_025;        # "My air is getting stale! Read the gauge!";
    }
    try
    {
        le (0);
        msg_011;        # "My air ran out!";
        die;
    }
    try
    {
        swap tr_01;
    }
    
}

act auto 100
{
    has (itm_042);        # *STRANGE ALIEN BELT*
    exists (itm_044);        # & it's activated
    !has (itm_044);        # & it's activated
    get itm_044;        # & it's activated
    
}

act auto 100
{
    here (itm_042);        # *STRANGE ALIEN BELT*
    exists (itm_044);        # & it's activated
    !here (itm_044);        # & it's activated
    drop itm_044;        # & it's activated
    
}

act auto 30
{
    has (itm_028);        # Rigilian Dia-Ice Hound
    msg_048;    # "The Ice Hound attacks me unexpectedly!";
    die;
    
}

act auto 15
{
    here (itm_028);        # Rigilian Dia-Ice Hound
    msg_048;    # "The Ice Hound attacks me unexpectedly!";
    die;
    
}

act auto 100
{
    exists (itm_029);        # Stunned Dia-Ice Hound
    swap tr_04;
    sub 1;
    try
    {
        le (0);
        swap itm_029, itm_028;        # Stunned Dia-Ice Hound        # Rigilian Dia-Ice Hound
    }
    try
    {
        avail (itm_028);        # Rigilian Dia-Ice Hound
        msg_049;        # "It woke up!";
    }
    try
    {
        swap tr_04;
    }
    
}

act auto 100
{
    set (flag_04);
    off flag_04;
    swap tr_02;
    try
    {
        !set (flag_03);
        sub 4;
        swap tr_02;
    }
    try
    {
        set (flag_03);
        sub 7;
        swap tr_02;
    }
    
}

act auto 100
{
    set (flag_02);
    !has (itm_008);        # which I'm wearing
    msg_009;    # "The air is";
    msg_008;    # "not";
    msg_007;    # "breatheable.";
    die;
    
}

act auto 100
{
    swap tr_02;
    try
    {
        le (0);
        !exists (itm_011);        # Phaser
        swap itm_011, itm_010;        # Phaser        # Phaser
    }
    try
    {
        swap tr_02;
    }
    
}

act auto 100
{
    here (itm_033);        # Empty crystal holder
    here (itm_026);        # Broken piece of rod
    swap itm_026, itm_035;        # Broken piece of rod        # Broken rod in the crystal holder
    zap itm_033;        # Empty crystal holder
    msg_054;    # "It's a tight fit!";
    
}

act auto 100
{
    here (itm_028);        # Rigilian Dia-Ice Hound
    try
    {
        in (rm_018);
        move rm_020, itm_036;        # Large ice mound
        zap itm_028;        # Rigilian Dia-Ice Hound
        msg_056;        # "The Ice Hound burrows off...";
    }
    try
    {
        in (rm_019);
        move rm_020, itm_036;        # Large ice mound
        zap itm_028;        # Rigilian Dia-Ice Hound
        msg_056;        # "The Ice Hound burrows off...";
    }
    try
    {
        in (rm_020);
        move rm_020, itm_036;        # Large ice mound
        zap itm_028;        # Rigilian Dia-Ice Hound
        msg_056;        # "The Ice Hound burrows off...";
    }
    try
    {
        in (rm_010);
        move rm_020, itm_036;        # Large ice mound
        zap itm_028;        # Rigilian Dia-Ice Hound
        msg_056;        # "The Ice Hound burrows off...";
    }
    try
    {
        !exists (itm_028);        # Rigilian Dia-Ice Hound
        move rm_016, itm_028;        # Rigilian Dia-Ice Hound
    }
    
}

act auto 100
{
    in (rm_024);
    quit;
    
}

act auto 100
{
    set (flag_09);
    swap tr_05;
    sub 1;
    try
    {
        le (1);
        off flag_09;
        on flag_10;
    }
    try
    {
        has (itm_050);        # which I'm wearing
        has (itm_049);        # Strange looking goggles
        off flag_15;
        drop itm_001;        # EVERYTHING HAS A BLUISH TINT
    }
    try
    {
        swap tr_05;
    }
    
}

act auto 100
{
    has (itm_050);        # which I'm wearing
    !set (flag_09);
    !set (flag_15);
    on flag_15;
    
}


act go door
{
    here (itm_019);        # Open outer door
    !set (flag_07);
    msg_003;    # "OK.";
    goto rm_012;
    
}

act go door
{
    here (itm_021);        # Open inner door
    msg_003;    # "OK.";
    goto rm_001;
    
}

act go door
{
    here (itm_013);        # Open door
    msg_003;    # "OK.";
    goto rm_002;
    
}

act go cave
{
    here (itm_015);        # Cave
    msg_003;    # "OK.";
    goto rm_003;
    
}

act go hole
{
    here (itm_009);        # Black Hole
    msg_091;    # "Tidal forces rip me apart!";
    die;
    
}

act go curt
{
    in (rm_006);
    set (flag_06);
    select_rv;
    drop itm_002;        # Strangely flickering curtain of light
    on flag_02;
    
}

act go curt
{
    here (itm_002);        # Strangely flickering curtain of light
    !exists (itm_053);        # A hose connects my suit to the machine.
    select_rv;
    off flag_02;
    msg_003;    # "OK.";
    
}

act go curt
{
    in (rm_006);
    !set (flag_06);
    select_rv;
    drop itm_002;        # Strangely flickering curtain of light
    off flag_02;
    
}

act go curt
{
    here (itm_002);        # Strangely flickering curtain of light
    exists (itm_053);        # A hose connects my suit to the machine.
    msg_053;    # "The hose rips out!";
    msg_018;    # "My suit popped open!";
    die;
    
}

act go door
{
    here (itm_019);        # Open outer door
    set (flag_07);
    msg_003;    # "OK.";
    goto rm_022;
    drop itm_003;        # Scoutship
    
}

act go ship
{
    here (itm_003);        # Scoutship
    msg_003;    # "OK.";
    goto rm_002;
    
}

act go moun
{
    here (itm_036);        # Large ice mound
    !has (itm_037);        # Ancient ice pick
    msg_041;    # "HOW?";
    msg_058;    # "Ice is very smooth & hard!";
    msg_059;    # "I slid back down.";
    
}

act go jung
{
    in (rm_009);
    msg_003;    # "OK.";
    goto rm_015;
    
}

act go craw
{
    here (itm_040);        # Entrance to a crawlway
    goto rm_023;
    
}

act go boul
{
    here (itm_023);        # Large boulder
    msg_050;    # "I found nothing.";
    msg_059;    # "I slid back down.";
    
}

act go grou
{
    in (rm_012);
    msg_041;    # "HOW?";
    
}

act go ship
{
    in (rm_012);
    msg_003;    # "OK.";
    goto rm_002;
    
}

act go tree
{
    here (itm_047);        # Centurion Slime Trees
    msg_079;    # "Wonderful. It ATE me!";
    die;
    
}

act go rod
{
    here (itm_025);        # Rod jutting straight out of the wall
    msg_039;    # "Odd, it only required very little force";
    msg_040;    # "for it to break off in my hand with a CRYSTALLINE snap!";
    zap itm_025;        # Rod jutting straight out of the wall
    steal itm_026;        # Broken piece of rod
    
}

act go hatc
{
    here (itm_040);        # Entrance to a crawlway
    msg_003;    # "OK.";
    goto rm_023;
    
}

act save game
{
    save;
    
}

act quit any
{
    quit;
    
}

act help any
{
    in (rm_006);
    msg_074;    # "A gentle touch will work wonders!";
    
}

act help any
{
    msg_003;    # "OK.";
    msg_041;    # "HOW?";
    
}

act to stun
{
    avail (itm_010);        # Phaser
    off flag_03;
    msg_003;    # "OK.";
    
}

act to dest
{
    avail (itm_010);        # Phaser
    on flag_03;
    msg_003;    # "OK.";
    
}

act get hose
{
    here (itm_022);        # Alien machine
    !exists (itm_053);        # A hose connects my suit to the machine.
    msg_003;    # "OK.";
    drop itm_053;        # A hose connects my suit to the machine.
    
}

act get rod
{
    here (itm_025);        # Rod jutting straight out of the wall
    msg_041;    # "HOW?";
    
}

act get rod
{
    avail (itm_026);        # Broken piece of rod
    msg_003;    # "OK.";
    get itm_026;        # Broken piece of rod
    
}

act get hatc
{
    here (itm_004);        # Maintenance access hatch
    !avail (itm_039);        # Short twisted piece of metal
    !exists (itm_040);        # Entrance to a crawlway
    msg_064;    # "I can't do that.";
    msg_069;    # "It's stuck.";
    
}

act get hatc
{
    here (itm_004);        # Maintenance access hatch
    avail (itm_039);        # Short twisted piece of metal
    !exists (itm_040);        # Entrance to a crawlway
    get itm_004;        # Maintenance access hatch
    drop itm_040;        # Entrance to a crawlway
    msg_003;    # "OK.";
    msg_089;    # "The metal helped!";
    
}

act get hatc
{
    avail (itm_004);        # Maintenance access hatch
    exists (itm_040);        # Entrance to a crawlway
    get itm_004;        # Maintenance access hatch
    msg_003;    # "OK.";
    
}

act get plas
{
    here (itm_024);        # Small piece of plastic flush in the wall
    msg_041;    # "HOW?";
    
}

act get belt
{
    avail (itm_048);        # *ALIEN SCULPTURE*
    !exists (itm_042);        # *STRANGE ALIEN BELT*
    msg_003;    # "OK.";
    get itm_042;        # *STRANGE ALIEN BELT*
    
}

act get belt
{
    avail (itm_042);        # *STRANGE ALIEN BELT*
    msg_003;    # "OK.";
    get itm_042;        # *STRANGE ALIEN BELT*
    
}

act get inve
{
    .inv;
    
}

act empt flas
{
    avail (itm_032);        # *ANCIENT FLASK SAURIAN BRANDY*
    swap itm_032, itm_016;        # *ANCIENT FLASK SAURIAN BRANDY*        # Empty flask
    msg_003;    # "OK.";
    
}

act fire mach
{
    msg_041;    # "HOW?";
    
}

act fire phas
{
    avail (itm_010);        # Phaser
    msg_061;    # "Try: 'SHOOT SOMETHING'";
    
}

act inve any
{
    .inv;
    
}

act drop hose
{
    here (itm_053);        # A hose connects my suit to the machine.
    msg_003;    # "OK.";
    zap itm_053;        # A hose connects my suit to the machine.
    
}

act drop suit
{
    avail (itm_007);        # Space suit
    drop itm_007;        # Space suit
    zap itm_008;        # which I'm wearing
    msg_003;    # "OK.";
    
}

act drop belt
{
    avail (itm_042);        # *STRANGE ALIEN BELT*
    zap itm_043;        # which I'm wearing
    msg_003;    # "OK.";
    drop itm_042;        # *STRANGE ALIEN BELT*
    try
    {
        exists (itm_044);        # & it's activated
        drop itm_044;        # & it's activated
        msg_073;        # "It floats!";
    }
    
}

act drop gogg
{
    has (itm_049);        # Strange looking goggles
    drop itm_049;        # Strange looking goggles
    zap itm_050;        # which I'm wearing
    off flag_15;
    msg_003;    # "OK.";
    zap itm_001;        # EVERYTHING HAS A BLUISH TINT
    
}

act read sign
{
    avail (itm_005);        # Alien sign
    msg_003;    # "OK.";
    msg_090;    # "Get Adventure 7: 'MYSTERY FUN HOUSE' from your favorite Dealer! Have you gotten your Adventure T-SHIRT yet?";
    
}

act read gaug
{
    avail (itm_007);        # Space suit
    msg_004;    # "The pressure gauge says";
    swap tr_01;
    .timer;
    msg_005;    # "moves until the suit air is expended. The air outside the suit is";
    try
    {
        set (flag_02);
        msg_008;        # "not";
    }
    try
    {
        msg_007;        # "breatheable.";
        swap tr_01;
    }
    
}

act read any
{
    msg_064;    # "I can't do that.";
    
}

act push red
{
    in (rm_001);
    swap itm_012, itm_013;        # Closed door        # Open door
    msg_003;    # "OK.";
    
}

act push red
{
    here (itm_017);        # Red button by door
    msg_003;    # "OK.";
    swap itm_018, itm_019;        # Closed outer door        # Open outer door
    swap itm_020, itm_021;        # Closed inner door        # Open inner door
    try
    {
        !set (flag_07);
        here (itm_019);        # Open outer door
        on flag_02;
        msg_065;        # "Whooosh!";
    }
    try
    {
        !set (flag_07);
        here (itm_018);        # Closed outer door
        off flag_02;
    }
    
}

act push blac
{
    avail (itm_022);        # Alien machine
    !here (itm_053);        # A hose connects my suit to the machine.
    msg_003;    # "OK.";
    msg_012;    # "Some GAS comes out of the hose for awhile and then stops.";
    
}

act push whit
{
    avail (itm_022);        # Alien machine
    !set (flag_08);
    msg_003;    # "OK.";
    msg_002;    # "Nothing happens.";
    on flag_08;
    
}

act push blac
{
    avail (itm_022);        # Alien machine
    avail (itm_053);        # A hose connects my suit to the machine.
    !set (flag_08);
    msg_003;    # "OK.";
    msg_012;    # "Some GAS comes out of the hose for awhile and then stops.";
    msg_009;    # "The air is";
    msg_008;    # "not";
    msg_007;    # "breatheable.";
    die;
    
}

act push blac
{
    avail (itm_022);        # Alien machine
    avail (itm_053);        # A hose connects my suit to the machine.
    set (flag_08);
    swap tr_01;
    msg_003;    # "OK.";
    add 25;
    msg_012;    # "Some GAS comes out of the hose for awhile and then stops.";
    try
    {
        gt (110);
        msg_018;        # "My suit popped open!";
        msg_011;        # "My air ran out!";
        die;
    }
    try
    {
        swap tr_01;
    }
    
}

act push blue
{
    here (itm_006);        # Control console
    !exists (itm_035);        # Broken rod in the crystal holder
    msg_003;    # "OK.";
    msg_021;    # "The console replies: 'INSUFFICIENT POWER'";
    msg_019;    # "A warning light says: 'POWER CRYSTAL DAMAGED'";
    msg_002;    # "Nothing happens.";
    
}

act push whit
{
    avail (itm_022);        # Alien machine
    set (flag_08);
    msg_003;    # "OK.";
    msg_002;    # "Nothing happens.";
    off flag_08;
    
}

act push rod
{
    here (itm_025);        # Rod jutting straight out of the wall
    set (flag_05);
    msg_002;    # "Nothing happens.";
    msg_033;    # "It seems to be as far";
    msg_035;    # "in";
    msg_038;    # "as it will go.";
    
}

act push plas
{
    here (itm_024);        # Small piece of plastic flush in the wall
    msg_039;    # "Odd, it only required very little force";
    msg_045;    # "for it to shatter!";
    msg_077;    # "The wiring behind the plastic shorts out! I'm electrocuted!";
    die;
    
}

act push rod
{
    here (itm_025);        # Rod jutting straight out of the wall
    !set (flag_05);
    msg_039;    # "Odd, it only required very little force";
    msg_047;    # "to slide";
    swap tr_03;
    msg_037;    # "in.";
    add 1;
    on flag_05;
    msg_043;    # "The plastic GLOWED briefly";
    .timer;
    msg_044;    # "times.";
    swap tr_03;
    
}

act push blue
{
    here (itm_006);        # Control console
    exists (itm_035);        # Broken rod in the crystal holder
    !set (flag_07);
    msg_055;    # "Lift off!! After a brief flight we arrive...";
    on flag_07;
    
}

act push blue
{
    here (itm_006);        # Control console
    exists (itm_035);        # Broken rod in the crystal holder
    set (flag_07);
    msg_055;    # "Lift off!! After a brief flight we arrive...";
    off flag_07;
    
}

act push yell
{
    avail (itm_049);        # Strange looking goggles
    !set (flag_10);
    !set (flag_09);
    msg_003;    # "OK.";
    on flag_09;
    
}

act push yell
{
    avail (itm_049);        # Strange looking goggles
    !set (flag_10);
    set (flag_09);
    msg_003;    # "OK.";
    off flag_09;
    
}

act push yell
{
    avail (itm_049);        # Strange looking goggles
    set (flag_10);
    msg_003;    # "OK.";
    msg_002;    # "Nothing happens.";
    msg_085;    # "I think it's broken!";
    
}

act push butt
{
    msg_062;    # "Say that again, but use a color.";
    
}

act kick any
{
    msg_087;    # "Ouch!";
    msg_002;    # "Nothing happens.";
    
}

act conn any
{
    here (itm_022);        # Alien machine
    !exists (itm_053);        # A hose connects my suit to the machine.
    drop itm_053;        # A hose connects my suit to the machine.
    msg_003;    # "OK.";
    
}

act wake houn
{
    avail (itm_029);        # Stunned Dia-Ice Hound
    msg_003;    # "OK.";
    swap itm_029, itm_028;        # Stunned Dia-Ice Hound        # Rigilian Dia-Ice Hound
    
}

act touc plas
{
    here (itm_024);        # Small piece of plastic flush in the wall
    !set (flag_05);
    msg_042;    # "The plastic GLOWED briefly.";
    swap tr_03;
    timer 0;
    swap tr_03;
    
}

act touc plas
{
    here (itm_024);        # Small piece of plastic flush in the wall
    set (flag_05);
    swap tr_03;
    select_rv;
    msg_003;    # "OK.";
    msg_046;    # "I feel strangely disoriented for a moment!";
    delay;
    delay;
    try
    {
        eq (1)
        goto rm_003;
        on flag_06;
    }
    try
    {
        eq (2)
        goto rm_009;
        off flag_06;
    }
    try
    {
        eq (3)
        goto rm_010;
        on flag_06;
    }
    try
    {
        eq (4)
        goto rm_011;
        on flag_06;
    }
    try
    {
        eq (5)
        goto rm_017;
        on flag_06;
    }
    try
    {
        eq (6)
        goto rm_013;
    }
    try
    {
        eq (7)
        goto rm_014;
    }
    try
    {
        gt (7);
        goto rm_017;
        on flag_06;
    }
    try
    {
        select_rv;
        swap tr_03;
    }
    
}

act touc curt
{
    here (itm_002);        # Strangely flickering curtain of light
    msg_003;    # "OK.";
    msg_093;    # "My hand went THROUGH it!";
    
}

act touc curt
{
    here (itm_014);        # Strangely flickering curtain of light
    msg_003;    # "OK.";
    msg_093;    # "My hand went THROUGH it!";
    
}

act touc any
{
    msg_003;    # "OK.";
    msg_002;    # "Nothing happens.";
    
}

act look gaug
{
    avail (itm_007);        # Space suit
    msg_063;    # "There's writing there.";
    
}

act look cons
{
    here (itm_006);        # Control console
    msg_020;    # "There's a blue button marked 'BLAST OFF' & an unmarked red button.";
    
}

act look curt
{
    here (itm_002);        # Strangely flickering curtain of light
    msg_028;    # "It's some sort of force field.";
    
}

act look phas
{
    avail (itm_010);        # Phaser
    !set (flag_15);
    swap tr_02;
    msg_032;    # "Charge left registers:";
    .timer;
    try
    {
        set (flag_03);
        msg_013;        # "The phaser is set on:";
        msg_014;        # "DESTROY!";
        swap tr_02;
    }
    try
    {
        !set (flag_03);
        msg_013;        # "The phaser is set on:";
        msg_015;        # "stun.";
        swap tr_02;
    }
    
}

act look phas
{
    avail (itm_011);        # Phaser
    !set (flag_15);
    msg_032;    # "Charge left registers:";
    msg_031;    # "It's empty.";
    
}

act look view
{
    here (itm_030);        # Viewport
    !set (flag_15);
    msg_003;    # "OK.";
    msg_051;    # "We're drifting in space!";
    
}

act look mach
{
    avail (itm_022);        # Alien machine
    !set (flag_15);
    msg_003;    # "OK.";
    msg_052;    # "I see: a black button, a white button, and a hose.";
    
}

act look pain
{
    avail (itm_045);        # *RARE ALIEN PAINTING*
    set (flag_09);
    has (itm_050);        # which I'm wearing
    !set (flag_15);
    msg_003;    # "OK.";
    msg_076;    # "The painting is of an Alien, twisting a buckle on a belt.";
    
}

act look belt
{
    avail (itm_042);        # *STRANGE ALIEN BELT*
    !set (flag_15);
    msg_075;    # "It should fit. It has a large buckle.";
    
}

act look pain
{
    avail (itm_045);        # *RARE ALIEN PAINTING*
    !set (flag_15);
    msg_003;    # "OK.";
    msg_084;    # "I just see shades of black. It makes my eyes swim!";
    
}

act look boul
{
    here (itm_023);        # Large boulder
    msg_003;    # "OK.";
    msg_022;    # "Alien script covers it.";
    
}

act look crys
{
    avail (itm_034);        # Broken pieces of Power Crystal
    !set (flag_15);
    msg_071;    # "The power crystal was in the shape of a thin rod.";
    
}

act look plas
{
    here (itm_024);        # Small piece of plastic flush in the wall
    !set (flag_15);
    msg_078;    # "I see a picture of an ALIEN TENTACLE.";
    
}

act look scul
{
    avail (itm_048);        # *ALIEN SCULPTURE*
    !set (flag_15);
    msg_003;    # "OK.";
    msg_080;    # "It is of an alien being.";
    try
    {
        !exists (itm_042);        # *STRANGE ALIEN BELT*
        msg_081;        # "It's wearing only a strange belt!";
    }
    
}

act look houn
{
    avail (itm_028);        # Rigilian Dia-Ice Hound
    !set (flag_15);
    msg_082;    # "Watch it! It's known to spit molten DIAMONDS!";
    
}

act look gogg
{
    avail (itm_049);        # Strange looking goggles
    !set (flag_15);
    msg_083;    # "There's a box on it, with a yellow button.";
    
}

act look pain
{
    avail (itm_045);        # *RARE ALIEN PAINTING*
    !has (itm_050);        # which I'm wearing
    !set (flag_15);
    msg_003;    # "OK.";
    msg_084;    # "I just see shades of black. It makes my eyes swim!";
    
}

act look suit
{
    avail (itm_007);        # Space suit
    msg_006;    # "The suit has a pressure gauge & a connecter for a hose.";
    
}

act look any
{
    msg_027;    # "I see nothing special.";
    
}

act say any
{
    msg_003;    # "OK.";
    .noun_nl;
    
}

act drin flas
{
    avail (itm_032);        # *ANCIENT FLASK SAURIAN BRANDY*
    swap itm_032, itm_016;        # *ANCIENT FLASK SAURIAN BRANDY*        # Empty flask
    msg_003;    # "OK.";
    msg_065;    # "Whooosh!";
    
}

act char any
{
    msg_041;    # "HOW?";
    
}

act remo suit
{
    has (itm_008);        # which I'm wearing
    msg_003;    # "OK.";
    zap itm_008;        # which I'm wearing
    
}

act remo gogg
{
    has (itm_050);        # which I'm wearing
    off flag_15;
    zap itm_050;        # which I'm wearing
    zap itm_001;        # EVERYTHING HAS A BLUISH TINT
    
}

act remo belt
{
    avail (itm_042);        # *STRANGE ALIEN BELT*
    zap itm_043;        # which I'm wearing
    msg_003;    # "OK.";
    try
    {
        exists (itm_044);        # & it's activated
        msg_073;        # "It floats!";
    }
    
}

act remo any
{
    msg_064;    # "I can't do that.";
    msg_092;    # "I'm not wearing it!";
    
}

act shoo boul
{
    has (itm_010);        # Phaser
    set (flag_03);
    here (itm_023);        # Large boulder
    msg_023;    # "I fire the Phaser,";
    on flag_04;
    delay;
    swap itm_023, itm_002;        # Large boulder        # Strangely flickering curtain of light
    msg_024;    # "I destroyed it!";
    drop itm_046;        # Rock dust
    
}

act shoo curt
{
    has (itm_010);        # Phaser
    here (itm_002);        # Strangely flickering curtain of light
    msg_028;    # "It's some sort of force field.";
    msg_023;    # "I fire the Phaser,";
    msg_030;    # "Either I missed, or the beam was absorbed without visible effect!";
    on flag_04;
    
}

act shoo ship
{
    has (itm_010);        # Phaser
    set (flag_03);
    here (itm_003);        # Scoutship
    msg_023;    # "I fire the Phaser,";
    on flag_04;
    msg_024;    # "I destroyed it!";
    zap itm_003;        # Scoutship
    
}

act shoo any
{
    has (itm_010);        # Phaser
    set (flag_03);
    in (rm_001);
    msg_023;    # "I fire the Phaser,";
    goto rm_024;
    msg_029;    # "I ruined the ship!";
    quit;
    
}

act shoo any
{
    has (itm_010);        # Phaser
    set (flag_03);
    in (rm_007);
    msg_023;    # "I fire the Phaser,";
    goto rm_024;
    msg_029;    # "I ruined the ship!";
    quit;
    
}

act shoo any
{
    has (itm_010);        # Phaser
    set (flag_03);
    in (rm_002);
    msg_023;    # "I fire the Phaser,";
    goto rm_024;
    msg_029;    # "I ruined the ship!";
    quit;
    
}

act shoo rod
{
    has (itm_010);        # Phaser
    set (flag_03);
    here (itm_025);        # Rod jutting straight out of the wall
    msg_023;    # "I fire the Phaser,";
    msg_024;    # "I destroyed it!";
    zap itm_025;        # Rod jutting straight out of the wall
    on flag_04;
    
}

act shoo plas
{
    has (itm_010);        # Phaser
    set (flag_03);
    here (itm_024);        # Small piece of plastic flush in the wall
    msg_023;    # "I fire the Phaser,";
    msg_024;    # "I destroyed it!";
    zap itm_024;        # Small piece of plastic flush in the wall
    on flag_04;
    
}

act shoo plas
{
    has (itm_010);        # Phaser
    !set (flag_03);
    here (itm_024);        # Small piece of plastic flush in the wall
    msg_042;    # "The plastic GLOWED briefly.";
    on flag_04;
    
}

act shoo plas
{
    has (itm_010);        # Phaser
    set (flag_03);
    avail (itm_027);        # Strange light far to the NORTH
    msg_023;    # "I fire the Phaser,";
    msg_024;    # "I destroyed it!";
    zap itm_027;        # Strange light far to the NORTH
    on flag_04;
    
}

act shoo phas
{
    msg_061;    # "Try: 'SHOOT SOMETHING'";
    
}

act shoo houn
{
    has (itm_010);        # Phaser
    avail (itm_028);        # Rigilian Dia-Ice Hound
    set (flag_03);
    on flag_04;
    msg_023;    # "I fire the Phaser,";
    msg_024;    # "I destroyed it!";
    zap itm_028;        # Rigilian Dia-Ice Hound
    
}

act shoo houn
{
    has (itm_010);        # Phaser
    avail (itm_028);        # Rigilian Dia-Ice Hound
    !set (flag_03);
    on flag_04;
    msg_023;    # "I fire the Phaser,";
    msg_088;    # "It's stunned!";
    swap itm_028, itm_029;        # Rigilian Dia-Ice Hound        # Stunned Dia-Ice Hound
    swap tr_04;
    timer 17;
    swap tr_04;
    
}

act shoo moun
{
    has (itm_010);        # Phaser
    set (flag_03);
    here (itm_036);        # Large ice mound
    msg_023;    # "I fire the Phaser,";
    msg_024;    # "I destroyed it!";
    zap itm_036;        # Large ice mound
    on flag_04;
    
}

act shoo moun
{
    in (rm_016);
    set (flag_03);
    has (itm_010);        # Phaser
    goto rm_018;
    on flag_04;
    msg_024;    # "I destroyed it!";
    msg_056;    # "The Ice Hound burrows off...";
    
}

act shoo belt
{
    avail (itm_048);        # *ALIEN SCULPTURE*
    has (itm_010);        # Phaser
    set (flag_03);
    zap itm_048;        # *ALIEN SCULPTURE*
    on flag_04;
    zap itm_042;        # *STRANGE ALIEN BELT*
    msg_023;    # "I fire the Phaser,";
    msg_024;    # "I destroyed it!";
    
}

act shoo any
{
    avail (itm_011);        # Phaser
    msg_003;    # "OK.";
    msg_023;    # "I fire the Phaser,";
    msg_002;    # "Nothing happens.";
    msg_031;    # "It's empty.";
    
}

act shoo any
{
    has (itm_010);        # Phaser
    on flag_04;
    msg_023;    # "I fire the Phaser,";
    msg_002;    # "Nothing happens.";
    msg_030;    # "Either I missed, or the beam was absorbed without visible effect!";
    
}

act find any
{
    msg_050;    # "I found nothing.";
    msg_060;    # "I don't know where to look.";
    
}

act move any
{
    msg_026;    # "It won't budge!";
    
}

act set phas
{
    avail (itm_010);        # Phaser
    msg_016;    # "'TO STUN' or 'TO DESTROY'?";
    msg_017;    # "(use 2 words)";
    
}

act suit up
{
    avail (itm_007);        # Space suit
    steal itm_008;        # which I'm wearing
    steal itm_007;        # Space suit
    msg_003;    # "OK.";
    
}

act wear suit
{
    avail (itm_007);        # Space suit
    steal itm_008;        # which I'm wearing
    steal itm_007;        # Space suit
    msg_003;    # "OK.";
    
}

act wear belt
{
    avail (itm_042);        # *STRANGE ALIEN BELT*
    steal itm_043;        # which I'm wearing
    msg_003;    # "OK.";
    steal itm_042;        # *STRANGE ALIEN BELT*
    try
    {
        exists (itm_044);        # & it's activated
        steal itm_044;        # & it's activated
        msg_072;        # "I feel LIGHT-HEADED!";
    }
    
}

act wear gogg
{
    avail (itm_049);        # Strange looking goggles
    steal itm_049;        # Strange looking goggles
    steal itm_050;        # which I'm wearing
    msg_003;    # "OK.";
    
}

act scor any
{
    .score;
    
}

act pull rod
{
    here (itm_025);        # Rod jutting straight out of the wall
    !set (flag_05);
    msg_002;    # "Nothing happens.";
    msg_033;    # "It seems to be as far";
    msg_034;    # "out";
    msg_038;    # "as it will go.";
    
}

act pull rod
{
    here (itm_025);        # Rod jutting straight out of the wall
    set (flag_05);
    msg_039;    # "Odd, it only required very little force";
    msg_047;    # "to slide";
    msg_036;    # "out.";
    off flag_05;
    
}

act bend rod
{
    here (itm_025);        # Rod jutting straight out of the wall
    msg_039;    # "Odd, it only required very little force";
    msg_040;    # "for it to break off in my hand with a CRYSTALLINE snap!";
    zap itm_025;        # Rod jutting straight out of the wall
    steal itm_026;        # Broken piece of rod
    
}

act bend buck
{
    avail (itm_042);        # *STRANGE ALIEN BELT*
    !exists (itm_044);        # & it's activated
    same itm_044, rm_042;        # & it's activated
    msg_003;    # "OK.";
    msg_073;    # "It floats!";
    
}

act bend buck
{
    avail (itm_042);        # *STRANGE ALIEN BELT*
    exists (itm_044);        # & it's activated
    msg_003;    # "OK.";
    zap itm_044;        # & it's activated
    
}

act bend buck
{
    !exists (itm_042);        # *STRANGE ALIEN BELT*
    msg_064;    # "I can't do that.";
    msg_094;    # "I don't have it!";
    
}

act clos suit
{
    has (itm_007);        # Space suit
    msg_003;    # "OK.";
    steal itm_008;        # which I'm wearing
    
}

act clos any
{
    msg_041;    # "HOW?";
    
}

act open door
{
    in (rm_001);
    msg_041;    # "HOW?";
    
}

act open suit
{
    has (itm_008);        # which I'm wearing
    msg_003;    # "OK.";
    zap itm_008;        # which I'm wearing
    
}

act open hatc
{
    here (itm_004);        # Maintenance access hatch
    !avail (itm_039);        # Short twisted piece of metal
    !exists (itm_040);        # Entrance to a crawlway
    msg_064;    # "I can't do that.";
    msg_069;    # "It's stuck.";
    
}

act open hatc
{
    here (itm_004);        # Maintenance access hatch
    avail (itm_039);        # Short twisted piece of metal
    get itm_004;        # Maintenance access hatch
    drop itm_040;        # Entrance to a crawlway
    msg_003;    # "OK.";
    msg_089;    # "The metal helped!";
    
}

act jump any
{
    here (itm_003);        # Scoutship
    msg_003;    # "OK.";
    goto rm_002;
    
}

act jump any
{
    in (rm_012);
    msg_003;    # "OK.";
    msg_066;    # "The gravity here is very";
    msg_068;    # "weak.";
    delay;
    delay;
    delay;
    goto rm_004;
    drop itm_003;        # Scoutship
    
}

act jump any
{
    msg_003;    # "OK.";
    
}

act dig any
{
    in (rm_016);
    msg_064;    # "I can't do that.";
    msg_058;    # "Ice is very smooth & hard!";
    
}

act dig any
{
    !exists (itm_038);        # Broken ice pick
    avail (itm_051);        # Shovel
    in (rm_009);
    !exists (itm_037);        # Ancient ice pick
    drop itm_037;        # Ancient ice pick
    msg_003;    # "OK.";
    msg_086;    # "I found something.";
    
}

act dig any
{
    here (itm_036);        # Large ice mound
    has (itm_037);        # Ancient ice pick
    msg_057;    # "Ice fills back in around me, as I dig my way in. The pick broke, but I made it!";
    goto rm_016;
    swap itm_037, itm_038;        # Ancient ice pick        # Broken ice pick
    
}

act dig any
{
    here (itm_036);        # Large ice mound
    !has (itm_037);        # Ancient ice pick
    msg_041;    # "HOW?";
    msg_058;    # "Ice is very smooth & hard!";
    
}

act dig any
{
    here (itm_036);        # Large ice mound
    avail (itm_051);        # Shovel
    msg_003;    # "OK.";
    msg_039;    # "Odd, it only required very little force";
    msg_045;    # "for it to shatter!";
    swap itm_051, itm_052;        # Shovel        # Broken & splintered shovel
    
}

act dig any
{
    avail (itm_051);        # Shovel
    msg_050;    # "I found nothing.";
    
}

act melt moun
{
    here (itm_036);        # Large ice mound
    msg_041;    # "HOW?";
    
}

act lift gogg
{
    has (itm_050);        # which I'm wearing
    msg_003;    # "OK.";
    zap itm_050;        # which I'm wearing
    zap itm_001;        # EVERYTHING HAS A BLUISH TINT
    
}


treasure=rm_022;
initial=rm_001;


