/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class AdventureGame {
    final boolean ScottLight;
    final boolean Trash80;
    final boolean OldLamp;
    final boolean UseYou;
    final char PlayerRoom;
    final int Actions;
    final int NumNouns;
    final int NumVerbs;
    final int NumRooms;
    final int Carry;
    final int Treasures;
    final int WordLength;
    final int LightRefill;
    final int NumMessages;
    final char TreasureRoom;
    final int NumObjects;
    final char[] ObjectStarts = new char[]{'\u0004', '\u0000', '\b', '\u0005', '\u0002', '\u0003', '\u0000', '\f', '\u0002', '\u0000', '\t', '\u0000', '\u000f', '\u0000', '\u0000', '\u0013', '\u0007', '\u0001', '\u0006', '\u0000', '\n', '\u000e', '\r', '\u0000', '\u0004', '\u0000', '\u0011', '\u0000', '\u0000', '\u0000', '\b', '\u0000', '\u0010', '\f', '\u0000', '\u0012', '\u0011', '\u0000', '\u0011', '\u000b', '\u0000', '\u0000', '\u0000', '\u000f', '\u0016', '\u0000', '\u000e', '\u0000', '\u0000', '\u0013', '\u0000', '\u0000', '\u0000', '\u0014', '\u0000', '\u0000', '\u000b', '\f', '\u0015', '\u0000', '\u0015', '\b', '\b', '\u0000', '\u0017', '\u0000'};
    final String[] ObjectNames = new String[]{"Bloody Knife", "Ledge", "Plaque", "Animal heads", "Broken glass", "Big kettle", "Dark hole", "Shield", "Stairs", "Brightly glowing idol", "Open Window", "Dark Chimney", "Closed Flue", "Open Flue", "Four leaf clover", "GrAves", "Cast iron pot", "Closed Coffin", "Crystal Ball", "Closed Window", "Large fireplace", "Soot", "Tiny open door", "Spirit Medium", "Massive stone door with a SAPPHIRE set into it", "Sapphire ring", "Ju-Ju bag", "Open Coffin", "Slick chute leading downward", "Ju-Ju man", "Slippery chute leading up", "Wide crack in the wall", "Rabbit's foot", "Dull & broken sword", "Open SAfe", "Stuck Chimney Sweep", "Chem tubes", "Closed SAfe", "Labeled chemicals", "Pocket Shovel", "Mixed Chemicals", "Wide open door", "Nails", "Dusty Idol", "Doll", "Wooden boards", "Wood boards nailed to chimney wall", "Antique hammer", "GrAting", "Rusting SAW", "Button in the wall", "Paper", "Voodoo book", "Ju-Ju man statue", "Stick", "Open wall", "Open jail cell", "Knight's Suit of Armor", "Closed cell door", "Broken grating", "Advertising leaflet", "Crack in the wall", "Hole in the wall", "Pieces of rock", "Page torn from a book", "Smiling Count Cristo"};
    final char[] AutoGets = new char[]{'\u0007', '\u0000', '\u0019', '(', '\u001f', '\u0000', '\u0000', '\u001b', '\u0000', '\t', '\u0000', '\u0000', '\u0000', '\u0000', '\u0010', '\u0000', 'B', '\u0000', '\u0000', '\u0000', '\u0000', '&', '\u0000', '\u0000', '\u0000', ' ', ',', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '/', '\r', '\u0000', '\u0000', '!', '\u0000', '*', '2', '*', '\u0000', 'K', '\t', '7', '8', '\u0000', '9', '\u0000', '.', '\u0000', '3', '?', '+', '=', '\u0000', '\u0000', '\u0000', '\u0000', '\u0014', 'W', '\u0000', '\u0000', 'O', 'Y', '\u0000'};
    final String[] Messages = new String[]{"", "Count Cristo's been CURSED! There's one way for him to flee!\nFind it, and he'll go FREE!", "It belongs to the medium", "Spirit vibrations drive me from room.", "Prints too small for the unaided eye.", "I can't do that", "Nothing happened", "Windows open", "Window just slAmmed shut", "For a reading just \"SUMMON MEDIUM MAEGEN\" today!!", "I see nothing very special.", "Phosphorescent letters are very hard to read in bright light!", "Amongst the GRAVES is a four leaf clover.", "Raven crys something outside", "One of the test tubes EXPLODED!", "This glass can't be broken", ".", "They appear to be mixable.", "There's something written there", "A sepulchral voice says:", "OK", "Safe's combination lock is numbered from 33 to 38.", "Ring glows briefly & door vanishes", "OUCH", "A sign here says:", "There's a man here", "Wearing a sapphire ring", "I slide back down", "A beam of light shines on grave", "Pins fall out of doll", "Plaque says: \"safe --> 38 33\"", "This grAve reserved for you!", "There's a CLAP OF THUNDER!", "Ju-Ju man says:\"My bag is now yours! Its magic will help you\n -CRACK- the curse!\".", "HURRAH! Look who is in the room!", "I'm now 4 feet tall!", "It's much to heavy to LIFT!", "I'm too big", "You startled medium & she vanished", "On what?", "Maid chased me with broom for tracking soot through the Ball-\nroom. I wonder where I am?", "Sweep pops out, thanks me, hands me a piece of paper then\nvanishes!", "As I dust of the Idol it begins to glow!", "He's wearing a rabbit's foot", ".", "HELP ME, I'm stuck!", "Luck wasn't with me!", "Doll looks like Count Cristo. There're pins in it!", ".", "Bird says: \"ask for ADVENTURE 5, -THE COUNT- at your\n favorite computer dealer. It will be LOVE AT FIRST BYTE!\"\n", "There's some soup here.", "I see a hole under it!", "Nails were rusted but I got them out.", "It's hArd work but it seems to be coming loose", "I hear strange sounds, as if someone were moaning.", "I've got it!", "Heavy duty exhaust fan comes on & sucks me up!", ".", "says: \"SAY ZAP   to restore someone changed to stone!\"", "Statue is made of stone", "I hear nothing.", "won't budge!", "I'll need something to pry it off the wall!", "It's a book on removing curses. Says: \"With knife in hand you\ntake a stand. Circle coffin and...\" The rest of the page is\nmissing!!!", "Its very dark, the only light is from the idol.", "That's illegal!", "Double bubble toil & trouble the encAntAtions Are About to peAk!", "There's an antique hammer here", "There's a Clap of Thunder & then suddenly the stone statue\nbegins to crack. I may be in trouble now, there's someone in\nthe room with me!", "Looks almost like lemonade. Yummy!", "You've been turned into a broomstick & a witch rides off on you!", "There's witch's brew there", "Cell door slams shut", "You've been sprung", "...wave the stick and hold the lamp and don't forget to yell\n\"CHANT\"! Oh yes, to help it succeed, a doll you'll need...", "Welcome to ADVENTURE:4, \"VOODOO CASTLE\" by Alexis ADAMS.\nDedicated to all MOMS!", "how?", "It appears stuck to the floor!", "There's no room in there for me!", "My idol acted strange", "I've no container.", "Some dust fell off it and it glowed briefly.", "Its very faint.", "Its much louder up here.", "There's a book there.", "There's a stick there.", "Boy it looks dusty.", "Its glowing.", "Strange hobby you have", "Check out the fireplace.", "Its empty.", "I hear someone mumbling.", ".", "Saw grating!", "I haven't got a knife!", "Inscription on ring says: \"WAVE ME!\"", "Medium appears, says: \"Keep a good luck charm on you & your\nfriend. I also see a -moving- bag helping you through a tight\nsqueeze!\"", "It will take some strong magic to get me through that!", "Use a number!", "Knife made no impression on it!"};
    final String[] Rooms = new String[]{"", "chapel", "Dingy Looking Stairwell", "room in the castle", "Tunnel", "room in the castle", "*I'm in Medium Maegen's Mad Room", "room in the castle", "room in the castle", "room in the castle", "Ballroom", "dungeon", "*I'm in the Armory", "torture chamber", "Chimney", "large fireplace", "room in the castle", "Lab", "narrow part of the chimney", "Graveyard", "parlor", "Jail Cell", "*I'm on a ledge", "hidden VOODOO room", "room in the castle", "lot of TROUBLE!"};
    final String[] Verbs = new String[]{"AUT", "GO", "*EN", "*WA", "*CL", "*RU", ".", "", "", "", "GET", "*TA", "*PI", "*RE", "*PU", "HEL", "*RE", ".", "DRO", "*PU", "*LE", "*TH", "DIG", "ON", "WAV", "DUS", "*CL", "PRE", "*PU", "MOV", "*SH", "*KI", "BRE", "*SM", "SAV", "REA", ".", "", "OPE", "CLO", "TUR", "*DI", "LOO", "*EX", "INV", "CIR", ".", "QUI", "DRI", "*EA", "SAW", "MIX", "HAM", ".", "SHR", ".", "LIS", "*HE", "STA", "", "SHA", "", "SLI", "DAN", "YEL", "*SC", "*SU", "*SA", "*CR", "CUT", "*ST", "", "RUB", "SMO", ".", "HUG", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    final String[] Nouns = new String[]{"ANY", "NOR", "SOU", "EAS", "WES", "UP", "DOW", "KNI", "COF", "IDO", "INV", "KET", "HOL", "SWO", "PAT", "WIN", "CLO", "DOO", "CHU", "LAB", "GRA", "WAL", "BAL", "MED", "CHI", "WRI", "*PL", "SHI", "SAF", "BRE", "ARM", "GLA", "RIN", "TUB", "FIR", "FLU", "*CH", "38", "SOO", "33", "HEA", "*AN", "CHE", "STA", "BAG", "PIN", "SAW", "FOO", "*RA", "GAM", "SHO", "PAP", "SWE", "MAN", "*CR", "DOL", "BOA", "HAM", "GRA", "BUT", "PUP", "STI", "STA", "BOO", "CHA", "ZAP", "POT", "CEL", "BAR", "LOC", "LED", "WOO", "VOI", "SIG", "FLO", "NAI", "MUM", "CRA", "SAP", "ROC", "ARO", "CRY", "*RA", "34", "35", "36", "37", "LEA", "MOA", "PAG"};
    final char[] GameCode = new char[]{'\u0019', '\u00ca', '\u0000', '\u0000', '\u0000', '\u0000', '\u079e', '\u0000', 'd', '\u00b8', '\u00ca', '\u0124', '\u00c8', '\u017c', '\u04f8', '\u0000', 'd', '\u00bb', '\u0189', '\u00c8', '\u017c', '\u0000', '\u2a30', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '-', '\u0180', '\u0126', '\u0000', '\u0000', '\u0000', '\u1068', '\u0000', '\u001e', '\u02d3', '\u0092', '\u01f4', '\u0000', '\u0000', '\u1fe4', '\u087d', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0e2f', '\u0000', '\u001e', '\u02d3', '\u008d', '\u0000', '\u0000', '\u0000', '\u0834', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'd', '\u0130', '\u0134', '\u0000', '\u0000', '\u0000', '\u21b2', '\u0000', '2', '\u01a5', '\u00dc', '\u00cc', '\u0000', '\u0000', '\u17a6', '\u0000', 'd', '@', '\u0134', '\u0000', '\u0000', '\u0000', '\u21b2', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'd', '\u016c', '\u02c9', '\u0000', '\u0000', '\u0000', '\u3cf0', '\u0000', '#', '\u011c', '\u02c9', '\u0000', '\u0000', '\u0000', '\u3cf0', '\u0000', '#', '\u0130', '\u02c9', '\u0000', '\u0000', '\u0000', '\u3cf0', '\u0000', 'd', '\u01f8', '\u0000', '\u0000', '\u0000', '\u0000', '\u1b33', '\u0000', 'd', '\u0095', '\u008c', '\u0000', '\u0000', '\u0000', '\u4978', '\u0000', '\u0007', '\u035d', '\u0000', '\u0000', '\u0000', '\u0000', '\u4c19', '\u0000', '#', '\u0247', '\u0000', '\u0000', '\u0000', '\u0000', '\u529e', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0610', '\u02be', '\u0000', '\u0000', '\u0000', '\u0000', '\u410a', '\u0000', '\u05f0', '\u049f', '\u049c', '\u0000', '\u0000', '\u0000', '\u0bec', '\u0000', '\u0e3c', '\u00a4', '\u027a', '\u020b', '\u026c', '\u04c4', '\u1318', '\u33d8', '\u1687', '\u011e', '\u0000', '\u0000', '\u0000', '\u0000', '\u02ee', '\u0000', '\u00d9', '\u0462', '\u011d', '\u01a4', '\u0000', '\u0000', '\u297e', '\u1fe4', '\u18b5', '+', '\u0000', '\u0000', '\u0000', '\u0000', '\u0a8c', '\u0000', '\u05e6', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u26ac', '\u0000', '\u12cf', '\u017e', '\u0000', '\u0000', '\u0000', '\u0000', '\u08ca', '\u0000', '\u1109', 'f', '}', 'x', '\u0000', '\u0000', '\u1f22', '\u0000', '\u05f2', '\u016a', '\u0000', '\u0000', '\u0000', '\u0000', '\u0b24', '\u0000', '\u05ec', '\u011a', '\u0118', '\u0000', '\u0000', '\u0000', '\u1e78', '\u0000', '\u18b0', '\u012e', '\u0126', '\u0000', '\u0000', '\u0000', '\u0720', '\u122a', '\u05ec', '\u0126', '\u0180', '\u0118', '\u0000', '\u0000', '\u1e8c', '\u0000', '\u18b0', '\u012e', '\u0125', '\u0000', '\u0000', '\u0000', '\u0e2f', '\u0000', '\u00c1', '\u00a2', '\u0190', '\u0000', '\u0000', '\u0000', '\u293a', '\u2580', '\u18b8', '\u02e6', '\u0000', '\u0000', '\u0000', '\u0000', '\u0c4e', '\u0000', '\u18b8', '\u02aa', '\u03ac', '\u03ba', '\u0000', '\u0000', '\u1f83', '\u0000', '\u1667', '\u00f2', '\u00f0', '\u0104', '\u00dc', '\u0000', '\u2a44', '\u1f0e', '\u16fd', '\u0106', '\u00f0', '\u0104', '\u00dc', '\u0000', '\u2a44', '\u2292', '\u00a2', 'z', '\u0140', '\u0000', '\u0000', '\u0000', '\u1fdc', '\u2944', '\u00b9', '\u0130', '\u0106', '\u0118', '\u0000', '\u0000', '\u2106', '\u2944', '\u18f3', '\u04b3', '\u0000', '\u0000', '\u0000', '\u0000', '\u0a8c', '\u0000', '\u18b2', '|', '\u016a', 'P', '\u0000', '\u0000', '\u0612', '\u2c8b', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00b8', '\u0192', '\u012c', '\u0000', '\u0000', '\u0000', '\u1ff0', '\u0000', '\u1655', '\u0108', '\u0000', '\u0000', '\u0000', '\u0000', '\u0bb8', '\u0000', '\u0e30', '\u01e2', '\u01f5', '\u0230', '\u01e0', '\u0000', '\u2a46', '\u0000', '\u00a8', '\u0232', '\u00a0', '\u0000', '\u0000', '\u0000', '\u0bee', '\u2c88', '\u05fc', '\u021e', '\u0202', '\u01f4', '\u0000', '\u0000', '\u1e8c', '\u0000', '\u1c3d', '\u0143', '\u0000', '\u0000', '\u0000', '\u0000', '\u1318', '\u468f', '\u164c', '\u0156', '\u0154', '\u021c', '\u0000', '\u0000', '\u2a44', '\u0000', '\u16e2', '\u021e', '\u0154', '\u021c', '\u0000', '\u0000', '\u2a44', '\u0000', '\u05fa', '\u0476', '\u0000', '\u0000', '\u0000', '\u0000', '\u0312', '\u0000', '\u12d6', '|', '\u0000', '\u0000', '\u0000', '\u0000', '\u23da', '\u1269', '\u1655', '\u01e2', '\u0000', '\u0000', '\u0000', '\u0000', '\u035d', '\u0000', '\u0608', '\u020b', '\u0251', '\u0208', '\u0000', '\u0000', '\u1e8c', '\u0000', '\u149b', '+', 'S', '\u0134', '\u0000', '\u0000', '\u1194', '\u0000', '\u00a8', '\u0232', '\u00a0', '\u0000', '\u0000', '\u0000', '\u1ff0', '\u0000', '\u00a8', '\u025a', '\u0000', '\u0000', '\u0000', '\u0000', '\u0fd2', '\u0000', '\u18c8', '\u020b', '\u041e', '\u0445', '\u0000', '\u0000', '\u4e84', '\u0000', '\u1a66', '\u0000', '\u0018', '\u0000', '\u0000', '\u0000', '\u2ada', '\u03dc', '\u0000', '\u028e', '\u00b7', '\u0001', '<', '\u0000', '\u221c', '\u2142', '\u18c6', '\u0323', '\u0000', '\u0000', '\u0000', '\u0000', '\u45ba', '\u0000', '\u0604', '\t', '\u0297', '<', '\u02e4', '>', '\u1ead', '\u0bfb', '\u1660', 'h', '\u02aa', '\u0000', '\u0000', '\u0000', '\u0bb8', '\u0000', '\u18b8', 'h', '\u02aa', '\u03b9', '\u0000', '\u0000', '\u0c44', '\u0000', '\u0604', '\b', '?', '<', '\u0000', '\u0000', '\u1e8c', '\u0000', '\u1795', '\u001d', '\u02e6', '\u0014', '\u0000', '\u0000', '\u2210', '\u0000', '\u1797', '\u001c', '\u02e6', '\u02a8', '\u02e4', '\u0000', '\u2a44', '\u0000', '\u18c8', '\u020b', '\u0446', '\u041e', '\u0251', '\u0000', '\u4f0b', '\u0000', '\u14c1', '\u0413', '\u0000', '\u0000', '\u0000', '\u0000', '\u4236', '\u0000', '\u2597', '\u01da', '|', '\u01cc', '\u0000', '\u0000', '\u0c0d', '\u1fa0', '\u00ae', '\u0106', '\u0118', '\u0000', '\u0000', '\u0000', '\u1fdc', '\u2c88', '\u1495', '\u02fb', '\u0000', '\u0000', '\u0000', '\u0000', '\u09f6', '\u0000', '\u1c4a', '\u0323', '\u0334', '\u01b8', '\u02f8', '\u0000', '\u1309', '\u2a6b', '\u0000', '\u0320', '\u0000', '\u0000', '\u0000', '\u0000', '\u22ea', '\u33b3', '\u25c1', '\u0427', '\u0424', '\u0244', '\u0000', '\u0000', '\u22c7', '\u2b1b', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u45b1', '\u0000', '\u141d', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u299a', '\u0000', '\u05e7', 'f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0312', '\u0000', '\u00a7', '\u01ba', '\u0000', '\u0000', '\u0000', '\u0000', '\u0313', '\u5622', '\u19c8', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u26ac', '\u0000', '\u0604', '\t', '?', '\u0000', '\u0000', '\u0000', '\u417a', '\u0000', '\u0abb', '\u0281', '\u0000', '\u0000', '\u0000', '\u0000', '\u16da', '\u0000', '\u0daf', '\u0283', '\u0280', '\u021e', '\u0000', '\u0000', '\u0bd8', '\u2292', '\u0609', '\u0372', '\u0000', '\u0000', '\u0000', '\u0000', '\u035d', '\u0000', '\u1006', '\u016c', '\u02be', '\u02bc', '\u03fc', '\u0000', '\u183d', '\u2b5c', '\u14b5', '\u03ff', '\u0000', '\u0000', '\u0000', '\u0000', '\u3f48', '\u0000', '\u18d3', '\u0373', '\u0000', '\u0000', '\u0000', '\u0000', '\u1b8a', '\u0000', '\u18a4', '\u021e', '\u0000', '\u0000', '\u0000', '\u0000', '\u0e11', '\u2adf', '\u0000', '\u028e', '\u0000', '\u0000', '\u0000', '\u0000', '\u1932', '\u0000', '\u0000', '\u0202', '\u0000', '\u0000', '\u0000', '\u0000', '\u0f3c', '\u0000', '\u25c0', '\u0018', '\u00b7', '\u011b', '\u0080', '\u0373', '\u2ae6', '\u33ad', '\u0000', '\u0514', '\u0000', '\u0000', '\u0000', '\u0000', '\u1f5a', '\u142b', '\u0627', '\u034b', '\u0348', '\u0000', '\u0000', '\u0000', '\u0bec', '\u0000', '\u00d8', '\u0462', '\u0000', '\u0000', '\u0000', '\u0000', '\u0bb8', '\u0000', '\u18c6', '\u02fb', '\u0000', '\u0000', '\u0000', '\u0000', '\u09f6', '\u0000', '\u18de', '\u0143', '\u0000', '\u0000', '\u0000', '\u0000', '\u46e6', '\u0000', '\u060b', '\u028e', '\u021e', '\u0280', '\u0000', '\u0000', '\u1e8c', '\u0000', '\u060b', '\u0283', '\u0280', '\u0000', '\u0000', '\u0000', '\u1e8c', '\u0000', '\u00a5', '\u00ca', '\u01b8', '\u0000', '\u0000', '\u0000', '\u1fb8', '\u2c88', '\u0eaf', '\u035f', '\u00b4', '\u035c', '\u0000', '\u0000', '\u18e4', '\u2c88', '\u1109', 'z', 'x', 'z', '\u0000', '\u0000', '\u2292', '\u0000', '\u18a7', 'f', '@', '\u0086', '\u0000', '\u0000', '\u0beb', '\u1d4c', '\u16eb', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u410a', '\u0000', '\u1c22', 'f', '\u0384', '\u0000', '\u0000', '\u0000', '\u0bef', '\u0000', '\u0e4d', '\u0373', '\u0000', '\u0000', '\u0000', '\u0000', '\u2ada', '\u03dc', '\u0000', '\u00b7', '\u0018', 'D', 'x', '\u0000', '\u33b0', '\u4432', '\u1d60', '\u03c2', '\u03d5', '\u03c0', '\u0000', '\u0000', '\u3c6e', '\u2afd', '\u0000', '\u03e8', '\u049c', '\u0000', '\u0000', '\u0000', '\u1f77', '\u2b5c', '\u100d', '\u03ea', '\u0168', '\u0000', '\u0000', '\u0000', '\u3e52', '\u2c88', '\u1b8a', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u24ea', '\u0000', '\u00e3', '\u026e', '\u01cc', '\u0000', '\u0000', '\u0000', '\u0bee', '\u2c88', '\u18c7', '\u0427', '\u0000', '\u0000', '\u0000', '\u0000', '\u3fde', '\u0000', '\u20d0', '\u0247', '\u0000', '\u0000', '\u0000', '\u0000', '\u1356', '\u0000', '\u0615', '\u03af', '\u03ac', '\u0000', '\u0000', '\u0000', '\u1e8c', '\u0000', '\u0615', '\u02aa', 'm', '\u03ac', 'd', '\u0000', '\u1e8c', '\u21fc', '\u14db', '\u0503', '\u0000', '\u0000', '\u0000', '\u0000', '\u48a8', '\u0000', '\u0e10', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0bbe', '\u0000', '\u1fa4', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u49d4', '\u0000', '\u149b', '+', '\\', '\u0000', '\u0000', '\u0000', '\u02f2', '\u0000', '\u1670', '\u0251', '\u020b', '\u0000', '\u0000', '\u0000', '\u0bb8', '\u0000', '\u18df', '\u00e0', '\u0000', '\u0000', '\u0000', '\u0000', '\u05dc', '\u0000', '\u111c', '\u0477', '\u0000', '\u0000', '\u0000', '\u0000', '\u0bb8', '\u0000', '\u0608', '\u020a', '\u0000', '\u0000', '\u0000', '\u0000', '\u4a6a', '\u0000', '\u149b', '+', 'S', '\u0000', '\u0000', '\u0000', '\u02f9', '\u0000', '\u00dc', '\u00b8', '\u0016', '\u0000', '\u0000', '\u0000', '\u1cb6', '\u0000', '\u20d0', '\u0130', '\u02c9', '\u0000', '\u0000', '\u0000', '\u3d74', '\u0000', '\u20d0', '\u02c9', '\u011c', '\u0000', '\u0000', '\u0000', '\u3d75', '\u0000', '\u009e', '\u021e', '\u0000', '\u0000', '\u0000', '\u0000', '\u4b00', '\u0000', '\u05de', 'f', '\u0000', '\u0000', '\u0000', '\u0000', '\u4c2c', '\u0000', '\u00a2', '\u04da', 'x', '\u01cc', '\u0000', '\u0000', '\u1ff0', '\u167f', '\u18bc', '\u01f7', '\u0000', '\u0000', '\u0000', '\u0000', '\u0a8c', '\u0000', '\u2877', '\u035f', '\u0003', '\u0000', '\u0000', '\u0000', '\u4c19', '\u0000', '\u286e', '\u0003', '\u0000', '\u0000', '\u0000', '\u0000', '\u0bbe', '\u574e', '\u18c8', '\u041d', '\u0446', '\u0251', '\u020b', '\u0000', '\u4f1a', '\u0000', '\u061b', '\u020b', '\u0251', '\u0410', '\u041e', '\u0000', '\u1e8c', '\u0000', '\u061b', '\u0413', '\u0410', '\u0000', '\u0000', '\u0000', '\u1e8c', '\u0000', '\u0619', '\u020b', '\u0446', '\u0438', '\u0251', '\u0000', '\u1e8c', '\u0000', '\u0619', '\u043b', '\u0438', '\u0000', '\u0000', '\u0000', '\u1e8c', '\u0000', '\u00a7', '\u0336', '\u017c', '\u0000', '\u0000', '\u0000', '\u1ff0', '\u0000', '\u2335', '\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u18a5', '\u035f', '\u0000', '\u0000', '\u0000', '\u0000', '\u4fba', '\u0000', '\u18a5', '\u00b7', '\u0000', '\u0000', '\u0000', '\u0000', '\u5046', '\u0000', '\u0cf8', '\u030f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0bac', '\u0000', '\u1d4c', '\u03d5', '\u048a', '\u00dc', '\u0000', '\u0000', '\u4848', '\u2580', '\u2121', '\u00b8', '\u0000', '\u0000', '\u0000', '\u0000', '\u1cb6', '\u0000', '\u1653', '\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u2454', '\u0232', '\u00a0', '\u0000', '\u0000', '\u0000', '\u1ff0', '\u0000', '\u20d0', '\u02be', '\u0000', '\u0000', '\u0000', '\u0000', '\u1a5e', '\u0000', '\u08ca', '\u00cc', '\u0000', '\u0000', '\u0000', '\u0000', '\u5172', '\u0000', '\u24ea', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0bbe', '\u0000', '\u2580', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0c0d', '\u0384', '\u0627', '\u039a', '\u03ad', '\u0398', '\u0384', '\u0348', '\u3c0c', '\u2b5c', '\u0dc4', '\u0281', '\u0280', '\u0000', '\u0000', '\u0000', '\u1f22', '\u0000', '\u0614', '\u0387', '\u0384', '\u00a9', '\u03c0', '\u00a0', '\u1ead', '\u21fc', '\u0614', '\u0387', '\u0384', '\u0000', '\u0000', '\u0000', '\u1e8c', '\u0000', '\u05f9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u4c2c', '\u0000', '\u08ca', '\u03c2', '\u0000', '\u0000', '\u0000', '\u0000', '\u53ca', '\u0000', '\u1e0c', '\u02fb', '\u0320', '\u02f8', '\u0000', '\u0000', '\u2a44', '\u0000', '\u08fe', '\u02be', '\u0000', '\u0000', '\u0000', '\u0000', '\u49d4', '\u0000', '\u2a39', '\u035f', '\u0000', '\u0000', '\u0000', '\u0000', '\u4c19', '\u0000', '\u189c', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u2c92', '\u0000', '\u286e', '\u0006', '\u0000', '\u0000', '\u0000', '\u0000', '\u037e', '\u0000', '\u20d0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u4074', '\u0000', '\u05fc', '\u01f6', '\u01f4', '\u0000', '\u0000', '\u0000', '\u1e8c', '\u0000', '\u2b08', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u4362', '\u0000', '\u12e1', '\u02d3', '\u0092', '\u01f4', '\u0000', '\u0000', '\u1fe4', '\u087d', '\u1d4c', '\u03d5', '\u0000', '\u0000', '\u0000', '\u0000', '\u0bbe', '\u0000', '\u14d9', '\u04b3', '\u0000', '\u0000', '\u0000', '\u0000', '\u0bc1', '\u0000', '\u0ce4', '\u030f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0bbe', '\u0000', '\u00e3', '\u04c6', '\u0000', '\u0000', '\u0000', '\u0000', '\u0313', '\u5622', '\u08ca', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0384', '\u0000', '\u1660', '\u02e6', '\u0000', '\u0000', '\u0000', '\u0000', '\u0c4e', '\u0000', '\u12eb', '\u0427', '\u0424', '\u04ec', '\u0000', '\u0000', '\u0c00', '\u0000', '\u17c3', '\u02e6', '\u0014', '\u0000', '\u0000', '\u0000', '\u233c', '\u0000', '\u17c4', '\u02e6', '\u0014', '\u0000', '\u0000', '\u0000', '\u233c', '\u0000', '\u17c5', '\u02e6', '\u0014', '\u0000', '\u0000', '\u0000', '\u233c', '\u0000', '\u17c6', '\u02e6', '\u0014', '\u0000', '\u0000', '\u0000', '\u233c', '\u0000', '\u14a2', '\u01f7', '\u0000', '\u0000', '\u0000', '\u0000', '\u54f6', '\u0000', '\u1653', '\u017e', '\u0000', '\u0000', '\u0000', '\u0000', '\u410a', '\u0000', '\u2a50', '\u01f7', '\u0000', '\u0000', '\u0000', '\u0000', '\u0a8c', '\u0000', '\u2a30', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0bbe', '\u0000', '\u17b5', '\u02e6', '\u0000', '\u0000', '\u0000', '\u0000', '\u56b8', '\u0000', '\u1797', '\u02e6', '\u0014', '\u0000', '\u0000', '\u0000', '\u233c', '\u0000', '\u1795', '\u02e6', '\u0014', '\u0000', '\u0000', '\u0000', '\u233c', '\u0000', '\u2c29', '\u0373', '\u0000', '\u0000', '\u0000', '\u0000', '\u0d7a', '\u0000'};
    final char[] ExitMap = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\t', '\u0002', '\u0004', '\n', '\u0000', '\u0000', '\u0001', '\u0018', '\u0003', '\u000b', '\u0000', '\u0000', '\u0005', '\u0000', '\u0000', '\u0002', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0003', '\u0007', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\b', '\u0000', '\u0000', '\u0000', '\u0000', '\u0011', '\u0005', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\r', '\u0002', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\r', '\u0000', '\u0000', '\u000b', '\u0000', '\f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u000f', '\u0000', '\n', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0003', '\u0000', '\u0000', '\u0000', '\u0000', '\u0007', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u000e', '\u0000', '\u0000', '\r', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0002', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\t', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\b', '\u0000', '\u0000', '\u0000', '\u0000', '\u0002', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    static String[] ExitNames = new String[]{"North", "East", "South", "West", "Up", "Down"};
    static String[] Quickies = new String[]{"", "N", "E", "S", "W", "U", "D"};
    final char Carried = (char)255;
    final char Destroyed;
    final char Lamp = (char)9;
    final int DarkFlag;
    final int LightOutFlag;
    final char NoWord = (char)1000;
    final char AnyWord;
    final char VerbGo;
    final char VerbGet = (char)10;
    final char VerbDrop = (char)18;
    final char DirNorth;
    final char DirDown = (char)6;
    boolean[] Flags = new boolean[32];
    int[] Counters = new int[16];
    char[] Yoho;
    char Location;
    int CurCounter;
    char CurYoho;
    int LightTime;
    char[] Objects = new char[66];
    char[] Params;
    int ParamPtr;
    boolean Continuation;
    boolean Ended;
    boolean Redraw;
    Random Rng;
    String VerbString;
    String NounString;
    char NounCode;
    char VerbCode;
    ScottCanvas DrawingAgent;
    ScottCanvas TopDrawingAgent;

    public AdventureGame(ScottCanvas scottCanvas, ScottCanvas scottCanvas2) {
        int n;
        this.ScottLight = false;
        this.Trash80 = false;
        this.OldLamp = false;
        this.UseYou = false;
        this.PlayerRoom = '\u0001';
        this.Actions = 190;
        this.NumNouns = 90;
        this.NumVerbs = 90;
        this.NumRooms = 26;
        this.Carry = 9;
        this.Treasures = 0;
        this.WordLength = 3;
        this.LightRefill = 15000;
        this.NumMessages = 100;
        this.TreasureRoom = '\u0000';
        this.NumObjects = 66;
        this.Destroyed = '\u0000';
        this.DarkFlag = 15;
        this.LightOutFlag = 16;
        this.AnyWord = '\u0000';
        this.VerbGo = '\u0001';
        this.DirNorth = '\u0001';
        this.Yoho = new char[16];
        this.Params = new char[5];
        for (n = 0; n < 32; ++n) {
            this.Flags[n] = false;
        }
        for (n = 0; n < 16; ++n) {
            this.Counters[n] = 0;
        }
        for (n = 0; n < 16; ++n) {
            this.Yoho[n] = '\u0000';
        }
        for (n = 0; n < 66; ++n) {
            this.Objects[n] = this.ObjectStarts[n];
        }
        this.CurCounter = 0;
        this.LightTime = 15000;
        this.Redraw = false;
        this.Ended = false;
        this.Location = '\u0001';
        this.Rng = new Random();
        this.DrawingAgent = scottCanvas;
        this.TopDrawingAgent = scottCanvas2;
    }

    boolean StringEqual(String string, String string2) {
        return string.toUpperCase().equals(string2);
    }

    int CountCarried() {
        int n = 0;
        for (int i = 0; i < 66; ++i) {
            if (this.Objects[i] != '\u00ff') continue;
            ++n;
        }
        return n;
    }

    int CountTreasure() {
        int n = 0;
        for (int i = 0; i < 66; ++i) {
            if (this.Objects[i] != '\u0000' || this.ObjectNames[i].charAt(0) != '*') continue;
            ++n;
        }
        return n;
    }

    boolean ExecuteCondition(char c) {
        char c2 = (char)(c % 20);
        char c3 = (char)(c / 20);
        switch (c2) {
            case '\u0000': {
                this.Params[this.ParamPtr++] = c3;
                return true;
            }
            case '\u0001': {
                return this.Objects[c3] == '\u00ff';
            }
            case '\u0002': {
                return this.Objects[c3] == this.Location;
            }
            case '\u0003': {
                if (this.Objects[c3] == '\u00ff') {
                    return true;
                }
                return this.Objects[c3] == this.Location;
            }
            case '\u0004': {
                return this.Location == c3;
            }
            case '\u0005': {
                return this.Objects[c3] != this.Location;
            }
            case '\u0006': {
                return this.Objects[c3] != '\u00ff';
            }
            case '\u0007': {
                return this.Location != c3;
            }
            case '\b': {
                return this.Flags[c3];
            }
            case '\t': {
                return !this.Flags[c3];
            }
            case '\n': {
                return this.CountCarried() == 0;
            }
            case '\u000b': {
                return this.CountCarried() == 0;
            }
            case '\f': {
                if (this.Objects[c3] == '\u00ff') {
                    return false;
                }
                return this.Objects[c3] != this.Location;
            }
            case '\r': {
                return this.Objects[c3] != '\u0000';
            }
            case '\u000e': {
                return this.Objects[c3] == '\u0000';
            }
            case '\u000f': {
                return this.CurCounter <= c3;
            }
            case '\u0010': {
                return this.CurCounter >= c3;
            }
            case '\u0011': {
                return this.Objects[c3] == this.ObjectStarts[c3];
            }
            case '\u0012': {
                return this.Objects[c3] != this.ObjectStarts[c3];
            }
            case '\u0013': {
                return this.CurCounter == c3;
            }
        }
        return false;
    }

    void Output(String string) {
        this.DrawingAgent.AddString(string);
    }

    void OutputNumber(int n) {
        this.DrawingAgent.AddString("" + n);
    }

    void ClearScreen() {
    }

    void DrawPicture(char c) {
    }

    void TwoSecondDelay() {
    }

    void TopBegin() {
        this.TopDrawingAgent.SwitchToTopScreen();
    }

    void TopOutput(String string) {
        this.TopDrawingAgent.AddString(string);
    }

    void TopDone() {
        this.TopDrawingAgent.SwitchToBottomScreen();
        this.TopDrawingAgent.SetCurrent();
    }

    void SaveGame() {
    }

    char Param() {
        return this.Params[this.ParamPtr++];
    }

    void CarryLimit() {
        this.Output("I've too much to carry! ");
    }

    void GameOver() {
        this.Output("The game is now over.\n");
        this.Ended = true;
    }

    void Plonk(char c, char c2) {
        if (this.Objects[c] == this.Location || c2 == this.Location) {
            this.Redraw = true;
        }
        this.Objects[c] = c2;
    }

    boolean Dark() {
        boolean bl = this.Flags[15];
        if (this.Objects[9] == this.Location || this.Objects[9] == '\u00ff') {
            bl = false;
        }
        return bl;
    }

    void Inventory() {
        boolean bl = false;
        this.Output("I'm carrying:\n");
        for (int i = 0; i < 66; ++i) {
            if (this.Objects[i] != '\u00ff') continue;
            if (bl) {
                this.Output(" - ");
            }
            bl = true;
            this.Output(this.ObjectNames[i]);
        }
        if (!bl) {
            this.Output("Nothing");
        }
        this.Output(".\n");
    }

    void Look() {
        int n;
        boolean bl = false;
        this.TopBegin();
        if (this.Dark()) {
            this.TopOutput("I can't see. It is too dark!\n");
            this.TopDone();
            return;
        }
        if (this.Rooms[this.Location].charAt(0) == '*') {
            this.TopOutput(this.Rooms[this.Location].substring(1));
        } else {
            this.TopOutput("I'm in a ");
            this.TopOutput(this.Rooms[this.Location]);
        }
        this.TopOutput("\nObvious exits: ");
        for (n = 0; n < 6; ++n) {
            if (this.ExitMap[this.Location * 6 + n] == '\u0000') continue;
            if (bl) {
                this.TopOutput(",");
            }
            bl = true;
            this.TopOutput(ExitNames[n]);
        }
        if (!bl) {
            this.TopOutput("none");
        }
        this.TopOutput("\n");
        bl = false;
        for (n = 0; n < 66; ++n) {
            if (this.Objects[n] != this.Location) continue;
            if (!bl) {
                this.TopOutput("\nI can also see: ");
                bl = true;
            } else {
                this.TopOutput(" - ");
            }
            this.TopOutput(this.ObjectNames[n]);
        }
        this.TopDone();
    }

    void ExecuteAction(char c) {
        switch (c) {
            case '\u0000': {
                return;
            }
            case '4': {
                if (this.CountCarried() >= 9) {
                    this.CarryLimit();
                } else {
                    this.Plonk(this.Param(), '\u00ff');
                }
                return;
            }
            case '5': {
                this.Plonk(this.Param(), this.Location);
                return;
            }
            case '6': {
                this.Location = this.Param();
                this.Redraw = true;
                return;
            }
            case '7': {
                this.Plonk(this.Param(), '\u0000');
                return;
            }
            case '8': {
                this.Flags[15] = true;
                return;
            }
            case '9': {
                this.Flags[15] = false;
                return;
            }
            case ':': {
                this.Flags[this.Param()] = true;
                return;
            }
            case ';': {
                this.Plonk(this.Param(), '\u0000');
                return;
            }
            case '<': {
                this.Flags[this.Param()] = false;
                return;
            }
            case '=': {
                this.Output("I am dead.\n");
                this.Flags[15] = false;
                this.Location = (char)25;
                this.Look();
                return;
            }
            case '>': {
                char c2 = this.Param();
                this.Objects[c2] = this.Param();
                return;
            }
            case '?': {
                this.GameOver();
                return;
            }
            case '@': {
                this.Look();
                return;
            }
            case 'A': {
                int n = this.CountTreasure();
                this.Output("I've stored ");
                this.OutputNumber(n);
                this.Output(" treasures. On a scale of 0 to 100, that rates ");
                this.OutputNumber(n * 100 / 0);
                this.Output(".\n");
                if (n == 0) {
                    this.Output("Well done.\n");
                    this.GameOver();
                }
                return;
            }
            case 'B': {
                this.Inventory();
                return;
            }
            case 'C': {
                this.Flags[0] = true;
                return;
            }
            case 'D': {
                this.Flags[0] = false;
                return;
            }
            case 'E': {
                this.LightTime = 15000;
                this.Plonk('\t', '\u00ff');
                this.Flags[9] = false;
                return;
            }
            case 'F': {
                this.ClearScreen();
                return;
            }
            case 'G': {
                this.SaveGame();
                return;
            }
            case 'H': {
                char c3 = this.Param();
                char c4 = this.Param();
                char c5 = this.Objects[c3];
                this.Plonk(c3, this.Objects[c4]);
                this.Plonk(c4, c5);
                return;
            }
            case 'I': {
                this.Continuation = true;
                return;
            }
            case 'J': {
                this.Plonk(this.Param(), '\u00ff');
                return;
            }
            case 'K': {
                char c6 = this.Param();
                this.Plonk(c6, this.Objects[this.Param()]);
                return;
            }
            case 'L': {
                this.Look();
                return;
            }
            case 'M': {
                if (this.CurCounter > 0) {
                    --this.CurCounter;
                }
                return;
            }
            case 'N': {
                this.OutputNumber(this.CurCounter);
                return;
            }
            case 'O': {
                this.CurCounter = this.Param();
                return;
            }
            case 'P': {
                char c7 = this.Yoho[this.CurYoho];
                this.Yoho[this.CurYoho] = this.Location;
                this.Location = c7;
                return;
            }
            case 'Q': {
                char c8 = this.Param();
                int n = this.CurCounter;
                this.CurCounter = this.Counters[c8];
                this.Counters[c8] = n;
                return;
            }
            case 'R': {
                this.CurCounter += this.Param();
                return;
            }
            case 'S': {
                this.CurCounter -= this.Param();
                if (this.CurCounter < -1) {
                    this.CurCounter = -1;
                }
                return;
            }
            case 'T': {
                this.Output(this.NounString);
                return;
            }
            case 'U': {
                this.Output(this.NounString);
            }
            case 'V': {
                this.Output("\n");
                return;
            }
            case 'W': {
                char c9 = this.Param();
                char c10 = this.Location;
                this.Location = this.Yoho[c9];
                this.Yoho[c9] = c10;
                this.Redraw = true;
                return;
            }
            case 'X': {
                this.TwoSecondDelay();
                return;
            }
            case 'Y': {
                this.DrawPicture(this.Param());
                return;
            }
        }
        if (c < '3') {
            this.Output(this.Messages[c]);
        } else if (c > 'e') {
            this.Output(this.Messages[c - 50]);
        }
        this.Output(" ");
    }

    void ExecuteActionPair(char c) {
        this.ExecuteAction((char)(c / 150));
        if (!this.Ended) {
            this.ExecuteAction((char)(c % 150));
        }
    }

    boolean ExecuteLineCodes(int n) {
        this.ParamPtr = 0;
        for (int i = 0; i < 5; ++i) {
            if (!this.ExecuteCondition(this.GameCode[n])) {
                return false;
            }
            ++n;
        }
        this.ParamPtr = 0;
        this.ExecuteActionPair(this.GameCode[n]);
        if (!this.Ended) {
            this.ExecuteActionPair(this.GameCode[n + 1]);
        }
        return true;
    }

    boolean RandomChance(char c) {
        int n = this.Rng.nextInt() % 100;
        if (n < 0) {
            n = -n;
        }
        return n < c;
    }

    int ExecuteActions(char c, char c2) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        this.Continuation = false;
        for (int i = 0; i < 190; ++i) {
            char c3 = this.GameCode[n];
            char c4 = (char)(c3 % 150);
            c3 = (char)(c3 / 150);
            if (this.Continuation && (c3 != '\u0000' || c4 != '\u0000')) {
                this.Continuation = false;
                if (c != '\u0000') break;
            }
            if (!this.Continuation) {
                if (c != '\u0000' && bl2) break;
                if (c != c3) {
                    n += 8;
                    continue;
                }
                if (c3 == '\u0000') {
                    if (!this.RandomChance(c4)) {
                        n += 8;
                        continue;
                    }
                } else if (c4 != c2 && c4 != '\u0000') {
                    n += 8;
                    continue;
                }
            }
            bl = true;
            if (this.ExecuteLineCodes(n + 1)) {
                bl2 = true;
            }
            n += 8;
        }
        if (bl2) {
            return 0;
        }
        if (bl) {
            return 1;
        }
        return 2;
    }

    boolean GoHelper(char c) {
        char c2;
        boolean bl = this.Dark();
        if (c == '\u03e8') {
            this.Output("Give me a direction too.");
            return false;
        }
        if (c < '\u0001' || c > '\u0006') {
            return false;
        }
        if (bl) {
            this.Output("Dangerous to move in the dark! ");
        }
        if ((c2 = this.ExitMap[this.Location * 6 + c - 1]) != '\u0000') {
            this.Location = c2;
            this.Look();
            return true;
        }
        if (!bl) {
            this.Output("I can't go in that direction. ");
            return true;
        }
        this.Output("I fell down and broke my neck. ");
        this.Ended = true;
        return true;
    }

    char MatchVerb(String string) {
        int n = string.length();
        char c = '\u0000';
        if (n == 0) {
            return '\u03e8';
        }
        if (n > 3) {
            n = 3;
        }
        String string2 = string.substring(0, n);
        for (int i = 0; i < 90; ++i) {
            if (this.Verbs[i].length() > 1 && this.Verbs[i].charAt(0) == '*') {
                if (!this.StringEqual(string2, this.Verbs[i].substring(1))) continue;
                return c;
            }
            c = (char)i;
            if (!this.StringEqual(string2, this.Verbs[i])) continue;
            return c;
        }
        return '\u0000';
    }

    char MatchNoun(String string) {
        int n = string.length();
        char c = '\u0000';
        if (n == 0) {
            return '\u03e8';
        }
        if (n > 3) {
            n = 3;
        }
        String string2 = string.substring(0, n);
        for (int i = 0; i < 90; ++i) {
            if (this.Nouns[i].charAt(0) == '*') {
                if (!this.StringEqual(string2, this.Nouns[i].substring(1))) continue;
                return c;
            }
            c = (char)i;
            if (!this.StringEqual(string2, this.Nouns[i])) continue;
            return c;
        }
        return '\u0000';
    }

    char MatchQuick(String string) {
        for (int i = 0; i < 6; ++i) {
            if (!this.StringEqual(string, Quickies[i])) continue;
            return (char)i;
        }
        return '\u0000';
    }

    char MatchUpItem(char c, char c2) {
        for (char c3 = '\u0000'; c3 < 'B'; c3 = (char)((char)(c3 + 1))) {
            if (this.Objects[c3] != c2 || this.AutoGets[c3] != c) continue;
            return c3;
        }
        return '\u03e8';
    }

    void GetAllHelper() {
        boolean bl = false;
        for (int i = 0; i < 66; ++i) {
            if (this.Objects[i] != this.Location || this.AutoGets[i] == '\u03e8') continue;
            this.ExecuteActions('\n', this.AutoGets[i]);
            if (this.CountCarried() >= 9) {
                this.CarryLimit();
                bl = true;
                break;
            }
            this.Plonk((char)i, '\u00ff');
            this.Output(this.ObjectNames[i]);
            this.Output(": OK.\n");
            bl = true;
        }
        if (!bl) {
            this.Output("Nothing taken.\n");
        }
    }

    boolean GetHelper(char c) {
        if (this.StringEqual(this.NounString, "ALL")) {
            if (this.Dark()) {
                this.Output("It is dark.\n");
            } else {
                this.GetAllHelper();
            }
            return true;
        }
        if (c == '\u03e8') {
            this.Output("What ? ");
            return false;
        }
        if (this.CountCarried() >= 9) {
            this.CarryLimit();
            return false;
        }
        char c2 = this.MatchUpItem(c, this.Location);
        if (c2 == '\u03e8') {
            this.Output("It is beyond my power to do that. ");
            return false;
        }
        this.Plonk(c2, '\u00ff');
        this.Output("O.K. ");
        return true;
    }

    void DropAllHelper() {
        boolean bl = false;
        for (int i = 0; i < 66; ++i) {
            if (this.Objects[i] != '\u00ff' || this.AutoGets[i] == '\u03e8') continue;
            this.ExecuteActions('\u0012', this.AutoGets[i]);
            this.Plonk((char)i, this.Location);
            this.Output(this.ObjectNames[i]);
            this.Output(": OK.\n");
            bl = true;
        }
        if (!bl) {
            this.Output("Nothing dropped.\n");
        }
    }

    boolean DropHelper(char c) {
        if (this.StringEqual(this.NounString, "ALL")) {
            this.DropAllHelper();
            return true;
        }
        if (c == '\u03e8') {
            this.Output("What ? ");
            return false;
        }
        char c2 = this.MatchUpItem(c, this.Location);
        if (c2 == '\u03e8') {
            this.Output("It is beyond my power to do that. ");
            return false;
        }
        this.Plonk(c2, this.Location);
        this.Output("O.K. ");
        return true;
    }

    boolean RunCommandLine(char c, char c2) {
        if (c == '\u0001' && this.GoHelper(c2)) {
            return true;
        }
        int n = this.ExecuteActions(c, c2);
        if (n != 0) {
            if (c == '\n') {
                if (this.GetHelper(c2)) {
                    return true;
                }
            } else if (c == '\u0012') {
                if (this.DropHelper(c2)) {
                    return true;
                }
            } else {
                if (n == 2) {
                    this.Output("I don't understand your command. ");
                }
                if (n == 1) {
                    this.Output("I can't do that yet. ");
                }
            }
            return false;
        }
        return true;
    }

    void LampIterate() {
        if (this.Objects[9] == '\u0000') {
            return;
        }
        if (this.LightTime == -1) {
            return;
        }
        --this.LightTime;
        if (this.LightTime < 1) {
            this.Flags[16] = true;
            if (this.Objects[9] == '\u00ff' || this.Objects[9] == this.Location) {
                this.Output("My light has run out. ");
                if (this.Flags[15]) {
                    this.Redraw = true;
                }
            }
        } else if (this.LightTime < 25 && (this.Objects[9] == '\u00ff' || this.Objects[9] == this.Location) && this.LightTime % 5 == 0) {
            this.Output("My light is growing dim. ");
        }
    }

    public void FirstGameCycle() {
        this.ExecuteActions('\u0000', '\u0000');
        this.Look();
        this.Redraw = false;
    }

    public boolean ParseInput(String string) {
        int n;
        this.VerbCode = (char)1000;
        this.NounCode = (char)1000;
        if ((string = string.trim()).equals("")) {
            return false;
        }
        this.NounString = "";
        int n2 = string.indexOf(32);
        if (n2 == -1) {
            this.VerbString = string;
            n = 1;
        } else {
            this.VerbString = string.substring(0, n2);
            this.NounString = (n2 = (string = string.substring(n2 + 1).trim()).indexOf(32)) == -1 ? string : string.substring(n2 - 1);
            n = 2;
        }
        this.VerbCode = this.MatchVerb(this.VerbString);
        if (n > 1) {
            this.NounCode = this.MatchNoun(this.NounString);
        }
        if (n == 1 && this.VerbCode == '\u0000') {
            char c = this.MatchNoun(this.VerbString);
            if (c >= '\u0001' && c <= '\u0006') {
                this.VerbCode = '\u0001';
                this.NounCode = c;
                this.NounString = this.VerbString;
            }
            if ((c = this.MatchQuick(this.VerbString)) >= '\u0001' && c <= '\u0006') {
                this.VerbCode = '\u0001';
                this.NounCode = c;
                this.NounString = this.VerbString;
            }
        }
        if (this.VerbCode == '\u0000') {
            this.Output("You use word(s) I don't know! ");
            return false;
        }
        return true;
    }

    public boolean GameCycle(String string) {
        if (!this.ParseInput(string)) {
            return true;
        }
        this.RunCommandLine(this.VerbCode, this.NounCode);
        if (!this.Ended) {
            this.LampIterate();
            this.ExecuteActions('\u0000', '\u0000');
        }
        if (this.Redraw) {
            this.Look();
            this.Redraw = false;
        }
        return !this.Ended;
    }
}

