import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

public class ScottFree extends MIDlet implements CommandListener {
	AdventureGame myEngine;
	ScottCanvas myCanvas;
	ScottCanvas myTopCanvas;
	TextBox myTextBox;
	Form myStartUpForm;
	Display myDisplay;

	boolean isResume = false;

	boolean singleCanvas = true;

	private Command exitCommand = new Command("Exit", Command.EXIT, 99);
	private Command typeCommand = new Command("Type", Command.OK, 1);
	private Command goCommand = new Command("Go", Command.SCREEN, 1);
	private Command lookCommand = new Command("Look", Command.SCREEN, 1);
	private Command okCommand = new Command("OK", Command.OK, 1);
	private Command ok2Command = new Command("OK", Command.OK, 1);
	private Command ok3Command = new Command("Accept", Command.OK, 1);
	private Command cancelCommand = new Command("Cancel", Command.CANCEL, 1);

	public ScottFree() {
		myCanvas = new ScottCanvas(this);

		if(myCanvas.Characters() < 350)
			singleCanvas = false;
		if(myCanvas.Characters() >= 600 && myCanvas.Lines() > 8)
			myCanvas.SplitScreen();

		if(singleCanvas == true)
			myTopCanvas = myCanvas;
		else
			myTopCanvas = new ScottCanvas(this);

		myEngine = new AdventureGame(myCanvas, myTopCanvas);
		myCanvas.addCommand(exitCommand);
		myCanvas.addCommand(typeCommand);
		/* myCanvas.addCommand(goCommand); */
		myCanvas.setCommandListener(this);
	
		if(singleCanvas == false) {
			myTopCanvas.addCommand(ok2Command);
			myTopCanvas.setCommandListener(this);
		}
	}

	public void startApp() throws MIDletStateChangeException {

		myTextBox = new TextBox("Command", "", 32, TextField.ANY);
		myTextBox.addCommand(okCommand);
		/* Messes up Nokia's myTextBox.addCommand(cancelCommand); */
		myTextBox.setCommandListener(this);

		myDisplay = Display.getDisplay(this);
		
		if(isResume == false) {
			myStartUpForm = new Form("Welcome");
			myStartUpForm.addCommand(ok3Command);
			myStartUpForm.append(new StringItem(
				"ScottFree 1.18beta",
				"J2ME Edition" + 
				"(c) 2004 Alan Cox"));
			myStartUpForm.setCommandListener(this);
			myDisplay.setCurrent(myStartUpForm);
		}
	}

	public void destroyApp(boolean unconditional) throws MIDletStateChangeException {
		myEngine = null;
		myCanvas = null;
	}

	public void pauseApp() {
		myTextBox = null;
		isResume = true;
	}

	public void commandAction(Command c, Displayable s) {
		if(c == exitCommand) {
			try {
				destroyApp(false);
				notifyDestroyed();
			} catch (MIDletStateChangeException ex) {
			}
		}
		/*
		 *	User wants to input a command
		 */
		if(c == typeCommand) {
			myTextBox.setString("");
			myDisplay.setCurrent(myTextBox);
		}
		/*
		 *	User completes command input
		 */
		if(c == okCommand) {
			myCanvas.SetCurrent();
			PerformCommand(myTextBox.getString());
		}
		/*
		 *	User aborts command input
		 */
		if(c == cancelCommand) {
			Display.getDisplay(this).setCurrent(myCanvas);
		}
		/*
		 *	User moves from "Look" window to main window
		 */
		if(c == ok2Command) {
			myCanvas.SetCurrent();
		}
		/*
 		 *	Destroy start-up form
		 */
		if(c == ok3Command) {
			myCanvas.SetDisplay(myDisplay);
			myTopCanvas.SetDisplay(myDisplay);
			myEngine.FirstGameCycle();
			myCanvas.AddString("\n");
			myCanvas.Refresh();
			myStartUpForm = null;
		}		
	}
	public synchronized void PerformCommand(String s) {
		if(myEngine.GameCycle(s) == false)
			myCanvas.removeCommand(typeCommand);
		myCanvas.AddString("\n");
		myCanvas.Refresh();
	}		
}
