/*
$Header: c:/tads/tads2/RCS/OSDBG.H 1.2 94/11/06 13:07:18 mroberts Exp $
*/

/* Copyright (c) 1992 by Michael J. Roberts.  All Rights Reserved. */
/*
Name
  osdbg.h - interface definitions for os routines for debugger
Function
  interface definitions for os routines for debugger
Notes
  none
Modified
  04/21/92 MJRoberts     - creation
*/

#ifndef OSDBG_INCLUDED
#define OSDBG_INCLUDED

/* lifted from tads 1.2 os.h (may just include it in the future) */
# define CMD_UP    1        /* up arrow (recall last command) */
# define CMD_DOWN  2        /* down arrow (recall next command) */
# define CMD_RIGHT 3        /* right arrow (move cursor right) */
# define CMD_LEFT  4        /* left arrow (move cursor left) */
# define CMD_END   5        /* END key (move cursor to end of line) */
# define CMD_HOME  6        /* HOME key (move cursor to start of line) */
# define CMD_DEOL  7        /* DEL-EOL key (delete to end of line) */
# define CMD_KILL  8        /* KILL key (delete entire line) */
# define CMD_DEL   9        /* DEL key (delete current character) */
# define CMD_SCR   11       /* toggle scrollback mode */
# define CMD_PGUP  12       /* page up */
# define CMD_PGDN  13       /* page down */
# define CMD_TOP   14       /* top of file */
# define CMD_BOT   15       /* bottom of file */
# define CMD_F2    16
# define CMD_F3    17
# define CMD_F4    18
# define CMD_F5    19
# define CMD_F6    20
# define CMD_F7    21
# define CMD_F8    22
# define CMD_F9    23
# define CMD_F10   24
# define CMD_CHOME 25       /* control-home */
# define CMD_TAB   26
# define CMD_SF2   27       /* shifted F2 */

/* window definiton */
struct oswdef
{
    int   oswx;                                       /* current x location */
    int   oswy;                                       /* current y location */
    int   oswcolor;                                   /* current text color */
    int   oswx1; /* left edge of window (this column is included in window) */
    int   oswy1;                                      /* top line of window */
    int   oswx2;                                    /* right edge of window */
    int   oswy2;                                   /* bottom line of window */
    int   oswflg;                                       /* flags for window */
#   define OSWFCLIP  0x01                          /* don't wrap long lines */
#   define OSWFMORE  0x02                 /* use [more] mode in this window */
    int   oswmore;                     /* number of lines since last [more] */
};
typedef struct oswdef oswdef;

#endif /* OSDBG_INCLUDED */
