/*
 * x_frotz.h
 *
 * X interface, declarations
 *
 */
/*
 * Copyright (c) 1998-2000 Daniel Schepler
 * Permission is granted to distribute, copy, and modify this source and
 * resulting binaries under the turns of the Artistic License.  This
 * should have been included in the COPYING file along with this
 * distribution.
 *
 * xfrotz comes with NO WARRANTY.  See the Artistic License for more
 * information.
 */

#ifndef USE_QUETZAL
#define USE_QUETZAL
#endif
#ifndef STRICTZ
#define STRICTZ
#endif
#ifndef HAVE_CONFIG_H
#define HAVE_CONFIG_H
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <X11/Xlib.h>


#ifndef SAVEDIR_DEF
#define SAVEDIR_DEF		".if-saves"
#endif
#ifndef ZCODEPATH_DEF
#define ZCODEPATH_DEF		"/usr/share/games/zcode:/usr/local/share/games/zcode:/usr/share/games/infocom:/usr/local/share/games/infocom"
#endif
#define PATHSEP		':'	/* for pathopen()	*/
#define DIRSEP		'/'	/* for pathopen()	*/
#define	PATH1		"ZCODE_PATH"
#define PATH2		"INFOCOM_PATH"

#define USAGE "frotz 2.43_vw1 (X11 \"xfrotz\" interface)\
\nan interpreter for Infocom and other ZCode/ZMachine engine text adventures\
\nfully compliant with Graham Nelsons ZCode Specification 1.0\
\nxfrotz 2.32 is copyright (c) 1998-2000 Daniel Schepler\
\nre-inclusion into Unix Frotz 2.43 and improvements 2007 by Valerie Winter\
\n\nusage: xfrotz [options] <storyfile>\
\n\noptions:\
\n   -c #\t\tkeep # context lines on screen\
\n   -lm #\tset left text margin to # chars\
\n   -rm #\tset right text margin to # chars\
\n   -sc #\ttansscript with # columns\
\n   -|+x\t\texpand abbreviations (x,z,l,q,...)\
\n   -u #\t\tuse # undo slots\
\n   -sz\t\tstrict ZCode\
\n   -|+e\t\tignore ZMachine errors\
\n   -|+p\t\tignore piracy bit\
\n   -|+p\t\tignore tandy bit\
\n   -|+aa\twatch attribute assignment\
\n   -|+at\twatch attribute testing\
\n   -|+ol\twatch object location\
\n   -|+om\twatch object movement\
\n   -fn\t\tgeneral font (X11 font metric)\
\n   -fn-b\tbold font (X11 font metric)\
\n   -fn-i\titalic font (X11 font metric)\
\n   -fn-bi\tbold italic font (X11 font metric)\
\n   -fn-f\tfixed font (X11 font metric)\
\n   -fn-fb\tfixed bold font (X11 font metric)\
\n   -fn-fi\tfixed bold italic font (X11 font metric)\
\n   -fn-z\tspecial character set (X11 font metric)\
\n   -geometry\tset X11 window geometry (x and y values in screen pixels)\
\n   -title\tset X11 window title\
\n\nNotes:\t-- For z6 games, window size is always 640x400 (scaled x2).\
\n\t-- X11 geometry screen offsets (the +X+Y part) are ignored.\
\n\t-- If set, ZCODE_PATH or INFOCOM_PATH will be searched for storyfiles.\
\n\t-- storyfile and gfx/sound/font files have to be in the same directory.\
\n\t-- Blorb packages are *not* supported.\n"


typedef struct unix_setup_struct {
	int disable_color;
	int force_color;
	int foreground_color;
	int background_color;
	int screen_width;
	int screen_height;
	int random_seed;
	int tandy_bit;
	int current_text_style;		/* also in ux_text.c and ux_screen.c */
        int curses_active;
        int plain_ascii;
	int current_color;		/* ux_text.c ux_screen.c */
	bool color_enabled;		/* ux_init.c ux_pic.c ux_text.c */

	int interpreter;		/* see frotz.h */
} u_setup_t;

/* X connection */
extern Display *dpy;

/* Window to draw into */
extern Window main_window;

extern char *x_class, *x_name;

/* The font resource for displaying text */
extern const XFontStruct *current_font_info;
extern GC current_gc, normal_gc, reversed_gc, bw_gc, cursor_gc;
extern char *font_names[9];

extern int curr_x, curr_y;

extern unsigned long bg_pixel, fg_pixel;
extern unsigned long def_bg_pixel, def_fg_pixel;

const XFontStruct * get_font(int font, int style);

void x_init_colour(char *bg_name, char *fg_name);

extern f_setup_t f_setup;
extern u_setup_t u_setup;

int option_attribute_assignment;
int option_attribute_testing;
int option_object_locating;
int option_object_movement;
int option_context_lines;
int option_left_margin;
int option_right_margin;
int option_ignore_errors;
int option_piracy;
int option_undo_slots;
int option_expand_abbreviations;
int option_script_cols;


