
#ifndef MAGNETIC_DEFS_H
#define MAGNETIC_DEFS_H

#include "machine-dependant.h"

/*----------------------------------------------------------------------
 definitions for the game identification routines 
*/

typedef const struct {
  const type16 undo_size;          /* storyfile header entry at offset 0x22 */
  const type16 undo_pc;            /* storyfile header entry at offset 0x26 */
  const char * const name;         /* game title */
  const char * const version;      /* game version */
  const char * const platform;     /* game platform */
} game_table_t;

typedef game_table_t *game_tableref_t;

/* 
  I have added all the current Amiga entries ---
  WHY DID THEY MISS AT ALL?  Magnetic Scrolls invented its engine
  originally on and for the Amiga!
     ---val
*/
static game_table_t GAME_TABLE[] = {
  {0x3a00, 0x3fb0, "The Pawn","v2.3","Amiga"},
  {0x5500, 0x6cac, "The Guild of Thieves","v1.0","Amiga"},
  {0x2800, 0x4336, "Corruption","v1.11","Amiga"},
  {0x3000, 0x3f72, "Fish!","v1.07","Amiga"},
  {0x3300, 0x488c, "Jinxter","v1.05","Amiga"},
  {0x1d00, 0x3940, "Myth","v1.0","Amiga"},

  {0x2100, 0x427e, "Corruption","v1.11","Amstrad CPC"},
  {0x2100, 0x43a0, "Corruption","v1.11","Archimedes"},
  {0x2100, 0x43a0, "Corruption","v1.11","MS-DOS"},
  {0x2100, 0x4336, "Corruption","v1.11","Commodore 64"},
  {0x2100, 0x4222, "Corruption","v1.11","Spectrum +3"},
  {0x2100, 0x4350, "Corruption","v1.12","Archimedes"},
  {0x2500, 0x6624, "Corruption (Magnetic Windows)","v1.12","MS-DOS"},

  {0x2300, 0x3fa0, "Fish!","v1.02","MS-DOS"},
  {0x2400, 0x4364, "Fish!","v1.03","Spectrum +3"},
  {0x2300, 0x3f72, "Fish!","v1.07","Commodore 64"},
  {0x2200, 0x3f9c, "Fish!","v1.08","Archimedes"},
  {0x2a00, 0x583a, "Fish! (Magnetic Windows)","v1.10","MS-DOS"},

  {0x5000, 0x6c30, "The Guild of Thieves","v1.0","Amstrad CPC"},
  {0x5000, 0x6cac, "The Guild of Thieves","v1.0","Commodore 64"},
  {0x5000, 0x6d5c, "The Guild of Thieves","v1.1","MS-DOS"},
  {0x3300, 0x698a, "The Guild of Thieves","v1.3","Archimedes"},
  {0x3200, 0x6772, "The Guild of Thieves","v1.3","Spectrum +3"},
  {0x3400, 0x6528, "The Guild of Thieves (Magnetic Windows)","v1.3","MS-DOS"},

  {0x2b00, 0x488c, "Jinxter","v1.05","Commodore 64"},
  {0x2c00, 0x4a08, "Jinxter","v1.05","MS-DOS"},
  {0x2c00, 0x487a, "Jinxter","v1.05","Spectrum +3"},
  {0x2c00, 0x4a56, "Jinxter","v1.10","MS-DOS"},
  {0x2b00, 0x4924, "Jinxter","v1.22","Amstrad CPC"},
  {0x2c00, 0x4960, "Jinxter","v1.30","Archimedes"},

  {0x1600, 0x3940, "Myth","v1.0","Commodore 64"},
  {0x1500, 0x3a0a, "Myth","v1.0","MS-DOS"},

  {0x3600, 0x42cc, "The Pawn","v2.3","Amstrad CPC"},
  {0x3600, 0x4420, "The Pawn","v2.3","Archimedes"},
  {0x3600, 0x3fb0, "The Pawn","v2.3","Commodore 64"},
  {0x3600, 0x4420, "The Pawn","v2.3","MS-DOS"},
  {0x3900, 0x42e4, "The Pawn","v2.3","Spectrum 128"},
  {0x3900, 0x42f4, "The Pawn","v2.4","Spectrum +3"},

  {0x3900, 0x75f2, "Wonderland (Magnetic Windows)","v1.21","MS-DOS"},
  {0x3900, 0x75f8, "Wonderland","v1.27","Archimedes"}
};


/****************************************************************************\
* Magnetic animated pictures support
*
* Note: Some of the pictures for Wonderland and the Collection Volume 1 games
* are animations. To detect these, pass a pointer to a type8 as the is_anim
* argument to ms_extract().
*
* There are two types of animated images, however almost all images are type1.
* A type1 image consists of four main elements:
* 1) A static picture which is loaded straight at the beginning 
* 2) A set of frames with a mask. These frames are just "small pictures", which
*    are coded like the normal static pictures. The image mask determines
*    how the frame is removed after it has been displayed. A mask is exactly
*    1/8 the size of the image and holds 1 bit per pixel, saying "remove pixel"
*    or leave pixel set when frame gets removed. It might be a good idea to check
*    your system documentation for masking operations as your system might be
*    able to use this mask data directly.
* 3) Positioning tables. These hold animation sequences consisting of commands
*    like "Draw frame 12 at (123,456)"
* 4) A playback script, which determines how to use the positioning tables.
*    These scripts are handled inside Magnetic, so no need to worry about.
*    However, details can be found in the ms_animate() function.
*
* A type2 image is like a type1 image, but it does not have a static
* picture, nor does it have frame masking. It just consists of frames.
*
* How to support animations?
* After getting is_anim == 1 you should call ms_animate() immediately, and at
* regular intervals until ms_animate() returns 0. An appropriate interval
* between calls is about 100 milliseconds.
* Each call to ms_animate() will fill in the arguments with the address
* and size of an array of ms_position structures (see below), each of
* which holds an an animation frame number and x and y co-ordinates. To
* display the animation, decode all the animation frames (discussed below)
* from a single call to ms_animate() and display each one over the main picture.
* If your port does not support animations, define NO_ANIMATION.
\****************************************************************************/

struct ms_position
{
  type16s x, y;
  type16s number;
};


/****************************************************************************\
* Magnetic Windows hint support
* 
* The windowed Magnetic Scolls games included online hints. To add support 
* for the hints to your magnetic port, you should implement the ms_showhints
* function. It retrieves a pointer to an array of ms_hint structs
* The root element is always hints[0]. The elcount determines the number
* of items in this topic. You probably want to display those in some kind
* of list interface. The content pointer points to the actual description of
* the items, separated by '\0' terminators. The nodetype is 1 if the items are
* "folders" and 2 if the items are hints. Hints should be displayed one after
* another. For "folder" items, the links array holds the index of the hint in
* the array which is to be displayed on selection. One hint block has exactly
* one type. The parent element determines the "back" target.
\****************************************************************************/
#define MAX_HITEMS 25

struct ms_hint
{
  type16  elcount;
  type16  nodetype;
  type8 * content;
  type16  links[MAX_HITEMS];
  type16  parent;
};

struct picture
{
  type8 * data;
  type32 data_size;
  type16 width;
  type16 height;
  type16 wbytes;
  type16 plane_step;
  type8 * mask;
};

#ifndef NO_ANIMATION

struct lookup
{
  type16s flag;
  type16s count;
};

#define MAX_POSITIONS 20
#define MAX_ANIMS 200
#define MAX_FRAMES 20
#define MAX_STRING_SIZE  0xFF00
#define MAX_PICTURE_SIZE 0xC800

#endif

/* Hint support */
#define MAX_HINTS 260
#define MAX_HCONTENTS 30000


/* prototypes */
type32 read_reg(type32, type32);
void write_reg(type32, type32, type32);

#include "prototypes.h"

#endif /* MAGNETIC_DEFS_H */
