/*
  term_curses.c --- a ncurses frontend to magnetic

  underlays arbitrary functions in term_common.c with actual routines.

  part of magnetic-2.2_vw1.
 ---val
*/



/*"#include <curses.h>" is done in defines_curses.h */
#include "defines_curses.h"


extern int screenwidth, screenheight;
extern char newstatus;
extern char reverse;
extern unsigned char log_on;
extern FILE *commandfile, *transscript; /* was log1 and log2 */

/* (n)curses related */
WINDOW *statuswin, *textwin;
int textwinheight;


/* set_term_attributes()

   set the terminal's ncurses attributes according to current mode
      ---val
*/
int set_term_attributes(void)
{
  if(reverse && newstatus)
    {
      wattrset(statuswin,A_NORMAL);
      wbkgd(statuswin,' ' | A_NORMAL);
      wattrset(textwin,A_REVERSE);
      wbkgd(textwin,' ' | A_REVERSE);
    }
  else if(newstatus)
    {
      wattrset(statuswin,A_REVERSE);
      wbkgd(statuswin,' ' | A_REVERSE);
      wattrset(textwin,A_NORMAL);
      wbkgd(textwin,' ' | A_NORMAL);
    }
  else if(reverse)
    {
      if(has_colors())
	wbkgd(statuswin,' ' | COLOR_PAIR(2) | A_BOLD);
      else
	wbkgd(statuswin,' ' | A_REVERSE | A_BOLD);
      wattrset(textwin,A_REVERSE);
      wbkgd(textwin,' ' | A_REVERSE);
    }
  else
    {
      if(has_colors())
	wbkgd(statuswin,' ' | COLOR_PAIR(2) | A_BOLD);
      else
	wbkgd(statuswin,' ' | A_NORMAL | A_BOLD);
      wattrset(textwin,A_NORMAL);
      wbkgd(textwin,' ' | A_NORMAL);
    }


  wrefresh(textwin);
  wrefresh(statuswin);
}



/* init_terminal()

   start a new curses screen and create the two output windows we will
   use.
      ---val
*/
int init_terminal(void)
{
  int x;

  initscr();
  start_color();
  use_default_colors();
  cbreak();
  echo();
  intrflush(stdscr, FALSE);
  keypad(textwin, TRUE);
  newwin(0,0,0,0);
  screenwidth=COLS;
  screenheight=LINES;

  if(has_colors())
    {
      init_pair(1,-1,-1);
      init_pair(2,COLOR_WHITE,COLOR_BLACK);
      init_pair(3,COLOR_BLACK,COLOR_WHITE);
    }

  statuswin=subwin(stdscr,1,screenwidth,0,0);
  textwin=subwin(stdscr,screenheight-1,screenwidth,1,0);
  scrollok(textwin, TRUE);

  set_term_attributes();

}


void reset_terminal(void)
{
  endwin();
}


/* interface dependant "macro" functions */

int print_char(WINDOW* context, char c)
{
  waddch(context,c);
}


char get_char(WINDOW* context)
{
  return wgetch(context);
}


int printf_string(WINDOW* context, char* formatstring, char* string)
{
    wprintw(context, formatstring, string);
}


int print_string(WINDOW* context, char* string)
{
    wprintw(context, string);
}

int refresh_window(WINDOW *context)
{
  wrefresh(context);
}


int toggle_cbreak(char mode)
{
  if(mode==TRUE)
    cbreak();
  else
    nocbreak();
}

