
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "terminal.h"

int screenwidth=80;
int screenheight=24;
char moreprompts=TRUE;
char newstatus=TRUE;
char pictures=TRUE;
char quickquit=FALSE;
char picinfo[14];
const char program_name[]=PROGID;
char program_info[256];
static char statusline[79]=" \0";
extern char version; /* from emu.c, for the status line method */
unsigned char buffer[80], xpos = 0, ypos, bufpos = 0;
unsigned char log_on = 0, ms_gfx_enabled, filename[256];
unsigned char logname[128], scriptname[128], record_ts=FALSE;
FILE *log1 = 0, *log2 = 0;

extern void ms_showpic(unsigned int picnum,unsigned char mode);

void putstring(char* string);
int more_prompt(void);

void transcript_write(unsigned char c)
{
  if (log2 && c == 0x08 && ftell(log2) > 0)
    fseek(log2,-1,SEEK_CUR);
  else if (log2 && fputc(c,log2) == EOF)
    {
      printf("[Problem with transcript file - closing]\n");
      fclose(log2);
      log2 = 0;
    }
}

void ms_flush(void)
{
  unsigned char j;

  if (!bufpos)
    {
      ypos=1;
      return;
    }

  if(xpos + bufpos > screenwidth)
    {
      putchar('\n');
      transcript_write('\n');
      xpos = 0;
      ypos++;
    }
  if(ypos>=screenheight-1)
    {
      more_prompt();
      ypos=1;
    }
  for (j = 0; j < bufpos; j++)
    {
      if (buffer[j] == 0x0a)
	{
	  xpos = 0;
	  ypos++;
	}
      if (buffer[j] == 0x08)
	xpos -= 2;
      putchar(buffer[j]);
      transcript_write(buffer[j]);
      xpos++;
    }
  bufpos = 0;
}

void ms_putchar(unsigned char c)
{
/*
  if (c == 0x08)
    {
      if (bufpos > 0)
      bufpos--;
      return;
    }
*/
  buffer[bufpos++] = c;
  if ((c == 0x20) || (c == 0x0a) || (bufpos >= 80))
      ms_flush();
}

void putstring(char* string)
{
  int i;

  for(i=0;i<strlen(string);i++)
    ms_putchar(string[i]);
}

int more_prompt(void)
{
  if(moreprompts)
    {
      printf("[More]");
      getchar();
      ypos=0;
    }
}

unsigned char ms_load_file(signed char *name, unsigned char *ptr, unsigned short size)
{
  FILE *fh;
  signed char *realname;

  if (name)
    realname = name;
  else
    {
      do
	{
	  printf("Filename: ");
	}
      while (!gets(filename));
      realname = filename;
    }
  if (!(fh=fopen(realname,"rb")))
    return 1;
  if (fread(ptr,1,size,fh) != size)
    return 1;
  fclose(fh);
  return 0;
}

unsigned char ms_save_file(signed char *name, unsigned char *ptr, unsigned short size)
{
  FILE *fh;
  signed char *realname;
  
  if (name)
    realname = name;
  else
    {
      do
	{
	  printf("Filename: ");
	}
      while (!gets(filename));
      realname = filename;
    }
  if (!(fh = fopen(realname,"wb")))
    return 1;
  if (fwrite(ptr,1,size,fh) != size)
    return 1;
  fclose(fh);
  return 0;
}

void script_write(unsigned char c)
{
  if (log_on == 2 && fputc(c,log1) == EOF)
    {
      printf("[Problem with script file - closing]\n");
      fclose(log1);
      log_on = 0;
    }
}

/* print_statusline()
   A "printer" that puts out a neat statusline, including info about
   which picture is currently displayed.
   Because of the somewhat silly trigger organization within the storyfiles,
   the picture number is always output one action later.
     ---val
 */
void print_statusline(void)
{
  int x,z=30; /* statusline[30] is the best point for additional info */

  /* insert the picture number information between location and score */
  /* works out stupidly on dumb terminals, hence commented in --- val */

  for(x=0;x<strlen(picinfo);x++)
    if(picinfo[x]!='\n' && picinfo[x]!='\0') 
      statusline[z++]=picinfo[x];
  for(x=1;x<5;x++)
  statusline[z++]=' ';

  /* now print to screen and pad to screenwidth */
  printf("\n%s\n\n",statusline);
  ypos+=3;
}


/*
  void ms_statuschar(c)
  A routine that puts characters from the output stream into a neat status line and
  calls print_status() to do the actual output with additional info.
  Magnetic Scrolls's status line (included in the storyfiles) is a bit weird:

  25bytes location + 0x09 ("jump-right") + 6bytes padded score + "/" + moves

  Hence, we must hack a little to turn this into a status line that
  corresponds to the IF standard.
     ---val
 */
void ms_statuschar(unsigned char c)
{
  static char statscore[]="Score: ";
  static char statmoves[]="     Moves: ";
  static int oldoffset=11, newoffset=27, length=1, x, tabdel=0;

  /* replace Score: and Moves: with S: and M: on small screens */
  if(screenwidth<70)
    {
      strcpy(statscore,"S: ");
      strcpy(statmoves,"     M: ");
      newoffset=18;
    }
  /* use Magnetic Scrolls's status on tiny screens */
  if(screenwidth<50)
    newstatus=FALSE;

  if(c == '\n')       /* newline terminates status line in storyfile's code, so
			 let's put it out */
    {

      statusline[79]='\0';

      /* un-do the engine's up-casing of the location string (core_engine.c) */
      if(newstatus)
	for(x=0; x<=strlen(statusline); x++)
	  if((statusline[x] >= 'A') && (statusline[x] <= 'Z') && (statusline[x-1]!=' '))
	    statusline[x]=tolower(statusline[x]);

      print_statusline();

      tabdel=0;
      length=1;

      for(x=0; x<=sizeof(statusline); x++)
	statusline[x]=' ';
    }
  else
    {
      if(c == 0x09) /* move-to-right-side byte */
	{
	  /* pad status line with blanks */
	  if(newstatus)
	    {
	      while (length + newoffset < screenwidth-1)
		statusline[length++] = ' ';
	      /* tell us the first number is the score */
	      for(x=0;x<strlen(statscore);x++)
		statusline[length++] = statscore[x];
	      /* set a flag to remove the padding in the score field */
	      tabdel=1;
	    }
	  else
	    while (length + oldoffset < screenwidth-1)
	      statusline[length++] = ' ';
	}
      else if((newstatus) && (c == '/'))
	{
	  /* replace "/" with "Moves:" */
	  for(x=0;x<strlen(statmoves);x++)
	    statusline[length++] = statmoves[x];
	}
      else if((newstatus) && (c == ':'))
	{
	  /* "Corruption" displays a time instead of Score/Moves,
	   so we just erase the "Score: " string we made earlier */
	  for(x=0;x<strlen(statscore);x++)
	    statusline[length-strlen(statscore)-2+x]=' ';
	  statusline[length++] = c;
	}
      else
	if(newstatus)
	  {
	    /* if tabdel is set, we're in the right half,
	       and the score field's spaces aren't welcome here */
	    if((tabdel==0) || (tabdel==1 && c != ' '))
	      statusline[length++] = c;
	  }
	else
	  statusline[length++] = c;
    }
}


unsigned char ms_getchar(unsigned char trans)
{
  static unsigned char buf[256];
  static unsigned short pos=0;
  int c;
  unsigned char i,key;
  
  if (!pos)
    {
      /* Read new line? */
      i = 0;
      ypos=1;
      while (1)
	{
	  if (log_on == 1)
	    {
	      /* Reading from logfile */
	      if ((c = fgetc(log1)) == EOF)
		{
		  /* End of log? - turn off */
		  log_on = 0;
		  fclose(log1);
		  c = getchar();
		}
	      else printf("%c",c); /* print the char as well */
	    }
	  else
	    {
	      c = getchar();
	      if(c == '\\' && !i && trans) /* Interpreter command? */
		{
		  while((c = getchar()) != '\n' && c != EOF && i < 255)
		    buf[i++] = c;
		  buf[i] = 0;
		  c = '\n'; /* => Prints new prompt */
		  i = 0;
		  if(!strcmp(buf,"script"))
		    {
		    if(log_on == 2)
		      printf("[we're already recording a script]\n");
		    if(log_on == 0)
		      {
			log1=fopen(scriptname,"w");
			log_on=2;
		      }
		    }
		  else if(!strcmp(buf,"transscript"))
		    {
		      if(log_on == 2)
			printf("[we're already recording a transscript]\n");
		      if(log_on == 0)
			{
			  log2=fopen(logname,"w");
			}
		    }
		  else if(!strcmp(buf,"stopscript") && log_on == 2)
		    {
		      printf("[closing script file]\n");
		      log_on = 0;
		      fclose(log1);
		    }
		  else if(!strcmp(buf,"stoptrans"))
		    {
		      printf("[closing transscript file]\n");
		      fclose(log2);
		    }
		  else if(!strcmp(buf,"undo"))
		    c = 0;
		  else if(!strcmp(buf,"version"))
		    printf("%s\n",program_info);
		  else if(!strcmp(buf,"status"))
		    {
		      if(newstatus==TRUE) 
			newstatus=FALSE;
		      else
			newstatus=TRUE;
		    }
		  else if(!strcmp(buf,"picnum"))
		    {
		      if(pictures==TRUE)
			pictures=FALSE;
		      else
			pictures=TRUE;
		      ms_showpic(0,0);
		    }
		  else if(!strcmp(buf,"q"))
		    {
		      printf("[quick-quit game --- sure (y/n)?] ");
		      quickquit=TRUE;
		    }
		  else if(!strcmp(buf,"help"))
		    printf("%s\n",INTERNAL_CMDS);
		  else
		    printf("[unknown command, try \\help]\n");
		}
	    }
	  script_write((unsigned char)c);
	  if (c != '\n')
	    transcript_write((unsigned char)c);
	  if (c == '\n' || c == EOF || i == 255)
	    break;
	  buf[i++] = c;
	  if (!c)
	    break;
	}
      buf[i] = '\n';
    }
  if ((c = buf[pos++]) == '\n' || !c || quickquit)
    pos = 0;
  if(quickquit)
    {
      key=getchar();
      if(key=='y' || key=='Y')
	{
	  ms_stop();
	}
      quickquit=FALSE;
    }
  return (unsigned char)c;
}


void ms_fatal(signed char *txt)
{
  fputs("\nFatal error: ",stderr);
  fputs(txt,stderr);
  fputs("\n",stderr);
  ms_status();
  exit(1);
}

unsigned char ms_showhints(struct ms_hint * hints)
{
  return 0;
}

main(int argc, char *argv[])
{
  int running, i;
  char *gamename="\0";
  char gfxname[256]="\0", hintname[256]="\0";
  char fqgamename[256]="\0";
  FILE *ftest;
  int dlimit, slimit;

  sprintf(program_info,"%s %s\n%s,\n%s",PROGID,PROGSUBID,COPYRIGHT,PROGPORT);

  if (sizeof(unsigned char) != 1 || sizeof(unsigned short) != 2 || sizeof(unsigned long) != 4)
    {
      fprintf(stderr,
	      "You have incorrect typesizes, please edit the typedefs and recompile\n"
	      "or proceed on your own risk...\n");
      exit(1);
    }
  dlimit = slimit = 0xffffffff;
  for (i = 1; i < argc; i++)
    {
      if (argv[i][0] == '-')
	{
	  switch (tolower(argv[i][1]))
	    {
	    case 'l':
	      if (strlen(argv[i])>2)
		screenheight = atoi(&argv[i][2]);
	      ypos=1;
	      break;
	    case 'c':
	      if (strlen(argv[i])>2)
		screenwidth = atoi(&argv[i][2]);
	      break;
	    case 'n':
	      switch(tolower(argv[i][2]))
	        {
		case 's':
		  newstatus=FALSE;
		  break;
		case 'p':
		  moreprompts=FALSE;
		  break;
		}
	      break;
	    case 'd':
	      if (strlen(argv[i]) > 2)
		dlimit = atoi(&argv[i][2]);
	      else
		dlimit = 0;
	      break;
	    case 's':
	      if (strlen(argv[i])>2)
		slimit = atoi(&argv[i][2]);
	      else
		slimit = 655360;
	      break;
	    case 't':
	      if (!(log2 = fopen(&argv[i][2],"w")))
		printf("Failed to open \"%s\" for writing.\n",&argv[i][2]);
	      break; 
	    case 'r':
	      if (log1 = fopen(&argv[i][2],"r"))
		log_on = 1;
	      else
		printf("Failed to open \"%s\" for reading.\n",&argv[i][2]);
	      break;
	    case 'w':
	      if (log1 = fopen(&argv[i][2],"w"))
		log_on = 2;
	      else
		printf("Failed to open \"%s\" for writing.\n",&argv[i][2]);
	      break;
	    default:
	      printf("Unknown option -%c, ignoring.\n",argv[i][1]);
	      break;
	    }
	}
      else if (gamename=="\0")
	gamename = argv[i];

    }

  if (gamename=="\0")
    {
      fprintf(stderr,"%s\n%s",program_info,USAGE);
      exit(1);
    }
  
  /* test if the storyfile exists in absolute path, ./ or STORYDIR */

  /* does given file exist with this fqfn or (path)name? */
  ftest=fopen(gamename,"r");
  if(ftest)
    {
      fclose(ftest);
      strcpy(fqgamename,gamename);
    }
  /* if not fqfn, try to find it in STORYDIR */
  if(gamename[0]!='/')
    {
      strcpy(fqgamename,STORYDIR);
      strcat(fqgamename,gamename);
    }
  ftest=fopen(fqgamename,"r");
  if(!ftest)
    {
      fprintf(stderr,"There's no \"%s\".\n",gamename);
      exit(1);
    }
  fclose(ftest);

  /* assume graphics and hints file end with .gfx and .hnt, respectively */
  strcpy(gfxname,fqgamename);
  strcpy(hintname,fqgamename);
  strcpy(strpbrk(gfxname,"."),".gfx");
  strcpy(strpbrk(hintname,"."),".hnt");

  strcpy(logname,basename(gamename));
  strcpy(scriptname,basename(gamename));
  strcpy(strpbrk(logname,"."),".transscript");
  strcpy(strpbrk(scriptname,"."),".script");

  ms_gfx_enabled = ms_init(fqgamename,gfxname,hintname);

  ms_gfx_enabled--;
  running = 1;
  while ((ms_count() < slimit) && running)
    {
      if (ms_count() >= dlimit)
	ms_status();
      running = ms_rungame();
    }
  if (ms_count() == slimit)
    {
      printf("\n\nSafety limit (%d) reached.\n",slimit);
      ms_status();
    }
  ms_freemem();
  if (log_on)
    fclose(log1);
  if (log2)
    fclose(log2);
  printf("\nExiting.\n");
  return 0;
}
