
/* advfio.c - file i/o routines for the adventure compiler */
/*
	Copyright (c) 1986, by David Michael Betz
	All rights reserved
*/
#pragma lint -1

#include "compiler.h" /* TUU */
#include <fcntl.h>  /* TUU */
#include <string.h> /* TUU */
#include <stdio.h>  /* TUU */

#pragma noroot

#if STACKDEBUG
#pragma debug 24
#endif

#if OPTIMIZE
#pragma optimize 9
#endif

#define BSIZE	8192

/* global variables */
long ad_foff;


/* local variables */
static char buf[BSIZE];
static int boff;
static FILE *fd; /* TUU */

void ad_create(char *name)
{
    /* create the file */
    if ((fd = fopen(name,"w")) == 0) /* was fopen(...)<0 -- TUU */
	fail("can't create output file");

    /* initialize the buffer and file offset */
    ad_foff = 0L;
    boff = 0;
}

void ad_close(void)
{
    ad_flush();
    fclose(fd);
}

void ad_putc(int ch)
{
    buf[boff++] = (char)ch; ad_foff++;
    if (boff >= BSIZE)
	ad_flush();
}

void ad_seek(long pos)
{
    ad_flush();
    if (((long) fseek(fd,pos,0) != pos)) /*was TUU--if (lseek(fd,pos,0)!=pos)*/
	fail("error positioning output file");
    ad_foff = pos;
}

void ad_flush(void)
{
    if (boff) {
	if (fwrite(buf,1,boff,fd)!=boff) /*TUUwasif(fwrite(fd,buf,boff)!=boff)*/
	    fail("error writing to output file");
	boff = 0;
    }
}
