
/* advint.h - adventure interpreter definitions */
/*
	Copyright (c) 1986, by David Michael Betz
	All rights reserved
*/

/* Text Adventures in Lisp 1.3 (Adventure System 1.2 improved)*/
#ifndef IDSTRING
#define IDSTRING "TAiL 1.3 (Adventure System 1.2)"
#endif

#ifndef MSG_VERSION
#define MSG_VERSION "Text Adventures in Lisp (TAiL) 1.3 interpreter\n\
ADVINT v1.2 (c) 1986 by David Betz / ANSI-C version by Matt Ackeret\n\
Patched/enhanced release TAiL 1.3 by Valerie Winter\n"
#endif

#ifndef MSG_USAGE
#ifdef CURSES
#define MSG_USAGE "\nusage: advsys-interpreter [options] <storyfile>\n\n\
options:\n\
   -r            reverse video\n\
   -t<log-file>  save transscript in <logfile>\n"
#endif
#ifdef DUMB
#define MSG_USAGE "\nusage: advsys-interpreter [options] <storyfile>\n\n\
options:\n\
   -l<lines>     screen is <lines> high\n\
   -c<columns>   screen is <columns> wide\n\
   -t<log-file>  save transscript in <logfile>\n\
   -d            disable [more] prompts\n"
#endif
#endif

#ifndef __stdio__
#include <stdio.h>
#endif
#include <ctype.h>

/* useful definitions */
#define TRUE		(int)1
#define FALSE		(int)0
#define EOS		'\0'

/* program limits */
#define STKSIZE		(int)500

/* code completion codes */
#define FINISH		(int)1
#define CHAIN		(int)2
#define ABORT		(int)3


/* allint.h -- TUU -- saves my sanity and prototyped header*/

/* #include <stdio.h> */ /* for FILE */

#pragma lint -1   /* TUU */
/* #define int long */  /* was int -- works as int! */
#define UNIX      /* TUU */

/* from advmsg.c */
void msg_init(FILE *fd,int base);
void msg_open(unsigned int msg);
int msg_byte(void);
int decode(int ch);
void get_block(unsigned int blk);

/* from advtrm.c */
void trm_init(int rows,int cols,char *name);
void trm_done(void);
char *trm_get(char *line);
void trm_str(char *str);
void trm_xstr(char *str);
void trm_chr(int ch);
void trm_word(void);
void trm_eol(void);
void trm_wait(void);
char *trm_line(char *line);
int getchr(void);  /* was myint getchr */
void putchr(int ch); /* was myInt ch */
void trm_shutdown(char *textport);  /* ONLY used when CONSOLE is defined */


/* from advprs.c */
int parse(void);
int next(void);
int fill_action_array(void);
int parse1(void);
int getverb(void);
int getnoun(void);
int get_line(void);
int skip_spaces(void);
void show_noun(int n);
int get_word(void);
int spacep(int ch);
void parse_error(void);

/* from advdbs.c */
void db_init(char *name);
int db_save(void); /* took out char *name TUU */
int db_restore(void); /* took out char *name TUU */
int db_restart(void);
void complement(char *adr,int len);
int findword(char *word);
int wtype(int wrd);
int match(int obj,int noun,int *adjs);
int checkverb(int *verbs);
int findaction(int *verbs,int preposition,int flag);
int getp(int obj,int prop);
int setp(int obj,int prop,int val);
int findprop(int obj,int prop);
int hasnoun(int obj,int noun);
int hasadjective(int obj,int adjective);
int hasverb(int act,int *verbs);
int haspreposition(int act,int preposition);
int inlist(int link,int word);
int getofield(int obj,int off);
int putofield(int obj,int off,int val);
int getafield(int act,int off);
int getabyte(int act,int off);
int getoloc(int n);
int getaloc(int n);
int getvalue(int n);
int setvalue(int n,int v);
int getwloc(int n);
int getword(int n);
int putword(int n,int w);
int getbyte(int n);
int getcbyte(int n);
int getcword(int n);
int getdword(char *p);
int putdword(char *p,int w);
void nerror(char *fmt,int n);

/* from advint.c */
void play(void);
void error(char *msg);
int single(void);

/* from advjunk.c */
#ifndef UNIX
int rand(void);
void srand(long n);
#endif
int getch(void);
void waitch(void);
void putch(int ch,FILE *fp);
int advsave(char *hdr,int hlen,char *save,int slen);
int advrestore(char *hdr,int hlen,char *save,int slen);

/* from advexe.c */
int execute(int code);
void exe_one(void);
int getboperand(void);
int getwoperand(void);
void print(int msg);
int vowel(int msg);
void pnumber(int n);
int getrand(int n);
void setrand(long n);

/* from advgfx.c */
void display_picture(void);
