/* NS32000 Assembler
 * List.c
 * Writes the listing.
 */
#include <stdio.h>
#ifdef MSDOS
#  include "a_out.h"
#else
#  include "a.out.h"
#endif
#include "glob.h"
#include "conv.h"

#define PREFIX 22
#define inline _inline			/* inline is ANSI keyword */

list()
{
  long textoff, dataoff;               /* text, data written so far */
  struct melt *meltp;
  lnptr l;
  char inline [LNLEN];

  myfseek (infp, 0L, 0);
  CM2L (header.a_text);
  textoff = 0;
  dataoff = header.a_text;
  lnnum = 0;
  for (l = ln_head; l != NULL; l = l->link) {
    for (meltp = l->map; meltp < l->map + l->len; ++meltp) {
      for (;;) {
        if (NULL == fgets (inline, LNLEN - 1, infp)) 
          error ("!#fgets failed in list");
        if (meltp->lnnum == ++lnnum) {
          writeln (inline,
            meltp->size & lDATA?  &dataoff: &textoff,
            meltp->size & lOFF);
          break;
        }
        else writeln (inline, NULL, 0L);
      }
    }
  }
  while (NULL != fgets (inline, LNLEN - 1, infp)) {
    ++lnnum;
    writeln (inline, NULL, 0L);
  }
  fputc ('\n', listfp);
  print_symtab();
}

/* Write a source line to the list file.  This will result in more than
 * one line in the list file if the line generates more than four bytes
 * of object.  Format: <line #> <adr> <object bytes> <source line>
 */
writeln (inline, offp, size)
char *inline;
long *offp;
long size;
{
  char outline [LNLEN + PREFIX], *cp;
  int lnbytes, i;

  if (offp != NULL) myfseek (outfp,    /* seek to object bytes */
    (long)(sizeof (struct exec) + *offp));
  for (;;) {                           /* write lines until all obj written */
    if (0 == (lnbytes = size) && inline == NULL) break;
    if (lnbytes > 4) lnbytes = 4;
    sprintf (outline, inline == NULL?
      "               \n":
      "                  %5d\t%s",
      lnnum, inline);
    inline = NULL;                     /* write source only once */
    if (lnbytes) {
      cp = outline;                    /* write address */
      byte2hex ((int)(*offp>>16), &cp);
      byte2hex ((int)(*offp>>8), &cp);
      byte2hex ((int)(*offp), &cp);
      ++cp;
      for (i = 0; i < lnbytes; ++i)    /* write object */
        byte2hex (mygetc (outfp), &cp);
      *offp += lnbytes;
    }
    fputs (outline, listfp);
    size -= lnbytes;
  }
}

/* Write a byte as two hex characters, advance character pointer.
 */
byte2hex (byte, cp)
int byte;
char **cp;
{
  *(*cp)++ = hexnib (byte>>4 & 0xf);
  *(*cp)++ = hexnib (byte & 0xf);
}

/* Convert a binary nibble to a hex character.
 */
int
hexnib (nib)
int nib;
{
  return *("0123456789ABCDEF" + nib);
}

print_lbl(p)
lblptr p;
{
  char *imp_exp,
       *seg,
       *res_str;

  res_str = p->typ & T_RESOLVED? "": "UNRESOLVED";
  imp_exp = p->typ & T_STATIC? "LOCAL ": "GLOBAL";
  switch (p->typ & T_LBL) {
    case T_UNDF:
      seg = "UNDF ";
      imp_exp = "      ";
      break;
    case T_TEXT:
      seg = "TEXT ";
      break;
    case T_DATA:
      seg = "DATA ";
      break;
    case T_BSS:
      seg = "BSS  ";
      break;
    case T_IMM:
      seg = "IMM  ";
      break;
  }
  fprintf (listfp, "%8lx %s %s %s %s\n",
    (p->typ & T_LBL) == T_UNDF? 0: p->val,
    seg, imp_exp,
    p->id == NULL? "*": p->id, res_str);
}

print_symtab()
{
  hashnav (T_LBL, print_lbl);
}
