/* Module mach_debug */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mig_errors.h>
#include <ipc/ipc_port.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msgh_request_port	msgh_remote_port
#define MACH_MSGH_BITS_REQUEST(bits)	MACH_MSGH_BITS_REMOTE(bits)
#define msgh_reply_port		msgh_local_port
#define MACH_MSGH_BITS_REPLY(bits)	MACH_MSGH_BITS_LOCAL(bits)

#include <mach/std_types.h>
#include <kern/ipc_kobject.h>
#include <kern/ipc_tt.h>
#include <kern/ipc_host.h>
#include <kern/task.h>
#include <kern/thread.h>
#include <kern/host.h>
#include <kern/processor.h>
#include <vm/vm_object.h>
#include <vm/vm_map.h>
#include <ipc/ipc_space.h>
#include <mach/mach_types.h>
#include <mach_debug/mach_debug_types.h>

/* Routine host_zone_info */
mig_internal novalue _Xhost_zone_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t namesCntType;
		mach_msg_type_number_t namesCnt;
		mach_msg_type_t infoCntType;
		mach_msg_type_number_t infoCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t namesType;
		zone_name_t names[25];
		mach_msg_type_long_t infoType;
		zone_info_t info[56];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t host_zone_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(host_t host, zone_name_array_t *names, mach_msg_type_number_t *namesCnt, zone_info_array_t *info, mach_msg_type_number_t *infoCnt);
#else
		();
#endif

	boolean_t msgh_simple;
	unsigned int msgh_size;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t namesCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t infoCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t namesType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	8,
		/* msgtl_size = */	8,
		/* msgtl_number = */	2000,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t infoType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	504,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t namesCnt;
	zone_info_t info[56];
	mach_msg_type_number_t infoCnt;

	zone_name_t *namesP;
	zone_info_t *infoP;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->namesCntType != * (int *) &namesCntCheck)
#else	UseStaticMsgType
	if ((In0P->namesCntType.msgt_inline != TRUE) ||
	    (In0P->namesCntType.msgt_longform != FALSE) ||
	    (In0P->namesCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->namesCntType.msgt_number != 1) ||
	    (In0P->namesCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->infoCntType != * (int *) &infoCntCheck)
#else	UseStaticMsgType
	if ((In0P->infoCntType.msgt_inline != TRUE) ||
	    (In0P->infoCntType.msgt_longform != FALSE) ||
	    (In0P->infoCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->infoCntType.msgt_number != 1) ||
	    (In0P->infoCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	namesP = OutP->names;
	namesCnt = 25;
	if (In0P->namesCnt < namesCnt)
		namesCnt = In0P->namesCnt;

	infoP = info;
	infoCnt = 56;
	if (In0P->infoCnt < infoCnt)
		infoCnt = In0P->infoCnt;

	OutP->RetCode = host_zone_info(convert_port_to_host((ipc_port_t) In0P->Head.msgh_request_port), &namesP, &namesCnt, &infoP, &infoCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->namesType = namesType;
#else	UseStaticMsgType
	OutP->namesType.msgtl_name = 8;
	OutP->namesType.msgtl_size = 8;
	OutP->namesType.msgtl_header.msgt_name = 0;
	OutP->namesType.msgtl_header.msgt_size = 0;
	OutP->namesType.msgtl_header.msgt_number = 0;
	OutP->namesType.msgtl_header.msgt_inline = TRUE;
	OutP->namesType.msgtl_header.msgt_longform = TRUE;
	OutP->namesType.msgtl_header.msgt_deallocate = FALSE;
	OutP->namesType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (namesP != OutP->names) {
		OutP->namesType.msgtl_header.msgt_inline = FALSE;
		OutP->namesType.msgtl_header.msgt_deallocate = TRUE;
		*((zone_name_t **)OutP->names) = namesP;
		msgh_simple = FALSE;
	}

	OutP->namesType.msgtl_number = 80 * namesCnt;
	msgh_size_delta = (OutP->namesType.msgtl_header.msgt_inline) ? 80 * namesCnt : sizeof(zone_name_t *);
	msgh_size = 56 + msgh_size_delta;
	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2000);

#if	UseStaticMsgType
	OutP->infoType = infoType;
#else	UseStaticMsgType
	OutP->infoType.msgtl_name = 2;
	OutP->infoType.msgtl_size = 32;
	OutP->infoType.msgtl_header.msgt_name = 0;
	OutP->infoType.msgtl_header.msgt_size = 0;
	OutP->infoType.msgtl_header.msgt_number = 0;
	OutP->infoType.msgtl_header.msgt_inline = TRUE;
	OutP->infoType.msgtl_header.msgt_longform = TRUE;
	OutP->infoType.msgtl_header.msgt_deallocate = FALSE;
	OutP->infoType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (infoP != info) {
		OutP->infoType.msgtl_header.msgt_inline = FALSE;
		OutP->infoType.msgtl_header.msgt_deallocate = TRUE;
		*((zone_info_t **)OutP->info) = infoP;
		msgh_simple = FALSE;
	}
	else {
		bcopy((char *) info, (char *) OutP->info, 36 * infoCnt);
	}

	OutP->infoType.msgtl_number = 9 * infoCnt;
	msgh_size += (OutP->infoType.msgtl_header.msgt_inline) ? 36 * infoCnt : sizeof(zone_info_t *);

	OutP = (Reply *) OutHeadP;
	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = msgh_size;
}

/* Routine mach_port_get_srights */
mig_internal novalue _Xmach_port_get_srights
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		mach_port_t name;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t srightsType;
		mach_port_rights_t srights;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t mach_port_get_srights
#if	(defined(__STDC__) || defined(c_plusplus))
		(ipc_space_t task, mach_port_t name, mach_port_rights_t *srights);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t nameCheck = {
		/* msgt_name = */		15,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t srightsType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	ipc_space_t task;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->nameType != * (int *) &nameCheck)
#else	UseStaticMsgType
	if ((In0P->nameType.msgt_inline != TRUE) ||
	    (In0P->nameType.msgt_longform != FALSE) ||
	    (In0P->nameType.msgt_name != 15) ||
	    (In0P->nameType.msgt_number != 1) ||
	    (In0P->nameType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	task = convert_port_to_space((ipc_port_t) In0P->Head.msgh_request_port);

	OutP->RetCode = mach_port_get_srights(task, In0P->name, &OutP->srights);
	space_deallocate(task);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->srightsType = srightsType;
#else	UseStaticMsgType
	OutP->srightsType.msgt_name = 2;
	OutP->srightsType.msgt_size = 32;
	OutP->srightsType.msgt_number = 1;
	OutP->srightsType.msgt_inline = TRUE;
	OutP->srightsType.msgt_longform = FALSE;
	OutP->srightsType.msgt_deallocate = FALSE;
	OutP->srightsType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine host_ipc_hash_info */
mig_internal novalue _Xhost_ipc_hash_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t infoCntType;
		mach_msg_type_number_t infoCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t infoType;
		hash_info_bucket_t info[512];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t host_ipc_hash_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(host_t host, hash_info_bucket_array_t *info, mach_msg_type_number_t *infoCnt);
#else
		();
#endif

	boolean_t msgh_simple;
#if	UseStaticMsgType
	static mach_msg_type_t infoCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t infoType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t infoCnt;

	hash_info_bucket_t *infoP;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->infoCntType != * (int *) &infoCntCheck)
#else	UseStaticMsgType
	if ((In0P->infoCntType.msgt_inline != TRUE) ||
	    (In0P->infoCntType.msgt_longform != FALSE) ||
	    (In0P->infoCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->infoCntType.msgt_number != 1) ||
	    (In0P->infoCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	infoP = OutP->info;
	infoCnt = 512;
	if (In0P->infoCnt < infoCnt)
		infoCnt = In0P->infoCnt;

	OutP->RetCode = host_ipc_hash_info(convert_port_to_host((ipc_port_t) In0P->Head.msgh_request_port), &infoP, &infoCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->infoType = infoType;
#else	UseStaticMsgType
	OutP->infoType.msgtl_name = 2;
	OutP->infoType.msgtl_size = 32;
	OutP->infoType.msgtl_header.msgt_name = 0;
	OutP->infoType.msgtl_header.msgt_size = 0;
	OutP->infoType.msgtl_header.msgt_number = 0;
	OutP->infoType.msgtl_header.msgt_inline = TRUE;
	OutP->infoType.msgtl_header.msgt_longform = TRUE;
	OutP->infoType.msgtl_header.msgt_deallocate = FALSE;
	OutP->infoType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (infoP != OutP->info) {
		OutP->infoType.msgtl_header.msgt_inline = FALSE;
		OutP->infoType.msgtl_header.msgt_deallocate = TRUE;
		*((hash_info_bucket_t **)OutP->info) = infoP;
		msgh_simple = FALSE;
	}

	OutP->infoType.msgtl_number = infoCnt;
	OutP->Head.msgh_size = 44 + ((OutP->infoType.msgtl_header.msgt_inline) ? 4 * infoCnt : sizeof(hash_info_bucket_t *));

	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
}

/* Routine host_ipc_marequest_info */
mig_internal novalue _Xhost_ipc_marequest_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t infoCntType;
		mach_msg_type_number_t infoCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t max_requestsType;
		unsigned max_requests;
		mach_msg_type_long_t infoType;
		hash_info_bucket_t info[512];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t host_ipc_marequest_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(host_t host, unsigned *max_requests, hash_info_bucket_array_t *info, mach_msg_type_number_t *infoCnt);
#else
		();
#endif

	boolean_t msgh_simple;
#if	UseStaticMsgType
	static mach_msg_type_t infoCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t max_requestsType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t infoType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t infoCnt;

	hash_info_bucket_t *infoP;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->infoCntType != * (int *) &infoCntCheck)
#else	UseStaticMsgType
	if ((In0P->infoCntType.msgt_inline != TRUE) ||
	    (In0P->infoCntType.msgt_longform != FALSE) ||
	    (In0P->infoCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->infoCntType.msgt_number != 1) ||
	    (In0P->infoCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	infoP = OutP->info;
	infoCnt = 512;
	if (In0P->infoCnt < infoCnt)
		infoCnt = In0P->infoCnt;

	OutP->RetCode = host_ipc_marequest_info(convert_port_to_host((ipc_port_t) In0P->Head.msgh_request_port), &OutP->max_requests, &infoP, &infoCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->max_requestsType = max_requestsType;
#else	UseStaticMsgType
	OutP->max_requestsType.msgt_name = 2;
	OutP->max_requestsType.msgt_size = 32;
	OutP->max_requestsType.msgt_number = 1;
	OutP->max_requestsType.msgt_inline = TRUE;
	OutP->max_requestsType.msgt_longform = FALSE;
	OutP->max_requestsType.msgt_deallocate = FALSE;
	OutP->max_requestsType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->infoType = infoType;
#else	UseStaticMsgType
	OutP->infoType.msgtl_name = 2;
	OutP->infoType.msgtl_size = 32;
	OutP->infoType.msgtl_header.msgt_name = 0;
	OutP->infoType.msgtl_header.msgt_size = 0;
	OutP->infoType.msgtl_header.msgt_number = 0;
	OutP->infoType.msgtl_header.msgt_inline = TRUE;
	OutP->infoType.msgtl_header.msgt_longform = TRUE;
	OutP->infoType.msgtl_header.msgt_deallocate = FALSE;
	OutP->infoType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (infoP != OutP->info) {
		OutP->infoType.msgtl_header.msgt_inline = FALSE;
		OutP->infoType.msgtl_header.msgt_deallocate = TRUE;
		*((hash_info_bucket_t **)OutP->info) = infoP;
		msgh_simple = FALSE;
	}

	OutP->infoType.msgtl_number = infoCnt;
	OutP->Head.msgh_size = 52 + ((OutP->infoType.msgtl_header.msgt_inline) ? 4 * infoCnt : sizeof(hash_info_bucket_t *));

	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
}

/* Routine mach_port_space_info */
mig_internal novalue _Xmach_port_space_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t table_infoCntType;
		mach_msg_type_number_t table_infoCnt;
		mach_msg_type_t tree_infoCntType;
		mach_msg_type_number_t tree_infoCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t infoType;
		ipc_info_space_t info;
		mach_msg_type_long_t table_infoType;
		ipc_info_name_t table_info[56];
		mach_msg_type_long_t tree_infoType;
		ipc_info_tree_name_t tree_info[46];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t mach_port_space_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(ipc_space_t task, ipc_info_space_t *info, ipc_info_name_array_t *table_info, mach_msg_type_number_t *table_infoCnt, ipc_info_tree_name_array_t *tree_info, mach_msg_type_number_t *tree_infoCnt);
#else
		();
#endif

	boolean_t msgh_simple;
	unsigned int msgh_size;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t table_infoCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t tree_infoCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t infoType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		6,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t table_infoType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	504,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t tree_infoType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	506,
	};
#endif	UseStaticMsgType

	ipc_space_t task;
	mach_msg_type_number_t table_infoCnt;
	ipc_info_tree_name_t tree_info[46];
	mach_msg_type_number_t tree_infoCnt;

	ipc_info_name_t *table_infoP;
	ipc_info_tree_name_t *tree_infoP;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->table_infoCntType != * (int *) &table_infoCntCheck)
#else	UseStaticMsgType
	if ((In0P->table_infoCntType.msgt_inline != TRUE) ||
	    (In0P->table_infoCntType.msgt_longform != FALSE) ||
	    (In0P->table_infoCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->table_infoCntType.msgt_number != 1) ||
	    (In0P->table_infoCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->tree_infoCntType != * (int *) &tree_infoCntCheck)
#else	UseStaticMsgType
	if ((In0P->tree_infoCntType.msgt_inline != TRUE) ||
	    (In0P->tree_infoCntType.msgt_longform != FALSE) ||
	    (In0P->tree_infoCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->tree_infoCntType.msgt_number != 1) ||
	    (In0P->tree_infoCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	task = convert_port_to_space((ipc_port_t) In0P->Head.msgh_request_port);

	table_infoP = OutP->table_info;
	table_infoCnt = 56;
	if (In0P->table_infoCnt < table_infoCnt)
		table_infoCnt = In0P->table_infoCnt;

	tree_infoP = tree_info;
	tree_infoCnt = 46;
	if (In0P->tree_infoCnt < tree_infoCnt)
		tree_infoCnt = In0P->tree_infoCnt;

	OutP->RetCode = mach_port_space_info(task, &OutP->info, &table_infoP, &table_infoCnt, &tree_infoP, &tree_infoCnt);
	space_deallocate(task);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->infoType = infoType;
#else	UseStaticMsgType
	OutP->infoType.msgt_name = 2;
	OutP->infoType.msgt_size = 32;
	OutP->infoType.msgt_number = 6;
	OutP->infoType.msgt_inline = TRUE;
	OutP->infoType.msgt_longform = FALSE;
	OutP->infoType.msgt_deallocate = FALSE;
	OutP->infoType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->table_infoType = table_infoType;
#else	UseStaticMsgType
	OutP->table_infoType.msgtl_name = 2;
	OutP->table_infoType.msgtl_size = 32;
	OutP->table_infoType.msgtl_header.msgt_name = 0;
	OutP->table_infoType.msgtl_header.msgt_size = 0;
	OutP->table_infoType.msgtl_header.msgt_number = 0;
	OutP->table_infoType.msgtl_header.msgt_inline = TRUE;
	OutP->table_infoType.msgtl_header.msgt_longform = TRUE;
	OutP->table_infoType.msgtl_header.msgt_deallocate = FALSE;
	OutP->table_infoType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (table_infoP != OutP->table_info) {
		OutP->table_infoType.msgtl_header.msgt_inline = FALSE;
		OutP->table_infoType.msgtl_header.msgt_deallocate = TRUE;
		*((ipc_info_name_t **)OutP->table_info) = table_infoP;
		msgh_simple = FALSE;
	}

	OutP->table_infoType.msgtl_number = 9 * table_infoCnt;
	msgh_size_delta = (OutP->table_infoType.msgtl_header.msgt_inline) ? 36 * table_infoCnt : sizeof(ipc_info_name_t *);
	msgh_size = 84 + msgh_size_delta;
	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2016);

#if	UseStaticMsgType
	OutP->tree_infoType = tree_infoType;
#else	UseStaticMsgType
	OutP->tree_infoType.msgtl_name = 2;
	OutP->tree_infoType.msgtl_size = 32;
	OutP->tree_infoType.msgtl_header.msgt_name = 0;
	OutP->tree_infoType.msgtl_header.msgt_size = 0;
	OutP->tree_infoType.msgtl_header.msgt_number = 0;
	OutP->tree_infoType.msgtl_header.msgt_inline = TRUE;
	OutP->tree_infoType.msgtl_header.msgt_longform = TRUE;
	OutP->tree_infoType.msgtl_header.msgt_deallocate = FALSE;
	OutP->tree_infoType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (tree_infoP != tree_info) {
		OutP->tree_infoType.msgtl_header.msgt_inline = FALSE;
		OutP->tree_infoType.msgtl_header.msgt_deallocate = TRUE;
		*((ipc_info_tree_name_t **)OutP->tree_info) = tree_infoP;
		msgh_simple = FALSE;
	}
	else {
		bcopy((char *) tree_info, (char *) OutP->tree_info, 44 * tree_infoCnt);
	}

	OutP->tree_infoType.msgtl_number = 11 * tree_infoCnt;
	msgh_size += (OutP->tree_infoType.msgtl_header.msgt_inline) ? 44 * tree_infoCnt : sizeof(ipc_info_tree_name_t *);

	OutP = (Reply *) OutHeadP;
	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = msgh_size;
}

/* Routine mach_port_dnrequest_info */
mig_internal novalue _Xmach_port_dnrequest_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		mach_port_t name;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t totalType;
		unsigned total;
		mach_msg_type_t usedType;
		unsigned used;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t mach_port_dnrequest_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(ipc_space_t task, mach_port_t name, unsigned *total, unsigned *used);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t nameCheck = {
		/* msgt_name = */		15,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t totalType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t usedType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	ipc_space_t task;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->nameType != * (int *) &nameCheck)
#else	UseStaticMsgType
	if ((In0P->nameType.msgt_inline != TRUE) ||
	    (In0P->nameType.msgt_longform != FALSE) ||
	    (In0P->nameType.msgt_name != 15) ||
	    (In0P->nameType.msgt_number != 1) ||
	    (In0P->nameType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	task = convert_port_to_space((ipc_port_t) In0P->Head.msgh_request_port);

	OutP->RetCode = mach_port_dnrequest_info(task, In0P->name, &OutP->total, &OutP->used);
	space_deallocate(task);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 48;

#if	UseStaticMsgType
	OutP->totalType = totalType;
#else	UseStaticMsgType
	OutP->totalType.msgt_name = 2;
	OutP->totalType.msgt_size = 32;
	OutP->totalType.msgt_number = 1;
	OutP->totalType.msgt_inline = TRUE;
	OutP->totalType.msgt_longform = FALSE;
	OutP->totalType.msgt_deallocate = FALSE;
	OutP->totalType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->usedType = usedType;
#else	UseStaticMsgType
	OutP->usedType.msgt_name = 2;
	OutP->usedType.msgt_size = 32;
	OutP->usedType.msgt_number = 1;
	OutP->usedType.msgt_inline = TRUE;
	OutP->usedType.msgt_longform = FALSE;
	OutP->usedType.msgt_deallocate = FALSE;
	OutP->usedType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine host_stack_usage */
mig_internal novalue _Xhost_stack_usage
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t reservedType;
		vm_size_t reserved;
		mach_msg_type_t totalType;
		unsigned total;
		mach_msg_type_t spaceType;
		vm_size_t space;
		mach_msg_type_t residentType;
		vm_size_t resident;
		mach_msg_type_t maxusageType;
		vm_size_t maxusage;
		mach_msg_type_t maxstackType;
		vm_offset_t maxstack;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t host_stack_usage
#if	(defined(__STDC__) || defined(c_plusplus))
		(host_t host, vm_size_t *reserved, unsigned *total, vm_size_t *space, vm_size_t *resident, vm_size_t *maxusage, vm_offset_t *maxstack);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t reservedType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t totalType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t spaceType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t residentType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t maxusageType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t maxstackType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = host_stack_usage(convert_port_to_host((ipc_port_t) In0P->Head.msgh_request_port), &OutP->reserved, &OutP->total, &OutP->space, &OutP->resident, &OutP->maxusage, &OutP->maxstack);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 80;

#if	UseStaticMsgType
	OutP->reservedType = reservedType;
#else	UseStaticMsgType
	OutP->reservedType.msgt_name = 2;
	OutP->reservedType.msgt_size = 32;
	OutP->reservedType.msgt_number = 1;
	OutP->reservedType.msgt_inline = TRUE;
	OutP->reservedType.msgt_longform = FALSE;
	OutP->reservedType.msgt_deallocate = FALSE;
	OutP->reservedType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->totalType = totalType;
#else	UseStaticMsgType
	OutP->totalType.msgt_name = 2;
	OutP->totalType.msgt_size = 32;
	OutP->totalType.msgt_number = 1;
	OutP->totalType.msgt_inline = TRUE;
	OutP->totalType.msgt_longform = FALSE;
	OutP->totalType.msgt_deallocate = FALSE;
	OutP->totalType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->spaceType = spaceType;
#else	UseStaticMsgType
	OutP->spaceType.msgt_name = 2;
	OutP->spaceType.msgt_size = 32;
	OutP->spaceType.msgt_number = 1;
	OutP->spaceType.msgt_inline = TRUE;
	OutP->spaceType.msgt_longform = FALSE;
	OutP->spaceType.msgt_deallocate = FALSE;
	OutP->spaceType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->residentType = residentType;
#else	UseStaticMsgType
	OutP->residentType.msgt_name = 2;
	OutP->residentType.msgt_size = 32;
	OutP->residentType.msgt_number = 1;
	OutP->residentType.msgt_inline = TRUE;
	OutP->residentType.msgt_longform = FALSE;
	OutP->residentType.msgt_deallocate = FALSE;
	OutP->residentType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->maxusageType = maxusageType;
#else	UseStaticMsgType
	OutP->maxusageType.msgt_name = 2;
	OutP->maxusageType.msgt_size = 32;
	OutP->maxusageType.msgt_number = 1;
	OutP->maxusageType.msgt_inline = TRUE;
	OutP->maxusageType.msgt_longform = FALSE;
	OutP->maxusageType.msgt_deallocate = FALSE;
	OutP->maxusageType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->maxstackType = maxstackType;
#else	UseStaticMsgType
	OutP->maxstackType.msgt_name = 2;
	OutP->maxstackType.msgt_size = 32;
	OutP->maxstackType.msgt_number = 1;
	OutP->maxstackType.msgt_inline = TRUE;
	OutP->maxstackType.msgt_longform = FALSE;
	OutP->maxstackType.msgt_deallocate = FALSE;
	OutP->maxstackType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine processor_set_stack_usage */
mig_internal novalue _Xprocessor_set_stack_usage
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t totalType;
		unsigned total;
		mach_msg_type_t spaceType;
		vm_size_t space;
		mach_msg_type_t residentType;
		vm_size_t resident;
		mach_msg_type_t maxusageType;
		vm_size_t maxusage;
		mach_msg_type_t maxstackType;
		vm_offset_t maxstack;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t processor_set_stack_usage
#if	(defined(__STDC__) || defined(c_plusplus))
		(processor_set_t pset, unsigned *total, vm_size_t *space, vm_size_t *resident, vm_size_t *maxusage, vm_offset_t *maxstack);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t totalType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t spaceType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t residentType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t maxusageType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t maxstackType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	processor_set_t pset;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	pset = convert_port_to_pset_name((ipc_port_t) In0P->Head.msgh_request_port);

	OutP->RetCode = processor_set_stack_usage(pset, &OutP->total, &OutP->space, &OutP->resident, &OutP->maxusage, &OutP->maxstack);
	pset_deallocate(pset);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 72;

#if	UseStaticMsgType
	OutP->totalType = totalType;
#else	UseStaticMsgType
	OutP->totalType.msgt_name = 2;
	OutP->totalType.msgt_size = 32;
	OutP->totalType.msgt_number = 1;
	OutP->totalType.msgt_inline = TRUE;
	OutP->totalType.msgt_longform = FALSE;
	OutP->totalType.msgt_deallocate = FALSE;
	OutP->totalType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->spaceType = spaceType;
#else	UseStaticMsgType
	OutP->spaceType.msgt_name = 2;
	OutP->spaceType.msgt_size = 32;
	OutP->spaceType.msgt_number = 1;
	OutP->spaceType.msgt_inline = TRUE;
	OutP->spaceType.msgt_longform = FALSE;
	OutP->spaceType.msgt_deallocate = FALSE;
	OutP->spaceType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->residentType = residentType;
#else	UseStaticMsgType
	OutP->residentType.msgt_name = 2;
	OutP->residentType.msgt_size = 32;
	OutP->residentType.msgt_number = 1;
	OutP->residentType.msgt_inline = TRUE;
	OutP->residentType.msgt_longform = FALSE;
	OutP->residentType.msgt_deallocate = FALSE;
	OutP->residentType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->maxusageType = maxusageType;
#else	UseStaticMsgType
	OutP->maxusageType.msgt_name = 2;
	OutP->maxusageType.msgt_size = 32;
	OutP->maxusageType.msgt_number = 1;
	OutP->maxusageType.msgt_inline = TRUE;
	OutP->maxusageType.msgt_longform = FALSE;
	OutP->maxusageType.msgt_deallocate = FALSE;
	OutP->maxusageType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->maxstackType = maxstackType;
#else	UseStaticMsgType
	OutP->maxstackType.msgt_name = 2;
	OutP->maxstackType.msgt_size = 32;
	OutP->maxstackType.msgt_number = 1;
	OutP->maxstackType.msgt_inline = TRUE;
	OutP->maxstackType.msgt_longform = FALSE;
	OutP->maxstackType.msgt_deallocate = FALSE;
	OutP->maxstackType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine host_virtual_physical_table_info */
mig_internal novalue _Xhost_virtual_physical_table_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t infoCntType;
		mach_msg_type_number_t infoCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t infoType;
		hash_info_bucket_t info[512];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t host_virtual_physical_table_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(host_t host, hash_info_bucket_array_t *info, mach_msg_type_number_t *infoCnt);
#else
		();
#endif

	boolean_t msgh_simple;
#if	UseStaticMsgType
	static mach_msg_type_t infoCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t infoType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t infoCnt;

	hash_info_bucket_t *infoP;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->infoCntType != * (int *) &infoCntCheck)
#else	UseStaticMsgType
	if ((In0P->infoCntType.msgt_inline != TRUE) ||
	    (In0P->infoCntType.msgt_longform != FALSE) ||
	    (In0P->infoCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->infoCntType.msgt_number != 1) ||
	    (In0P->infoCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	infoP = OutP->info;
	infoCnt = 512;
	if (In0P->infoCnt < infoCnt)
		infoCnt = In0P->infoCnt;

	OutP->RetCode = host_virtual_physical_table_info(convert_port_to_host((ipc_port_t) In0P->Head.msgh_request_port), &infoP, &infoCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->infoType = infoType;
#else	UseStaticMsgType
	OutP->infoType.msgtl_name = 2;
	OutP->infoType.msgtl_size = 32;
	OutP->infoType.msgtl_header.msgt_name = 0;
	OutP->infoType.msgtl_header.msgt_size = 0;
	OutP->infoType.msgtl_header.msgt_number = 0;
	OutP->infoType.msgtl_header.msgt_inline = TRUE;
	OutP->infoType.msgtl_header.msgt_longform = TRUE;
	OutP->infoType.msgtl_header.msgt_deallocate = FALSE;
	OutP->infoType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (infoP != OutP->info) {
		OutP->infoType.msgtl_header.msgt_inline = FALSE;
		OutP->infoType.msgtl_header.msgt_deallocate = TRUE;
		*((hash_info_bucket_t **)OutP->info) = infoP;
		msgh_simple = FALSE;
	}

	OutP->infoType.msgtl_number = infoCnt;
	OutP->Head.msgh_size = 44 + ((OutP->infoType.msgtl_header.msgt_inline) ? 4 * infoCnt : sizeof(hash_info_bucket_t *));

	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
}

/* Routine host_load_symbol_table */
mig_internal novalue _Xhost_load_symbol_table
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t taskType;
		ipc_port_t task;
		mach_msg_type_long_t nameType;
		symtab_name_t name;
		mach_msg_type_long_t symtabType;
		vm_offset_t symtab;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t host_load_symbol_table
#if	(defined(__STDC__) || defined(c_plusplus))
		(host_t host, task_t task, symtab_name_t name, vm_offset_t symtab, mach_msg_type_number_t symtabCnt);
#else
		();
#endif

	task_t task;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 92) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->taskType.msgt_inline != TRUE) ||
	    (In0P->taskType.msgt_longform != FALSE) ||
	    (In0P->taskType.msgt_name != 17) ||
	    (In0P->taskType.msgt_number != 1) ||
	    (In0P->taskType.msgt_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->nameType.msgtl_header.msgt_inline != TRUE) ||
	    (In0P->nameType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->nameType.msgtl_name != 12) ||
	    (In0P->nameType.msgtl_number != 1) ||
	    (In0P->nameType.msgtl_size != 256))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->symtabType.msgtl_header.msgt_inline != FALSE) ||
	    (In0P->symtabType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->symtabType.msgtl_name != 9) ||
	    (In0P->symtabType.msgtl_size != 8))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	task = convert_port_to_task(In0P->task);

	OutP->RetCode = host_load_symbol_table(convert_port_to_host_priv((ipc_port_t) In0P->Head.msgh_request_port), task, In0P->name, In0P->symtab, In0P->symtabType.msgtl_number);
	task_deallocate(task);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	if (IP_VALID(In0P->task))
		ipc_port_release_send(In0P->task);
}

/* Routine mach_port_kernel_object */
mig_internal novalue _Xmach_port_kernel_object
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		mach_port_t name;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t object_typeType;
		unsigned object_type;
		mach_msg_type_t object_addrType;
		vm_offset_t object_addr;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t mach_port_kernel_object
#if	(defined(__STDC__) || defined(c_plusplus))
		(ipc_space_t task, mach_port_t name, unsigned *object_type, vm_offset_t *object_addr);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t nameCheck = {
		/* msgt_name = */		15,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t object_typeType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t object_addrType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	ipc_space_t task;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->nameType != * (int *) &nameCheck)
#else	UseStaticMsgType
	if ((In0P->nameType.msgt_inline != TRUE) ||
	    (In0P->nameType.msgt_longform != FALSE) ||
	    (In0P->nameType.msgt_name != 15) ||
	    (In0P->nameType.msgt_number != 1) ||
	    (In0P->nameType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	task = convert_port_to_space((ipc_port_t) In0P->Head.msgh_request_port);

	OutP->RetCode = mach_port_kernel_object(task, In0P->name, &OutP->object_type, &OutP->object_addr);
	space_deallocate(task);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 48;

#if	UseStaticMsgType
	OutP->object_typeType = object_typeType;
#else	UseStaticMsgType
	OutP->object_typeType.msgt_name = 2;
	OutP->object_typeType.msgt_size = 32;
	OutP->object_typeType.msgt_number = 1;
	OutP->object_typeType.msgt_inline = TRUE;
	OutP->object_typeType.msgt_longform = FALSE;
	OutP->object_typeType.msgt_deallocate = FALSE;
	OutP->object_typeType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->object_addrType = object_addrType;
#else	UseStaticMsgType
	OutP->object_addrType.msgt_name = 2;
	OutP->object_addrType.msgt_size = 32;
	OutP->object_addrType.msgt_number = 1;
	OutP->object_addrType.msgt_inline = TRUE;
	OutP->object_addrType.msgt_longform = FALSE;
	OutP->object_addrType.msgt_deallocate = FALSE;
	OutP->object_addrType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine mach_vm_region_info */
mig_internal novalue _Xmach_vm_region_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t addressType;
		vm_address_t address;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t regionType;
		vm_region_info_t region;
		mach_msg_type_t objectType;
		ipc_port_t object;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t mach_vm_region_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(vm_map_t task, vm_address_t address, vm_region_info_t *region, ipc_port_t *object);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t addressCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t regionType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		11,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t objectType = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	vm_map_t task;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->addressType != * (int *) &addressCheck)
#else	UseStaticMsgType
	if ((In0P->addressType.msgt_inline != TRUE) ||
	    (In0P->addressType.msgt_longform != FALSE) ||
	    (In0P->addressType.msgt_name != 2) ||
	    (In0P->addressType.msgt_number != 1) ||
	    (In0P->addressType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	task = convert_port_to_map((ipc_port_t) In0P->Head.msgh_request_port);

	OutP->RetCode = mach_vm_region_info(task, In0P->address, &OutP->region, &OutP->object);
	vm_map_deallocate(task);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 88;

#if	UseStaticMsgType
	OutP->regionType = regionType;
#else	UseStaticMsgType
	OutP->regionType.msgt_name = 2;
	OutP->regionType.msgt_size = 32;
	OutP->regionType.msgt_number = 11;
	OutP->regionType.msgt_inline = TRUE;
	OutP->regionType.msgt_longform = FALSE;
	OutP->regionType.msgt_deallocate = FALSE;
	OutP->regionType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->objectType = objectType;
#else	UseStaticMsgType
	OutP->objectType.msgt_name = 17;
	OutP->objectType.msgt_size = 32;
	OutP->objectType.msgt_number = 1;
	OutP->objectType.msgt_inline = TRUE;
	OutP->objectType.msgt_longform = FALSE;
	OutP->objectType.msgt_deallocate = FALSE;
	OutP->objectType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine mach_vm_object_info */
mig_internal novalue _Xmach_vm_object_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t infoType;
		vm_object_info_t info;
		mach_msg_type_t shadowType;
		ipc_port_t shadow;
		mach_msg_type_t copyType;
		ipc_port_t copy;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t mach_vm_object_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(vm_object_t object, vm_object_info_t *info, ipc_port_t *shadow, ipc_port_t *copy);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t infoType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		14,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t shadowType = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t copyType = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	vm_object_t object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	object = vm_object_lookup_name((ipc_port_t) In0P->Head.msgh_request_port);

	OutP->RetCode = mach_vm_object_info(object, &OutP->info, &OutP->shadow, &OutP->copy);
	vm_object_deallocate(object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 108;

#if	UseStaticMsgType
	OutP->infoType = infoType;
#else	UseStaticMsgType
	OutP->infoType.msgt_name = 2;
	OutP->infoType.msgt_size = 32;
	OutP->infoType.msgt_number = 14;
	OutP->infoType.msgt_inline = TRUE;
	OutP->infoType.msgt_longform = FALSE;
	OutP->infoType.msgt_deallocate = FALSE;
	OutP->infoType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->shadowType = shadowType;
#else	UseStaticMsgType
	OutP->shadowType.msgt_name = 17;
	OutP->shadowType.msgt_size = 32;
	OutP->shadowType.msgt_number = 1;
	OutP->shadowType.msgt_inline = TRUE;
	OutP->shadowType.msgt_longform = FALSE;
	OutP->shadowType.msgt_deallocate = FALSE;
	OutP->shadowType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->copyType = copyType;
#else	UseStaticMsgType
	OutP->copyType.msgt_name = 17;
	OutP->copyType.msgt_size = 32;
	OutP->copyType.msgt_number = 1;
	OutP->copyType.msgt_inline = TRUE;
	OutP->copyType.msgt_longform = FALSE;
	OutP->copyType.msgt_deallocate = FALSE;
	OutP->copyType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine mach_vm_object_pages */
mig_internal novalue _Xmach_vm_object_pages
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t pagesCntType;
		mach_msg_type_number_t pagesCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t pagesType;
		vm_page_info_t pages[85];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t mach_vm_object_pages
#if	(defined(__STDC__) || defined(c_plusplus))
		(vm_object_t object, vm_page_info_array_t *pages, mach_msg_type_number_t *pagesCnt);
#else
		();
#endif

	boolean_t msgh_simple;
#if	UseStaticMsgType
	static mach_msg_type_t pagesCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t pagesType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	510,
	};
#endif	UseStaticMsgType

	vm_object_t object;
	mach_msg_type_number_t pagesCnt;

	vm_page_info_t *pagesP;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pagesCntType != * (int *) &pagesCntCheck)
#else	UseStaticMsgType
	if ((In0P->pagesCntType.msgt_inline != TRUE) ||
	    (In0P->pagesCntType.msgt_longform != FALSE) ||
	    (In0P->pagesCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->pagesCntType.msgt_number != 1) ||
	    (In0P->pagesCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	object = vm_object_lookup_name((ipc_port_t) In0P->Head.msgh_request_port);

	pagesP = OutP->pages;
	pagesCnt = 85;
	if (In0P->pagesCnt < pagesCnt)
		pagesCnt = In0P->pagesCnt;

	OutP->RetCode = mach_vm_object_pages(object, &pagesP, &pagesCnt);
	vm_object_deallocate(object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->pagesType = pagesType;
#else	UseStaticMsgType
	OutP->pagesType.msgtl_name = 2;
	OutP->pagesType.msgtl_size = 32;
	OutP->pagesType.msgtl_header.msgt_name = 0;
	OutP->pagesType.msgtl_header.msgt_size = 0;
	OutP->pagesType.msgtl_header.msgt_number = 0;
	OutP->pagesType.msgtl_header.msgt_inline = TRUE;
	OutP->pagesType.msgtl_header.msgt_longform = TRUE;
	OutP->pagesType.msgtl_header.msgt_deallocate = FALSE;
	OutP->pagesType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (pagesP != OutP->pages) {
		OutP->pagesType.msgtl_header.msgt_inline = FALSE;
		OutP->pagesType.msgtl_header.msgt_deallocate = TRUE;
		*((vm_page_info_t **)OutP->pages) = pagesP;
		msgh_simple = FALSE;
	}

	OutP->pagesType.msgtl_number = 6 * pagesCnt;
	OutP->Head.msgh_size = 44 + ((OutP->pagesType.msgtl_header.msgt_inline) ? 24 * pagesCnt : sizeof(vm_page_info_t *));

	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
}

static mig_routine_t mach_debug_server_routines[] = {
		0,
		0,
		0,
		0,
		0,
		_Xhost_zone_info,
		0,
		_Xmach_port_get_srights,
		_Xhost_ipc_hash_info,
		_Xhost_ipc_marequest_info,
		_Xmach_port_space_info,
		_Xmach_port_dnrequest_info,
		0,
		0,
		_Xhost_stack_usage,
		_Xprocessor_set_stack_usage,
		_Xhost_virtual_physical_table_info,
		_Xhost_load_symbol_table,
		_Xmach_port_kernel_object,
		_Xmach_vm_region_info,
		_Xmach_vm_object_info,
		_Xmach_vm_object_pages,
};

mig_external boolean_t mach_debug_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register mach_msg_header_t *InP =  InHeadP;
	register mig_reply_header_t *OutP = (mig_reply_header_t *) OutHeadP;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	register mig_routine_t routine;

	OutP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REPLY(InP->msgh_bits), 0);
	OutP->Head.msgh_size = sizeof *OutP;
	OutP->Head.msgh_remote_port = InP->msgh_reply_port;
	OutP->Head.msgh_local_port = MACH_PORT_NULL;
	OutP->Head.msgh_seqno = 0;
	OutP->Head.msgh_id = InP->msgh_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msgt_size = 32;
	OutP->RetCodeType.msgt_number = 1;
	OutP->RetCodeType.msgt_inline = TRUE;
	OutP->RetCodeType.msgt_longform = FALSE;
	OutP->RetCodeType.msgt_deallocate = FALSE;
	OutP->RetCodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	if ((InP->msgh_id > 3021) || (InP->msgh_id < 3000) ||
	    ((routine = mach_debug_server_routines[InP->msgh_id - 3000]) == 0)) {
		OutP->RetCode = MIG_BAD_ID;
		return FALSE;
	}
	(*routine) (InP, &OutP->Head);
	return TRUE;
}

mig_external mig_routine_t mach_debug_server_routine
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP)
#else
	(InHeadP)
	mach_msg_header_t *InHeadP;
#endif
{
	register int msgh_id;

	msgh_id = InHeadP->msgh_id - 3000;

	if ((msgh_id > 21) || (msgh_id < 0))
		return 0;

	return mach_debug_server_routines[msgh_id];
}

