.\" Copyright (c) 1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND CARNEGIE MELLON UNIVERSITY
.\" DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT
.\" SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE FOR ANY SPECIAL, DIRECT,
.\" INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
.\" RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
.\" CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" Users of this software agree to return to Carnegie Mellon any
.\" improvements or extensions that they make and grant Carnegie the
.\" rights to redistribute these changes.
.\"
.\" Export of this software is permitted only after complying with the
.\" regulations of the U.S. Deptartment of Commerce relating to the
.\" Export of Technical Data.
.\"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
.\" HISTORY
.\" $Log:	atoh.man,v $
.\" Revision 2.3  92/02/16  15:24:54  rpd
.\" 	Moved from libcs to libcmucs.
.\" 
.\" Revision 2.2  92/01/22  23:13:16  rpd
.\" 	Moved to libcs from libmach.
.\" 	[92/01/19            rpd]
.\" 
.\" Revision 2.2  91/04/11  11:10:54  mrt
.\" 	Copied from libcs
.\" 
.\" Revision 1.3  90/12/12  15:45:56  mja
.\" 	Add copyright/disclaimer for distribution.
.\" 
.\" 13-Nov-86  Andi Swimmer (andi) at Carnegie-Mellon University
.\" 	Revised for 4.3.
.\" 
.\" 05-Dec-79  Steven Shafer (sas) at Carnegie-Mellon University
.\" 	Created.
.\" 
.TH ATOH 3 12/5/79
.CM 1
.SH "NAME"
atoh, atoo \- convert ASCII to hexadecimal or octal
.SH "SYNOPSIS"
.B
unsigned int atoh (ap)
.br
.B
char *ap;
.sp
.B
unsigned int atoo (ap)
.br
.B
char *ap;
.SH "DESCRIPTION"
.I
Atoh
converts the string pointed to by
.I
ap,
representing an hexadecimal number, to an unsigned integer.
The string may contain leading blanks and tabs, and a string of
hexadecimal digits.
Conversion stops at the first character which is
not a valid hexadecimal digit.
The digits themselves include the characters "0" through "9",
"a" through "f", and "A" through "F".
.sp
.I
Atoo
converts the string pointed to by
.I
ap,
representing an octal number, to an unsigned integer.
The string may contain leading blanks and tabs, and a string of
octal digits.
Conversion stops at the first character which is
not a valid octal digit.
.SH "SEE ALSO"
.IR atof (3), 
.IR atoi (3), 
.IR atol (3), 
.SH "BUGS"
There is no provision for overflow.
Unary + is not accepted.
(Unary
- is not accepted, due to the interpretation of the numbers as unsigned.)
