.\" Copyright (c) 1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND CARNEGIE MELLON UNIVERSITY
.\" DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT
.\" SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE FOR ANY SPECIAL, DIRECT,
.\" INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
.\" RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
.\" CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" Users of this software agree to return to Carnegie Mellon any
.\" improvements or extensions that they make and grant Carnegie the
.\" rights to redistribute these changes.
.\"
.\" Export of this software is permitted only after complying with the
.\" regulations of the U.S. Deptartment of Commerce relating to the
.\" Export of Technical Data.
.\"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
.\" HISTORY
.\" $Log:	searchp.man,v $
.\" Revision 2.3  92/02/16  15:25:27  rpd
.\" 	Moved from libcs to libcmucs.
.\" 
.\" Revision 2.2  92/01/22  23:15:05  rpd
.\" 	Moved here from facilities's libcs.
.\" 	[92/01/19            rpd]
.\" 
.\" Revision 1.2  90/12/12  15:57:09  mja
.\" 	Add copyright/disclaimer for distribution.
.\" 
.\" 13-Nov-86  Andi Swimmer (andi) at Carnegie-Mellon University
.\" 	Revised for 4.3.
.\" 
.\" 05-Dec-79  Steven Shafer (sas) at Carnegie-Mellon University
.\" 	Created.
.\" 
.TH SEARCHP 3 12/5/79
.CM 1
.SH "NAME"
searchp \- search for file using searchlist
.SH "SYNOPSIS"
.B
int searchp (searchlist,filename,buffer,function);
.br
.B
char *searchlist,*filename,*buffer;
.br
.B
int (*function)();
.SH "DESCRIPTION"
.I
Searchp
looks for an acceptable filename by concatenating
a name onto each directory name within a given 
.IR searchlist .
.sp
.I
Searchlist
is a list of directory names, separated by colons (:).
.I
Searchp
will parse these names, prepending each in turn to
.I
filename,
the name of the file being sought.
The resulting pathname
is passed as an argument to
.I
function,
a function provided by the user.
This function will receive one parameter -- the pathname --
and must return an integer telling whether this filename
is acceptable or not.
If a non-zero value is returned, then the
search continues with the next directory name from
.I
searchlist.
If the value 0 is returned, then searching stops.
In this case, the full filename is copied into the string
.I
buffer,
and
.I
searchp
returns 0.
.sp
If all the directories are unsuccessfully searched, then
.I
searchp
returns the value -1.
.sp
If
.I
filename
begins with a slash, it is assumed to be an absolute pathname
and
.I
searchlist
is not used.
.SH "SEE ALSO"
.IR openp (3), 
.IR fopenp (3), 
.IR wantread (3), 
.IR wantwrite (3), 
.IR fwantread (3), 
.IR fwantwrite (3),
.IR execlp (3), 
.IR execvp (3), 
.IR runp (3), 
.IR runvp (3)
.SH "DIAGNOSTICS"
\-1 is returned if no filename is satisfactory; 0 otherwise.
.SH "BUGS"
UNIX from Bell Labs uses three different searching algorithms
in three different contexts.
In the SHELL, executable programs
are sought, but are considered absolute pathnames if they
.I
contain
a slash, even if it is not the first character (bogus, in my
opinion -- sas).
The routines 
.I execvp 
and 
.I execlp 
use the same rule,
but also accept the minus sign (\-) as a separator in the pathlist.
The C compiler, in searching for macro files, uses the rule of
.I
searchp
-- a filename is only absolute if it
.I
begins
with a slash.
.sp
Users normally do not need to use
.I
searchp;
there are other, higher-level routines
.RI ( runp ,
.IR runvp ,
.IR openp ,
.IR fopenp )
which should normally be used.
There are, however,
occasions in which such routines are not powerful enough;
then,
.I
searchp
is appropriate.
