#include "default_pager.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine default_pager_object_pages */
mig_external kern_return_t default_pager_object_pages
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t default_pager,
	mach_port_t memory_object,
	default_pager_page_array_t *pages,
	mach_msg_type_number_t *pagesCnt
)
#else
	(default_pager, memory_object, pages, pagesCnt)
	mach_port_t default_pager;
	mach_port_t memory_object;
	default_pager_page_array_t *pages;
	mach_msg_type_number_t *pagesCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_objectType;
		mach_port_t memory_object;
		mach_msg_type_t pagesCntType;
		mach_msg_type_number_t pagesCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t pagesType;
		default_pager_page_t pages[512];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t memory_objectType = {
		/* msgt_name = */		19,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pagesCntType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->memory_objectType = memory_objectType;
#else	UseStaticMsgType
	InP->memory_objectType.msgt_name = 19;
	InP->memory_objectType.msgt_size = 32;
	InP->memory_objectType.msgt_number = 1;
	InP->memory_objectType.msgt_inline = TRUE;
	InP->memory_objectType.msgt_longform = FALSE;
	InP->memory_objectType.msgt_deallocate = FALSE;
	InP->memory_objectType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->memory_object = memory_object;

#if	UseStaticMsgType
	InP->pagesCntType = pagesCntType;
#else	UseStaticMsgType
	InP->pagesCntType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pagesCntType.msgt_size = 32;
	InP->pagesCntType.msgt_number = 1;
	InP->pagesCntType.msgt_inline = TRUE;
	InP->pagesCntType.msgt_longform = FALSE;
	InP->pagesCntType.msgt_deallocate = FALSE;
	InP->pagesCntType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (*pagesCnt < 512)
		InP->pagesCnt = *pagesCnt;
	else
		InP->pagesCnt = 512;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = default_pager;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2278;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 2378) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size < 44)) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if ((OutP->pagesType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->pagesType.msgtl_name != 2) ||
	    (OutP->pagesType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 44 + ((OutP->pagesType.msgtl_header.msgt_inline) ? 4 * OutP->pagesType.msgtl_number : sizeof(default_pager_page_t *)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (!OutP->pagesType.msgtl_header.msgt_inline)
	    *pages = *((default_pager_page_t **)OutP->pages);
	else if (OutP->pagesType.msgtl_number > *pagesCnt) {
	    mig_allocate((vm_offset_t *)pages,
		4 * OutP->pagesType.msgtl_number);
	    bcopy((char *) OutP->pages, (char *) *pages, 4 * OutP->pagesType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->pages, (char *) *pages, 4 * OutP->pagesType.msgtl_number);
	}

	*pagesCnt = OutP->pagesType.msgtl_number;

	return KERN_SUCCESS;
}
