#include "mach_debug.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine host_load_symbol_table */
mig_external kern_return_t host_load_symbol_table
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t host,
	mach_port_t task,
	symtab_name_t name,
	vm_offset_t symtab,
	mach_msg_type_number_t symtabCnt
)
#else
	(host, task, name, symtab, symtabCnt)
	mach_port_t host;
	mach_port_t task;
	symtab_name_t name;
	vm_offset_t symtab;
	mach_msg_type_number_t symtabCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t taskType;
		mach_port_t task;
		mach_msg_type_long_t nameType;
		symtab_name_t name;
		mach_msg_type_long_t symtabType;
		vm_offset_t symtab;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t taskType = {
		/* msgt_name = */		19,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t nameType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	12,
		/* msgtl_size = */	256,
		/* msgtl_number = */	1,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t symtabType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		FALSE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	9,
		/* msgtl_size = */	8,
		/* msgtl_number = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->taskType = taskType;
#else	UseStaticMsgType
	InP->taskType.msgt_name = 19;
	InP->taskType.msgt_size = 32;
	InP->taskType.msgt_number = 1;
	InP->taskType.msgt_inline = TRUE;
	InP->taskType.msgt_longform = FALSE;
	InP->taskType.msgt_deallocate = FALSE;
	InP->taskType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->task = task;

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgtl_name = 12;
	InP->nameType.msgtl_size = 256;
	InP->nameType.msgtl_number = 1;
	InP->nameType.msgtl_header.msgt_name = 0;
	InP->nameType.msgtl_header.msgt_size = 0;
	InP->nameType.msgtl_header.msgt_number = 0;
	InP->nameType.msgtl_header.msgt_inline = TRUE;
	InP->nameType.msgtl_header.msgt_longform = TRUE;
	InP->nameType.msgtl_header.msgt_deallocate = FALSE;
	InP->nameType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	(void) mig_strncpy(InP->name, name, 32);

#if	UseStaticMsgType
	InP->symtabType = symtabType;
#else	UseStaticMsgType
	InP->symtabType.msgtl_name = 9;
	InP->symtabType.msgtl_size = 8;
	InP->symtabType.msgtl_header.msgt_name = 0;
	InP->symtabType.msgtl_header.msgt_size = 0;
	InP->symtabType.msgtl_header.msgt_number = 0;
	InP->symtabType.msgtl_header.msgt_inline = FALSE;
	InP->symtabType.msgtl_header.msgt_longform = TRUE;
	InP->symtabType.msgtl_header.msgt_deallocate = FALSE;
	InP->symtabType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->symtab = symtab;

	InP->symtabType.msgtl_number = symtabCnt;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = host;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 3017;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 3117) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}
