#include "mach_debug.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine host_stack_usage */
mig_external kern_return_t host_stack_usage
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t host,
	vm_size_t *reserved,
	unsigned *total,
	vm_size_t *space,
	vm_size_t *resident,
	vm_size_t *maxusage,
	vm_offset_t *maxstack
)
#else
	(host, reserved, total, space, resident, maxusage, maxstack)
	mach_port_t host;
	vm_size_t *reserved;
	unsigned *total;
	vm_size_t *space;
	vm_size_t *resident;
	vm_size_t *maxusage;
	vm_offset_t *maxstack;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t reservedType;
		vm_size_t reserved;
		mach_msg_type_t totalType;
		unsigned total;
		mach_msg_type_t spaceType;
		vm_size_t space;
		mach_msg_type_t residentType;
		vm_size_t resident;
		mach_msg_type_t maxusageType;
		vm_size_t maxusage;
		mach_msg_type_t maxstackType;
		vm_offset_t maxstack;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t reservedCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t totalCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t spaceCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t residentCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t maxusageCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t maxstackCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = host;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 3014;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 3114) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;

	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    ((msgh_size != 80) &&
	     ((msgh_size != sizeof(mig_reply_header_t)) ||
	      (OutP->RetCode == KERN_SUCCESS))))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->reservedType != * (int *) &reservedCheck)
#else	UseStaticMsgType
	if ((OutP->reservedType.msgt_inline != TRUE) ||
	    (OutP->reservedType.msgt_longform != FALSE) ||
	    (OutP->reservedType.msgt_name != 2) ||
	    (OutP->reservedType.msgt_number != 1) ||
	    (OutP->reservedType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*reserved = OutP->reserved;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->totalType != * (int *) &totalCheck)
#else	UseStaticMsgType
	if ((OutP->totalType.msgt_inline != TRUE) ||
	    (OutP->totalType.msgt_longform != FALSE) ||
	    (OutP->totalType.msgt_name != 2) ||
	    (OutP->totalType.msgt_number != 1) ||
	    (OutP->totalType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*total = OutP->total;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->spaceType != * (int *) &spaceCheck)
#else	UseStaticMsgType
	if ((OutP->spaceType.msgt_inline != TRUE) ||
	    (OutP->spaceType.msgt_longform != FALSE) ||
	    (OutP->spaceType.msgt_name != 2) ||
	    (OutP->spaceType.msgt_number != 1) ||
	    (OutP->spaceType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*space = OutP->space;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->residentType != * (int *) &residentCheck)
#else	UseStaticMsgType
	if ((OutP->residentType.msgt_inline != TRUE) ||
	    (OutP->residentType.msgt_longform != FALSE) ||
	    (OutP->residentType.msgt_name != 2) ||
	    (OutP->residentType.msgt_number != 1) ||
	    (OutP->residentType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*resident = OutP->resident;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->maxusageType != * (int *) &maxusageCheck)
#else	UseStaticMsgType
	if ((OutP->maxusageType.msgt_inline != TRUE) ||
	    (OutP->maxusageType.msgt_longform != FALSE) ||
	    (OutP->maxusageType.msgt_name != 2) ||
	    (OutP->maxusageType.msgt_number != 1) ||
	    (OutP->maxusageType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*maxusage = OutP->maxusage;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->maxstackType != * (int *) &maxstackCheck)
#else	UseStaticMsgType
	if ((OutP->maxstackType.msgt_inline != TRUE) ||
	    (OutP->maxstackType.msgt_longform != FALSE) ||
	    (OutP->maxstackType.msgt_name != 2) ||
	    (OutP->maxstackType.msgt_number != 1) ||
	    (OutP->maxstackType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*maxstack = OutP->maxstack;

	return KERN_SUCCESS;
}
