/* 
 * Mach Operating System
 * Copyright (c) 1991 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 * Copyright 1988, 1989, 1990, 1991 by Intel Corporation,
 * Santa Clara, California.
 * 
 *                          All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and that
 * both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Intel not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * INTEL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT
 * SHALL INTEL BE LIABLE FOR ANY SPECIAL, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE, OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */
/*
 * HISTORY
 * $Log:	bzero.s,v $
 * Revision 2.2  91/09/04  11:28:58  jsb
 * 	First checkin. Provided by Intel SSD.
 * 	[91/09/04  10:33:01  jsb]
 * 
 */

#include <machine/psl.h>

#define	ASSEMBLY
#define	BCOPY_REG r30

	.text

//
//	bzero(adr, bcnt)
//
_bzero::
_blkclr::				// wlb
	or	r17,r0,r0
	bc	bzdone

	adds	-1,r0,r18	//r18 = -1 for bla
	or	r16,r17,r19
	and	3,r19,r0
	bc	bzdolongs	//long aligned addr and 4*x bcnt?

blp_start:
	adds	-1,r17,r17
	bla	r18,r17,blp
	nop
blp:
	st.b	r0,0(r16)
	bla	r18,r17,blp
	addu	1,r16,r16

	bri	r1
	nop

bzdolongs:
	shr	2,r17,r17
	adds	-1,r17,r17
	adds	-4,r16,r16
	bla	r18,r17,llp
	nop
llp:
	bla	r18,r17,llp
	fst.l	f0,4(r16)++

bzdone:
	bri	r1
	nop

//
//	memcopy(to,from,nbytes)
//	bcopy(from,to,nbytes)
//

_memcpy::
	mov	r16,BCOPY_REG
	mov	r17,r16
	mov	BCOPY_REG,r17
_bcopy::
	or	r0,r18,r0
	bc	bcdone

	adds	-1,r0,BCOPY_REG		//r30 = -1 for bla

	or	r16,r17,r19
	or	r18,r19,r19
	and	3,r19,r0


	bc	bcdolongs	//long aligned addr and 4*x bcnt?
	nop

bcblp_start:
	adds	-1,r18,r18
	bla	BCOPY_REG,r18,bcblp
	nop
bcblp:
	ld.b	0(r16),r29
	and	0x00FF,r29,r29
	st.b	r29,0(r17)
	addu	1,r17,r17
	bla	BCOPY_REG,r18,bcblp
	addu	1,r16,r16

	bri	r1
	nop

bcdolongs:
	shr	2,r18,r18
	adds	-1,r18,r18
	bla	BCOPY_REG,r18,bcllp
	nop
bcllp:

	ld.l	0(r16),r29
	st.l	r29,0(r17)
	addu	4,r17,r17
	addu	4,r16,r16

	bla	BCOPY_REG,r18,bcllp
	nop

bcdone:
	bri	r1
	nop

