#ifndef	_mach_norma_user_
#define	_mach_norma_user_

/* Module mach_norma */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>

/* Routine task_set_child_node */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t task_set_child_node
#if	defined(LINTLIBRARY)
    (target_task, child_node)
	mach_port_t target_task;
	int child_node;
{ return task_set_child_node(target_task, child_node); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t target_task,
	int child_node
);
#else
    ();
#endif
#endif

/* Routine norma_node_self */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t norma_node_self
#if	defined(LINTLIBRARY)
    (host, node)
	mach_port_t host;
	int *node;
{ return norma_node_self(host, node); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t host,
	int *node
);
#else
    ();
#endif
#endif

/* Routine norma_task_create */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t norma_task_create
#if	defined(LINTLIBRARY)
    (target_task, inherit_memory, child_node, child_task)
	mach_port_t target_task;
	boolean_t inherit_memory;
	int child_node;
	mach_port_t *child_task;
{ return norma_task_create(target_task, inherit_memory, child_node, child_task); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t target_task,
	boolean_t inherit_memory,
	int child_node,
	mach_port_t *child_task
);
#else
    ();
#endif
#endif

/* Routine norma_get_special_port */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t norma_get_special_port
#if	defined(LINTLIBRARY)
    (host_priv, node, which, port)
	mach_port_t host_priv;
	int node;
	int which;
	mach_port_t *port;
{ return norma_get_special_port(host_priv, node, which, port); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t host_priv,
	int node,
	int which,
	mach_port_t *port
);
#else
    ();
#endif
#endif

/* Routine norma_set_special_port */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t norma_set_special_port
#if	defined(LINTLIBRARY)
    (host_priv, which, port)
	mach_port_t host_priv;
	int which;
	mach_port_t port;
{ return norma_set_special_port(host_priv, which, port); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t host_priv,
	int which,
	mach_port_t port
);
#else
    ();
#endif
#endif

/* Routine norma_port_location_hint */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t norma_port_location_hint
#if	defined(LINTLIBRARY)
    (task, port, node)
	mach_port_t task;
	mach_port_t port;
	int *node;
{ return norma_port_location_hint(task, port, node); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t task,
	mach_port_t port,
	int *node
);
#else
    ();
#endif
#endif

#endif	_mach_norma_user_
