#include "notify_user.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* SimpleRoutine mach_notify_port_deleted */
mig_external kern_return_t mach_notify_port_deleted
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t notify,
	mach_port_t name
)
#else
	(notify, name)
	mach_port_t notify;
	mach_port_t name;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		mach_port_t name;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		15,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = 15;
	InP->nameType.msgt_size = 32;
	InP->nameType.msgt_number = 1;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->name = name;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(18, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = notify;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 65;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine mach_notify_msg_accepted */
mig_external kern_return_t mach_notify_msg_accepted
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t notify,
	mach_port_t name
)
#else
	(notify, name)
	mach_port_t notify;
	mach_port_t name;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		mach_port_t name;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		15,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = 15;
	InP->nameType.msgt_size = 32;
	InP->nameType.msgt_number = 1;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->name = name;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(18, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = notify;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 66;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine mach_notify_port_destroyed */
mig_external kern_return_t mach_notify_port_destroyed
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t notify,
	mach_port_t rights,
	mach_msg_type_name_t rightsPoly
)
#else
	(notify, rights, rightsPoly)
	mach_port_t notify;
	mach_port_t rights;
	mach_msg_type_name_t rightsPoly;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t rightsType;
		mach_port_t rights;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;

	boolean_t msgh_simple = TRUE;

#if	UseStaticMsgType
	static mach_msg_type_t rightsType = {
		/* msgt_name = */		((mach_msg_type_name_t) -1),
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->rightsType = rightsType;
#else	UseStaticMsgType
	InP->rightsType.msgt_size = 32;
	InP->rightsType.msgt_number = 1;
	InP->rightsType.msgt_inline = TRUE;
	InP->rightsType.msgt_longform = FALSE;
	InP->rightsType.msgt_deallocate = FALSE;
	InP->rightsType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->rights = rights;

	if (MACH_MSG_TYPE_PORT_ANY(rightsPoly))
		msgh_simple = FALSE;

	InP->rightsType.msgt_name = rightsPoly;

	InP->Head.msgh_bits = msgh_simple ?
		MACH_MSGH_BITS(18, 0) :
		(MACH_MSGH_BITS_COMPLEX|
		 MACH_MSGH_BITS(18, 0));
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = notify;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 69;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine mach_notify_no_senders */
mig_external kern_return_t mach_notify_no_senders
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t notify,
	mach_port_mscount_t mscount
)
#else
	(notify, mscount)
	mach_port_t notify;
	mach_port_mscount_t mscount;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t mscountType;
		mach_port_mscount_t mscount;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t mscountType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->mscountType = mscountType;
#else	UseStaticMsgType
	InP->mscountType.msgt_name = 2;
	InP->mscountType.msgt_size = 32;
	InP->mscountType.msgt_number = 1;
	InP->mscountType.msgt_inline = TRUE;
	InP->mscountType.msgt_longform = FALSE;
	InP->mscountType.msgt_deallocate = FALSE;
	InP->mscountType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->mscount = mscount;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(18, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = notify;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 70;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine mach_notify_send_once */
mig_external kern_return_t mach_notify_send_once
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t notify
)
#else
	(notify)
	mach_port_t notify;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


	InP->Head.msgh_bits =
		MACH_MSGH_BITS(18, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = notify;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 71;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine mach_notify_dead_name */
mig_external kern_return_t mach_notify_dead_name
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t notify,
	mach_port_t name
)
#else
	(notify, name)
	mach_port_t notify;
	mach_port_t name;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		mach_port_t name;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		15,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = 15;
	InP->nameType.msgt_size = 32;
	InP->nameType.msgt_number = 1;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->name = name;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(18, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = notify;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 72;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}
