#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 138 "config.y"
typedef union {
	char	*str;
	int	val;
	struct	file_list *file;
	struct	idlst *lst;
} YYSTYPE;
#line 205 "config.y"

#include "config.h"
#include <ctype.h>
#include <stdio.h>

struct	device cur;
struct	device *curp = 0;
char	*temp_id;
char	*val_id;
char	*malloc();

#line 25 "y.tab.c"
#define ADDRMOD 257
#define AND 258
#define ANY 259
#define AT 260
#define BIN 261
#define COMMA 262
#define CONFIG 263
#define CONTROLLER 264
#define CONF 265
#define CSR 266
#define DEVICE 267
#define DISK 268
#define DRIVE 269
#define DST 270
#define EQUALS 271
#define FLAGS 272
#define IDENT 273
#define MAJOR 274
#define MASTER 275
#define MAXUSERS 276
#define MAXDSIZ 277
#define MBA 278
#define MBII 279
#define MINOR 280
#define MINUS 281
#define NEXUS 282
#define OPTIONS 283
#define MAKEOPTIONS 284
#define PLATFORM 285
#define PRIORITY 286
#define PSEUDO_DEVICE 287
#define SEMICOLON 288
#define SLAVE 289
#define TRACE 290
#define UBA 291
#define VECTOR 292
#define VME 293
#define VME16D16 294
#define VME24D16 295
#define VME32D16 296
#define VME16D32 297
#define VME24D32 298
#define VME32D32 299
#define LUN 300
#define SLOT 301
#define TAPE 302
#define ID 303
#define NUMBER 304
#define FPNUMBER 305
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    6,    6,    7,    7,    7,    7,    7,    9,    9,
    9,    9,    9,    9,   12,   13,   10,   10,   14,   14,
    2,    2,    2,    1,   11,   11,   15,    3,    3,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    8,    8,
    8,    8,    8,    8,    8,   16,   19,   17,   17,   20,
   20,   20,   21,   21,   22,   22,   22,   22,   22,   22,
   22,   22,    5,    5,   18,   18,   18,   18,   18,   23,
    4,    4,    4,    4,
};
short yylen[] = {                                         2,
    1,    2,    0,    2,    2,    2,    1,    2,    2,    2,
    2,    2,    2,    1,    1,    2,    3,    1,    1,    3,
    1,    1,    0,    1,    3,    1,    3,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    4,    4,
    4,    4,    4,    3,    4,    3,    0,    2,    0,    3,
    3,    3,    2,    0,    2,    2,    2,    2,    2,    2,
    2,    2,    1,    2,    1,    2,    3,    3,    0,    2,
    1,    2,    2,    3,
};
short yydefred[] = {                                      3,
    0,    0,    0,    0,   47,    0,   47,   47,    0,   47,
    0,    0,    0,   47,    7,    0,   47,    2,    0,    0,
   14,   15,    8,   24,   16,    0,    0,    9,    0,    0,
   13,    0,    0,    0,   18,    0,    0,   26,   10,    0,
    6,    0,    4,    5,    0,    0,   54,   29,   37,   28,
   36,   30,   31,   32,   33,   34,   35,   38,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   43,    0,    0,   46,   39,   41,   40,
   21,   22,   20,   17,   27,   25,   45,   42,   52,   51,
   50,    0,    0,   70,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   53,   67,    0,   72,   68,   58,   61,
   55,   56,   60,   57,   59,    0,   63,   62,   74,   64,
};
short yydgoto[] = {                                       1,
   93,   83,   59,   94,  118,    2,   18,   19,   20,   34,
   37,   21,   22,   35,   38,   26,   46,   74,   27,   47,
   76,  104,   75,
};
short yysindex[] = {                                      0,
    0, -210, -282, -288,    0, -288,    0,    0, -283,    0,
 -288, -288, -288,    0,    0, -260,    0,    0, -252, -232,
    0,    0,    0,    0,    0, -199, -185,    0, -199, -199,
    0, -199, -207, -194,    0, -195, -157,    0,    0, -185,
    0, -199,    0,    0, -212, -241,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -197, -241,
 -241, -241, -204, -288, -204, -288, -189, -241, -188, -187,
 -184, -183, -288,    0, -214, -256,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -173, -200,    0, -182, -181, -180, -179, -178, -177,
 -176, -175, -270,    0,    0, -288,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -174,    0,    0,    0,    0,
};
short yyrindex[] = {                                      0,
    0,  131,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -191,    0,    0, -191, -191,
    0, -191, -259, -156,    0,    0, -155,    0,    0,    0,
    0, -191,    0,    0,    0, -154,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -154,
 -154, -154, -258,    0, -258,    0, -232, -154,    0,    0,
    0,    0,    0,    0, -153, -190,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -152, -217,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -198,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
};
short yygindex[] = {                                      0,
   -4,   72,  -28,  -79,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   74,   73,   42,  -11,  -36,  126,    0,
    0,    0,   49,
};
#define YYTABLESIZE 141
short yytable[] = {                                      25,
   96,   28,   19,   23,   97,   23,   33,   36,   39,   98,
  116,   67,   99,  107,   24,  100,   71,   60,   61,   31,
   62,   48,   49,   78,   79,   80,  119,   41,   19,   23,
   68,   88,  101,  117,   50,   43,   51,   52,   53,   54,
   55,   56,   57,  102,   72,    3,   58,  103,   29,   30,
   73,   32,    4,    5,    6,   44,    7,    8,   42,   33,
   45,   36,    9,   63,   10,   48,   49,   64,   71,   69,
   71,   95,   11,   12,   13,   65,   14,   15,   50,   16,
   51,   52,   53,   54,   55,   56,   57,   73,   70,   73,
   58,   17,   48,   49,   49,   48,   49,   48,   81,   82,
   49,   48,   24,  106,   66,   50,   77,   51,   52,   53,
   54,   55,   56,   57,   87,   89,   90,   58,   73,   91,
   92,  108,  109,  110,  111,  112,  113,  114,  115,  120,
    1,   11,   12,   69,   65,   66,   85,   84,   86,   40,
  105,
};
short yycheck[] = {                                       4,
  257,    6,  262,  262,  261,  288,   11,   12,   13,  266,
  281,   40,  269,   93,  303,  272,   45,   29,   30,  303,
   32,  278,  279,   60,   61,   62,  106,  288,  288,  288,
   42,   68,  289,  304,  291,  288,  293,  294,  295,  296,
  297,  298,  299,  300,  286,  256,  303,   76,    7,    8,
  292,   10,  263,  264,  265,  288,  267,  268,   17,   64,
  260,   66,  273,  271,  275,  278,  279,  262,  286,  282,
  288,  286,  283,  284,  285,  271,  287,  288,  291,  290,
  293,  294,  295,  296,  297,  298,  299,  286,  301,  288,
  303,  302,  278,  279,  286,  286,  288,  288,  303,  304,
  292,  292,  303,  304,  262,  291,  304,  293,  294,  295,
  296,  297,  298,  299,  304,  304,  304,  303,  292,  304,
  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
    0,  288,  288,  288,  288,  288,   65,   64,   66,   14,
   92,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 305
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"ADDRMOD","AND","ANY","AT","BIN",
"COMMA","CONFIG","CONTROLLER","CONF","CSR","DEVICE","DISK","DRIVE","DST",
"EQUALS","FLAGS","IDENT","MAJOR","MASTER","MAXUSERS","MAXDSIZ","MBA","MBII",
"MINOR","MINUS","NEXUS","OPTIONS","MAKEOPTIONS","PLATFORM","PRIORITY",
"PSEUDO_DEVICE","SEMICOLON","SLAVE","TRACE","UBA","VECTOR","VME","VME16D16",
"VME24D16","VME32D16","VME16D32","VME24D32","VME32D32","LUN","SLOT","TAPE","ID",
"NUMBER","FPNUMBER",
};
char *yyrule[] = {
"$accept : Configuration",
"Configuration : Many_specs",
"Many_specs : Many_specs Spec",
"Many_specs :",
"Spec : Device_spec SEMICOLON",
"Spec : Config_spec SEMICOLON",
"Spec : TRACE SEMICOLON",
"Spec : SEMICOLON",
"Spec : error SEMICOLON",
"Config_spec : CONF Save_id",
"Config_spec : PLATFORM Save_id",
"Config_spec : OPTIONS Opt_list",
"Config_spec : MAKEOPTIONS Mkopt_list",
"Config_spec : IDENT ID",
"Config_spec : System_spec",
"System_spec : System_id",
"System_id : CONFIG Save_id",
"Opt_list : Opt_list COMMA Option",
"Opt_list : Option",
"Option : Save_id",
"Option : Save_id EQUALS Opt_value",
"Opt_value : ID",
"Opt_value : NUMBER",
"Opt_value :",
"Save_id : ID",
"Mkopt_list : Mkopt_list COMMA Mkoption",
"Mkopt_list : Mkoption",
"Mkoption : Save_id EQUALS Opt_value",
"Dev : UBA",
"Dev : MBA",
"Dev : VME16D16",
"Dev : VME24D16",
"Dev : VME32D16",
"Dev : VME16D32",
"Dev : VME24D32",
"Dev : VME32D32",
"Dev : VME",
"Dev : MBII",
"Dev : ID",
"Device_spec : DEVICE Dev_name Dev_info Int_spec",
"Device_spec : MASTER Dev_name Dev_info Int_spec",
"Device_spec : DISK Dev_name Dev_info Int_spec",
"Device_spec : TAPE Dev_name Dev_info Int_spec",
"Device_spec : CONTROLLER Dev_name Dev_info Int_spec",
"Device_spec : PSEUDO_DEVICE Init_dev Dev",
"Device_spec : PSEUDO_DEVICE Init_dev Dev NUMBER",
"Dev_name : Init_dev Dev NUMBER",
"Init_dev :",
"Dev_info : Con_info Info_list",
"Dev_info :",
"Con_info : AT Dev NUMBER",
"Con_info : AT SLOT NUMBER",
"Con_info : AT NEXUS NUMBER",
"Info_list : Info_list Info",
"Info_list :",
"Info : CSR NUMBER",
"Info : DRIVE NUMBER",
"Info : SLAVE NUMBER",
"Info : ADDRMOD NUMBER",
"Info : LUN NUMBER",
"Info : FLAGS NUMBER",
"Info : BIN NUMBER",
"Info : Dev Value",
"Value : NUMBER",
"Value : MINUS NUMBER",
"Int_spec : Vec_spec",
"Int_spec : PRIORITY NUMBER",
"Int_spec : PRIORITY NUMBER Vec_spec",
"Int_spec : Vec_spec PRIORITY NUMBER",
"Int_spec :",
"Vec_spec : VECTOR Id_list",
"Id_list : Save_id",
"Id_list : Save_id Id_list",
"Id_list : Save_id NUMBER",
"Id_list : Save_id NUMBER Id_list",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 658 "config.y"

yyerror(s)
	char *s;
{
	fprintf(stderr, "config: line %d: %s\n", yyline, s);
}

/*
 * return the passed string in a new space
 */
char *
ns(str)
	register char *str;
{
	register char *cp;

	cp = malloc((unsigned)(strlen(str)+1));
	(void) strcpy(cp, str);
	return (cp);
}

/*
 * add a device to the list of devices
 */
newdev(dp)
	register struct device *dp;
{
	register struct device *np;

	np = (struct device *) malloc(sizeof *np);
	*np = *dp;
	if (curp == 0)
		dtab = np;
	else
		curp->d_next = np;
	curp = np;
	curp->d_next = 0;
}

/*
 * note that a configuration should be made
 */
mkconf(sysname)
	char *sysname;
{
	register struct file_list *fl, **flp;

	fl = (struct file_list *) malloc(sizeof *fl);
	fl->f_type = SYSTEMSPEC;
	fl->f_needs = sysname;
	fl->f_fn = 0;
	fl->f_next = 0;
	for (flp = confp; *flp; flp = &(*flp)->f_next)
		;
	*flp = fl;
	confp = flp;
}

/*
 * find the pointer to connect to the given device and number.
 * returns 0 if no such device and prints an error message
 */
struct device *
connect(dev, num)
	register char *dev;
	register int num;
{
	register struct device *dp;
	struct device *huhcon();

	if (num == QUES)
		return (huhcon(dev));
	for (dp = dtab; dp != 0; dp = dp->d_next) {
		if ((num != dp->d_unit) || !eq(dev, dp->d_name))
			continue;
		if (dp->d_type != CONTROLLER && dp->d_type != MASTER) {
			(void) sprintf(errbuf,
			    "%s connected to non-controller", dev);
			yyerror(errbuf);
			return (0);
		}
		return (dp);
	}
	(void) sprintf(errbuf, "%s %d not defined", dev, num);
	yyerror(errbuf);
	return (0);
}

/*
 * connect to an unspecific thing
 */
struct device *
huhcon(dev)
	register char *dev;
{
	register struct device *dp, *dcp;
	struct device rdev;
	int oldtype;

	/*
	 * First make certain that there are some of these to wildcard on
	 */
	for (dp = dtab; dp != 0; dp = dp->d_next)
		if (eq(dp->d_name, dev))
			break;
	if (dp == 0) {
		(void) sprintf(errbuf, "no %s's to wildcard", dev);
		yyerror(errbuf);
		return (0);
	}
	oldtype = dp->d_type;
	dcp = dp->d_conn;
	/*
	 * Now see if there is already a wildcard entry for this device
	 * (e.g. Search for a "uba ?")
	 */
	for (; dp != 0; dp = dp->d_next)
		if (eq(dev, dp->d_name) && dp->d_unit == -1)
			break;
	/*
	 * If there isn't, make one because everything needs to be connected
	 * to something.
	 */
	if (dp == 0) {
		dp = &rdev;
		init_dev(dp);
		dp->d_unit = QUES;
		dp->d_name = ns(dev);
		dp->d_type = oldtype;
		newdev(dp);
		dp = curp;
		/*
		 * Connect it to the same thing that other similar things are
		 * connected to, but make sure it is a wildcard unit
		 * (e.g. up connected to sc ?, here we make connect sc? to a
		 * uba?).  If other things like this are on the NEXUS or
		 * if they aren't connected to anything, then make the same
		 * connection, else call ourself to connect to another
		 * unspecific device.
		 */
		if (dcp == TO_NEXUS || dcp == 0)
			dp->d_conn = dcp;
		else
			dp->d_conn = connect(dcp->d_name, QUES);
	}
	return (dp);
}

init_dev(dp)
	register struct device *dp;
{

	dp->d_name = "OHNO!!!";
	dp->d_type = DEVICE;
	dp->d_conn = 0;
	dp->d_vec = 0;
	dp->d_addr = dp->d_pri = dp->d_flags = dp->d_dk = 0;
	dp->d_slave = dp->d_drive = dp->d_unit = UNKNOWN;
	if (conftype == CONFTYPE_SUN2 || conftype == CONFTYPE_SUN3
	    || conftype == CONFTYPE_SUN4){
		dp->d_addr = UNKNOWN;
		dp->d_mach = dp->d_bus = 0;
	}
	if (conftype == CONFTYPE_MIPSY || conftype == CONFTYPE_MIPS){
		dp->d_addrmod = 0;
	}
}

/*
 * make certain that this is a reasonable type of thing to connect to a nexus
 */
check_nexus(dev, num)
	register struct device *dev;
	int num;
{

	switch (conftype) {

	case CONFTYPE_VAX:
		if (!eq(dev->d_name, "uba") && !eq(dev->d_name, "mba"))
			yyerror("only uba's and mba's should be connected to the nexus");
		if (num != QUES)
			yyerror("can't give specific nexus numbers");
		break;

	case CONFTYPE_SUN:
		if (!eq(dev->d_name, "mb"))
			yyerror("only mb's should be connected to the nexus");
		break;

	case CONFTYPE_ROMP:
		if (!eq(dev->d_name, "iocc"))
			yyerror("only iocc's should be connected to the nexus");
		break;
        case CONFTYPE_SUN2:
		if (!eq(dev->d_name, "virtual") &&
		    !eq(dev->d_name, "obmem") &&
		    !eq(dev->d_name, "obio") &&
		    !eq(dev->d_name, "mbmem") &&
		    !eq(dev->d_name, "mbio") &&
		    !eq(dev->d_name, "vme16d16") &&
		    !eq(dev->d_name, "vme24d16")) {
			(void)sprintf(errbuf,
			    "unknown bus type `%s' for nexus connection on %s",
			    dev->d_name, conftypename);
			yyerror(errbuf);
		}

	case CONFTYPE_MMAX:
		yyerror("don't grok 'nexus' on mmax -- try 'slot'.");
		break;
        case CONFTYPE_SUN3:
        case CONFTYPE_SUN4:
		if (!eq(dev->d_name, "virtual") &&
		    !eq(dev->d_name, "obmem") &&
		    !eq(dev->d_name, "obio") &&
		    !eq(dev->d_name, "mbmem") &&
		    !eq(dev->d_name, "mbio") &&
		    !eq(dev->d_name, "vme16d16") &&
		    !eq(dev->d_name, "vme24d16") &&
                    !eq(dev->d_name, "vme32d16") &&
		    !eq(dev->d_name, "vme16d32") &&
		    !eq(dev->d_name, "vme24d32") &&
		    !eq(dev->d_name, "vme32d32")) {
			(void)sprintf(errbuf,
			    "unknown bus type `%s' for nexus connection on %s",
			    dev->d_name, conftypename);
			yyerror(errbuf);
		}
		break;
	case CONFTYPE_MIPSY:
	case CONFTYPE_MIPS:
		if (!eq(dev->d_name, "vme") && !eq(dev->d_name, "mbii"))
			yyerror("only vme's and mbii's should be connected to the nexus");
		if (num != QUES)
			yyerror("can't give specific nexus numbers");
		break;
	case CONFTYPE_LUNA88K:
		if (!eq(dev->d_name, "obio") && !eq(dev->d_name, "obmem") &&
				!eq(dev->d_name, "xp"))
			yyerror("only obio's, obmem's and xp's should be connected to the nexus");
		break;
	}
}

/*
 * make certain that this is a reasonable type of thing to connect to a slot
 */

check_slot(dev, num)
	register struct device *dev;
	int num;
{

	switch (conftype) {

	case CONFTYPE_MMAX:
		if (!eq(dev->d_name, "emc"))
			yyerror("only emc's plug into backplane slots.");
		if (num == QUES)
			yyerror("specific slot numbers must be given");
		break;

	case CONFTYPE_SQT:
		if (!eq(dev->d_name, "mbad") &&
		    !eq(dev->d_name, "zdc") &&
		    !eq(dev->d_name, "sec")) {
			(void)sprintf(errbuf,
			    "unknown bus type `%s' for slot on %s",
			    dev->d_name, conftypename);
			yyerror(errbuf);
		}
		break;

        case CONFTYPE_LUNA88K:
		if (!eq(dev->d_name, "obio") && !eq(dev->d_name, "obmem") &&
				!eq(dev->d_name, "xp"))
			yyerror("only obio's, obmem's and xp's should be connected to the nexus");
		break;

	default:
		yyerror("don't grok 'slot' for this conftype -- try 'nexus'.");
		break;
	}
}

/*
 * bi_info gives the magic number used to construct the token for
 * the autoconf code.  bi_max is the maximum value (across all
 * machine types for a given architecture) that a given "bus 
 * type" can legally have.
 */
struct bus_info {
	char    *bi_name;
	u_short bi_info;
	u_int   bi_max;
};

struct bus_info sun2_info[] = {
	{ "virtual",    0x0001, (1<<24)-1 },
	{ "obmem",      0x0002, (1<<23)-1 },
	{ "obio",       0x0004, (1<<23)-1 },
	{ "mbmem",      0x0010, (1<<20)-1 },
	{ "mbio",       0x0020, (1<<16)-1 },
	{ "vme16d16",   0x0100, (1<<16)-1 },
	{ "vme24d16",   0x0200, (1<<24)-(1<<16)-1 },
	{ (char *)0,    0,      0 }
};

struct bus_info sun3_info[] = {
	{ "virtual",    0x0001, (1<<32)-1 },
	{ "obmem",      0x0002, (1<<32)-1 },
	{ "obio",       0x0004, (1<<21)-1 },
	{ "vme16d16",   0x0100, (1<<16)-1 },
	{ "vme24d16",   0x0200, (1<<24)-(1<<16)-1 },
	{ "vme32d16",   0x0400, (1<<32)-(1<<24)-1 },
	{ "vme16d32",   0x1000, (1<<16) },
	{ "vme24d32",   0x2000, (1<<24)-(1<<16)-1 },
	{ "vme32d32",   0x4000, (1<<32)-(1<<24)-1 },
	{ (char *)0,    0,      0 }
};

struct bus_info sun4_info[] = {
	{ "virtual",    0x0001, 0xffffffff },
	{ "obmem",      0x0002, 0xffffffff },
	{ "obio",       0x0004, 0xffffffff },
	{ "vme16d16",   0x0100, (1<<16)-1 },
	{ "vme24d16",   0x0200, (1<<24)-(1<<16)-1 },
	{ "vme32d16",   0x0400, 0xfeffffff },
	{ "vme16d32",   0x1000, (1<<16) },
	{ "vme24d32",   0x2000, (1<<24)-(1<<16)-1 },
	{ "vme32d32",   0x4000, 0xfeffffff },
	{ (char *)0,    0,      0 }
};

bus_encode(addr, dp)
        u_int addr;
	register struct device *dp;
{
	register char *busname;
	register struct bus_info *bip;
	register int num;

	if (conftype == CONFTYPE_SUN2)
		bip = sun2_info;
	else if (conftype == CONFTYPE_SUN3)
		bip = sun3_info;
	else if (conftype == CONFTYPE_SUN4)
		bip = sun4_info;
	else {
		yyerror("bad conftype type for bus_encode");
		exit(1);
	}

        if (dp->d_conn == TO_NEXUS || dp->d_conn == 0) {
		yyerror("bad connection");
		exit(1);
	}

        busname = dp->d_conn->d_name;
        num = dp->d_conn->d_unit;

        for (; bip->bi_name != 0; bip++)
                if (eq(busname, bip->bi_name))
                        break;

        if (bip->bi_name == 0) {
                (void)sprintf(errbuf, "bad bus type '%s' for conftype %s",
                        busname, conftypename);
                yyerror(errbuf);
        } else if (addr > bip->bi_max) {
                (void)sprintf(errbuf,
                        "0x%x exceeds maximum address 0x%x allowed for %s",
                        addr, bip->bi_max, busname);
                yyerror(errbuf);
        } else {
                dp->d_bus = bip->bi_info;       /* set up bus type info */
                if (num != QUES)
                        /*
                         * Set up cpu type since the connecting
                         * bus type is not wildcarded.
                         */
                        dp->d_mach = num;
        }
}
#line 693 "y.tab.c"
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 4:
#line 230 "config.y"
 { newdev(&cur); }
break;
case 6:
#line 234 "config.y"
 { do_trace = !do_trace; }
break;
case 9:
#line 242 "config.y"
 {
		if (!strcmp(yyvsp[0].str, "vax")) {
			conftype = CONFTYPE_VAX;
			conftypename = "vax";
		} else if (!strcmp(yyvsp[0].str, "sun")) {
			/* default to Sun 3 */
			conftype = CONFTYPE_SUN3;
			conftypename = "sun3";
		} else if (!strcmp(yyvsp[0].str, "sun2")) {
			conftype = CONFTYPE_SUN2;
			conftypename = "sun2";
		} else if (!strcmp(yyvsp[0].str, "sun3")) {
			conftype = CONFTYPE_SUN3;
			conftypename = "sun3";
		} else if (!strcmp(yyvsp[0].str, "sun4")) {
			conftype = CONFTYPE_SUN4;
			conftypename = "sun4";
		} else if (!strcmp(yyvsp[0].str, "romp")) {
			conftype = CONFTYPE_ROMP;
			conftypename = "romp";
		} else if (!strcmp(yyvsp[0].str, "ca")) {
			conftype = CONFTYPE_ROMP;
			conftypename = "ca";
		} else if (!strcmp(yyvsp[0].str, "mmax")) {
			conftype = CONFTYPE_MMAX;
			conftypename = "mmax";
		} else if (!strcmp(yyvsp[0].str, "sqt")) {
			conftype = CONFTYPE_SQT;
			conftypename = "i386";	/* assume SYMMETRY */
		} else if (!strcmp(yyvsp[0].str, "i")) {
			conftype = CONFTYPE_I386;
			conftypename = "i386";
		} else if (!strcmp(yyvsp[0].str, "i386")) {
			conftype = CONFTYPE_I386;
			conftypename = "i386";
		} else if (!strcmp(yyvsp[0].str, "ix")) {
			conftype = CONFTYPE_IX;
			conftypename = "ix";
		} else if (!strcmp(yyvsp[0].str, "mipsy")) {
			conftype = CONFTYPE_MIPSY;
			conftypename = "mipsy";
		} else if (!strcmp(yyvsp[0].str, "mips")) {
			conftype = CONFTYPE_MIPS;
			conftypename = "mips";
		} else if (!strcmp(yyvsp[0].str, "i860")) {
			conftype = CONFTYPE_I860;
			conftypename = "i860";
		} else if (!strcmp(yyvsp[0].str, "luna88k")) {
			conftype = CONFTYPE_LUNA88K;
			conftypename = "luna88k";
		} else if (!strcmp(yyvsp[0].str, "mac2")) {
			conftype = CONFTYPE_MAC2;
			conftypename = "mac2";
		} else if (!strcmp(yyvsp[0].str, "pc532")) {
			conftype = CONFTYPE_PC532;
			conftypename = "ns532";
		} else
			yyerror("Unknown conftype type");
	      }
break;
case 10:
#line 302 "config.y"
 {
		struct platform *pp =
		    (struct platform *)malloc(sizeof (struct platform));
		pp->name = ns(yyvsp[0].str);
		pp->next = platform;
		platform = pp;
		free(temp_id);
	      }
break;
case 13:
#line 315 "config.y"
 { ident = ns(yyvsp[0].str); }
break;
case 16:
#line 325 "config.y"
 { mkconf(yyvsp[0].str); }
break;
case 19:
#line 336 "config.y"
 {
		struct opt *op = (struct opt *)malloc(sizeof (struct opt));
		op->op_name = ns(yyvsp[0].str);
		op->op_next = (struct opt *) 0;
		op->op_value = 0;
		if (opt == (struct opt *) 0)
			opt = op;
		else
			opt_tail->op_next = op;
		opt_tail = op;
		free(temp_id);
	      }
break;
case 20:
#line 349 "config.y"
 {
		struct opt *op = (struct opt *)malloc(sizeof (struct opt));
		op->op_name = ns(yyvsp[-2].str);
		op->op_next = (struct opt *) 0;
		op->op_value = ns(yyvsp[0].str);
		if (opt == (struct opt *) 0)
			opt = op;
		else
			opt_tail->op_next = op;
		opt_tail = op;
		free(temp_id);
		if (val_id)
			free(val_id);
	      }
break;
case 21:
#line 366 "config.y"
 { yyval.str = val_id = ns(yyvsp[0].str); }
break;
case 22:
#line 368 "config.y"
 { char nb[16];
	          (void) sprintf(nb, "%u", yyvsp[0].val);
	      	  yyval.str = val_id = ns(nb);
	      }
break;
case 23:
#line 373 "config.y"
 { yyval.str = val_id = ns(""); }
break;
case 24:
#line 378 "config.y"
 { yyval.str = temp_id = ns(yyvsp[0].str); }
break;
case 27:
#line 389 "config.y"
 {
		struct opt *op = (struct opt *)malloc(sizeof (struct opt));
		op->op_name = ns(yyvsp[-2].str);
		op->op_next =  (struct opt *) 0;
		op->op_value = ns(yyvsp[0].str);
		if (mkopt == (struct opt *) 0)
			mkopt = op;
		else
			mkopt_tail->op_next = op;
		mkopt_tail = op;
		free(temp_id);
		if (val_id)
			free(val_id);
	      }
break;
case 28:
#line 406 "config.y"
 { yyval.str = ns("uba"); }
break;
case 29:
#line 408 "config.y"
 { yyval.str = ns("mba"); }
break;
case 30:
#line 410 "config.y"
 {
		if (conftype != CONFTYPE_SUN2 && conftype != CONFTYPE_SUN3
		    && conftype != CONFTYPE_SUN4)
			yyerror("wrong conftype type for vme16d16");
		yyval.str = ns("vme16d16");
		}
break;
case 31:
#line 417 "config.y"
 {
		if (conftype != CONFTYPE_SUN2 && conftype != CONFTYPE_SUN3
		    && conftype != CONFTYPE_SUN4)
			yyerror("wrong conftype type for vme24d16");
			yyval.str = ns("vme24d16");
		}
break;
case 32:
#line 424 "config.y"
 {
		if (conftype != CONFTYPE_SUN3 && conftype != CONFTYPE_SUN4)

                        yyerror("wrong conftype type for vme32d16");
                yyval.str = ns("vme32d16");
                }
break;
case 33:
#line 431 "config.y"
 {
                if (conftype != CONFTYPE_SUN3  && conftype != CONFTYPE_SUN4)
                        yyerror("wrong conftype type for vme16d32");
                yyval.str = ns("vme16d32");
                }
break;
case 34:
#line 437 "config.y"
 {
		if (conftype != CONFTYPE_SUN3 && conftype != CONFTYPE_SUN4)
			yyerror("wrong conftype type for vme24d32");
		yyval.str = ns("vme24d32");
		}
break;
case 35:
#line 443 "config.y"
 {
		if (conftype != CONFTYPE_SUN3 && conftype != CONFTYPE_SUN4)
			yyerror("wrong conftype type for vme32d32");
		yyval.str = ns("vme32d32");
		}
break;
case 36:
#line 449 "config.y"
 {
		if (conftype != CONFTYPE_MIPSY && conftype != CONFTYPE_MIPS)
			yyerror("wrong conftype type for vme");
			yyval.str = ns("vme");
		}
break;
case 37:
#line 455 "config.y"
 {
		if (conftype != CONFTYPE_MIPSY && conftype != CONFTYPE_MIPS)
			yyerror("wrong conftype type for mbii");
			yyval.str = ns("mbii");
		}
break;
case 38:
#line 461 "config.y"
 { yyval.str = ns(yyvsp[0].str); }
break;
case 39:
#line 466 "config.y"
 { cur.d_type = DEVICE; }
break;
case 40:
#line 468 "config.y"
 { cur.d_type = MASTER; }
break;
case 41:
#line 470 "config.y"
 { cur.d_dk = 1; cur.d_type = DEVICE; }
break;
case 42:
#line 473 "config.y"
 { cur.d_type = DEVICE; }
break;
case 43:
#line 475 "config.y"
 { cur.d_type = CONTROLLER; }
break;
case 44:
#line 477 "config.y"
 {
		cur.d_name = yyvsp[0].str;
		cur.d_type = PSEUDO_DEVICE;
		}
break;
case 45:
#line 482 "config.y"
 {
		cur.d_name = yyvsp[-1].str;
		cur.d_type = PSEUDO_DEVICE;
		cur.d_slave = yyvsp[0].val;
		}
break;
case 46:
#line 490 "config.y"
 {
		cur.d_name = yyvsp[-1].str;
		if (eq(yyvsp[-1].str, "mba"))
			seen_mba = 1;
		else if (eq(yyvsp[-1].str, "uba"))
			seen_uba = 1;
		else if (eq(yyvsp[-1].str, "mbii"))
			seen_mbii = 1;
		else if (eq(yyvsp[-1].str, "vme"))
			seen_vme = 1;
		cur.d_unit = yyvsp[0].val;
		}
break;
case 47:
#line 505 "config.y"
 { init_dev(&cur); }
break;
case 50:
#line 515 "config.y"
 {
		if (eq(cur.d_name, "mba") || eq(cur.d_name, "uba")
		    || eq(cur.d_name, "mbii") || eq(cur.d_name, "vme")) {
			(void) sprintf(errbuf,
			    "%s must be connected to a nexus", cur.d_name);
			yyerror(errbuf);
		}
		cur.d_conn = connect(yyvsp[-1].str, yyvsp[0].val);
		if (conftype == CONFTYPE_SQT)
			dev_param(&cur, "index", cur.d_unit);
		}
break;
case 51:
#line 528 "config.y"
 { 
		check_slot(&cur, yyvsp[0].val);
		cur.d_addr = yyvsp[0].val;
		cur.d_conn = TO_SLOT; 
		 }
break;
case 52:
#line 534 "config.y"
 { check_nexus(&cur, yyvsp[0].val); cur.d_conn = TO_NEXUS; }
break;
case 55:
#line 544 "config.y"
 {
		cur.d_addr = yyvsp[0].val;
                if (conftype == CONFTYPE_SUN2 || conftype == CONFTYPE_SUN3
		    || conftype == CONFTYPE_SUN4)
			bus_encode(yyvsp[0].val, &cur);
		if (conftype == CONFTYPE_SQT) {
			dev_param(&cur, "csr", yyvsp[0].val);
		}
		}
break;
case 56:
#line 554 "config.y"
 {
			cur.d_drive = yyvsp[0].val;
			if (conftype == CONFTYPE_SQT) {
				dev_param(&cur, "drive", yyvsp[0].val);
			}
		}
break;
case 57:
#line 561 "config.y"
 {
		if (cur.d_conn != 0 && cur.d_conn != TO_NEXUS &&
		    cur.d_conn->d_type == MASTER)
			cur.d_slave = yyvsp[0].val;
		else
			yyerror("can't specify slave--not to master");
		}
break;
case 58:
#line 570 "config.y"
 { cur.d_addrmod = yyvsp[0].val; }
break;
case 59:
#line 573 "config.y"
 {
		if ((cur.d_conn != 0) && (cur.d_conn != TO_SLOT) &&
			(cur.d_conn->d_type == CONTROLLER)) {
			cur.d_addr = yyvsp[0].val; 
		}
		else {
			yyerror("device requires controller card");
		    }
		}
break;
case 60:
#line 583 "config.y"
 {
		cur.d_flags = yyvsp[0].val;
		if (conftype == CONFTYPE_SQT) {
			dev_param(&cur, "flags", yyvsp[0].val);
		}
	      }
break;
case 61:
#line 590 "config.y"
 { 
		 if (conftype != CONFTYPE_SQT)
			yyerror("bin specification only valid on Sequent Balance");
		 if (yyvsp[0].val < 1 || yyvsp[0].val > 7)  
			yyerror("bogus bin number");
		 else {
			cur.d_bin = yyvsp[0].val;
			dev_param(&cur, "bin", yyvsp[0].val);
		}
	       }
break;
case 62:
#line 601 "config.y"
 {
		if (conftype != CONFTYPE_SQT)
			yyerror("bad device spec");
		dev_param(&cur, yyvsp[-1].str, yyvsp[0].val);
		}
break;
case 64:
#line 611 "config.y"
 { yyval.val = -(yyvsp[0].val); }
break;
case 65:
#line 616 "config.y"
 { cur.d_pri = 0; }
break;
case 66:
#line 618 "config.y"
 { cur.d_pri = yyvsp[0].val; }
break;
case 67:
#line 620 "config.y"
 { cur.d_pri = yyvsp[-1].val; }
break;
case 68:
#line 622 "config.y"
 { cur.d_pri = yyvsp[0].val; }
break;
case 70:
#line 628 "config.y"
 { cur.d_vec = yyvsp[0].lst; }
break;
case 71:
#line 633 "config.y"
 {
		struct idlst *a = (struct idlst *)malloc(sizeof(struct idlst));
		a->id = yyvsp[0].str; a->id_next = 0; yyval.lst = a;
		a->id_vec = 0;
		}
break;
case 72:
#line 638 "config.y"

		{
		struct idlst *a = (struct idlst *)malloc(sizeof(struct idlst));
	        a->id = yyvsp[-1].str; a->id_next = yyvsp[0].lst; yyval.lst = a;
		a->id_vec = 0;
		}
break;
case 73:
#line 645 "config.y"
 {
		struct idlst *a = (struct idlst *)malloc(sizeof(struct idlst));
		a->id_next = 0; a->id = yyvsp[-1].str; yyval.lst = a;
		a->id_vec = yyvsp[0].val;
		}
break;
case 74:
#line 651 "config.y"
 {
		struct idlst *a = (struct idlst *)malloc(sizeof(struct idlst));
		a->id_next = yyvsp[0].lst; a->id = yyvsp[-2].str; yyval.lst = a;
		a->id_vec = yyvsp[-1].val;
		}
break;
#line 1283 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
