;;
;; Default elisp code for jkp's pc532
;;

;; gnmhist from tree dired package

(autoload 'read-with-history-in "gmhist")
(autoload 'read-file-name-with-history-in "gmhist")
(autoload 'gmhist-make-magic "gmhist")

;; dired-extra from tree dired

(autoload 'dired-extra-startup "dired-extra")

;; calendar package

(autoload 'holidays "holidays"
  "Prepare a list of holidays in the previous, present, and next months." t)
(autoload 'calendar "calendar"
  "Display a three-month calendar window." t)
(autoload 'diary "diary"
  "Display a window of diary entries." t)

;; The following lines can be included or omitted, as you prefer

;;(setq mark-holidays-in-calendar t)
;;(setq all-hebrew-calendar-holidays t)
;;(setq all-islamic-calendar-holidays t)
;;(setq all-christian-calendar-holidays t)
;;(setq diary-list-include-blanks t)
;;(setq nongregorian-diary-marking-hook 'mark-hebrew-diary-entries)
;;(setq mark-diary-entries-hook 'mark-included-diary-files)
;;(setq nongregorian-diary-listing-hook 'list-hebrew-diary-entries)
;;(setq list-diary-entries-hook
;;      '(include-other-diary-files
;;        (lambda nil
;;          (setq diary-entries-list
;;                (sort diary-entries-list 'diary-entry-compare)))))

;; NOTE!! Change some day to not override user's hook
;; Use the 'fancy' diary buffer'
(setq diary-display-hook 'fancy-diary-display)
;; Use the include facility and sorted files
(setq list-diary-entries-hook
      '(include-other-diary-files
        (lambda nil
          (setq diary-entries-list
                (sort diary-entries-list 'diary-entry-compare)))))
(setq mark-diary-entries-hook 'mark-included-diary-files)

;; display the diary entries automagically

(setq view-diary-entries-initially t)

;; mark the diary entries in the calendar
;; this takes too much time, omit it

;;(setq mark-diary-entries-in-calendar t)

;; we don't want holidays, as they generally don't apply in Finland anyway

(setq holidays-in-diary-buffer nil)

;; show diary entries a couple of days in advance

(setq number-of-diary-entries [3 2 2 2 2 5 4])

;; use European format (day first, then month)

(setq european-calendar-style t)

;; Appt package to be used with calendar
;; Probably doesn't work in emacs 18.57

(autoload 'appt-make-list "appt" nil t)
;;(setq list-diary-entries-hook 
;;;    (list 'appt-make-list 'prepare-fancy-diary-buffer))

;; crypt.el from tut.cs.ohio-state.edu archive misc/crypt.el.Z

(require 'crypt)

;; texinfo 2

(load-library "texinfo")

;; our info

(define-key global-map "i" 'our-info)

;;
;; our own info file for personal notes
;;
(defun our-info ()
  "Read jkp's & viu's own info file"
  (interactive)
  (info)
  (Info-goto-node "(~jkp/lib/info)"))

;; the game of gomoku

(require 'gomoku)

;; tar package

(setq auto-mode-alist (cons '("\\.tar$" . tar-mode) auto-mode-alist))
(autoload 'tar-mode "tar-mode")

;; c++ mode

(setq auto-mode-alist (cons '("\\.C$" . c++-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.cc$" . c++-mode) auto-mode-alist))
(autoload 'c++-mode "c++-mode")

;; calc 1.07

(autoload 'calc             "calc-1.07/calc.elc"     "Calculator Mode" t)
(autoload 'calc-extensions  "calc-1.07/calc-ext.elc" nil)
(autoload 'quick-calc       "calc-1.07/calc.elc"     "Quick Calculator" t)
(autoload 'full-calc        "calc-1.07/calc.elc"     "Full-screen Calculator" t)
(autoload 'calc-keypad      "calc-1.07/calc.elc"     "X windows Calculator" t)
(autoload 'calc-eval        "calc-1.07/calc.elc"     "Use Calculator from Lisp")
(autoload 'calc-grab-region "calc-1.07/calc-ext.elc" nil t)
(autoload 'defmath          "calc-1.07/calc-ext.elc" nil t t)

;; keyboard macro editor from the calc 1.07 package

(autoload 'edit-kbd-macro      "calc-1.07/macedit.elc" "Edit Keyboard Macro" t)
(autoload 'edit-last-kbd-macro "calc-1.07/macedit.elc" "Edit Keyboard Macro" t)
(autoload 'read-kbd-macro      "calc-1.07/macedit.elc" "Read Keyboard Macro" t)

;; info-simulator for texinfo

(autoload 'para-mode "para"
  "Hypertext-like extension of Texinfo.
Provides editing and Info-like movement commands for Texinfo files."
t nil)

;; less mode

(autoload 'less-mode "less-mode"
  "Less emulation" t nil)

;; asm mode

(autoload 'asm-mode "asm-mode"
  "Edit assembler files" t nil)
(setq auto-mode-alist (cons '("\\.s$" . asm-mode) auto-mode-alist))

;; archive mode

(autoload 'archive-mode "archive" nil t)

;; bison mode

(autoload 'bison-mode "bison-mode" nil t)

(setq auto-mode-alist (cons '("\\.y$" . bison-mode) auto-mode-alist))

;; boss

(autoload 'boss-has-come "boss" nil t)

;; c-comment

(autoload 'c-comment "c-comment" nil t)

;; c-style

(autoload 'set-c-style "c-style.el" nil t)

;; cobol mode

(autoload 'cobol-mode "cobol" nil t)

;; dvorak keyboard

(autoload 'dvorak-mode "dvorak" nil t)

;; fast apropos - whoops, this is broken

;;(autoload 'fast-apropos "fast-apropos" nil t)
;;(autoload 'fast-command-apropos "fast-apropos" nil t)
;;(autoload 'super-apropos "fast-apropos" nil t)
;;(define-key help-map "a" 'fast-command-apropos)

;; tetris

(setq kanji-flag nil)
(autoload 'getris "getris" nil t)

;;; LaTeXinfo

(setq latexinfo-formats-directory
      "/u/gnu/emacs-18.57/lisp/local/latexinfo")
;;      (expand-file-name (getenv "LATEXINFO")))

(setq load-path 
      (cons
       latexinfo-formats-directory
       load-path))

(autoload 'get-latexinfo-node "get-node"
	  "Get help on a LaTeXinfo topic" t)

(define-key help-map "g" 'get-latexinfo-node)

(autoload 'latexinfo-format-buffer "latexinfo"
	  "Format a buffer for LaTeXinfo" t)

(autoload 'latexinfo-mode "latexinfomd"
	  "An editing for LaTeXinfo files" t)

(autoload 'nodify-file "nodify"
	  "Create nodes structure for a LaTeXinfo file." t)

(autoload 'tex-to-latexinfo "tolatexinfo"
	  "Convert a buffer from TeXinfo to LaTeXinfo" t)

;; generic code mode

(autoload 'generic-code-mode "gener-code" nil t)

;; add these to your .emacs for msdos-mode

;(setq find-file-hooks (cons 'read-msdos find-file-hooks))
;(setq write-file-hooks (cons 'write-msdos write-file-hooks))

(autoload 'read-msdos "msdos" nil t)
(autoload 'write-msdos "msdos" nil t)

;; sql mode

(setq auto-mode-alist (append (list (cons "\\.sql$" 'sql-mode))
                               auto-mode-alist))
(autoload 'sql-mode "sql" nil t)

;; perl mode

(setq auto-mode-alist (append (list (cons "\\.pl$" 'perl-mode))
                               auto-mode-alist))
(autoload 'perl-mode "perl" nil t)

;; pascal mode

(setq auto-mode-alist (append (list (cons "\\.p$" 'pascal-mode))
                               auto-mode-alist))
(setq auto-mode-alist (append (list (cons "\\.pas$" 'pascal-mode))
                               auto-mode-alist))
(autoload 'pascal-mode "pascal" nil t)
