;;; With this style loaded, & is a special character for the tabular
;;; environments.  Use \& if you want to insert an & .
(put '& 'latexinfo-format 'latexinfo-format-&)
(defun latexinfo-format-& ()
  (latexinfo-parse-noarg)
  (insert "&"))


;; Math tabular environments are ignored.
(put 'displaymath 'latexinfo-format 'latexinfo-format-displaymath)
(put 'displaymath 'latexinfo-end 'latexinfo-discard-command)
(defun latexinfo-format-displaymath ()
  (delete-region latexinfo-command-start
		 (progn (re-search-forward "\\\\end[ {]displaymath[ }\n]")
			(point))))

(put 'equation 'latexinfo-format 'latexinfo-format-equation)
(put 'equation 'latexinfo-end 'latexinfo-discard-command)
(defun latexinfo-format-equation ()
  (delete-region latexinfo-command-start
		 (progn (re-search-forward "\\\\end[ {]equation[ }\n]")
			(point))))

(put 'eqnarray 'latexinfo-format 'latexinfo-format-eqnarray)
(put 'eqnarray 'latexinfo-end 'latexinfo-discard-command)
(defun latexinfo-format-eqnarray ()
  (delete-region latexinfo-command-start
		 (progn (re-search-forward "\\\\end[ {]eqnarray[ }\n]")
			(point))))

(put 'array 'latexinfo-format 'latexinfo-format-array)
(put 'array 'latexinfo-end 'latexinfo-discard-command)
(defun latexinfo-format-array ()
  (delete-region latexinfo-command-start
		 (progn (re-search-forward "\\\\end[ {]array[ }\n]")
			(point))))



;;; The tabular environment
(put 'tabular 'latexinfo-format 'latexinfo-format-tabular)
(put 'tabular 'latexinfo-end 'latexinfo-end-tabular)
(defun latexinfo-format-tabular ()
  (latexinfo-push-stack 'tabular nil)
  (latexinfo-discard-line-with-args))

(defun latexinfo-end-tabular ()
  (latexinfo-discard-command)
  (let ((stacktop
	 (latexinfo-pop-stack 'tabular)))
    (latexinfo-do-tabular (nth 1 stacktop))))

(put 'hline 'latexinfo-format 'latexinfo-format-hline)
(defun latexinfo-format-hline ()
    (let ((dashes (make-string fill-column ?-)))
      (latexinfo-discard-line-with-args)
      (insert dashes "\n")))
  
(defun latexinfo-do-tabular (from)
  (let ((end (point)))
    (save-excursion
      (goto-char from)
      (while (search-forward "&" end t)
	(if (save-excursion
	      (bobp)
	      (forward-char -2)
	      (not (looking-at "\\\\")))
	    (progn
	      (delete-char -1)
	      (insert " ")
	      )))
      (goto-char from)
      (replace-regexp "\\\\\\\\$" "")
      )))

