/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChartApplet;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.LineChartApplet;
import com.objectplanet.chart.NonFlickerPanel;
import com.objectplanet.chart.PieChartApplet;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public abstract class ChartApplet
extends Applet
implements Runnable,
ItemListener,
MouseMotionListener {
    private String[] parameters_all = new String[]{"seriescount", "samplevalues", "charttitle", "samplecolors", "legendcolors", "valuelabelson", "legendon", "labeldelimiter", "samplelabels", "serieslabels", "samplelabelcolors", "serieslabelcolors", "legendposition", "automaticrefreshtime", "background", "foreground", "chartbackground", "chartforeground", "titlefont", "font", "legendfont", "3dmodeon", "3ddepth", "legendlabels", "graphinsets", "gridadjustmenton", "rangedecimalcount", "rangedecimalcount_2", "valuelineson", "maxvaluelineCount", "sampleaxisrange", "defaultgridlineson", "gridlines", "gridlinescolor", "defaultgridlinescolor", "gridlinecolors", "valuelinescolor", "rangelabelsoff", "rangelabelsoff_2", "rangelabelfont", "rangelabelprefix", "rangelabelprefix_2", "rangelabelpostfix", "rangelabelpostfix_2", "sampleaxislabel", "rangeaxislabel", "rangeaxislabel_2", "sampleaxislabelfont", "rangeaxislabelfont", "visiblesamples", "rangeaxislabelangle", "rangeaxislabelangle_2", "sampleaxislabelangle", "valuelabelangle", "barlabelangle", "samplelabelangle", "rangeposition", "rangeposition_2", "rangeon", "rangeon_2", "rangeadjusterposition", "rangeadjusterposition_2", "rangeadjusted_1", "rangeadjusted_2", "rangecolor", "rangecolor_2", "sampledecimalcount", "valuelabelprefix", "valuelabelpostfix", "printasbitmap", "floatinglabelfont", "floatingonlegendoff", "urltarget", "samplescrolleron", "rangestep", "rangestep_2", "range", "range_2", "lowerrange", "lowerrange_2", "rangeadjusteron", "rangeadjusteron_2", "doublebufferingoff", "samplelabelselectioncolor", "singleclickurlon"};
    private String[] parameters_series = new String[]{"samplevalues_", "valuelabelprefix_", "valuelabelpostfix_", "seriesrange_", "valuelabelson_", "sampledecimalcount_"};
    private String[] parameters_range = new String[]{"rangestep", "rangestep_2", "range", "range_2", "lowerrange", "lowerrange_2", "rangeadjusteron", "rangeadjusteron_2"};
    public Chart theChart = this.createChart(null);
    protected String labelDelimiter = ",";
    private Applet parentApplet;
    private Hashtable overlayCharts;
    private Thread refreshThread;
    private Hashtable targets;
    private static Cursor HAND_CURSOR = new Cursor(12);
    private static Cursor POINT_CURSOR = new Cursor(0);
    protected int sampleCountRead;
    protected int seriesCountRead;
    private String parameterPrefix;
    private double[] rangeStep = new double[2];
    private int automaticRefreshTime;
    private Hashtable urlList;
    private Hashtable urlTargetList;
    private boolean singleClickURLOn;
    private int lastSelectedSample;
    private int lastSelectedSeries;
    private long lastSelectedTime;
    private static final int DOUBLE_CLICK_TIME = 350;
    private boolean sampleCountSet;

    public void stop() {
        if (this.refreshThread != null) {
            this.refreshThread.stop();
            this.refreshThread = null;
        }
    }

    protected Color[] getColorValues(String string) {
        Color[] colorArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            colorArray = new Color[stringTokenizer.countTokens()];
            int n = 0;
            while (n < colorArray.length) {
                if (stringTokenizer.hasMoreTokens()) {
                    colorArray[n] = ChartApplet.createColor(stringTokenizer.nextToken().trim());
                }
                ++n;
            }
        }
        return colorArray;
    }

    private URL getSampleURL(int n, int n2, int n3) {
        if (this.urlList == null) {
            return null;
        }
        String string = this.createURLParam("url", n2, n3);
        URL uRL = (URL)this.urlList.get(string);
        if (uRL == null) {
            string = n > 1 ? this.createURLParam("url", n2, -1) : this.createURLParam("url", -1, n3);
            uRL = (URL)this.urlList.get(string);
        }
        if (uRL == null) {
            uRL = (URL)this.urlList.get(this.createURLParam("url", -1, -1));
        }
        return uRL;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ChartSample chartSample = (ChartSample)itemEvent.getItem();
        Chart chart = (Chart)itemEvent.getSource();
        if (itemEvent.getStateChange() == 1 && chartSample != null && chart != null) {
            URL uRL;
            int n = chart.getSeriesCount();
            int n2 = chartSample.getIndex();
            int n3 = chartSample.getSeries();
            long l = System.currentTimeMillis();
            boolean bl = n2 == this.lastSelectedSample && n3 == this.lastSelectedSeries;
            boolean bl2 = false;
            if (this.singleClickURLOn) {
                bl2 = true;
            } else {
                boolean bl3 = bl2 = bl && l - this.lastSelectedTime < 350L;
            }
            if (bl2 && (uRL = this.getSampleURL(n, n3, n2)) != null) {
                String string = this.createURLParam("urltarget", n3, n2);
                String string2 = (String)this.urlTargetList.get(string);
                if (string2 == null) {
                    string = n > 1 ? this.createURLParam("urltarget", n3, -1) : this.createURLParam("urltarget", -1, n2);
                    string2 = (String)this.urlTargetList.get(string);
                }
                if (string2 == null) {
                    string2 = (String)this.urlTargetList.get("urltarget");
                }
                try {
                    AppletContext appletContext = this.getAppletContext();
                    if (appletContext != null) {
                        appletContext.showDocument(uRL, string2);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("Not an applet, could not open url " + uRL);
                }
            }
            this.lastSelectedSample = n2;
            this.lastSelectedSeries = n3;
            this.lastSelectedTime = l;
        }
    }

    static String convertLineBreaks(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (n2 < cArray.length - 1 && cArray[n2] == '\\' && cArray[n2 + 1] == 'n') {
                cArray2[n++] = 10;
                ++n2;
            } else {
                cArray2[n++] = cArray[n2];
            }
            ++n2;
        }
        return new String(cArray2, 0, n);
    }

    public void setParentApplet(Applet applet) {
        if (applet == this) {
            applet = null;
        }
        this.parentApplet = applet;
    }

    public static Color createColor(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.indexOf(",") >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            try {
                return new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (Exception exception) {
                System.out.println("Invalid RGB color: " + string);
            }
        } else if (string.startsWith("#")) {
            try {
                return new Color(Integer.parseInt(string.substring(1, 3), 16), Integer.parseInt(string.substring(3, 5), 16), Integer.parseInt(string.substring(5, 7), 16));
            }
            catch (Exception exception) {
                System.out.println("Invalid hex color: " + string);
            }
        } else {
            if ((string = string.toLowerCase()).equals("black")) {
                return Color.black;
            }
            if (string.equals("blue")) {
                return Color.blue;
            }
            if (string.equals("cyan")) {
                return Color.cyan;
            }
            if (string.equals("darkgray")) {
                return Color.darkGray;
            }
            if (string.equals("gray")) {
                return Color.gray;
            }
            if (string.equals("green")) {
                return Color.green;
            }
            if (string.equals("lightgray")) {
                return Color.lightGray;
            }
            if (string.equals("magenta")) {
                return Color.magenta;
            }
            if (string.equals("orange")) {
                return Color.orange;
            }
            if (string.equals("pink")) {
                return Color.pink;
            }
            if (string.equals("red")) {
                return Color.red;
            }
            if (string.equals("white")) {
                return Color.white;
            }
            if (string.equals("yellow")) {
                return Color.yellow;
            }
            System.out.println("Invalid color name: " + string);
        }
        return null;
    }

    protected abstract Chart createChart(String var1);

    public void start() {
        if (this.automaticRefreshTime > 0) {
            this.refreshThread = new Thread(this);
            this.refreshThread.start();
        }
    }

    protected static Double[] getDoubleValues(String string) {
        Double[] doubleArray = null;
        if (string != null && !string.equals("")) {
            boolean bl = string.trim().startsWith(",");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            doubleArray = new Double[stringTokenizer.countTokens() + (bl ? 1 : 0)];
            int n = bl ? 1 : 0;
            while (n < doubleArray.length) {
                try {
                    doubleArray[n] = new Double(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {}
                ++n;
            }
        }
        return doubleArray;
    }

    protected String[] getStringValues(String string) {
        String[] stringArray = new String[]{};
        if (string != null) {
            String string2 = this.labelDelimiter == null ? "," : this.labelDelimiter;
            int n = 1;
            int n2 = 0;
            while (n2 >= 0) {
                if ((n2 = string.indexOf(string2, n2)) != -1 && n2 != string.length() - 1) {
                    ++n2;
                    ++n;
                    continue;
                }
                if (n2 != string.length() - 1) continue;
                n2 = -1;
            }
            stringArray = new String[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                if (n3 < string.length() && string.charAt(n3) == string2.charAt(0)) {
                    stringArray[n4] = "";
                    ++n3;
                } else {
                    int n5 = string.indexOf(string2, n3 + 1);
                    stringArray[n4] = n5 > 0 ? string.substring(n3, n5).trim() : string.substring(n3).trim();
                    n3 = n5 + 1;
                }
                ++n4;
            }
        }
        return stringArray;
    }

    public void setParameter(String string, String string2) {
        block347: {
            if (string == null) {
                return;
            }
            if (this.theChart == null) {
                throw new IllegalStateException("theChart has not been set");
            }
            if ((string = string.toLowerCase()).equals("width")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        int n = Integer.parseInt(string2.trim());
                        this.setSize(n, this.theChart.getSize().height);
                        this.theChart.setSize(n, this.theChart.getSize().height);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid width: " + string2);
                    }
                }
            } else if (string.equals("height")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        int n = Integer.parseInt(string2.trim());
                        this.setSize(this.theChart.getSize().width, n);
                        this.theChart.setSize(this.theChart.getSize().width, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid height: " + string2);
                    }
                }
            } else if (string.startsWith("samplevalues")) {
                try {
                    int n = 0;
                    if (string.startsWith("samplevalues_")) {
                        n = Integer.parseInt(string.substring(13));
                    }
                    if (string2 != null && string2.trim().length() > 0) {
                        Double[] doubleArray = ChartApplet.getDoubleValues(string2);
                        if (doubleArray != null && n >= 0 && n < this.theChart.getSeriesCount()) {
                            int n2 = this.theChart.getSampleCount();
                            if (!this.sampleCountSet && doubleArray.length > n2) {
                                this.theChart.setSampleCount(doubleArray.length);
                                n2 = doubleArray.length;
                            }
                            int n3 = 0;
                            while (n3 < n2) {
                                if (n3 < doubleArray.length && doubleArray[n3] != null) {
                                    this.theChart.setSampleValue(n, n3, doubleArray[n3]);
                                } else {
                                    ChartSample chartSample = this.theChart.getSample(n, n3);
                                    if (chartSample != null) {
                                        chartSample.clearValue();
                                    }
                                }
                                ++n3;
                            }
                        }
                    } else if (n >= 0 && n < this.theChart.getSeriesCount()) {
                        this.theChart.setSampleValues(n, null);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid " + string + " " + string2);
                }
            } else if (string.equals("samplecount")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.theChart.setSampleCount(Math.max(0, Integer.parseInt(string2.trim())));
                        this.sampleCountSet = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid sampleCount: " + string2);
                    }
                }
            } else if (string.equals("samplecolors")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color[] colorArray = this.getColorValues(string2);
                    this.theChart.setSampleColors(colorArray);
                } else {
                    this.theChart.setSampleColors(null);
                }
            } else if (string.equals("legendcolors")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color[] colorArray = this.getColorValues(string2);
                    this.theChart.setLegendColors(colorArray);
                } else {
                    this.theChart.setLegendColors(null);
                }
            } else if (string.equals("seriescount")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.theChart.setSeriesCount(Math.max(1, Integer.parseInt(string2.trim())));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid seriesCount: " + string2);
                    }
                } else {
                    this.theChart.setSeriesCount(1);
                }
            } else if (string.startsWith("seriesrange_")) {
                try {
                    int n = Integer.parseInt(string.substring(12));
                    if (n < 0 || n >= this.theChart.getSeriesCount()) break block347;
                    if (string2 != null && string2.length() > 0) {
                        try {
                            int n4 = Integer.parseInt(string2.trim());
                            n4 = n4 == 2 ? 1 : 0;
                            this.theChart.setSeriesRange(n, n4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid range index: " + string + " " + string2);
                        }
                        break block347;
                    }
                    this.theChart.setSeriesRange(n, 0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid series index: " + string + " " + string2);
                }
            } else if (string.startsWith("rangestep")) {
                int n = string.equals("rangestep_2") ? 1 : 0;
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.rangeStep[n] = new Double(string2.trim());
                        this.rangeStep[n] = Math.abs(this.rangeStep[n]);
                        this.theChart.setRelativeRange(n, 1.0, this.rangeStep[n]);
                        this.theChart.setLowerRelativeRange(n, 1.0, this.rangeStep[n]);
                        break block347;
                    }
                    this.rangeStep[n] = -1.0;
                    this.theChart.setRelativeRangeIndex(n, 1.0);
                    this.theChart.setLowerRelativeRangeIndex(n, 1.0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid rangeStep: " + string2);
                    this.rangeStep[n] = -1.0;
                    this.theChart.setLowerRelativeRange(1.0);
                }
            } else if (string.equals("range") || string.equals("range_2")) {
                int n = string.equals("range_2") ? 1 : 0;
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setRange(n, new Double(string2.trim()));
                        break block347;
                    }
                    if (this.rangeStep[n] > -1.0) {
                        this.theChart.setRelativeRange(n, 1.0, this.rangeStep[n]);
                        break block347;
                    }
                    this.theChart.setRelativeRangeIndex(n, 1.0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid range: " + string2);
                    if (this.rangeStep[n] != -1.0) {
                        this.theChart.setRelativeRange(n, 1.0, this.rangeStep[n]);
                        break block347;
                    }
                    this.theChart.setRelativeRangeIndex(n, 1.0);
                }
            } else if (string.equals("lowerrange") || string.equals("lowerrange_2")) {
                int n = string.equals("lowerrange_2") ? 1 : 0;
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setLowerRange(n, new Double(string2.trim()));
                        break block347;
                    }
                    if (this.rangeStep[n] != -1.0) {
                        this.theChart.setLowerRelativeRange(n, 1.0, this.rangeStep[n]);
                        break block347;
                    }
                    this.theChart.setLowerRelativeRangeIndex(n, 1.0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid lowerRange: " + string2);
                    if (this.rangeStep[n] > -1.0) {
                        this.theChart.setLowerRelativeRange(n, 1.0, this.rangeStep[n]);
                        break block347;
                    }
                    this.theChart.setLowerRelativeRangeIndex(n, 1.0);
                }
            } else if (string.startsWith("rangeon")) {
                int n;
                int n5 = n = string.equals("rangeon_2") ? 1 : 0;
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setRangeOn(n, string2.trim().equalsIgnoreCase("true"));
                }
            } else if (string.startsWith("rangecolor")) {
                int n;
                int n6 = n = string.equals("rangecolor_2") ? 1 : 0;
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setRangeColor(n, ChartApplet.createColor(string2));
                }
            } else if (string.startsWith("rangeposition")) {
                int n;
                int n7 = n = string.equals("rangeposition_2") ? 1 : 0;
                if (string2 != null && string2.length() > 0) {
                    if ((string2 = string2.trim()).equalsIgnoreCase("right") || string2.equalsIgnoreCase("top")) {
                        this.theChart.setRangePosition(n, 1);
                    } else {
                        this.theChart.setRangePosition(n, 0);
                    }
                }
            } else if (string.startsWith("rangeadjusteron")) {
                int n = string.equals("rangeadjusteron_2") ? 1 : 0;
                this.theChart.setRangeAdjusterOn(n, string2 != null && string2.trim().equalsIgnoreCase("true"));
            } else if (string.startsWith("rangeadjusterposition")) {
                int n;
                int n8 = n = string.equals("rangeadjusterposition_2") ? 1 : 0;
                if (string2 != null && string2.length() > 0) {
                    if ((string2 = string2.trim()).equalsIgnoreCase("right") || string2.equalsIgnoreCase("top")) {
                        this.theChart.setRangeAdjusterPosition(n, 1);
                    } else {
                        this.theChart.setRangeAdjusterPosition(n, 0);
                    }
                }
            } else if (string.startsWith("rangeadjusted_")) {
                int n;
                int n9 = n = string.equals("rangeadjusted_2") ? 1 : 0;
                if (string2 != null && string2.length() > 0) {
                    if (string2.trim().equals("1")) {
                        this.theChart.setRangeAdjusted(n, 0);
                    } else if (string2.trim().equals("2")) {
                        this.theChart.setRangeAdjusted(n, 1);
                    } else {
                        this.theChart.setRangeAdjusted(n, 2);
                    }
                }
            } else if (string.startsWith("rangedecimalcount")) {
                int n = string.equals("rangedecimalcount_2") ? 1 : 0;
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setRangeDecimalCount(n, Integer.parseInt(string2.trim()));
                        break block347;
                    }
                    this.theChart.setRangeDecimalCount(n, 0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid " + string + ": " + string2);
                    this.theChart.setRangeDecimalCount(n, 0);
                }
            } else if (string.equals("labeldelimiter")) {
                this.labelDelimiter = string2 != null && string2.trim().length() > 0 || string2.equals("\t") ? string2 : ",";
            } else if (string.equals("serieslabels")) {
                this.theChart.setSeriesLabels(this.getStringValues(ChartApplet.convertLineBreaks(string2)));
            } else if (string.equals("serieslabelcolors")) {
                Color[] colorArray = this.getColorValues(string2);
                int n = this.theChart.getSeriesCount();
                int n10 = 0;
                while (n10 < n) {
                    if (colorArray != null && n10 < colorArray.length) {
                        this.theChart.setSeriesLabelColor(n10, colorArray[n10]);
                    } else {
                        this.theChart.setSeriesLabelColor(n10, null);
                    }
                    ++n10;
                }
            } else if (string.equals("samplelabels")) {
                string2 = ChartApplet.convertLineBreaks(string2);
                String[] stringArray = this.getStringValues(string2);
                this.theChart.setSampleLabels(stringArray);
            } else if (string.equals("samplelabelcolors")) {
                Color[] colorArray = this.getColorValues(string2);
                int n = Math.max(colorArray != null ? colorArray.length : 0, this.theChart.getSampleCount());
                int n11 = 0;
                while (n11 < n) {
                    if (colorArray != null && n11 < colorArray.length) {
                        this.theChart.setSampleLabelColor(n11, colorArray[n11]);
                    } else {
                        this.theChart.setSampleLabelColor(n11, null);
                    }
                    ++n11;
                }
            } else if (string.equals("samplelabelselectioncolor")) {
                Color color;
                this.theChart.setSampleLabelSelectionColor(null);
                if (string2 != null && string2.trim().length() > 0 && (color = ChartApplet.createColor(string2)) != null) {
                    this.theChart.setSampleLabelSelectionColor(color);
                }
            } else if (string.equals("legendlabels")) {
                this.theChart.setLegendLabels(null);
                if (string2 != null && string2.trim().length() > 0) {
                    String[] stringArray = this.getStringValues(ChartApplet.convertLineBreaks(string2));
                    if (stringArray.length > 1) {
                        this.theChart.setLegendLabels(stringArray);
                    } else if (stringArray.length == 1 && stringArray[0] != null) {
                        if (stringArray[0].trim().equalsIgnoreCase("samplelabels")) {
                            this.theChart.setLegendLabels(this.theChart.getSampleLabels());
                        } else if (stringArray[0].trim().equalsIgnoreCase("serieslabels")) {
                            this.theChart.setLegendLabels(this.theChart.getSeriesLabels());
                        } else {
                            this.theChart.setLegendLabels(stringArray);
                        }
                    }
                }
            } else if (string.startsWith("valuelabelson")) {
                if (string.equals("valuelabelson")) {
                    this.theChart.setValueLabelsOn(-1, string2 != null && string2.trim().equalsIgnoreCase("true"));
                } else if (string.startsWith("valuelabelson_")) {
                    try {
                        int n = Integer.parseInt(string.substring(14));
                        if (n >= 0 && n < this.theChart.getSeriesCount()) {
                            this.theChart.setValueLabelsOn(n, string2 != null && string2.trim().equalsIgnoreCase("true"));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid " + string + " " + string2);
                    }
                }
            } else if (string.startsWith("valuelabelprefix") || string.startsWith("valuelabelpostfix")) {
                this.theChart.setLabel(string, ChartApplet.convertLineBreaks(string2));
            } else if (string.startsWith("sampledecimalcount")) {
                try {
                    int n;
                    if (string.equals("sampledecimalcount")) {
                        if (string2 != null && string2.trim().length() > 0) {
                            this.theChart.setSampleDecimalCount(-1, Integer.parseInt(string2.trim()));
                        } else {
                            this.theChart.setSampleDecimalCount(-1, 0);
                        }
                        break block347;
                    }
                    if (!string.startsWith("sampledecimalcount_") || (n = Integer.parseInt(string.substring(19))) < 0 || n >= this.theChart.getSeriesCount()) break block347;
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setSampleDecimalCount(n, Integer.parseInt(string2.trim()));
                        break block347;
                    }
                    this.theChart.setSampleDecimalCount(n, 0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid " + string + " " + string2);
                }
            } else if (string.equals("charttitle") || string.equals("title")) {
                this.theChart.setTitle(ChartApplet.convertLineBreaks(string2));
                this.theChart.setTitleOn(string2 != null && string2.length() > 0);
            } else if (string.equals("legendon")) {
                this.theChart.setLegendOn(string2 != null && string2.trim().equalsIgnoreCase("true"));
            } else if (string.equals("legendposition")) {
                this.theChart.setLegendPosition(1);
                if (string2 != null && string2.trim().length() > 0) {
                    if (string2.equalsIgnoreCase("right")) {
                        this.theChart.setLegendPosition(1);
                    } else if (string2.equalsIgnoreCase("top")) {
                        this.theChart.setLegendPosition(2);
                    } else if (string2.equalsIgnoreCase("bottom")) {
                        this.theChart.setLegendPosition(3);
                    } else if (string2.equalsIgnoreCase("left")) {
                        this.theChart.setLegendPosition(0);
                    } else {
                        System.out.println("Invalid legendPosition: " + string2);
                    }
                }
            } else if (string.equals("automaticrefreshtime")) {
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.automaticRefreshTime = Math.max(100, Integer.parseInt(string2));
                        break block347;
                    }
                    this.automaticRefreshTime = 3600000;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid automaticRefreshTime: " + string2);
                    this.automaticRefreshTime = 3600000;
                }
            } else if (string.equals("3dmodeon")) {
                this.theChart.set3DModeOn(string2 != null && string2.equalsIgnoreCase("true"));
            } else if (string.equals("3ddepth")) {
                this.theChart.set3DDepth(-1);
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        int n = Integer.parseInt(string2.trim());
                        this.theChart.set3DDepth(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid 3DDepth: " + string2);
                    }
                }
            } else if (string.equals("foreground")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartApplet.createColor(string2);
                    if (color != null) {
                        this.theChart.setForeground(color);
                    } else {
                        this.theChart.setForeground(Color.black);
                    }
                } else {
                    this.theChart.setForeground(Color.black);
                }
            } else if (string.equals("background")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartApplet.createColor(string2);
                    if (color != null) {
                        this.theChart.setBackground(color);
                    } else {
                        this.theChart.setBackground(new Color(231, 221, 231));
                    }
                } else {
                    this.theChart.setBackground(new Color(231, 221, 231));
                }
            } else if (string.equals("chartforeground")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartApplet.createColor(string2);
                    if (color != null) {
                        this.theChart.setChartForeground(color);
                    } else {
                        this.theChart.setChartForeground(Color.black);
                    }
                } else {
                    this.theChart.setChartForeground(Color.black);
                }
            } else if (string.equals("chartbackground")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartApplet.createColor(string2);
                    if (color != null) {
                        this.theChart.setChartBackground(color);
                    } else {
                        this.theChart.setChartBackground(Color.white);
                    }
                } else {
                    this.theChart.setChartBackground(Color.white);
                }
            } else if (string.equals("titlefont")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setFont("titleFont", this.createFont(string2, "Dialog", 1, 14));
                } else {
                    this.theChart.setFont("titleFont", new Font("Dialog", 1, 14));
                }
            } else if (string.equals("font")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setFont(this.createFont(string2, "Arial", 0, 11));
                } else {
                    this.theChart.setFont(new Font("Arial", 0, 11));
                }
            } else if (string.endsWith("font")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setFont(string, this.createFont(string2, "Arial", 0, 11));
                } else {
                    this.theChart.setFont(string, null);
                }
            } else if (string.equals("graphinsets")) {
                if (string2 != null && string2.trim().length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2.trim(), ",");
                    int n = -1;
                    int n12 = -1;
                    int n13 = -1;
                    int n14 = -1;
                    try {
                        if (stringTokenizer.hasMoreTokens()) {
                            n = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            n12 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            n13 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            n14 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        this.theChart.setGraphInsets(n, n12, n13, n14);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid graphinsets: " + string2);
                    }
                } else {
                    this.theChart.setGraphInsets(-1, -1, -1, -1);
                }
            } else if (string.equals("gridadjustmenton")) {
                this.theChart.setGridAdjustmentOn(2, false);
                this.theChart.setGridAdjustmentOn(1, false);
                this.theChart.setGridAdjustmentOn(3, false);
                this.theChart.setGridAdjustmentOn(0, false);
                if (string2 != null && string2.trim().length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken().trim();
                        if (string3.equalsIgnoreCase("top")) {
                            this.theChart.setGridAdjustmentOn(2, true);
                            continue;
                        }
                        if (string3.equalsIgnoreCase("right")) {
                            this.theChart.setGridAdjustmentOn(1, true);
                            continue;
                        }
                        if (string3.equalsIgnoreCase("bottom")) {
                            this.theChart.setGridAdjustmentOn(3, true);
                            continue;
                        }
                        if (!string3.equalsIgnoreCase("left")) continue;
                        this.theChart.setGridAdjustmentOn(0, true);
                    }
                }
            } else if (string.startsWith("urltarget")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.urlTargetList.put(string, string2);
                } else if (string.equals("urltarget")) {
                    this.urlTargetList.put(string, "_self");
                } else {
                    this.urlTargetList.remove(string);
                }
            } else if (string.startsWith("url")) {
                if (string2 != null && string2.trim().length() > 0) {
                    URL uRL = this.createURL(string2);
                    if (uRL != null) {
                        this.urlList.put(string, uRL);
                    } else {
                        this.urlList.remove(string);
                    }
                } else {
                    this.urlList.remove(string);
                }
            } else if (string.equals("singleclickurlon")) {
                this.singleClickURLOn = string2 != null && string2.trim().equalsIgnoreCase("true");
            } else if (string.equals("valuelineson")) {
                this.theChart.setValueLinesOn(string2 != null && string2.trim().equalsIgnoreCase("true"));
            } else if (string.equals("maxvaluelinecount")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.theChart.setMaxValueLineCount(Integer.parseInt(string2.trim()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid maxValueLineCount: " + string2);
                        this.theChart.setMaxValueLineCount(-1);
                    }
                } else {
                    this.theChart.setMaxValueLineCount(-1);
                }
            } else if (string.equals("defaultgridlineson")) {
                if (string2 != null) {
                    String[] stringArray = this.getStringValues(string2);
                    if (stringArray.length < 3) {
                        this.theChart.setDefaultGridLinesOn(stringArray[0].trim().equalsIgnoreCase("true"));
                    } else if (stringArray.length >= 3) {
                        double d = Double.valueOf(stringArray[1]);
                        double d2 = Double.valueOf(stringArray[2]);
                        this.theChart.setDefaultGridLinesOn(stringArray[0].trim().equalsIgnoreCase("true"), d, d2);
                    }
                }
            } else if (string.equals("defaultgridlinescolor")) {
                Color[] colorArray;
                this.theChart.setDefaultGridLinesColor(null);
                if (string2 != null && string2.trim().length() > 0 && (colorArray = this.getColorValues(string2)) != null && colorArray.length > 0 && colorArray[0] != null) {
                    this.theChart.setDefaultGridLinesColor(colorArray[0]);
                }
            } else if (string.equals("gridlines")) {
                Double[] doubleArray;
                this.theChart.setGridLines(null);
                if (string2 != null && (doubleArray = ChartApplet.getDoubleValues(string2)) != null) {
                    double[] dArray = new double[doubleArray.length];
                    int n = 0;
                    while (n < doubleArray.length) {
                        if (doubleArray[n] != null) {
                            dArray[n] = doubleArray[n];
                        }
                        ++n;
                    }
                    this.theChart.setGridLines(dArray);
                }
            } else if (string.equals("gridlinescolor")) {
                Color[] colorArray;
                this.theChart.setGridLinesColor(null);
                if (string2 != null && string2.trim().length() > 0 && (colorArray = this.getColorValues(string2)) != null && colorArray.length > 0 && colorArray[0] != null) {
                    this.theChart.setGridLinesColor(colorArray[0]);
                }
            } else if (string.equals("gridlinecolors")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setGridLineColors(this.getColorValues(string2));
                } else {
                    this.theChart.setGridLineColors(null);
                }
            } else if (string.equals("valuelinescolor")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartApplet.createColor(string2);
                    if (color != null) {
                        this.theChart.setValueLinesColor(color);
                    } else {
                        this.theChart.setValueLinesColor(Color.lightGray);
                    }
                } else {
                    this.theChart.setValueLinesColor(Color.lightGray);
                }
            } else if (string.equals("rangelabelsoff")) {
                this.theChart.setRangeLabelsOn(0, string2 == null || !string2.trim().equalsIgnoreCase("true"));
            } else if (string.equals("rangelabelsoff_2")) {
                this.theChart.setRangeLabelsOn(1, string2 == null || !string2.trim().equalsIgnoreCase("true"));
            } else if (string.equals("sampleaxislabel") || string.equals("rangeaxislabel") || string.equals("rangeaxislabel_2")) {
                this.theChart.setLabel(string, ChartApplet.convertLineBreaks(string2));
            } else if (string.startsWith("rangelabelprefix") || string.startsWith("rangelabelpostfix")) {
                this.theChart.setLabel(string, ChartApplet.convertLineBreaks(string2));
            } else if (string.endsWith("angle") || string.equals("rangeaxislabelangle_2")) {
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setLabelAngle(string, Integer.parseInt(string2));
                        break block347;
                    }
                    this.theChart.setLabelAngle(string, 0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid " + string + ": " + string2);
                }
            } else if (string.equals("samplescrolleron")) {
                this.theChart.setSampleScrollerOn(string2 != null && string2.trim().equalsIgnoreCase("true"));
            } else if (string.equals("sampleaxisrange")) {
                Double[] doubleArray;
                this.theChart.setSampleAxisRange(0.0, 100.0);
                if (string2 != null && string2.trim().length() > 0 && (doubleArray = ChartApplet.getDoubleValues(string2)).length >= 2) {
                    this.theChart.setSampleAxisRange(doubleArray[0] != null ? doubleArray[0] : 0.0, doubleArray[1] != null ? doubleArray[1] : 100.0);
                }
            } else if (string.equals("visiblesamples")) {
                if (string2 != null && string2.length() > 0) {
                    int n = 0;
                    int n15 = -1;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    try {
                        if (stringTokenizer.hasMoreTokens()) {
                            n = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            n15 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid visibleSamples: " + string2);
                    }
                    this.theChart.setVisibleSamples(n, n15);
                } else {
                    this.theChart.setVisibleSamples(0, -1);
                }
            } else if (string.startsWith("printasbitmap")) {
                this.theChart.setPrintAsBitmap(string2 != null && string2.trim().equalsIgnoreCase("true"));
            } else if (string.equals("floatingonlegendoff")) {
                this.theChart.setFloatingOnLegendOn(string2 == null || !string2.trim().equalsIgnoreCase("true"));
            } else {
                if (string.startsWith("legendimage_")) {
                    try {
                        block348: {
                            try {
                                int n = Integer.parseInt(string.substring(string.indexOf("_") + 1));
                                this.theChart.setLegendImage(n, null);
                                if (string2 == null || string2.trim().length() <= 0) break block348;
                                URL uRL = null;
                                Image image = null;
                                try {
                                    uRL = this.getDocumentBase();
                                    image = this.getImage(uRL, string2);
                                }
                                catch (NullPointerException nullPointerException) {
                                    image = this.theChart.loadImage(string2);
                                }
                                if (image != null) {
                                    this.theChart.addImage(string, image);
                                    this.theChart.setLegendImage(n, string);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("Invalid legend index: " + string);
                            }
                            catch (SecurityException securityException) {
                                System.out.println("Security exception, could not load image: " + string2);
                            }
                        }
                        Object var11_73 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_74 = null;
                        throw throwable;
                    }
                }
                if (string.startsWith("targetvalueline")) {
                    Object object;
                    if (this.targets.containsKey(string)) {
                        object = (String)this.targets.remove(string);
                        this.theChart.setTargetValueLine((String)object, 0.0, null, 0);
                    }
                    if (string2 != null && string2.length() > 0) {
                        String string4;
                        Object object2;
                        object = new StringTokenizer(string2, this.labelDelimiter);
                        String string5 = null;
                        if (((StringTokenizer)object).hasMoreElements()) {
                            string5 = (String)((StringTokenizer)object).nextElement();
                        }
                        double d = 0.0;
                        if (((StringTokenizer)object).hasMoreElements()) {
                            try {
                                object2 = (String)((StringTokenizer)object).nextElement();
                                d = new Double(((String)object2).trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("Invalid targetValueLine value: " + string2);
                            }
                        }
                        object2 = this.theChart.getValueLinesColor();
                        if (((StringTokenizer)object).hasMoreElements() && (object2 = ChartApplet.createColor((string4 = (String)((StringTokenizer)object).nextElement()).trim())) == null) {
                            object2 = this.theChart.getValueLinesColor();
                        }
                        int n = 3;
                        if (((StringTokenizer)object).hasMoreElements()) {
                            String string6 = ((String)((StringTokenizer)object).nextElement()).trim();
                            n = string6.equals("label") ? 1 : (string6.equals("value") ? 2 : 3);
                        }
                        if (string5 != null) {
                            this.targets.put(string, string5);
                            this.theChart.setTargetValueLine(string5, d, (Color)object2, n);
                        }
                    }
                } else if (!string.equals("chart")) {
                    if (string.startsWith("overlay")) {
                        int n = string.indexOf("_");
                        if (n > -1) {
                            String string7 = string.substring(0, n).toLowerCase();
                            ChartApplet chartApplet = (ChartApplet)this.overlayCharts.get(string7);
                            if (chartApplet != null) {
                                String string8 = string.substring(n + 1);
                                chartApplet.setParameter(string8, string2);
                            }
                        } else if (!this.overlayCharts.containsKey(string)) {
                            if (string2 != null) {
                                ChartApplet chartApplet = null;
                                if (string2 != null) {
                                    if (string2.equalsIgnoreCase("line")) {
                                        chartApplet = new LineChartApplet();
                                    } else if (string2.equalsIgnoreCase("bar")) {
                                        chartApplet = new BarChartApplet();
                                    } else if (string2.equalsIgnoreCase("pie")) {
                                        chartApplet = new PieChartApplet();
                                    } else {
                                        System.out.println("Invalid overlay: " + string + " " + string2);
                                    }
                                }
                                if (chartApplet != null) {
                                    chartApplet.reset();
                                    chartApplet.theChart.setSampleCount(1);
                                    chartApplet.setParentApplet(this);
                                    chartApplet.setParameterPrefix(string + "_");
                                    this.overlayCharts.put(string, chartApplet);
                                    this.theChart.addOverlayChart(chartApplet.theChart);
                                }
                            } else {
                                this.overlayCharts.remove(string);
                            }
                        }
                    } else if (string.equalsIgnoreCase("doubleBufferingOff")) {
                        if (string2 != null && string2.trim().equalsIgnoreCase("true")) {
                            this.removeAll();
                            this.add("Center", this.theChart);
                        }
                    } else {
                        System.out.println("Invalid parameter name: " + string);
                    }
                }
            }
        }
    }

    public String getParameter(String string) {
        String string2 = null;
        if (string != null) {
            if (this.parameterPrefix != null && this.parameterPrefix.length() > 0) {
                string = this.parameterPrefix + string;
            }
            if (this.parentApplet != null) {
                string2 = this.parentApplet.getParameter(string);
            } else {
                try {
                    string2 = super.getParameter(string);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        return string2;
    }

    private URL createURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            int n;
            URL uRL2 = null;
            try {
                uRL2 = this.getDocumentBase();
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("Not an applet, could not create url: " + string);
            }
            String string2 = "";
            if (uRL2 != null) {
                string2 = uRL2.toExternalForm();
            }
            if ((n = string2.lastIndexOf("?")) > -1) {
                string2 = string2.substring(0, n);
            }
            if (string.startsWith("/")) {
                int n2;
                String string3 = uRL2.getFile();
                if (string3 != null && string3.trim().length() > 0 && (n2 = string2.lastIndexOf(string3)) >= 0) {
                    string2 = string2.substring(0, n2);
                }
            } else if (!string2.endsWith("/")) {
                string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
            }
            if (string2.startsWith("file:/\\")) {
                string2 = "file://" + string2.substring(8);
            }
            try {
                uRL = new URL(string2 + string);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("Invalid URL: " + string2);
            }
        }
        return uRL;
    }

    public Font createFont(String string, String string2, int n, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string3 = string2;
        int n3 = Math.max(0, n2);
        int n4 = n;
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            n4 = ChartApplet.getFontType(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            try {
                n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 12;
            }
        }
        return new Font(string3, n4, n3);
    }

    public AppletContext getAppletContext() {
        if (this.parentApplet != null) {
            return this.parentApplet.getAppletContext();
        }
        return super.getAppletContext();
    }

    public void reset() {
        this.urlList.clear();
        this.urlTargetList.clear();
        this.urlTargetList.put("urltarget", "_self");
        this.lastSelectedSample = -1;
        this.lastSelectedSeries = -1;
        this.overlayCharts.clear();
        this.sampleCountSet = false;
        this.rangeStep[1] = -1.0;
        this.rangeStep[0] = -1.0;
        this.labelDelimiter = ",";
        this.singleClickURLOn = false;
        this.theChart.reset();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public ChartApplet() {
        this.rangeStep[1] = -1.0;
        this.rangeStep[0] = -1.0;
        this.targets = new Hashtable();
        this.urlList = new Hashtable();
        this.urlTargetList = new Hashtable();
        this.urlTargetList.put("urltarget", "_self");
        this.overlayCharts = new Hashtable();
        this.automaticRefreshTime = 2500;
        this.lastSelectedSample = -1;
        this.lastSelectedSeries = -1;
        this.setLayout(new BorderLayout());
        NonFlickerPanel nonFlickerPanel = new NonFlickerPanel(new BorderLayout());
        nonFlickerPanel.add("Center", this.theChart);
        this.add("Center", nonFlickerPanel);
        this.theChart.addItemListener(this);
        this.theChart.addMouseMotionListener(this);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        URL uRL;
        if (this.urlList == null || this.urlList.size() == 0) {
            return;
        }
        Chart chart = (Chart)mouseEvent.getSource();
        ChartSample chartSample = chart.checkSelection(new Point(mouseEvent.getX(), mouseEvent.getY()));
        int n = chart.getSeriesCount();
        Cursor cursor = POINT_CURSOR;
        if (chartSample != null && (uRL = this.getSampleURL(n, chartSample.getSeries(), chartSample.getIndex())) != null) {
            cursor = HAND_CURSOR;
        }
        this.setCursor(cursor);
    }

    private static int getFontType(String string) {
        if ((string = string.toLowerCase().trim()).equals("bold")) {
            return 1;
        }
        if (string.equals("italic")) {
            return 2;
        }
        if (string.equals("bolditalic") || string.equals("italicbold")) {
            return 3;
        }
        return 0;
    }

    public URL getDocumentBase() {
        if (this.parentApplet != null) {
            return this.parentApplet.getDocumentBase();
        }
        return super.getDocumentBase();
    }

    public synchronized void loadParameters(Hashtable hashtable) {
        Object object;
        Object object2;
        String string;
        String string2;
        if (hashtable == null) {
            return;
        }
        this.sampleCountRead = 0;
        if (this.getParameter("sampleCount") != null) {
            String string3 = this.getParameter("sampleCount");
            try {
                this.sampleCountRead = Integer.parseInt(string3);
                this.sampleCountSet = true;
                hashtable.put("samplecount", string3);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Invalid sampleCount: " + string3);
            }
        }
        int n = 0;
        while (n < this.parameters_all.length) {
            string2 = this.parameters_all[n].toLowerCase();
            string = this.getParameter(string2);
            if (string != null && string.trim().length() > 0 || string != null && string.equals("\t")) {
                hashtable.put(string2, string);
                try {
                    if (!this.sampleCountSet && string2.equalsIgnoreCase("sampleValues")) {
                        object2 = ChartApplet.getDoubleValues(string);
                        this.sampleCountRead = Math.max(object2 != null ? ((Double[])object2).length : 0, this.sampleCountRead);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n;
        }
        this.seriesCountRead = 1;
        if (hashtable.containsKey("seriescount")) {
            try {
                this.seriesCountRead = Integer.parseInt((String)hashtable.get("seriescount"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        n = 0;
        while (n < this.parameters_series.length) {
            int n2 = 0;
            while (n2 < this.seriesCountRead) {
                string = this.parameters_series[n] + n2;
                object2 = this.getParameter(string = string.toLowerCase());
                if (object2 != null && ((String)object2).trim().length() > 0) {
                    hashtable.put(string, object2);
                    if (!this.sampleCountSet && string.startsWith("samplevalues")) {
                        object = ChartApplet.getDoubleValues((String)object2);
                        this.sampleCountRead = Math.max(object != null ? ((Double[])object).length : 0, this.sampleCountRead);
                    }
                }
                ++n2;
            }
            ++n;
        }
        n = 0;
        string2 = this.getParameter("targetvalueline_0");
        while (string2 != null && string2.length() > 0) {
            hashtable.put("targetvalueline_" + n, string2);
            string2 = this.getParameter("targetvalueline_" + ++n);
        }
        int n3 = 0;
        do {
            if (this.getParameter((String)(object2 = "legendimage_" + n3)) == null) continue;
            object = this.getParameter((String)object2);
            hashtable.put(object2, object);
        } while (++n3 < 100);
        if (this.getParameter("url") != null) {
            hashtable.put("url", this.getParameter("url"));
        }
        if (this.getParameter("urltarget") != null) {
            hashtable.put("urltarget", this.getParameter("urltarget"));
        }
        n3 = Math.max(this.seriesCountRead, this.sampleCountRead);
        int n4 = 0;
        while (n4 < n3) {
            object = "url_" + n4;
            if (this.getParameter((String)object) != null) {
                hashtable.put(object, this.getParameter((String)object));
            }
            if (this.getParameter((String)(object = "urltarget_" + n4)) != null) {
                hashtable.put(object, this.getParameter((String)object));
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.seriesCountRead) {
            int n5 = 0;
            while (n5 < this.sampleCountRead) {
                String string4 = "url_" + n4 + "_" + n5;
                if (this.getParameter(string4) != null) {
                    hashtable.put(string4, this.getParameter(string4));
                }
                if (this.getParameter(string4 = "urltarget_" + n4 + "_" + n5) != null) {
                    hashtable.put(string4, this.getParameter(string4));
                }
                ++n5;
            }
            ++n4;
        }
    }

    public void loadURLParameters(String string, Hashtable hashtable) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if (hashtable == null) {
            return;
        }
        URL uRL = this.createURL(string);
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    int n = string2.indexOf("=");
                    if (n <= 0) continue;
                    String string3 = string2.substring(0, n).trim().toLowerCase();
                    String string4 = string2.substring(n + 1).trim();
                    hashtable.put(string3, string4);
                }
                bufferedReader.close();
                inputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("Error reading from the URL resource: " + uRL.toExternalForm());
                iOException.printStackTrace();
            }
            catch (SecurityException securityException) {
                System.out.println("Error reading from the URL resource: " + uRL.toExternalForm());
                securityException.printStackTrace();
            }
        }
    }

    public void setParameterPrefix(String string) {
        this.parameterPrefix = string;
    }

    public String getParameterPrefix() {
        return this.parameterPrefix;
    }

    protected void refresh() {
    }

    public void setParameters(Hashtable hashtable) {
        String string;
        String string2;
        Double[] doubleArray;
        if (hashtable == null) {
            return;
        }
        if (hashtable.containsKey("chartclass")) {
            String string3 = (String)hashtable.get("chartclass");
            this.theChart = this.createChart(string3);
            NonFlickerPanel nonFlickerPanel = new NonFlickerPanel(new BorderLayout());
            nonFlickerPanel.add("Center", this.theChart);
            this.add("Center", nonFlickerPanel);
            this.theChart.addItemListener(this);
            this.theChart.addMouseMotionListener(this);
            hashtable.remove("chartclass");
        }
        if (hashtable.get("overlay") != null) {
            this.setParameter("overlay", (String)hashtable.get("overlay"));
        }
        if (hashtable.get("overlay_seriescount") != null) {
            this.setParameter("overlay_seriesCount", (String)hashtable.get("overlay_seriescount"));
        }
        if (hashtable.get("overlay0") != null) {
            this.setParameter("overlay0", (String)hashtable.get("overlay0"));
        }
        if (hashtable.get("overlay0_seriescount") != null) {
            this.setParameter("overlay0_seriesCount", (String)hashtable.get("overlay0_seriescount"));
        }
        int n = 1;
        while (hashtable.get("overlay" + n) != null) {
            this.setParameter("overlay" + n, (String)hashtable.get("overlay" + n));
            if (hashtable.get("overlay" + n + "_seriescount") != null) {
                this.setParameter("overlay" + n + "_seriescount", (String)hashtable.get("overlay" + n + "_seriescount"));
            }
            ++n;
        }
        int n2 = 1;
        if (hashtable.containsKey("seriescount")) {
            this.setParameter("seriesCount", (String)hashtable.get("seriescount"));
            n2 = this.theChart.getSeriesCount();
        }
        int n3 = 1;
        if (hashtable.get("samplecount") != null) {
            try {
                String string4 = (String)hashtable.get("samplecount");
                n3 = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                System.out.println("Invalid sampleCount " + hashtable.get("samplecount"));
            }
        } else if (n2 == 1 && hashtable.get("samplevalues") != null) {
            Double[] doubleArray2 = ChartApplet.getDoubleValues((String)hashtable.get("samplevalues"));
            n3 = Math.max(doubleArray2 != null ? doubleArray2.length : 0, n3);
        } else {
            int n4 = 0;
            while (n4 < n2) {
                if (hashtable.get("samplevalues_" + n4) != null) {
                    doubleArray = ChartApplet.getDoubleValues((String)hashtable.get("samplevalues_" + n4));
                    n3 = Math.max(doubleArray != null ? doubleArray.length : 0, n3);
                }
                ++n4;
            }
        }
        this.theChart.setSampleCount(n3);
        String string5 = (String)hashtable.get("samplecount");
        doubleArray = (Double[])hashtable.get("seriescount");
        Hashtable hashtable2 = new Hashtable();
        int n5 = 0;
        while (n5 < this.parameters_range.length) {
            string2 = this.parameters_range[n5];
            if (hashtable.containsKey(string2)) {
                hashtable2.put(string2, hashtable.remove(string2));
            }
            ++n5;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = (String)hashtable.get(string2);
            this.setParameter(string2, string);
        }
        int n6 = 0;
        while (n6 < this.parameters_range.length) {
            string = this.parameters_range[n6];
            String string6 = (String)hashtable2.get(string);
            this.setParameter(string, string6);
            if (string6 != null) {
                hashtable.put(string, string6);
            }
            ++n6;
        }
        if (string5 != null) {
            hashtable.put("samplecount", string5);
        }
        if (doubleArray != null) {
            hashtable.put("seriescount", doubleArray);
        }
    }

    public void run() {
        try {
            Thread.sleep((int)Math.random() * 1000);
            while (true) {
                Thread.sleep(this.automaticRefreshTime);
                this.theChart.repaint();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void init() {
        Serializable serializable;
        Panel panel;
        if (this.theChart == null) {
            throw new IllegalStateException("No chart has been created");
        }
        if (this.getParameter("chartClass") != null) {
            this.theChart = this.createChart(this.getParameter("chartClass"));
            panel = new NonFlickerPanel(new BorderLayout());
            panel.add("Center", this.theChart);
            this.add("Center", panel);
            this.theChart.addItemListener(this);
            this.theChart.addMouseMotionListener(this);
        }
        this.reset();
        this.theChart.setAutomaticRepaintOn(false);
        if (this.getParameter("overlay") != null) {
            this.setParameter("overlay", this.getParameter("overlay"));
            panel = (ChartApplet)this.overlayCharts.get("overlay");
            if (panel != null) {
                serializable = new Hashtable();
                ((ChartApplet)panel).loadParameters((Hashtable)serializable);
                ((ChartApplet)panel).setParameters((Hashtable)serializable);
            }
        }
        if (this.getParameter("overlay0") != null) {
            this.setParameter("overlay0", this.getParameter("overlay0"));
            panel = (ChartApplet)this.overlayCharts.get("overlay0");
            if (panel != null) {
                serializable = new Hashtable();
                ((ChartApplet)panel).loadParameters((Hashtable)serializable);
                ((ChartApplet)panel).setParameters((Hashtable)serializable);
            }
        }
        int n = 1;
        while (this.getParameter("overlay" + n) != null) {
            this.setParameter("overlay" + n, this.getParameter("overlay" + n));
            serializable = (ChartApplet)this.overlayCharts.get("overlay" + n);
            if (serializable != null) {
                Hashtable hashtable = new Hashtable();
                ((ChartApplet)serializable).loadParameters(hashtable);
                ((ChartApplet)serializable).setParameters(hashtable);
            }
            ++n;
        }
        serializable = new Hashtable();
        if (this.getParameter("data") != null) {
            this.loadURLParameters(this.getParameter("data"), (Hashtable)serializable);
        }
        this.loadParameters((Hashtable)serializable);
        this.setParameters((Hashtable)serializable);
        this.theChart.setAutomaticRepaintOn(true);
    }

    public void print(Graphics graphics) {
        this.theChart.print(graphics);
    }

    private String createURLParam(String string, int n, int n2) {
        String string2 = string;
        if (n >= 0) {
            string2 = string2 + "_" + n;
        }
        if (n2 >= 0) {
            string2 = string2 + "_" + n2;
        }
        return string2;
    }
}

